(function(){

// module factory: start

var moduleFactory = function($) {
// module body: start

var module = this; 
$.require() 
 .stylesheet("fancybox/thumbs") 
 .done(function() { 
var exports = function() { 

 /*!
 * Thumbnail helper for fancyBox
 * version: 1.0.2
 * @requires fancyBox v2.0 or later
 *
 * Usage:
 *     $(".fancybox").fancybox({
 *         thumbs: {
 *             width	: 50,
 *             height	: 50
 *         }
 *     });
 *
 * Options:
 *     width - thumbnail width
 *     height - thumbnail height
 *     source - function to obtain the URL of the thumbnail image
 *     position - 'top' or 'bottom'
 *
 */

//Shortcut for fancyBox object
var F = $.fancybox;

//Add helper object
F.helpers.thumbs = {
	wrap: null,
	list: null,
	width: 0,

	//Default function to obtain the URL of the thumbnail image
	source: function (el) {
		var img = $(el).find('img');

		return img.length ? img.attr('src') : el.href;
	},

	init: function (opts) {
		var that = this,
			list,
			thumbWidth = opts.width || 50,
			thumbHeight = opts.height || 50,
			thumbSource = opts.source || this.source;

		//Build list structure
		list = '';

		for (var n = 0; n < F.group.length; n++) {
			list += '<li><a style="width:' + thumbWidth + 'px;height:' + thumbHeight + 'px;" href="javascript:' + $.globalNamespace + '.fancybox.jumpto(' + n + ');"></a></li>';
		}

		this.wrap = $('<div id="fancybox-thumbs"></div>').addClass(opts.position || 'bottom').appendTo('body');
		this.list = $('<ul>' + list + '</ul>').appendTo(this.wrap);

		//Load each thumbnail
		$.each(F.group, function (i) {
			$("<img />").load(function () {
				var width = this.width,
					height = this.height,
					widthRatio, heightRatio, parent;

				if (!that.list || !width || !height) {
					return;
				}

				//Calculate thumbnail width/height and center it
				widthRatio = width / thumbWidth;
				heightRatio = height / thumbHeight;
				parent = that.list.children().eq(i).find('a');

				if (widthRatio >= 1 && heightRatio >= 1) {
					if (widthRatio > heightRatio) {
						width = Math.floor(width / heightRatio);
						height = thumbHeight;

					} else {
						width = thumbWidth;
						height = Math.floor(height / widthRatio);
					}
				}

				$(this).css({
					width: width,
					height: height,
					top: Math.floor(thumbHeight / 2 - height / 2),
					left: Math.floor(thumbWidth / 2 - width / 2)
				});

				parent.width(thumbWidth).height(thumbHeight);

				$(this).hide().appendTo(parent).fadeIn(300);

			}).attr('src', thumbSource(this));
		});

		//Set initial width
		this.width = this.list.children().eq(0).outerWidth();

		this.list.width(this.width * (F.group.length + 1)).css('left', Math.floor($(window).width() * 0.5 - (F.current.index * this.width + this.width * 0.5)));
	},

	//Center list
	update: function (opts) {
		if (this.list) {
			this.list.stop(true).animate({
				'left': Math.floor($(window).width() * 0.5 - (F.current.index * this.width + this.width * 0.5))
			}, 150);
		}
	},

	beforeLoad: function (opts) {
		//Remove self if gallery do not have at least two items
		if (F.group.length < 2) {
			F.coming.helpers.thumbs = false;

			return;
		}

		//Increase bottom margin to give space for thumbs
		F.coming.margin[ opts.position === 'top' ? 0 : 2 ] = opts.height + 30;
	},

	afterShow: function (opts) {
		//Check if exists and create or update list
		if (this.list) {
			this.update(opts);

		} else {
			this.init(opts);
		}

		//Set active element
		this.list.children().removeClass('active').eq(F.current.index).addClass('active');
	},

	onUpdate: function () {
		this.update();
	},

	beforeClose: function () {
		if (this.wrap) {
			this.wrap.remove();
		}

		this.wrap = null;
		this.list = null;
		this.width = 0;
	}
}

}; 

exports(); 
module.resolveWith(exports); 

}); 
// module body: end

}; 
// module factory: end

dispatch("fancybox/thumbs")
.containing(moduleFactory)
.to("Foundry/2.1 Modules");

}());