SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE IF NOT EXISTS `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=482 ;

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 1, 686, 0, 'root.1', 'Root Asset', '{"core.login.site":{"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":[],"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(2, 1, 2, 3, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 4, 13, 1, 'com_banners', 'com_banners', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(4, 1, 14, 15, 1, 'com_cache', 'com_cache', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(5, 1, 16, 17, 1, 'com_checkin', 'com_checkin', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(6, 1, 18, 19, 1, 'com_config', 'com_config', '{}'),
(7, 1, 20, 91, 1, 'com_contact', 'com_contact', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(8, 1, 92, 287, 1, 'com_content', 'com_content', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(9, 1, 288, 289, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 290, 291, 1, 'com_installer', 'com_installer', '{"core.admin":{"7":1},"core.manage":{"7":1},"core.delete":[],"core.edit.state":[]}'),
(11, 1, 292, 293, 1, 'com_languages', 'com_languages', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(12, 1, 294, 295, 1, 'com_login', 'com_login', '{}'),
(13, 1, 296, 297, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 298, 299, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 300, 301, 1, 'com_media', 'com_media', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1},"core.edit":[],"core.edit.state":[]}'),
(16, 1, 302, 303, 1, 'com_menus', 'com_menus', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(17, 1, 39, 40, 1, 'com_messages', 'com_messages', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(18, 1, 306, 543, 1, 'com_modules', 'com_modules', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(19, 1, 544, 551, 1, 'com_newsfeeds', 'com_newsfeeds', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(20, 1, 552, 553, 1, 'com_plugins', 'com_plugins', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(21, 1, 554, 555, 1, 'com_redirect', 'com_redirect', '{"core.admin":{"7":1},"core.manage":[]}'),
(22, 1, 556, 557, 1, 'com_search', 'com_search', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.edit.state":[]}'),
(23, 1, 558, 559, 1, 'com_templates', 'com_templates', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(24, 1, 560, 561, 1, 'com_users', 'com_users', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(25, 1, 562, 579, 1, 'com_weblinks', 'com_weblinks', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1,"10":0,"12":0},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(26, 1, 580, 581, 1, 'com_wrapper', 'com_wrapper', '{}'),
(34, 8, 109, 126, 2, 'com_content.category.9', 'Explore', '{"core.create":{"10":0,"12":0},"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(35, 3, 7, 8, 2, 'com_banners.category.10', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(36, 7, 25, 26, 2, 'com_contact.category.11', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(37, 19, 547, 548, 2, 'com_newsfeeds.category.12', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(38, 25, 569, 570, 2, 'com_weblinks.category.13', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(39, 8, 127, 158, 2, 'com_content.category.14', 'Sample Data-Articles', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(40, 3, 9, 10, 2, 'com_banners.category.15', 'Sample Data-Banners', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(41, 7, 27, 88, 2, 'com_contact.category.16', 'Sample Data-Contact', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(42, 19, 549, 550, 2, 'com_newsfeeds.category.17', 'Smartaddons-Newsfeeds', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(43, 25, 571, 578, 2, 'com_weblinks.category.18', 'Sample Data-Weblinks', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(44, 39, 128, 153, 3, 'com_content.category.19', 'Joomla!', '{"core.create":{"10":0,"12":0},"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(45, 44, 129, 146, 4, 'com_content.category.20', 'Extensions', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(46, 45, 130, 131, 5, 'com_content.category.21', 'Components', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(47, 45, 132, 139, 5, 'com_content.category.22', 'Modules', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(50, 45, 142, 145, 5, 'com_content.category.25', 'Plugins', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(56, 43, 572, 573, 3, 'com_weblinks.category.31', ' Smartaddons ', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(57, 43, 574, 577, 3, 'com_weblinks.category.32', 'Joomla! Specific Links', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(58, 57, 575, 576, 4, 'com_weblinks.category.33', 'Other Resources', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(59, 41, 28, 29, 3, 'com_contact.category.34', 'Park Site', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(60, 41, 30, 87, 3, 'com_contact.category.35', 'Shop Site', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(61, 60, 31, 32, 4, 'com_contact.category.36', 'Staff', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(62, 60, 33, 86, 4, 'com_contact.category.37', 'Fruit Encyclopedia', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(63, 62, 34, 35, 5, 'com_contact.category.38', 'A', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(64, 62, 36, 37, 5, 'com_contact.category.39', 'B', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(65, 62, 38, 39, 5, 'com_contact.category.40', 'C', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(66, 62, 40, 41, 5, 'com_contact.category.41', 'D', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(67, 62, 42, 43, 5, 'com_contact.category.42', 'E', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(68, 62, 44, 45, 5, 'com_contact.category.43', 'F', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(69, 62, 46, 47, 5, 'com_contact.category.44', 'G', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(70, 62, 48, 49, 5, 'com_contact.category.45', 'H', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(71, 62, 50, 51, 5, 'com_contact.category.46', 'I', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(72, 62, 52, 53, 5, 'com_contact.category.47', 'J', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(73, 62, 54, 55, 5, 'com_contact.category.48', 'K', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(74, 62, 56, 57, 5, 'com_contact.category.49', 'L', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(75, 62, 58, 59, 5, 'com_contact.category.50', 'M', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(76, 62, 60, 61, 5, 'com_contact.category.51', 'N', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(77, 62, 62, 63, 5, 'com_contact.category.52', 'O', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(78, 62, 64, 65, 5, 'com_contact.category.53', 'P', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(79, 62, 66, 67, 5, 'com_contact.category.54', 'Q', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(80, 62, 68, 69, 5, 'com_contact.category.55', 'R', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(81, 62, 70, 71, 5, 'com_contact.category.56', 'S', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(82, 62, 72, 73, 5, 'com_contact.category.57', 'T', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(83, 62, 74, 75, 5, 'com_contact.category.58', 'U', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(84, 62, 76, 77, 5, 'com_contact.category.59', 'V', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(85, 62, 78, 79, 5, 'com_contact.category.60', 'W', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(86, 62, 80, 81, 5, 'com_contact.category.61', 'X', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(87, 62, 82, 83, 5, 'com_contact.category.62', 'Y', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(88, 62, 84, 85, 5, 'com_contact.category.63', 'Z', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(95, 47, 133, 136, 6, 'com_content.category.66', 'Display Modules', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(100, 45, 140, 141, 5, 'com_content.category.71', 'Milky Way', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(101, 50, 143, 144, 6, 'com_content.article.5', 'Authentication', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(103, 95, 134, 135, 7, 'com_content.article.7', 'Banner Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(104, 44, 147, 148, 4, 'com_content.article.8', 'Beginners', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(122, 44, 149, 150, 4, 'com_content.article.24', 'Joomla!', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(151, 44, 151, 152, 4, 'com_content.article.53', 'Using Joomla!', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(168, 34, 110, 111, 3, 'com_content.article.67', 'What''s New in 1.5?', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(180, 245, 160, 181, 3, 'com_content.category.78', 'Content Category 1', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(181, 245, 182, 205, 3, 'com_content.category.79', 'Content Category 2', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(182, 180, 161, 162, 4, 'com_content.article.78', 'Tames pede elit', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(183, 180, 163, 164, 4, 'com_content.article.79', 'Xulla semper Curabitur luctus', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(184, 180, 165, 166, 4, 'com_content.article.80', 'Detus laoreet dignissim ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(185, 180, 167, 168, 4, 'com_content.article.81', 'Lacinia Sed convallis ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(186, 180, 169, 170, 4, 'com_content.article.82', 'Mes pede elit nibh ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(187, 180, 171, 172, 4, 'com_content.article.83', 'Mauris ut mauris ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(188, 181, 199, 200, 4, 'com_content.article.84', 'Misociis nulla interdum', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(189, 180, 173, 174, 4, 'com_content.article.85', 'Aliquam lobortis cursus ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(190, 180, 175, 176, 4, 'com_content.article.86', 'Aenean vea aliquam', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(191, 180, 177, 178, 4, 'com_content.article.87', 'Ursus senectus ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(192, 181, 183, 184, 4, 'com_content.article.88', 'Ruci tenna mes', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(194, 181, 185, 186, 4, 'com_content.article.90', 'Us laoreet dignissim vel.', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(195, 180, 179, 180, 4, 'com_content.article.91', 'Faucibus eu laoreet nunc', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(196, 181, 187, 188, 4, 'com_content.article.92', 'Cinia Sed convallis urna ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(197, 181, 189, 190, 4, 'com_content.article.93', 'Tes pede elit nibh ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(198, 181, 191, 192, 4, 'com_content.article.94', 'Sociis nulla interdum et', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(199, 181, 193, 194, 4, 'com_content.article.95', 'Gimes pede elit', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(200, 181, 195, 196, 4, 'com_content.article.96', 'Kril penectus aliquet pretium', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(201, 181, 197, 198, 4, 'com_content.article.97', 'Netra faucibus eu laoreet', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(202, 245, 206, 227, 3, 'com_content.category.80', 'Content Category 3', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(203, 245, 228, 249, 3, 'com_content.category.81', 'Content Category 4', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(204, 202, 207, 208, 4, 'com_content.article.98', 'Lisl Pellentesquem metus', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(205, 202, 209, 210, 4, 'com_content.article.99', 'Laoreet digen nissim', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(206, 202, 211, 212, 4, 'com_content.article.100', 'Kaucibus eu laoreet nunc', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(207, 202, 213, 214, 4, 'com_content.article.101', 'Bener senver munst onvase', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(209, 202, 215, 216, 4, 'com_content.article.103', 'Ciis nulla interdum senectus', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(210, 202, 217, 218, 4, 'com_content.article.104', 'Lames pede elit', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(211, 202, 219, 220, 4, 'com_content.article.105', 'Jes pede elit', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(212, 202, 221, 222, 4, 'com_content.article.106', 'Kiop senectus aliquet ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(213, 202, 223, 224, 4, 'com_content.article.107', 'Ma semper ac nec sit', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(214, 202, 225, 226, 4, 'com_content.article.108', 'Karetra faucibus eu lao', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(215, 203, 229, 230, 4, 'com_content.article.109', 'Kara senver munst onvase', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(216, 203, 231, 232, 4, 'com_content.article.110', 'Kulla interdum ersus senectus', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(218, 203, 233, 234, 4, 'com_content.article.111', 'Pes pede elit', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(219, 203, 235, 236, 4, 'com_content.article.112', 'Tra faucibus eu laoreet ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(220, 203, 237, 238, 4, 'com_content.article.113', 'Gaucibus eu laoreet', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(221, 203, 239, 240, 4, 'com_content.article.114', 'Cibus eu laoreet nunc', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(222, 203, 241, 242, 4, 'com_content.article.115', 'Gucibus Teu laoreet nunc', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(223, 203, 243, 244, 4, 'com_content.article.116', 'Seni senectus aliquet ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(224, 203, 245, 246, 4, 'com_content.article.117', 'Tanra mes pede elit', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(225, 203, 247, 248, 4, 'com_content.article.118', 'Nal pede elit nibh ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(235, 34, 112, 113, 3, 'com_content.article.128', 'Features', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(236, 34, 114, 115, 3, 'com_content.article.129', 'Module Variations', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(237, 34, 116, 117, 3, 'com_content.article.130', 'Positions', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(238, 34, 118, 119, 3, 'com_content.article.131', 'Extensions', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(240, 34, 124, 125, 3, 'com_content.article.133', 'Typography', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(241, 3, 11, 12, 2, 'com_banners.category.83', 'JTC', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(245, 8, 159, 250, 2, 'com_content.category.84', 'Yt Sample Data', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(249, 7, 89, 90, 2, 'com_contact.category.85', 'Contact', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(265, 1, 644, 645, 1, 'com_finder', 'com_finder', '{"core.admin":[],"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(276, 298, 266, 267, 3, 'com_content.article.155', 'Page break example ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(298, 8, 251, 274, 2, 'com_content.category.91', 'Joomla page', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(299, 298, 252, 253, 3, 'com_content.article.176', 'FAQ', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(300, 298, 254, 255, 3, 'com_content.article.177', 'Join now', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(301, 298, 256, 257, 3, 'com_content.article.178', 'About us', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(302, 34, 122, 123, 3, 'com_content.article.179', 'Shortcodes', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(303, 298, 258, 259, 3, 'com_content.article.180', 'Testimonials', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(304, 298, 260, 261, 3, 'com_content.article.181', 'Services', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(305, 298, 262, 263, 3, 'com_content.article.182', 'Columns', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(306, 298, 264, 265, 3, 'com_content.article.183', 'What''s new?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(307, 298, 268, 269, 3, 'com_content.article.184', 'Photo Gallery ', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(308, 298, 270, 271, 3, 'com_content.article.185', 'Portfolio', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(310, 298, 272, 273, 3, 'com_content.article.187', 'Bonus pages', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(317, 39, 156, 157, 3, 'com_content.article.193', 'Coming Soon', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(318, 1, 646, 647, 1, '#__ucm_content.1', '#__ucm_content.1', '[]'),
(320, 1, 648, 649, 1, '#__ucm_content.3', '#__ucm_content.3', '[]'),
(321, 1, 650, 651, 1, '#__ucm_content.4', '#__ucm_content.4', '[]'),
(322, 1, 652, 653, 1, '#__ucm_content.5', '#__ucm_content.5', '[]'),
(324, 1, 654, 655, 1, '#__ucm_content.7', '#__ucm_content.7', '[]'),
(325, 1, 656, 657, 1, '#__ucm_content.8', '#__ucm_content.8', '[]'),
(326, 1, 658, 659, 1, '#__ucm_content.9', '#__ucm_content.9', '[]'),
(327, 1, 660, 661, 1, '#__ucm_content.10', '#__ucm_content.10', '[]'),
(328, 1, 662, 663, 1, '#__ucm_content.11', '#__ucm_content.11', '[]'),
(330, 1, 664, 665, 1, '#__ucm_content.13', '#__ucm_content.13', '[]'),
(331, 1, 666, 667, 1, 'com_tags', 'com_tags', '{"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(333, 18, 307, 308, 2, 'com_modules.module.71', 'Shortcodes', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(337, 34, 120, 121, 3, 'com_content.article.198', 'Powerfull Features', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(338, 1, 668, 669, 1, 'com_jw_disqus', 'jw_disqus', '{}'),
(339, 18, 309, 310, 2, 'com_modules.module.233', 'Wellcome to SJ Plus', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(340, 18, 311, 312, 2, 'com_modules.module.210', 'Free Joomla! 3.0 Template', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(341, 18, 313, 314, 2, 'com_modules.module.234', 'YT Framework + Bootstrap', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(342, 18, 315, 316, 2, 'com_modules.module.235', 'Responsive Web Design', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(343, 18, 317, 318, 2, 'com_modules.module.250', 'Mega1- List Shortcode', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(344, 18, 319, 320, 2, 'com_modules.module.224', 'Mega1- Photo Shortcode', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(345, 18, 321, 322, 2, 'com_modules.module.251', 'Mega1- Featured Shortcode', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(347, 18, 323, 324, 2, 'com_modules.module.253', 'Mega1 - Custom Module', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(348, 18, 325, 326, 2, 'com_modules.module.246', 'Joomla Page', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(350, 18, 327, 328, 2, 'com_modules.module.25', '"_menu" style ', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(351, 18, 329, 330, 2, 'com_modules.module.90', '"icon-phone" Style', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(352, 18, 331, 332, 2, 'com_modules.module.249', 'Popular Tags', ''),
(353, 18, 333, 334, 2, 'com_modules.module.202', '"Title1" Style', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(355, 18, 335, 336, 2, 'com_modules.module.17', 'Breadcrumbs', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(356, 18, 337, 338, 2, 'com_modules.module.76', 'Login Form', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(358, 18, 339, 340, 2, 'com_modules.module.207', '"Title3" style', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(362, 18, 341, 342, 2, 'com_modules.module.258', '"Title2" Style ', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(364, 18, 343, 344, 2, 'com_modules.module.232', 'Social Networking', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(365, 18, 345, 346, 2, 'com_modules.module.236', '"Default" Style', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(366, 18, 347, 348, 2, 'com_modules.module.225', 'LESS CSS', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(367, 18, 349, 350, 2, 'com_modules.module.237', 'Bootstrap', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(368, 18, 351, 352, 2, 'com_modules.module.238', 'HTML5 Introduction', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(369, 18, 353, 354, 2, 'com_modules.module.239', 'LESS CSS', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(370, 18, 355, 356, 2, 'com_modules.module.178', 'Joomla Templates', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(371, 18, 357, 358, 2, 'com_modules.module.260', 'SCLogin Module', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(373, 18, 359, 360, 2, 'com_modules.module.261', 'Language Switcher', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(374, 18, 361, 362, 2, 'com_modules.module.262', 'Breadcrumb', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(375, 18, 363, 364, 2, 'com_modules.module.263', 'Default Style', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(377, 18, 365, 366, 2, 'com_modules.module.264', '“Box 1” Style', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(378, 18, 367, 368, 2, 'com_modules.module.240', 'About joomla', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(379, 18, 369, 370, 2, 'com_modules.module.197', 'Who''s Online', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(380, 18, 371, 372, 2, 'com_modules.module.265', '“Box 3” Style', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(381, 18, 373, 374, 2, 'com_modules.module.266', '“Box 2” Style', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(382, 18, 375, 376, 2, 'com_modules.module.267', '"icon-bell"', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(383, 18, 377, 378, 2, 'com_modules.module.268', '"icon-file-alt"', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(384, 18, 379, 380, 2, 'com_modules.module.269', '"icon-comment-alt"', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(385, 18, 381, 382, 2, 'com_modules.module.270', '"icon-bookmark-empty"', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(386, 18, 383, 384, 2, 'com_modules.module.143', 'Follow Us', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(387, 18, 385, 386, 2, 'com_modules.module.271', 'Login-Form', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(388, 18, 387, 388, 2, 'com_modules.module.272', 'Login', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(389, 18, 389, 390, 2, 'com_modules.module.273', 'Languages', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(390, 18, 391, 392, 2, 'com_modules.module.274', 'Suffix “Badge new”', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(391, 18, 393, 394, 2, 'com_modules.module.275', 'Suffix “baged hot”', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(392, 18, 395, 396, 2, 'com_modules.module.276', 'Suffix “Badge best”', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(393, 18, 397, 398, 2, 'com_modules.module.277', 'Suffix “Baged cool”', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(394, 18, 399, 400, 2, 'com_modules.module.278', 'Bootstrap', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(395, 18, 401, 402, 2, 'com_modules.module.279', 'Search', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(396, 18, 403, 404, 2, 'com_modules.module.280', 'Search', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(397, 18, 405, 406, 2, 'com_modules.module.281', 'Menu Bottom', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(398, 18, 407, 408, 2, 'com_modules.module.282', 'Support customer', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(399, 18, 409, 410, 2, 'com_modules.module.283', 'Search top', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(400, 1, 670, 671, 1, 'com_easyblog', 'easyblog', '{}'),
(401, 18, 411, 412, 2, 'com_modules.module.284', 'Newsletter', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(402, 18, 413, 414, 2, 'com_modules.module.285', 'Are You Ready To Enjoy', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(403, 1, 672, 673, 1, 'com_k2', 'com_k2', '{"core.admin":[],"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(404, 18, 415, 416, 2, 'com_modules.module.286', 'Top Comments', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(405, 18, 417, 418, 2, 'com_modules.module.287', 'Top Ratings', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(406, 18, 419, 420, 2, 'com_modules.module.288', 'K2 Tools', ''),
(407, 18, 421, 422, 2, 'com_modules.module.289', 'K2 Users', ''),
(408, 18, 423, 424, 2, 'com_modules.module.290', 'K2 User', ''),
(409, 18, 425, 426, 2, 'com_modules.module.291', 'K2 Quick Icons (admin)', ''),
(410, 18, 427, 428, 2, 'com_modules.module.292', 'K2 Stats (admin)', ''),
(411, 18, 429, 430, 2, 'com_modules.module.293', 'Sj News Scroller', ''),
(412, 18, 431, 432, 2, 'com_modules.module.294', 'New Review Video', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(413, 18, 433, 434, 2, 'com_modules.module.295', 'Our Blog', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(414, 18, 435, 436, 2, 'com_modules.module.296', 'HTML5 Introduction11', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(415, 18, 437, 438, 2, 'com_modules.module.297', 'Popular tags', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(416, 18, 439, 440, 2, 'com_modules.module.298', 'Custom module', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(417, 18, 441, 442, 2, 'com_modules.module.299', 'Who''s online', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(418, 18, 443, 444, 2, 'com_modules.module.300', 'Categories', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(419, 18, 445, 446, 2, 'com_modules.module.301', 'Sj Module Tabs', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(420, 18, 447, 448, 2, 'com_modules.module.302', 'Top Comments', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(421, 18, 449, 450, 2, 'com_modules.module.303', 'Partner', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(422, 18, 451, 452, 2, 'com_modules.module.304', 'Meet Our Team', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(423, 18, 453, 454, 2, 'com_modules.module.305', 'مدونتنا', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(424, 18, 455, 456, 2, 'com_modules.module.306', 'NOTRE BLOG', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(425, 18, 457, 458, 2, 'com_modules.module.307', 'الفئات', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(426, 18, 459, 460, 2, 'com_modules.module.308', 'Catégories', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(427, 18, 461, 462, 2, 'com_modules.module.309', 'وحدة مخصصة', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(428, 18, 463, 464, 2, 'com_modules.module.310', 'Module personnalisé', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(429, 18, 465, 466, 2, 'com_modules.module.311', 'Qui est en ligne', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(430, 18, 467, 468, 2, 'com_modules.module.312', 'Mots-clés populaires', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(431, 18, 469, 470, 2, 'com_modules.module.313', 'به شعبية', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(432, 18, 471, 472, 2, 'com_modules.module.314', 'من هو على الانترنت', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(433, 18, 473, 474, 2, 'com_modules.module.315', 'استعراض فيديو جديدة', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(434, 18, 475, 476, 2, 'com_modules.module.316', 'Nouvelle Vidéo', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(435, 18, 477, 478, 2, 'com_modules.module.317', 'Slideshow', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(436, 18, 479, 480, 2, 'com_modules.module.318', 'Prêt jouir', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(437, 18, 481, 482, 2, 'com_modules.module.319', 'استمتع جاهزة', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(438, 18, 483, 484, 2, 'com_modules.module.320', 'Slideshow', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(439, 8, 275, 284, 2, 'com_content.category.92', 'Slideshow', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(440, 439, 276, 277, 3, 'com_content.article.199', 'Lorem ipsum dolor sit amet', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(441, 439, 278, 279, 3, 'com_content.article.200', 'Fusce in bibendum dolor', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(442, 18, 485, 486, 2, 'com_modules.module.321', 'تلبية فريقنا', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(443, 18, 487, 488, 2, 'com_modules.module.322', 'تلبية فريقنا', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(444, 18, 489, 490, 2, 'com_modules.module.323', 'Rencontrez notre équipe', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(445, 1, 674, 675, 1, '#__ucm_content.14', '#__ucm_content.14', '[]'),
(446, 1, 676, 677, 1, '#__ucm_content.15', '#__ucm_content.15', '[]'),
(447, 181, 201, 202, 4, 'com_content.article.201', 'Paze duma kire', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(448, 18, 491, 492, 2, 'com_modules.module.115', '"icon-user" Style ', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(449, 18, 493, 494, 2, 'com_modules.module.324', 'Find us on the map', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(450, 18, 495, 496, 2, 'com_modules.module.325', 'Archive', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(451, 18, 497, 498, 2, 'com_modules.module.326', 'Blog Categories', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(452, 18, 499, 500, 2, 'com_modules.module.327', 'Login', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(453, 18, 501, 502, 2, 'com_modules.module.328', 'Latest Blogs', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(454, 18, 503, 504, 2, 'com_modules.module.329', 'Calendar', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(455, 18, 505, 506, 2, 'com_modules.module.330', 'EasyBlog Select List', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(456, 18, 507, 508, 2, 'com_modules.module.331', 'EasyBlog Most Active Bloggers', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(457, 18, 509, 510, 2, 'com_modules.module.332', 'EasyBlog Tag Cloud', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(458, 18, 511, 512, 2, 'com_modules.module.333', 'Contact Us', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(459, 18, 513, 514, 2, 'com_modules.module.334', 'أرشيف', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(460, 18, 515, 516, 2, 'com_modules.module.335', 'Archives', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(461, 18, 517, 518, 2, 'com_modules.module.336', 'Sélectionnez un Compte', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(462, 18, 519, 520, 2, 'com_modules.module.337', 'حدد حساب', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(463, 18, 521, 522, 2, 'com_modules.module.338', 'بلوق التصنيفات', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(464, 18, 523, 524, 2, 'com_modules.module.339', 'Catégories de Blog', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(465, 18, 525, 526, 2, 'com_modules.module.340', 'Derniers Blogs', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(466, 18, 527, 528, 2, 'com_modules.module.341', 'أحدث المدونات', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(467, 439, 280, 281, 3, 'com_content.article.202', 'Lorem ipsum dolor sit amet', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(468, 439, 282, 283, 3, 'com_content.article.203', 'Lorem ipsum dolor sit amet', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(469, 18, 529, 530, 2, 'com_modules.module.342', 'Social', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(470, 18, 531, 532, 2, 'com_modules.module.343', 'Categories', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(471, 18, 533, 534, 2, 'com_modules.module.344', 'الفئات', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(472, 18, 535, 536, 2, 'com_modules.module.345', 'Catégories', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(473, 18, 537, 538, 2, 'com_modules.module.346', 'Who''s online?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(474, 8, 285, 286, 2, 'com_content.category.93', 'Shortcodes', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(475, 181, 203, 204, 4, 'com_content.article.204', 'Cinia Sed convallis urna 1111 (2)', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(476, 18, 539, 540, 2, 'com_modules.module.347', 'Partner', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(477, 1, 678, 679, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
(478, 1, 680, 681, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(479, 1, 682, 683, 1, 'com_ajax', 'com_ajax', '{}'),
(480, 1, 684, 685, 1, 'com_postinstall', 'com_postinstall', '{}'),
(481, 18, 541, 542, 2, 'com_modules.module.348', 'Slideshow', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}');

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE IF NOT EXISTS `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE IF NOT EXISTS `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `params` text NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

INSERT INTO `#__banners` (`id`, `cid`, `type`, `name`, `alias`, `imptotal`, `impmade`, `clicks`, `clickurl`, `state`, `catid`, `description`, `custombannercode`, `sticky`, `ordering`, `metakey`, `params`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `reset`, `created`, `language`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `version`) VALUES
(2, 1, 0, 'Shop 1', 'shop-1', 0, 212, 1, 'http://shop.joomla.org/amazoncom-bookstores.html', -2, 15, 'Get books about Joomla! at the Joomla! book shop.', '', 0, 0, '', '{"imageurl":"images\\/banners\\/shop-ad-books.jpg","width":"","height":"","alt":"Joomla! Books"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2011-01-01 00:00:01', 'en-GB', 0, '', '0000-00-00 00:00:00', 0, 1),
(3, 1, 0, 'Shop 2', 'shop-2', 0, 65, 0, 'http://shop.joomla.org', -2, 15, 'T Shirts, caps and more from the Joomla! Shop.', '', 0, 0, '', '{"imageurl":"images\\/banners\\/shop-ad.jpg","width":"","height":"","alt":"Joomla! Shop"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2011-01-01 00:00:01', 'en-GB', 0, '', '0000-00-00 00:00:00', 0, 1),
(4, 1, 0, 'Support Joomla!', 'support-joomla', 0, 75, 0, 'http://contribute.joomla.org', -2, 15, 'Your contributions of time, talent and money make Joomla! possible.', '', 0, 0, '', '{"imageurl":"images\\/banners\\/white.png","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 'en-GB', 0, '', '0000-00-00 00:00:00', 0, 1),
(5, 0, 0, 'SJ MerryChristmas', 'sj-merrychristmas', 0, 6087, 0, 'http://demo.smartaddons.com/templates/joomla17/?template=sj-merrychristmas', -2, 83, '', '', 0, 0, '', '{"imageurl":"images\\/banners\\/sj-merry.jpg","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2012-02-08 00:00:00', '2012-01-08 16:47:04', '*', 0, '', '0000-00-00 00:00:00', 0, 1);

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` text NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `#__banner_clients` (`id`, `name`, `contact`, `email`, `extrainfo`, `state`, `checked_out`, `checked_out_time`, `metakey`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`) VALUES
(1, 'Joomla!', 'Administrator', 'email@email.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, -1, -1);

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned DEFAULT NULL,
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=94 ;

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 119, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(9, 34, 1, 97, 98, 1, 'explore', 'com_content', 'Explore', 'explore', '', '\r\n', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2011-01-01 00:00:01', 42, '2013-03-29 01:53:47', 0, '*', 1),
(10, 35, 1, 95, 96, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(11, 36, 1, 91, 92, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(12, 37, 1, 27, 28, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(13, 38, 1, 23, 24, 1, 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(14, 39, 1, 9, 22, 1, 'sample-data-articles', 'com_content', 'Sample Data-Articles', 'sample-data-articles', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(15, 40, 1, 93, 94, 1, 'sample-data-banners', 'com_banners', 'Sample Data-Banners', 'sample-data-banners', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(16, 41, 1, 29, 90, 1, 'sample-data-contact', 'com_contact', 'Sample Data-Contact', 'sample-data-contact', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(17, 42, 1, 25, 26, 1, 'sample-data-newsfeeds', 'com_newsfeeds', 'Smartaddons-Newsfeeds', 'sample-data-newsfeeds', '', '\r\n', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2011-01-01 00:00:01', 42, '2013-04-10 04:46:30', 0, '*', 1),
(18, 43, 1, 1, 8, 1, 'sample-data-weblinks', 'com_weblinks', 'Sample Data-Weblinks', 'sample-data-weblinks', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(19, 44, 14, 10, 21, 2, 'sample-data-articles/joomla', 'com_content', 'Joomla!', 'joomla', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 42, '2011-01-01 00:00:01', 0, '*', 1),
(20, 45, 19, 11, 20, 3, 'sample-data-articles/joomla/extensions', 'com_content', 'Extensions', 'extensions', '', '<p>The Joomla! content management system lets you create webpages of various types using extensions. There are 5 basic types of extensions: components, modules, templates, languages, and plugins. Your website includes the extensions you need to create a basic website in English, but thousands of additional extensions of all types are available. The <a href="http://extensions.joomla.org" style="color: #1b57b1; text-decoration: none; font-weight: normal;">Joomla! Extensions Directory</a> is the largest directory of Joomla! extensions.</p>', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 42, '2011-01-01 00:00:01', 0, '*', 1),
(21, 46, 20, 12, 13, 4, 'sample-data-articles/joomla/extensions/components', 'com_content', 'Components', 'components', '', '<p><img src="administrator/templates/bluestork/images/header/icon-48-component.png" class="image-left" alt="Component Image" />Components are larger extensions that produce the major content for your site. Each component has one or more "views" that control how content is displayed.In the Joomla! administrator there are additional extensions suce as Menus, Redirection, and the extension managers.</p>', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 42, '2011-01-01 00:00:01', 0, '*', 1),
(22, 47, 20, 14, 17, 4, 'sample-data-articles/joomla/extensions/modules', 'com_content', 'Modules', 'modules', '', '<p><img src="administrator/templates/bluestork/images/header/icon-48-module.png" alt="Media Image" class="image-left" />Modules are small blocks of content that can be displayed in positions on a web page. The menus on this site are displayed in modules. The core of Joomla! includes 17 separate modules ranging from login to search to random images. Each module has a name that starts mod_ but when it displays it has a title. In the descriptions in this section, the titles are the same as the names.</p>', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 42, '2011-01-01 00:00:01', 0, '*', 1),
(25, 50, 20, 18, 19, 4, 'sample-data-articles/joomla/extensions/plugins', 'com_content', 'Plugins', 'plugins', '', '<p><img src="administrator/templates/bluestork/images/header/icon-48-plugin.png" border="0" alt="Plugin Image" align="left" />Plugins are small task oriented extensions that enhance the Joomla! framework. Some are associated with particular extensions and others, such as editors, are used across all of Joomla!. Most beginning users do not need to change any of the plugins that install with Joomla!. <a href="http://help.joomla.org/proxy/index.php?option=com_help&keyref=Help16:Extensions_Plugin_Manager_Edit">Help</a></p>', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2011-01-01 00:00:01', 42, '2011-01-10 04:05:05', 0, '*', 1),
(31, 56, 18, 2, 3, 2, 'sample-data-weblinks/park-links', 'com_weblinks', ' Smartaddons ', 'park-links', '', '<p style="margin-bottom:30px;">\r\nWelcome to <strong>SmartAddons'' </strong>Joomla template and WordPress theme clubs. We offer 50+ eye-catching website templates and 150+ professional Joomla ...\r\n</p>\r\n\r\n', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"images\\/sampledata\\/parks\\/banner_cradle.jpg"}', '', '', '{"author":"","robots":""}', 415, '2011-01-01 00:00:01', 315, '2014-01-14 15:51:21', 0, 'en-GB', 1),
(32, 57, 18, 4, 7, 2, 'sample-data-weblinks/joomla-specific-links', 'com_weblinks', 'Joomla! Specific Links', 'joomla-specific-links', '', '<p><div style="font-family: Tahoma, Helvetica, Arial, sans-serif; font-size: 76%; background-color: #ffffff; background-image: initial; background-attachment: initial; background-origin: initial; background-clip: initial; line-height: 1.3em; color: #333333;"><p>A selection of links that are all related to the Joomla! Project.</p></div></p>', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(33, 58, 32, 5, 6, 3, 'sample-data-weblinks/joomla-specific-links/other-resources', 'com_weblinks', 'Other Resources', 'other-resources', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(34, 59, 16, 30, 31, 2, 'sample-data-contact/park-site', 'com_contact', 'Park Site', 'park-site', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 42, '2011-01-01 00:00:01', 0, 'en-GB', 1),
(35, 60, 16, 32, 89, 2, 'sample-data-contact/shop-site', 'com_contact', 'Shop Site', 'shop-site', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(36, 61, 35, 33, 34, 3, 'sample-data-contact/shop-site/staff', 'com_contact', 'Staff', 'staff', '', '<p>Please feel free to contact our staff at any time should you need assistance.</p>', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(37, 62, 35, 35, 88, 3, 'sample-data-contact/shop-site/fruit-encyclopedia', 'com_contact', 'Fruit Encyclopedia', 'fruit-encyclopedia', '', '<p> </p><p>Our directory of information about different kinds of fruit.</p><p>We love fruit and want the world to know more about all of its many varieties.</p><p>Although it is small now, we work on it whenever we have a chance.</p><p>All of the images can be found in <a href="http://commons.wikimedia.org/wiki/Main_Page">Wikimedia Commons</a>.</p><p><img src="images/sampledata/fruitshop/apple.jpg" border="0" alt="Apples" title="Apples" /></p><p><em>This encyclopedia is implemented using the contact component, each fruit a separate contact and a category for each letter. A CSS style is used to create the horizontal layout of the alphabet headings. </em></p><p><em>If you wanted to, you could allow some users (such as your growers) to have access to just this category in the contact component and let them help you to create new content for the encyclopedia.</em></p><p> </p>', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(38, 63, 37, 36, 37, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/a', 'com_contact', 'A', 'a', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(39, 64, 37, 38, 39, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/b', 'com_contact', 'B', 'b', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(40, 65, 37, 40, 41, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/c', 'com_contact', 'C', 'c', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(41, 66, 37, 42, 43, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/d', 'com_contact', 'D', 'd', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(42, 67, 37, 44, 45, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/e', 'com_contact', 'E', 'e', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(43, 68, 37, 46, 47, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/f', 'com_contact', 'F', 'f', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(44, 69, 37, 48, 49, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/g', 'com_contact', 'G', 'g', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(45, 70, 37, 50, 51, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/h', 'com_contact', 'H', 'h', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(46, 71, 37, 52, 53, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/i', 'com_contact', 'I', 'i', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(47, 72, 37, 54, 55, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/j', 'com_contact', 'J', 'j', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(48, 73, 37, 56, 57, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/k', 'com_contact', 'K', 'k', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(49, 74, 37, 58, 59, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/l', 'com_contact', 'L', 'l', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(50, 75, 37, 60, 61, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/m', 'com_contact', 'M', 'm', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(51, 76, 37, 62, 63, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/n', 'com_contact', 'N', 'n', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(52, 77, 37, 64, 65, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/o', 'com_contact', 'O', 'o', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(53, 78, 37, 66, 67, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/p', 'com_contact', 'P', 'p', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(54, 79, 37, 68, 69, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/q', 'com_contact', 'Q', 'q', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(55, 80, 37, 70, 71, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/r', 'com_contact', 'R', 'r', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(56, 81, 37, 72, 73, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/s', 'com_contact', 'S', 's', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(57, 82, 37, 74, 75, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/t', 'com_contact', 'T', 't', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(58, 83, 37, 76, 77, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/u', 'com_contact', 'U', 'u', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(59, 84, 37, 78, 79, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/v', 'com_contact', 'V', 'v', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(60, 85, 37, 80, 81, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/w', 'com_contact', 'W', 'w', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(61, 86, 37, 82, 83, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/x', 'com_contact', 'X', 'x', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(62, 87, 37, 84, 85, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/y', 'com_contact', 'Y', 'y', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(63, 88, 37, 86, 87, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/z', 'com_contact', 'Z', 'z', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(66, 95, 22, 15, 16, 5, 'sample-data-articles/joomla/extensions/modules/display-modules', 'com_content', 'Display Modules', 'display-modules', '', '<p>These modules display information from components other than content and user. These include weblinks, news feeds and the media manager.</p>', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 415, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*', 1),
(78, 180, 84, 102, 103, 2, 'yt-sample-data/content-category-1', 'com_content', 'Content Category 1', 'content-category-1', '', '<p> Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit. </p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2011-05-26 16:40:47', 42, '2012-11-28 18:30:52', 64, '*', 1),
(79, 181, 84, 104, 105, 2, 'yt-sample-data/content-category-2', 'com_content', 'Content Category 2', 'content-category-2', '', ' Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit. ', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2011-05-26 16:42:50', 42, '2012-11-28 18:31:02', 2, '*', 1),
(80, 202, 84, 106, 107, 2, 'yt-sample-data/content-category-3', 'com_content', 'Content Category 3', 'content-category-3', '', ' Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit. ', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2011-05-28 02:43:19', 42, '2012-11-28 18:31:11', 0, '*', 1),
(81, 203, 84, 108, 109, 2, 'yt-sample-data/content-category-4', 'com_content', 'Content Category 4', 'content-category-4', '', ' Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit. ', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2011-05-28 02:45:10', 42, '2012-11-28 18:31:21', 0, '*', 1),
(83, 241, 1, 99, 100, 1, 'jtc', 'com_banners', 'JTC', 'jtc', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2012-01-08 16:46:31', 0, '0000-00-00 00:00:00', 0, '*', 1),
(84, 245, 1, 101, 110, 1, 'yt-sample-data', 'com_content', 'Yt Sample Data', 'yt-sample-data', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2012-01-11 03:02:28', 0, '0000-00-00 00:00:00', 0, '*', 1),
(85, 249, 1, 111, 112, 1, 'contact', 'com_contact', 'Contact', 'contact', '', '\r\n', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2012-02-28 04:25:59', 42, '2013-04-05 09:02:16', 0, '*', 1),
(91, 298, 1, 113, 114, 1, 'joomla-page', 'com_content', 'Joomla page', 'joomla-page', '', '<div class="jf_typo_accord_container" style="display: block;">Dignissim nec odio pid etiam sagittis aliquet sed dis, tincidunt, etiam rhoncus odio mus proin amet vel, sit urna? Lundium, auctor integer elementum vel dolor! Etiam? Et a enim nunc non massa porta, sed, dolor tincidunt magna penatibus vut purus nec nisi, duis enim et odio! In turpis, montes scelerisque proin nec urna sit, aliquet augue turpis, phasellus lundium tristique.</div>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2013-02-25 04:42:52', 0, '0000-00-00 00:00:00', 0, '*', 1),
(92, 439, 1, 115, 116, 1, 'slideshow', 'com_content', 'Slideshow', 'slideshow', '', '', 1, 660, '2014-03-28 02:01:53', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2014-03-17 08:39:09', 0, '0000-00-00 00:00:00', 0, '*', 1),
(93, 474, 1, 117, 118, 1, 'short-code', 'com_content', 'Shortcodes', 'short-code', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 415, '2014-03-26 10:18:18', 660, '2014-03-26 10:19:12', 0, '*', 1);

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` text,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext,
  `image` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned DEFAULT NULL,
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL,
  `sortname2` varchar(255) NOT NULL,
  `sortname3` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Contact Name Here', 'name', 'Position', 'Street Address', 'Suburb', 'State', 'Country', 'Zip Code', 'Telephone', 'Fax', '<p>Information about or by the contact.</p>', 'images/powered_by.png', 'email@email.com', 1, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Twitter","linka":"http:\\/\\/twitter.com\\/joomla","linkb_name":"YouTube","linkb":"http:\\/\\/www.youtube.com\\/user\\/joomla","linkc_name":"Facebook","linkc":"http:\\/\\/www.facebook.com\\/joomla","linkd_name":"FriendFeed","linkd":"http:\\/\\/friendfeed.com\\/joomla","linke_name":"Scribed","linke":"http:\\/\\/www.scribd.com\\/people\\/view\\/504592-joomla","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 16, 1, '', '', 'last', 'first', 'middle', 'en-GB', '2011-01-01 00:00:01', 415, '', '2011-01-08 17:39:00', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(2, 'Webmaster', 'webmaster', '', '', '', '', '', '', '', '', '', '', 'webmaster@example.com', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"","redirect":""}', 0, 34, 1, '', '', '', '', '', 'en-GB', '2011-01-01 00:00:01', 415, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(3, 'Owner', 'owner', '', '', '', '', '', '', '', '', '<p>I''m the owner of this store.</p>', '', '', 0, -2, 0, '0000-00-00 00:00:00', 2, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 36, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 415, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(4, 'Buyer', 'buyer', '', '', '', '', '', '', '', '', '<p>I am in charge of buying fruit. If you sell good fruit, contact me.</p>', '', '', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"0","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 36, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 415, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(5, 'Bananas', 'bananas', 'Scientific Name: Musa', 'Image Credit: Enzik\r\nRights: Creative Commons Share Alike Unported 3.0\r\nSource: http://commons.wikimedia.org/wiki/File:Bananas_-_Morocco.jpg', '', 'Type: Herbaceous', 'Large Producers: India, China, Brasil', '', '', '', '<p>Bananas are a great source of potassium.</p>\r\n<p> </p>', 'images/sampledata/fruitshop/bananas_2.jpg', '', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"show_with_link","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"1","show_email":"","show_street_address":"","show_suburb":"","show_state":"1","show_postcode":"","show_country":"1","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Wikipedia: Banana English","linka":"http:\\/\\/en.wikipedia.org\\/wiki\\/Banana","linkb_name":"Wikipedia:  \\u0939\\u093f\\u0928\\u094d\\u0926\\u0940 \\u0915\\u0947\\u0932\\u093e","linkb":"http:\\/\\/hi.wikipedia.org\\/wiki\\/%E0%A4%95%E0%A5%87%E0%A4%B2%E0%A4%BE","linkc_name":"Wikipedia:Banana Portugu\\u00eas","linkc":"http:\\/\\/pt.wikipedia.org\\/wiki\\/Banana","linkd_name":"Wikipedia: \\u0411\\u0430\\u043d\\u0430\\u043d  \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","linkd":"http:\\/\\/ru.wikipedia.org\\/\\u0411\\u0430\\u043d\\u0430\\u043d","linke_name":"","linke":"","contact_layout":"beez5:encyclopedia"}', 0, 39, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 415, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(6, 'Apples', 'apples', 'Scientific Name: Malus domestica', 'Image Credit: Fievet\r\nRights: Public Domain\r\nSource: http://commons.wikimedia.org/wiki/File:Pommes_vertes.JPG', '', 'Family: Rosaceae', 'Large: Producers: China, United States', '', '', '', '<p>Apples are a versatile fruit, used for eating, cooking, and preserving.</p>\r\n<p>There are more that 7500 different kinds of apples grown around the world.</p>', 'images/sampledata/fruitshop/apple.jpg', '', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Wikipedia: Apples English","linka":"http:\\/\\/en.wikipedia.org\\/wiki\\/Apple","linkb_name":"Wikipedia: Manzana Espa\\u00f1ol ","linkb":"http:\\/\\/es.wikipedia.org\\/wiki\\/Manzana","linkc_name":"Wikipedia: \\u82f9\\u679c \\u4e2d\\u6587","linkc":"http:\\/\\/zh.wikipedia.org\\/zh\\/\\u82f9\\u679c","linkd_name":"Wikipedia: Tofaa Kiswahili","linkd":"http:\\/\\/sw.wikipedia.org\\/wiki\\/Tofaa","linke_name":"","linke":"","contact_layout":"beez5:encyclopedia"}', 0, 38, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 415, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(7, 'Tamarind', 'tamarind', 'Scientific Name: Tamarindus indica', 'Image Credit: Franz Eugen Köhler, Köhler''s Medizinal-Pflanzen \r\nRights: Public Domain\r\nSource:http://commons.wikimedia.org/wiki/File:Koeh-134.jpg', '', 'Family: Fabaceae', 'Large Producers: India, United States', '', '', '', '<p>Tamarinds are a versatile fruit used around the world. In its young form it is used in hot sauces; ripened it is the basis for many refreshing drinks.</p>\r\n<p> </p>', 'images/sampledata/fruitshop/tamarind.jpg', '', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Wikipedia: Tamarind English","linka":"http:\\/\\/en.wikipedia.org\\/wiki\\/Tamarind","linkb_name":"Wikipedia: \\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2  \\u09ac\\u09be\\u0982\\u09b2\\u09be  ","linkb":"http:\\/\\/bn.wikipedia.org\\/wiki\\/\\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2 ","linkc_name":"Wikipedia: Tamarinier Fran\\u00e7ais","linkc":"http:\\/\\/fr.wikipedia.org\\/wiki\\/Tamarinier","linkd_name":"Wikipedia:Tamaline lea faka-Tonga","linkd":"http:\\/\\/to.wikipedia.org\\/wiki\\/Tamaline","linke_name":"","linke":"","contact_layout":"beez5:encyclopedia"}', 0, 57, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 415, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(8, 'Shop Address', 'shop-address', '', '', 'Our City', 'Our Province', 'Our Country', '', '555-555-5555', '', '<p>Here are directions for how to get to our shop.</p>', '', '', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 35, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 415, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(9, 'Jane Q. Public', 'jane-q-public', ' Chief Information Officer ', '40th Street, Oakland, California, United States ', 'Cupertino', 'California', 'USA', '95014', ' 1-212-555555-1 ', '', '<p>Forem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque convallis ligula eget tellus lacinia tristique. Vivamus convallis tristique fringilla. Pellentesque pharetra, lacus tincidunt pulvinar facilisis</p>\r\n<div class="add1">Add 1 : 40th Street, Oakland, California, United States <br />Tel : 084 - 00 - 12345678 <br />Email : <a href="mailto:contact@ytcvn.com">contact@ytcvn.com </a></div>\r\n<div class="add2">Add 2 : 40th Street, Oakland, California, United States <br />Tel : 084 - 00 - 12345678 <br />Email : contact@ytcvn.com </div>', '', 'noreply@smartaddons.com', 0, 1, 660, '2014-03-20 04:04:50', 3, '{"show_contact_category":"hide","show_contact_list":"0","presentation_style":"","show_tags":"0","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"1","show_links":"0","linka_name":"","linka":false,"linkb_name":"","linkb":false,"linkc_name":"","linkc":false,"linkd_name":"","linkd":false,"linke_name":"","linke":"","contact_layout":"","show_email_form":"","show_email_copy":"0","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 85, 1, ' 1-212-555555-1 ', 'http://smartaddons.com', '', '', '', '*', '2012-02-28 04:26:36', 415, '', '2014-03-20 04:04:50', 660, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 8, 274),
(10, 'Jane Q. Public 2', 'jane-q-public11', ' Chief Information Officer ', '', 'Cupertino', 'California', 'USA', '', ' 1-212-555555-1 ', '', '<p>\r\nForem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque convallis ligula eget tellus lacinia tristique. Vivamus convallis tristique fringilla. Pellentesque pharetra, lacus tincidunt pulvinar facilisis\r\n</p>\r\n\r\n', 'images/demo/sam-15.jpg', 'noreply@smartaddons.com', 0, 1, 0, '0000-00-00 00:00:00', 3, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"0","show_position":"","show_email":"0","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"1","show_links":"0","linka_name":"","linka":null,"linkb_name":"","linkb":null,"linkc_name":"","linkc":null,"linkd_name":"","linkd":null,"linke_name":"","linke":"","contact_layout":"","show_email_form":"","show_email_copy":"0","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 42, 85, 1, ' 1-212-555555-1 ', 'http://.', '', '', '', '*', '2012-02-28 04:26:36', 415, '', '2013-05-07 08:20:40', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0);

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=205 ;

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(5, 101, 'Authentication', 'authentication', '<p>The authentication plugins operate when users login to your site or administrator. The Joomla! authentication is in operation by default but you can enable Gmail or LDAP or install a plugin for a different system. An example is included that may be used to create a new authentication plugin.</p><p>Default on:</p><ul><li>Joomla</li></ul><p>Default off:</p><ul><li>Gmail</li><li>LDAP</li></ul>', '', 2, 25, '2011-01-01 00:00:01', 415, 'Joomla!', '2011-01-01 00:00:01', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 1, 3, '', '', 1, 2, '', 0, '*', ''),
(7, 103, 'Banner Module', 'banner-module', '<p>The banner module is used to display the banners that are managed by the banners component in the site administrator. <a href="http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help16:Extensions_Module_Manager_Banners">Help</a>.</p>\r\n<p>{loadposition bannersload}</p>', '', 2, 66, '2011-01-01 00:00:01', 415, 'Joomla!', '2011-01-10 03:41:15', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 2, 6, '', '', 1, 4, '', 0, '*', ''),
(8, 104, 'Beginners', 'beginners', '<p>If this is your first Joomla site or your first web site, you have come to the right place. Joomla will help you get your website up and running quickly and easily.</p>\r\n<p>Start off using your site by logging in using the administrator account you created when you installed Joomla!.</p>\r\n', '\r\n<p>Explore the articles and other resources right here on your site data to learn more about how Joomla works.(When you''re done reading, you can delete or archive all of this.) You will also probably want to visit the beginners'' areas of the <a href="http://docs.joomla.org/Beginners">Joomla documentation</a> and <a href="http://forum.joomla.org">support forums</a>.</p>\r\n<p>You''ll also want to sign up for the Joomla Security Mailing list and the Announcements mailing list. For inspiration visit the Joomla Site Showcase to see an amazing array of ways people use Joomla to tell their stories on the web.</p>\r\n<p>The basic Joomla! installation will let you get a great site up and running, but when you are ready for more features the power of Joomla! is in the creative ways that developers have extended it to do all kinds of things. Visit the Joomla! Extensions Directory to see thousands of extensions that can do almost anything you could want on a website. Can''t find what you need? You may want to find a Joomla professional on the Joomla! Resources Directory.</p>\r\n<p>Want to learn more? Consider attending a Joomla! Day or other event or joining a local Joomla! Users Group. Can''t find one near you? Start one yourself.</p>', 2, 19, '2011-01-01 00:00:01', 415, 'Joomla!', '2011-01-09 16:41:00', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 3, 4, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(24, 122, 'Joomla!', 'joomla', '<p>Congratulations! You have a Joomla! site! Joomla! makes it easy to build a website just the way you want it and keep it simple to update and maintain.</p>\r\n<p>Joomla! is a flexible and powerful platform, whether you are building a small site for yourself or a huge site with hundreds of thousands of visitors. Joomla is open source, which means you can make it work just the way you want it to.</p>', '', 1, 19, '2011-01-01 00:00:01', 415, 'Joomla!', '2011-06-29 04:53:32', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 2, 2, '', '', 1, 53, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(53, 151, 'Using Joomla!', 'using-joomla', '<p>With Joomla! You can create anything from a simple personal website to a complex ecommerce or social site with millions of visitors.</p><p>This section of the sample data provides you with a brief introduction to Joomla! concepts and reference material to help you understand how Joomla! works.</p><p><em>When you no longer need the sample data, you can can simply unpublish the sample data category found within each extension in the site administrator or you may completely delete each item and all of the categories. </em></p>', '', 1, 19, '2011-01-01 00:00:01', 415, 'Joomla!', '2013-03-09 04:54:02', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 7, '', '', 1, 21, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(67, 168, 'What''s New in 1.5?', 'whats-new-in-15', '<p>As with previous releases, Joomla! provides a unified and easy-to-use framework for delivering content for Web sites of all kinds. To support the changing nature of the Internet and emerging Web technologies, Joomla! required substantial restructuring of its core functionality and we also used this effort to simplify many challenges within the current user interface. Joomla! 1.5 has many new features.</p>\r\n<p style="margin-bottom: 0in;">In Joomla! 1.5, you''''ll notice:</p>\r\n<ul>\r\n<li>Substantially improved usability, manageability, and scalability far beyond the original Mambo foundations</li>\r\n<li>Expanded accessibility to support internationalisation, double-byte characters and right-to-left support for Arabic, Farsi, and Hebrew languages among others</li>\r\n<li>Extended integration of external applications through Web services</li>\r\n<li>Enhanced content delivery, template and presentation capabilities to support accessibility standards and content delivery to any destination</li>\r\n<li>A more sustainable and flexible framework for Component and Extension developers</li>\r\n<li>Backward compatibility with previous releases of Components, Templates, Modules, and other Extensions</li>\r\n</ul>', '', 2, 9, '2011-01-01 00:00:01', 415, 'Joomla! 1.5', '2011-01-01 00:00:01', 0, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 1, 6, '', '', 1, 6, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(78, 182, 'Tames pede elit', 'tames-pede-elit', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 78, '2011-05-26 16:44:15', 415, '', '2014-03-17 15:39:12', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:44:15', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c16.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c16.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 10, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(79, 183, 'Xulla semper Curabitur luctus', 'xulla-semper-ac-nec-sit', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 78, '2011-05-26 16:45:24', 415, '', '2014-03-17 15:41:38', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:45:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c18.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c18.jpg","float_fulltext":"","image_fulltext_alt":"Curabitur luctus tortor non quam gravida ultrices","image_fulltext_caption":"Curabitur luctus tortor non quam gravida ultrices"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 9, '', '', 1, 23, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(80, 184, 'Detus laoreet dignissim ', 'detus-laoreet-dignissim-vel', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 78, '2011-05-26 16:46:07', 415, '', '2014-03-17 15:35:22', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:46:07', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c11.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c11.jpg","float_fulltext":"","image_fulltext_alt":"Detus laoreet dignissim ","image_fulltext_caption":"Detus laoreet dignissim "}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 12, 8, '', '', 1, 62, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(81, 185, 'Lacinia Sed convallis ', 'lacinia-sed-convallis-urna', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 78, '2011-05-26 16:46:50', 415, '', '2014-03-17 15:37:08', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:46:50', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c13.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c13.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 7, '', '', 1, 20, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(82, 186, 'Mes pede elit nibh ', 'mes-pede-elit-nibh', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 78, '2011-05-26 16:48:10', 415, '', '2014-03-17 15:38:32', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:48:10', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c15.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c15.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 6, '', '', 1, 31, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(83, 187, 'Mauris ut mauris ', 'mauris-ut-mauris-vel-libero', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit.</p>\r\n<p>[space height="20px"]</p>\r\n<div class="g-pageteam">\r\n<div class="row-fluid b-gettouch">\r\n<div class="span9">\r\n<h4 class="h-heading4">Donec purus nibh, commodo ac pellentesque quis, vehicula ut leo. Suspendisse potenti. Sed rhoncus est ac arcu malesuada bibendum. Cras ut nisi id lacus aliquam sodales</h4>\r\n</div>\r\n<div class="span3"><a class="btn btn-3d green" style="border-radius: 3px;" href="#" target=""> get in touch width us </a></div>\r\n</div>\r\n</div>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 78, '2011-05-26 16:49:05', 415, '', '2014-03-17 15:37:52', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:49:05', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c14.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c14.jpg","float_fulltext":"left","image_fulltext_alt":"Proin consectetur vestibulum tellus eu tempor","image_fulltext_caption":"Proin consectetur vestibulum tellus eu tempor"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 27, 5, '', '', 1, 88, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(84, 188, 'Misociis nulla interdum', 'misociis-nulla-interdum-et-cursus', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Aenean id turpis lectus. Duis eget consequat velit.nulla vel eros blandit placerat.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 79, '2011-05-26 16:50:18', 415, '', '2014-03-17 15:45:21', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:50:18', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c23.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c23.jpg","float_fulltext":"","image_fulltext_alt":"Misociis nulla interdum et","image_fulltext_caption":"Misociis nulla interdum et"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 5, '', '', 1, 21, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(85, 189, 'Aliquam lobortis cursus ', 'aliquam-lobortis-cursus-erat', '<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam sodales.</p>\r\n', '\r\n<p>[space height="15"]<br /> [quote width="auto" align="none" border="#666" color="#666" title="Smartaddon"] Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. [/quote]</p>\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>', 1, 78, '2011-05-26 16:51:13', 415, '', '2014-03-17 15:34:40', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:51:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c10.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c10.jpg","float_fulltext":"","image_fulltext_alt":"Garetra faucibus eu ","image_fulltext_caption":"Garetra faucibus eu "}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 22, 3, '', '', 1, 167, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(86, 190, 'Aenean vea aliquam', 'aenean-vehicula-vehicula-aliquam', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 78, '2011-05-26 16:52:24', 415, '', '2014-03-17 15:33:54', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:52:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c1.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":" Page break example","targeta":"","urlb":false,"urlbtext":" Stet clita kasd guber","targetb":"","urlc":false,"urlctext":" Curabitur a lectus vitae elit","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 55, 2, '', '', 1, 286, '{"robots":"","author":"","rights":"SJ Company","xreference":""}', 0, '*', ''),
(87, 191, 'Ursus senectus ', 'ursus-senectus-aliquet-pretium', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 78, '2011-05-26 16:53:19', 415, '', '2014-03-17 15:40:46', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:53:19', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c17.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c17.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 28, 4, '', '', 1, 84, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(88, 192, 'Ruci tenna mes', 'ruci-tenna-mes', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 79, '2011-05-26 16:54:17', 415, '', '2014-03-17 15:46:51', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:54:17', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c25.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c25.jpg","float_fulltext":"","image_fulltext_alt":"Vestibulum sit amet libero vel neque dapibus ultrices mattis massa","image_fulltext_caption":"Vestibulum sit amet libero vel neque dapibus ultrices mattis massa"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 10, '', '', 1, 62, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(90, 194, 'Us laoreet dignissim vel.', 'detus-laoreet-dignissim-vel', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 79, '2011-05-26 16:46:07', 415, '', '2014-03-17 15:49:07', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:46:07', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c4.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c4.jpg","float_fulltext":"","image_fulltext_alt":"Us laoreet dignissim vel.","image_fulltext_caption":"Us laoreet dignissim vel."}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 9, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(91, 195, 'Faucibus eu laoreet nunc', 'haretra-faucibus-eu-laoreet-nunc', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 78, '2011-05-26 16:52:24', 415, '', '2014-03-17 15:36:03', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:52:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c12.jpg","float_intro":"","image_intro_alt":"Faucibus eu laoreet nunc","image_intro_caption":"Faucibus eu laoreet nunc","image_fulltext":"images\\/SJ_iCenter\\/c12.jpg","float_fulltext":"","image_fulltext_alt":"Faucibus eu laoreet nunc","image_fulltext_caption":"Faucibus eu laoreet nunc"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 14, 1, '', '', 1, 77, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(92, 196, 'Cinia Sed convallis urna ', 'lacinia-sed-convallis-urna', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 79, '2011-05-26 16:46:50', 415, '', '2014-03-17 15:42:42', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:46:50', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c2.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c2.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 8, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(93, 197, 'Tes pede elit nibh ', 'mes-pede-elit-nibh', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 79, '2011-05-26 16:48:10', 415, '', '2014-03-17 15:48:16', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:48:10', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c3.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c3.jpg","float_fulltext":"","image_fulltext_alt":"Curabitur luctus tortor non quam","image_fulltext_caption":"Curabitur luctus tortor non quam"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(94, 198, 'Sociis nulla interdum et', 'misociis-nulla-interdum-et-cursu', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 79, '2011-05-26 16:50:18', 415, '', '2014-03-17 15:47:34', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:50:18', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c26.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c26.jpg","float_fulltext":"","image_fulltext_alt":"Sociis nulla interdum et","image_fulltext_caption":"Sociis nulla interdum et"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 6, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(95, 199, 'Gimes pede elit', 'tames-pede-elit', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 79, '2011-05-26 16:44:15', 415, '', '2014-03-17 15:43:17', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:44:15', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c21.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c21.jpg","float_fulltext":"","image_fulltext_alt":">Vestibulum sit amet libero vel neque","image_fulltext_caption":">Vestibulum sit amet libero vel neque"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 4, '', '', 1, 6, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(96, 200, 'Kril penectus aliquet pretium', 'ursus-senectus-aliquet-pretiu', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 79, '2011-05-26 16:53:19', 415, '', '2014-03-17 15:44:01', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:53:19', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c22.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c22.jpg","float_fulltext":"","image_fulltext_alt":"Kril penectus aliquet pretium","image_fulltext_caption":"Kril penectus aliquet pretium"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 3, '', '', 1, 25, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(97, 201, 'Netra faucibus eu laoreet', 'yinean-pharetra-faucibus-eu-laoree', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 79, '2011-05-26 16:51:13', 415, '', '2014-03-17 15:46:03', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:51:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c24.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c24.jpg","float_fulltext":"","image_fulltext_alt":"Netra faucibus eu laoreet","image_fulltext_caption":"Netra faucibus eu laoreet"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 2, '', '', 1, 13, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(98, 204, 'Lisl Pellentesquem metus', 'ceger-nisl-pellentesque-in-id-metus', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 80, '2011-05-26 16:49:05', 415, '', '2014-03-17 15:57:41', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:49:05', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c21.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c21.jpg","float_fulltext":"","image_fulltext_alt":"Lisl Pellentesque In id metus","image_fulltext_caption":"Lisl Pellentesque In id metus"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 11, '', '', 1, 41, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(99, 205, 'Laoreet digen nissim', 'detus-laoreet-dignissim-vel', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 80, '2011-05-26 16:46:07', 415, '', '2014-03-17 15:56:57', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:46:07', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c18.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c18.jpg","float_fulltext":"","image_fulltext_alt":"Laoreet digen nissim veli","image_fulltext_caption":"Laoreet digen nissim veli"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 10, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(100, 206, 'Kaucibus eu laoreet nunc', 'haretra-faucibus-eu-laoreet-nunc', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 80, '2011-05-26 16:52:24', 415, '', '2014-03-17 15:54:32', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:52:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c10.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c10.jpg","float_fulltext":"","image_fulltext_alt":"Kaucibus eu laoreet nunc","image_fulltext_caption":"Kaucibus eu laoreet nunc"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 9, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(101, 207, 'Bener senver munst onvase', 'haretra-faucibus-eu-laoreet-nuns', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 80, '2011-05-26 16:52:24', 415, '', '2014-03-17 15:51:44', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:52:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c6.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c6.jpg","float_fulltext":"","image_fulltext_alt":"Bener senver munst onvase","image_fulltext_caption":"Bener senver munst onvase"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 8, '', '', 1, 9, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(103, 209, 'Ciis nulla interdum senectus', 'misociis-nulla-interdum-et-cursus', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 80, '2011-05-26 16:50:18', 415, '', '2014-03-17 15:52:27', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:50:18', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c7.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c7.jpg","float_fulltext":"","image_fulltext_alt":"Ciis nulla interdum senectus","image_fulltext_caption":"Ciis nulla interdum senectus"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 6, '', '', 1, 7, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(104, 210, 'Lames pede elit', 'tames-pede-elit', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 80, '2011-05-26 16:44:15', 415, '', '2014-03-17 15:55:59', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:44:15', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c14.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c14.jpg","float_fulltext":"","image_fulltext_alt":"Curabitur luctus tortor non quam gravida","image_fulltext_caption":"Curabitur luctus tortor non quam gravida"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(105, 211, 'Jes pede elit', 'tames-pede', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 80, '2011-05-26 16:44:15', 415, '', '2014-03-17 15:53:05', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:44:15', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c8.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c8.jpg","float_fulltext":"","image_fulltext_alt":"Cras condimentum vulputate ante in imperdiet","image_fulltext_caption":"Cras condimentum vulputate ante in imperdiet"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 4, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(106, 212, 'Kiop senectus aliquet ', 'ursus-senectus-aliquet-pretium', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 80, '2011-05-26 16:53:19', 415, '', '2014-03-17 15:55:17', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:53:19', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c12.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c12.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 3, '', '', 1, 16, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(107, 213, 'Ma semper ac nec sit', 'xulla-semper-ac-nec-sit', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 80, '2011-05-26 16:45:24', 415, '', '2014-03-17 15:58:25', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:45:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c24.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c24.jpg","float_fulltext":"","image_fulltext_alt":"Ma semper ac nec sit","image_fulltext_caption":"Ma semper ac nec sit"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 1, '', '', 1, 4, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(108, 214, 'Karetra faucibus eu lao', 'yinean-pharetra-faucibus-eu-laoreet-nunc', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 80, '2011-05-26 16:51:13', 415, '', '2014-03-17 15:53:53', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:51:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c9.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c9.jpg","float_fulltext":"","image_fulltext_alt":"Karetra faucibus eu laoreet","image_fulltext_caption":"Karetra faucibus eu laoreet"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(109, 215, 'Kara senver munst onvase', 'haretra-faucibus-eu-laoreet-nuns', '<p><img src="images/content_category/munich-travel-guide.jpg" alt="" border="0" /></p>\r\n<p>Rance fanceus eu laoreet nunc. Tincidunt nulla a Nulla eu convallis scelerisque sociis nulla interdum et. Cursus senectus alique maken chika</p>\r\n', '\r\n<p>Donec ac ante in erat dictum adipiscing. Maecenas pretium accumsan velit, vitae congue diam malesuada nec. Curabitur ut mauris et elit pharetra venenatis id at lectus. Duis porttitor, orci imperdiet porta ultricies, mi arcu blandit sapien, auctor consectetur velit nunc sed mauris. Donec ac ipsum ligula. Aenean egestas facilisis facilisis. Sed id tortor lacus. Integer blandit urna ut dolor sagittis eget pharetra mi eleifend. Maecenas eu eros vitae lectus sodales tempor. Sed tellus erat, lobortis a sodales sit amet, varius sed ante. Phasellus vitae magna vitae augue lobortis vulputate sit amet ut ante. In semper dictum nibh in condimentum. Phasellus vestibulum tortor vitae erat feugiat in tempor leo tempor. Proin sed lacus nibh, non porttitor metus. </p>\r\n<p>Vestibulum id elit a felis fermentum vehicula. In ligula purus, consectetur sodales pellentesque vel, volutpat vel elit. Donec sed lacus at sapien eleifend iaculis. Donec dui ligula, adipiscing sed feugiat non, elementum in metus. Donec molestie consequat mattis. Ut id turpis sed purus adipiscing sollicitudin eget mollis turpis. Integer enim neque, egestas quis fermentum in, gravida in lacus. Nullam vitae ante nibh, nec gravida leo. Duis consectetur nulla eget odio aliquet euismod. Phasellus vehicula augue fermentum tellus rhoncus porta. Fusce at dapibus nisi. Vivamus feugiat tincidunt lorem, nec venenatis erat congue vel. </p>\r\n<p>Quisque sem lacus, elementum ut faucibus at, convallis nec massa. Nam vel rhoncus sem. Nunc sed tellus ac dui ullamcorper sodales vel at est. Fusce non purus at nibh dapibus pellentesque. Nam semper, est at dignissim mattis, dui mauris vulputate nunc, eu convallis enim tortor quis ante. Sed tincidunt luctus sapien et luctus. Phasellus commodo ante elit, ut pellentesque massa. Vestibulum enim tellus, interdum et tempus vel, consequat nec ante. Aliquam erat volutpat. Donec blandit rutrum metus viverra aliquam. Morbi imperdiet laoreet elementum. Curabitur sit amet orci eget felis condimentum hendrerit. </p>\r\n<p>Donec sodales adipiscing mauris eu consequat. Aenean sit amet nibh eu lacus varius luctus. Aliquam erat volutpat. Mauris tristique porttitor tortor, ac commodo enim ultricies ac. Suspendisse at diam quis nibh sagittis semper. Nunc vel aliquam dui. Aenean posuere mauris at diam pretium faucibus. Sed elementum, lacus at varius dignissim, ipsum ipsum egestas diam, at egestas ante nisi at lectus. </p>\r\n<p>Maecenas in lacus turpis. Fusce pellentesque convallis tincidunt. Morbi ac urna ipsum, sed congue metus. Maecenas a enim eu est ornare congue consectetur vel elit. Etiam dictum orci eu augue imperdiet sollicitudin. Mauris consequat lacus sapien, eget condimentum arcu. Cras at tortor leo, in accumsan turpis. Proin a est et massa luctus venenatis. Vivamus mollis arcu a justo aliquam gravida. Pellentesque sagittis fermentum purus, id tincidunt tortor luctus quis. Donec aliquam leo id dolor egestas non condimentum nisl bibendum. In hac habitasse platea dictumst. Sed eget enim dui. In facilisis luctus justo, id faucibus dolor sodales sed. Nullam ligula mauris, pharetra quis bibendum eget, ultrices convallis velit. </p>\r\n<p>In vehicula nisi nec massa sollicitudin fermentum ut et odio. Quisque tellus enim, faucibus eget vehicula aliquam, interdum fringilla nunc. Nunc at porta massa. Donec sed est erat. Nulla dictum nisl et sapien ornare et bibendum massa rutrum. Sed sapien justo, gravida ac cursus vitae, gravida et turpis. Mauris a quam diam. Aenean aliquet, dolor eget pretium interdum, ligula sem egestas odio, fringilla adipiscing libero diam sed ipsum. Aliquam a orci vel mi ullamcorper auctor nec eget eros. Aenean nec diam ut risus molestie vulputate. Proin sagittis felis in dolor blandit eu consequat ipsum adipiscing. Maecenas adipiscing, nibh ac mollis lobortis, diam arcu semper turpis, sit amet interdum purus sapien et turpis. Suspendisse mi erat, mollis non molestie vitae, malesuada sit amet est. Proin tincidunt augue nec est lobortis ullamcorper. </p>\r\n<p>In feugiat diam viverra sem eleifend viverra vulputate quam placerat. Cras facilisis luctus purus at gravida. Vivamus sit amet mi elementum purus faucibus adipiscing. Aenean vulputate justo vel enim congue vehicula. Nullam ut ligula interdum lorem ullamcorper feugiat. Cras egestas sollicitudin ullamcorper. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam in orci massa. Duis mollis est a urna venenatis eget accumsan mi cursus. Etiam risus mauris, tempor sit amet hendrerit sit amet, rhoncus et sem. Fusce purus elit, tincidunt porttitor porta et, mattis quis nulla. Vivamus justo ligula, bibendum eu sagittis non, interdum ut ipsum.</p>\r\n<p> </p>', 1, 81, '2011-05-26 16:52:24', 415, '', '2014-03-17 16:00:58', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:52:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c2.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c2.jpg","float_fulltext":"","image_fulltext_alt":"Kara senver munst onvase","image_fulltext_caption":"Kara senver munst onvase"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 9, '', '', 1, 10, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(110, 216, 'Kulla interdum ersus senectus', 'misociis-nulla-interdum-et-cursus-senectus', '<p><img src="images/content_category/makeup_2.jpg" alt="" border="0" /></p>\r\n<p>Nis nulla interdum et. Cursus senectus aliquet pretium at tristique hac ullamcorper adipiscing et Donec. Enim montes parturient metus laoreet dignissim</p>\r\n', '\r\n<p>Nunc arcu nibh, facilisis ac tincidunt eu, varius ut dolor. Maecenas non tortor nec magna aliquet egestas non at nunc. Vivamus placerat rutrum rutrum. Vestibulum blandit rutrum leo sit amet ultricies. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque at imperdiet nulla. Quisque felis sapien, consectetur vitae interdum in, bibendum et risus. Quisque dolor ante, cursus vel rutrum ac, malesuada non nulla. Sed lacus enim, tempor a vestibulum sit amet, condimentum ut eros. Pellentesque sit amet nulla metus, id bibendum urna. Suspendisse potenti. </p>\r\n<p>Aenean pulvinar euismod pretium. Donec a tortor elit, quis pellentesque ipsum. Proin eleifend interdum tellus vel venenatis. Nullam id leo in ipsum ullamcorper cursus. Donec tincidunt iaculis aliquet. Proin commodo felis vitae massa pretium et imperdiet justo lacinia. Morbi metus tortor, fringilla a vestibulum vitae, varius nec elit. Nam velit nunc, sagittis a dictum vel, pellentesque in lectus. Quisque eu urna enim. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Phasellus felis justo, iaculis sit amet pellentesque non, dapibus sed urna. Fusce libero ipsum, venenatis at pellentesque vel, adipiscing a ante. Sed ullamcorper nulla in tellus congue a hendrerit quam condimentum. Praesent augue mi, sodales vitae viverra vel, convallis id risus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. </p>\r\n<p>Nulla facilisi. Nunc varius sagittis ante. Vivamus aliquet tincidunt diam, quis molestie leo lobortis a. Proin commodo rhoncus urna sit amet aliquet. Nunc elementum leo id nisi malesuada fringilla. Quisque faucibus interdum massa in elementum. Pellentesque volutpat quam eu justo dapibus vitae rhoncus est eleifend. Nam tempor vulputate nibh quis gravida. Nullam facilisis tristique auctor. Fusce condimentum mauris quis purus sodales fermentum. Aliquam rhoncus facilisis enim egestas fermentum. Nullam enim ipsum, porta a venenatis a, adipiscing non metus. Vestibulum aliquet nulla tempor lectus tempor tincidunt pulvinar nec nisl. Integer commodo tellus id est ornare interdum. Vivamus eu diam eget urna porta adipiscing. </p>\r\n<p>Curabitur semper pellentesque malesuada. Sed justo nisi, tempor id adipiscing a, fermentum sed nisi. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Maecenas sed felis ac turpis vehicula posuere. Morbi consectetur purus a elit sodales convallis. Sed quis turpis nec velit vulputate mattis. Praesent at rhoncus augue. Aenean quis quam ac nisl dapibus porta. </p>\r\n<p>Maecenas adipiscing, nunc ullamcorper consectetur tristique, nibh elit posuere turpis, ut suscipit lorem tellus vitae turpis. Morbi et orci diam. Maecenas in ornare lacus. Phasellus in mi non mauris cursus sollicitudin. Maecenas sed magna elit, a vestibulum sapien. Proin eros quam, vulputate et varius a, varius vitae eros. Sed porta enim vel turpis suscipit tincidunt. Aenean aliquam nunc a est elementum elementum. Nunc quis purus ante. Mauris placerat elit sed neque tempus interdum. Proin in libero nec dolor ullamcorper posuere in a arcu. Proin sem dui, vestibulum a consectetur sodales, ullamcorper id turpis. Proin nibh nibh, commodo id luctus quis, lacinia tempor enim. Nunc vestibulum tempus nisi, varius iaculis quam venenatis ut. </p>\r\n<p>Fusce non lectus ac dui scelerisque ullamcorper. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Morbi lacus dolor, vehicula et volutpat eu, auctor et sapien. Cras vel neque et lacus fringilla aliquam. Aliquam viverra leo id lacus pulvinar rutrum ut eu justo. Fusce velit arcu, vestibulum sed suscipit non, fermentum id diam. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Mauris non ligula ac purus rutrum scelerisque eget vitae ligula. Nullam nec aliquam felis. Mauris et sollicitudin turpis. Morbi gravida, enim sed faucibus dictum, purus nisi dapibus nunc, sed faucibus orci lorem at eros. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In porta libero sit amet dui interdum tempor. Maecenas vestibulum iaculis sem, vitae tincidunt risus interdum eu. Etiam ullamcorper justo sit amet nunc aliquam convallis. Etiam ut suscipit risus. Ut sed dui lectus, vel adipiscing ligula. Phasellus iaculis condimentum tellus dapibus aliquet. Praesent in arcu quis neque porta eleifend sed vel tellus. Proin ut risus massa, vel pulvinar massa. Integer id ligula est, sit amet luctus ipsum. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n<p> </p>', 1, 81, '2011-05-26 16:50:18', 415, '', '2014-03-17 16:01:41', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:50:18', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c23.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c23.jpg","float_fulltext":"","image_fulltext_alt":"Kulla interdum ersus senectus","image_fulltext_caption":"Kulla interdum ersus senectus"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 8, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(111, 218, 'Pes pede elit', 'tames-pede', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 81, '2011-05-26 16:44:15', 415, '', '2014-03-17 16:03:06', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:44:15', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c4.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c4.jpg","float_fulltext":"","image_fulltext_alt":"Vestibulum sit amet libero vel neque","image_fulltext_caption":"Vestibulum sit amet libero vel neque"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(112, 219, 'Tra faucibus eu laoreet ', 'yinean-pharetra-faucibus-eu-laoreet-nunc', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 81, '2011-05-26 16:51:13', 415, '', '2014-03-17 16:05:16', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:51:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c9.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c9.jpg","float_fulltext":"","image_fulltext_alt":"Curabitur luctus tortor non quam ","image_fulltext_caption":"Curabitur luctus tortor non quam"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(113, 220, 'Gaucibus eu laoreet', 'yinean-pharetra-faucibus-eu-laoreet-nu1', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 81, '2011-05-26 16:51:13', 415, '', '2014-03-17 15:59:46', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:51:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c11.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c11.jpg","float_fulltext":"","image_fulltext_alt":"Gaucibus eu laoreet nunc","image_fulltext_caption":"Gaucibus eu laoreet nunc"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(114, 221, 'Cibus eu laoreet nunc', 'inean-pharetra-faucibus-eu', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 81, '2011-05-26 16:51:13', 415, '', '2014-03-18 01:53:25', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:51:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/sjcontent\\/12.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c1.jpg","float_fulltext":"","image_fulltext_alt":"Kaucibus eu laoreet nunc","image_fulltext_caption":"Kaucibus eu laoreet nunc"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 4, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(115, 222, 'Gucibus Teu laoreet nunc', 'getra-faucibus-eu-laoreet-nunc', '<p>Kus eu laoreet nunc. Tincidunt nulla a Nulla eu convallis scelerisque sociis nulla interdum et. Cursus senectus alique.Ty fames pede elit nibh at risus tempus.</p>\r\n', '\r\n<p>Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Maecenas libero odio, fringilla a elementum nec, iaculis a tortor. Praesent eget tortor leo. Cras bibendum mauris ut metus lacinia cursus. Aenean posuere diam quis quam aliquet nec dignissim orci convallis. Mauris molestie tincidunt convallis. Curabitur vestibulum vehicula erat eget placerat.Donec mattis, sapien id ornare interdum, orci nibh egestas nulla, at consectetur nunc libero eget nunc. Sed dignissim nisl at diam</p>\r\n<p>[clear] [space height="30"] [columns background="none" ] [column_item col="10"]</p>\r\n<blockquote class="yt-boxquote pull-none" style="width: auto; border-color: #0291FF; color: #666;">Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Praesent tincidunt tincidunt turpis quis ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. <small>Smartaddons</small></blockquote>\r\n<p>[/column_item][/columns]</p>\r\n<h3>Praesent eget tortor leo varius nulla</h3>\r\n<p>Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Maecenas libero odio, fringilla a elementum nec, iaculis a tortor. Praesent eget tortor leo. Cras bibendum mauris ut metus lacinia cursus.</p>\r\n<p>[space height="10"]</p>\r\n<h3>Nam tincidunt fermentum ultrices</h3>\r\n<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nullam sed sapien ipsum. Pellentesque ac eros eu mauris suscipit fermentum et sed lacus. Sed sodales mollis sagittis. Donec mattis, sapien id ornare interdum, orci nibh egestas nulla, at consectetur nunc libero eget nunc. Sed dignissim nisl at diam consectetur lacinia. Vivamus eget posuere erat. Aenean enim odio, cursus sit amet ultrices sed, dictum quis felis. Praesent eget diam in mauris accumsan posuere. Mauris ornare rhoncus nunc, ac varius tellus congue eget. Ut vitae tellus a dolor viverra cursus sed non lectus. Maecenas in velit vel lectus tempor ornare eget eget dolor. Nulla felis enim, venenatis at interdum sit amet, auctor at nisl. Duis sed mauris elit, et volutpat felis. Praesent vitae ante sed ante sagittis consectetur nec et arcu. Sed venenatis ligula id nisl imperdiet convallis.</p>\r\n<p>[space height="10"]</p>', 1, 81, '2011-05-26 16:52:24', 415, '', '2014-03-24 03:59:45', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:52:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c15.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c15.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 62, 3, '', '', 1, 368, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(116, 223, 'Seni senectus aliquet ', 'ursus-senectus-aliquet-pretium', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 81, '2011-05-26 16:53:19', 415, '', '2014-03-17 16:03:56', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:53:19', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c6.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c6.jpg","float_fulltext":"","image_fulltext_alt":"In erat urna, tincidunt nec pulvinar","image_fulltext_caption":"In erat urna, tincidunt nec pulvinar"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 2, '', '', 1, 19, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(117, 224, 'Tanra mes pede elit', 'tames-pede-elit', '<p>Gimes pede elit nibh at risus tempus. Nulla semper ac nec sit massa In Curabitur id risus sit. Non ante gravida eros quis justo sed nonummy et velit orci sagittis eu</p>\r\n', '\r\n<p>Vestibulum ullamcorper varius nisl, ac ornare libero laoreet a. Nam lobortis feugiat quam nec consequat. Proin ut orci et nibh vestibulum sodales nec a felis. Etiam mollis gravida laoreet. Sed at eros nulla. Quisque ut orci ut mauris egestas volutpat. Vestibulum lectus diam, dictum nec sagittis interdum, tincidunt vitae elit. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Morbi erat velit, gravida rutrum pulvinar at, aliquam id mi. Sed non augue mauris. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nullam porttitor vulputate ipsum in aliquam. Vivamus semper dui nec nulla rhoncus non suscipit velit aliquam. Nam orci metus, pulvinar at rhoncus ac, ultrices id orci. Praesent rutrum faucibus ante rhoncus lobortis.</p>\r\n<p>Nullam a felis leo, eget iaculis odio. In vulputate auctor rutrum. Sed ligula metus, imperdiet tincidunt sagittis vitae, iaculis at sapien. Aliquam viverra nisi vitae mauris congue vitae interdum elit tincidunt. Aliquam orci arcu, tempor ut euismod eget, rhoncus non quam. Aenean sed nisl eu tortor sodales tempor. Aenean ultricies ornare auctor. Mauris et turpis ante, nec molestie erat. Curabitur congue ante vel odio tincidunt elementum. Donec a fringilla augue. Mauris est ligula, pretium ultrices adipiscing quis, faucibus quis elit.</p>\r\n<p>Nam sed risus ante, nec feugiat purus. Maecenas volutpat volutpat volutpat. Duis ornare eleifend congue. Maecenas elementum porta nulla ut vulputate. Fusce vel erat neque. Phasellus mi massa, rutrum a mollis eu, rutrum ut risus. Aenean non augue risus. Phasellus porta mi quis mauris cursus ac euismod leo interdum. In hac habitasse platea dictumst. Donec pulvinar luctus velit sit amet hendrerit.</p>\r\n<p>Vivamus non justo leo. Morbi posuere lacinia elit, in feugiat augue ornare et. Aenean sodales tincidunt volutpat. Cras eleifend ornare lobortis. Suspendisse ornare mauris dui. Pellentesque a euismod nulla. Sed ac ante id dui hendrerit porttitor at quis felis. Nulla dui sapien, sollicitudin at semper non, auctor sit amet orci. Fusce mattis gravida velit, sed iaculis purus consequat et. Nullam ut metus at velit tristique tempus id ac quam. Suspendisse non suscipit nisi. Integer non malesuada purus.</p>\r\n<p>Suspendisse mauris ligula, convallis ac consectetur vel, condimentum non massa. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nunc mattis hendrerit laoreet. Suspendisse potenti. Proin vel auctor diam. Morbi mattis tellus in elit ullamcorper eu vulputate dui cursus. Nulla facilisi. Donec tristique dictum justo et pretium. Sed vestibulum, nisl nec tempus volutpat, mi mi aliquam urna, non egestas turpis ante et velit.</p>\r\n<p>Ut ac sapien purus. Suspendisse sollicitudin mattis lectus, at elementum nunc facilisis vel. Mauris a massa nibh, at blandit felis. Sed iaculis enim nisi. Mauris lobortis lacus nisi. Integer blandit augue dui. Quisque dolor orci, congue fringilla aliquam id, pellentesque sit amet justo. Vestibulum magna enim, lacinia at vulputate id, porta sed nulla. Curabitur ante dolor, iaculis vel pharetra non, sodales sit amet ligula. Fusce id lacus sapien, et facilisis erat. Integer non libero est. Nunc nisl felis, egestas eget ultricies ac, lobortis a quam. </p>\r\n<p>Nam eget tempus enim. Mauris id dui mi. In hac habitasse platea dictumst. In vitae cursus sem. Mauris porta placerat metus vitae tempus. Mauris imperdiet accumsan molestie. Donec orci nulla, feugiat fermentum bibendum id, dignissim nec nisl. Sed ultricies turpis sodales quam vestibulum non hendrerit odio lacinia. Duis in porttitor ipsum. Quisque vestibulum nibh a quam varius quis pellentesque augue placerat. Donec justo massa, interdum in malesuada sit amet, lobortis at arcu. Suspendisse odio est, consectetur eu tincidunt et, convallis id est. Cras nisl nunc, ultrices at varius eu, facilisis sit amet nisi. Mauris volutpat nisi eget orci iaculis molestie. In vestibulum, metus a lobortis luctus, leo ipsum mollis eros, at malesuada magna mi eget turpis. Quisque lectus libero, porta et posuere egestas, sodales vel diam.</p>\r\n<div> </div>', 1, 81, '2011-05-26 16:44:15', 415, '', '2014-03-25 02:03:42', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:44:15', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c8.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c8.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(118, 225, 'Nal pede elit nibh ', 'mes-pede-elit-nibh', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 81, '2011-05-26 16:48:10', 415, '', '2014-03-17 16:02:18', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:48:10', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c26.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c26.jpg","float_fulltext":"","image_fulltext_alt":"Nal pede elit nibh ","image_fulltext_caption":"Nal pede elit nibh "}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(128, 235, 'Features', 'features', '<p><strong>Yt Framework</strong> uses xml file to render your layout.  The framework  supports all general features of a joomla template. The  below is the  list of features:</p>\r\n<ul>\r\n<li>Multiple Layouts: Left-Main-Right,  Left-Main, Main-Right, etc. With  xml file, you can easy to create some  layouts for a joomla template</li>\r\n<li>Mobile Ready</li>\r\n<li>Table-less Layout</li>\r\n<li>Search Engine Friendly</li>\r\n<li>Modules Types</li>\r\n<li>Cross-browser Support</li>\r\n<li>Typography</li>\r\n<li>Validation</li>\r\n<li>Template Parameters</li>\r\n<li>Google Font</li>\r\n<li>Font Size</li>\r\n<li>RTL language support</li>\r\n</ul>', '', 1, 9, '2011-06-29 03:10:46', 415, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2011-06-29 03:10:46', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 1, 5, '', '', 1, 338, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(129, 236, 'Module Variations', 'module-variations', '<p><strong> Enter any available suffixes at Extensions - Module Manager - Module - Module Class Suffix. </strong></p>\r\n<p>This template''s module system comes with a wide range of module styles, color variations, badges and icons. Below you can see which module styles come with color variations and with which badges and icons you can combine them.Here is a list of the available options:</p>\r\n<table class="variations">\r\n<tbody>\r\n<tr class="odd">\r\n<td class="bold">Box</td>\r\n<td>Default, Box 1, Box 2, Box 3</td>\r\n</tr>\r\n<tr class="odd">\r\n<td class="bold">Badge</td>\r\n<td>Badge_new, Badge_hot, Badge_cool, Badge_best</td>\r\n</tr>\r\n<tr>\r\n<td class="bold">Icons</td>\r\n<td>icon-bell, icon-comment-alt.vv.. You can find the full icons of usage at <a href="http://fortawesome.github.io/Font-Awesome/3.2.1/" target="_blank">Font Awesome3.2.1 </a></td>\r\n</tr>\r\n<tr class="odd">\r\n<td class="bold">Responsive</td>\r\n<td>visible-phone, visible-tablet, visible-desktop, hidden-phone , hidden-tablet , hidden-desktop</td>\r\n</tr>\r\n<tr>\r\n<td class="bold">Other</td>\r\n<td>clear, menu</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', 1, 9, '2011-06-29 03:31:50', 415, '', '2014-03-24 07:46:46', 660, 0, '0000-00-00 00:00:00', '2011-06-29 03:31:50', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 16, 4, '', '', 1, 2410, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(130, 237, 'Positions', 'positions', '<p>This Joomla! template supports a wide variety of module positions which can be archived automatically by the system.The module positions are fully collapsible mean that if there are no modules published in particular position, this module position will disappear and the other modules with take this place. Also you can have 2-Columns layout (content, left or right)</p>\r\n<p><a class="button" href="images/Position.jpg" target="_blank" data-rel="prettyPhoto">Click here to view clearer picture</a></p>', '', 1, 9, '2011-06-29 03:32:22', 415, '', '2014-03-27 09:11:41', 660, 0, '0000-00-00 00:00:00', '2011-06-29 03:32:22', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 12, 3, '', '', 1, 109, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(131, 238, 'Extensions', 'extenstions', '<p><strong>This Template is using:</strong></p>\r\n<p>[list type="smallnumber5"] [list_item]</p>\r\n<p><strong> Modules:</strong></p>\r\n<ul style="margin: 0 20px;">\r\n<li><a href="http://www.smartaddons.com/joomla/extensions/free-extensions/item/158-sj-moduletabs" target="_blank">SJ Module Tabs</a></li>\r\n<li><a href="http://www.smartaddons.com/joomla/extensions/commercial-extensions/item/69-sj-content-slick-slider-joomla-module" target="_blank">SJ Content Slick Slider </a></li>\r\n<li><a href="http://www.smartaddons.com/joomla/extensions/commercial-extensions/item/67-sj-k2-extra-slider-joomla-module" target="_blank">SJ K2 Extra Slider </a></li>\r\n<li><a href="http://www.smartaddons.com/joomla/extensions/commercial-extensions/item/410-sj-responsive-listing-for-k2-joomla-module" target="_blank">SJ Responsive Listing for K2</a></li>\r\n<li><a href="http://www.smartaddons.com/joomla/extensions/commercial-extensions/item/60-sj-k2-slider-joomla-module" target="_blank">SJ K2 Slider</a></li>\r\n</ul>\r\n<p>[/list_item] [list_item]</p>\r\n<p><strong> Plugins</strong></p>\r\n<ul style="margin: 0 20px;">\r\n<li>Yt Plugin</li>\r\n<li>SJ Core Plugin</li>\r\n<li><a href="http://www.smartaddons.com/joomla/extensions/commercial-extensions/item/537-sj-listing-ajax-for-k2-joomla-plugin">SJ Listing Ajax for K2</a></li>\r\n<li><a href="http://www.smartaddons.com/joomla/extensions/commercial-extensions/item/563-sj-listing-ajax-for-content-joomla-plugin">SJ Listing Ajax for Content</a></li>\r\n<li><a href="http://www.smartaddons.com/joomla/extensions/free-extensions/item/252-sj-content-related-news-joomla-plugin">Sj Content Related News</a></li>\r\n</ul>\r\n<p>[/list_item] [/list]</p>', '', 1, 9, '2011-06-29 03:33:13', 415, '', '2014-03-31 09:55:47', 660, 0, '0000-00-00 00:00:00', '2011-06-29 03:33:13', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 18, 2, '', '', 1, 217, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(133, 240, 'Typography', 'typography', '<p> </p>\r\n<!-- Headings\r\n================================================== -->\r\n<div class="yt-typography">\r\n<div class="page-header">\r\n<h1>Headings</h1>\r\n</div>\r\n<div class="accordion-body in">\r\n<section id="Headings">\r\n<p>All HTML headings, <code>&lt;h1&gt;</code> through <code>&lt;h6&gt;</code> are available.</p>\r\n<div class="bs-docs-example">\r\n<h1>h1. Heading 1</h1>\r\n<h2>h2. Heading 2</h2>\r\n<h3>h3. Heading 3</h3>\r\n<h4>h4. Heading 4</h4>\r\n<h5>h5. Heading 5</h5>\r\n<h6>h6. Heading 6</h6>\r\n</div>\r\n<h2 id="body-copy">Body copy</h2>\r\n<p>Bootstrap''s global default <code>font-size</code> is <strong>14px</strong>, with a <code>line-height</code> of <strong>20px</strong>. This is applied to the <code>&lt;body&gt;</code> and all paragraphs. In addition, <code>&lt;p&gt;</code> (paragraphs) receive a bottom margin of half their line-height (10px by default).</p>\r\n<div class="bs-docs-example">\r\n<p>Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nullam id dolor id nibh ultricies vehicula.</p>\r\n<p>Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec ullamcorper nulla non metus auctor fringilla. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Donec ullamcorper nulla non metus auctor fringilla.</p>\r\n<p>Maecenas sed diam eget risus varius blandit sit amet non magna. Donec id elit non mi porta gravida at eget metus. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit.</p>\r\n</div>\r\n<pre class="prettyprint"><span class="tag">&lt;p&gt;</span><span class="pln">...</span><span class="tag">&lt;/p&gt;</span></pre>\r\n<h3>Lead body copy</h3>\r\n<p>Make a paragraph stand out by adding <code>.lead</code>.</p>\r\n<div class="bs-docs-example">\r\n<p class="lead">Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.</p>\r\n</div>\r\n<pre class="prettyprint"><span class="tag">&lt;p</span><span class="atn">class</span><span class="pun">=</span><span class="atv">"lead"</span><span class="tag">&gt;</span><span class="pln">...</span><span class="tag">&lt;/p&gt;</span></pre>\r\n<h3>Built with Less</h3>\r\n<p>The typographic scale is based on two LESS variables in <strong>variables.less</strong>: <code>@baseFontSize</code> and <code>@baseLineHeight</code>. The first is the base font-size used throughout and the second is the base line-height. We use those variables and some simple math to create the margins, paddings, and line-heights of all our type and more. Customize them and Bootstrap adapts.</p>\r\n<hr class="bs-docs-separator" />\r\n<h2 id="emphasis">Emphasis</h2>\r\n<p>Make use of HTML''s default emphasis tags with lightweight styles.</p>\r\n<h3><code>&lt;small&gt;</code></h3>\r\n<p>For de-emphasizing inline or blocks of text, <small>use the small tag.</small></p>\r\n<div class="bs-docs-example">\r\n<p><small>This line of text is meant to be treated as fine print.</small></p>\r\n</div>\r\n<pre class="prettyprint">&lt;p&gt;\r\n     &lt;small&gt;This line of text is meant to be treated as fine print. &lt;/small&gt;\r\n&lt;/p&gt;</pre>\r\n<h3>Bold</h3>\r\n<p>For emphasizing a snippet of text with a heavier font-weight.</p>\r\n<div class="bs-docs-example">\r\n<p>The following snippet of text is <strong>rendered as bold text</strong>.</p>\r\n</div>\r\n<pre class="prettyprint"><span class="tag">&lt;strong&gt;</span><span class="pln">rendered as bold text</span><span class="tag">&lt;/strong&gt;</span></pre>\r\n<h3>Italics</h3>\r\n<p>For emphasizing a snippet of text with italics.</p>\r\n<div class="bs-docs-example">\r\n<p>The following snippet of text is <em>rendered as italicized text</em>.</p>\r\n</div>\r\n<pre class="prettyprint"><span class="tag">&lt;em&gt;</span><span class="pln">rendered as italicized text</span><span class="tag">&lt;/em&gt;</span></pre>\r\n<p><span class="label label-info">Heads up!</span> Feel free to use <code>&lt;b&gt;</code> and <code>&lt;i&gt;</code> in HTML5. <code>&lt;b&gt;</code> is meant to highlight words or phrases without conveying additional importance while <code>&lt;i&gt;</code> is mostly for voice, technical terms, etc.</p>\r\n<h3>Emphasis classes</h3>\r\n<p>Convey meaning through color with a handful of emphasis utility classes.</p>\r\n<div class="bs-docs-example">\r\n<p class="muted">Fusce dapibus, tellus ac cursus commodo, tortor mauris nibh.</p>\r\n<p class="text-warning">Etiam porta sem malesuada magna mollis euismod.</p>\r\n<p class="text-error">Donec ullamcorper nulla non metus auctor fringilla.</p>\r\n<p class="text-info">Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis.</p>\r\n<p class="text-success">Duis mollis, est non commodo luctus, nisi erat porttitor ligula.</p>\r\n</div>\r\n<pre class="prettyprint linenums">&lt;p class="muted"&gt;Fusce dapibus, tellus ac cursus commodo, tortor mauris nibh.&lt;/p&gt;\r\n&lt;p class="text-warning"&gt;Etiam porta sem malesuada magna mollis euismod.&lt;/p&gt;\r\n&lt;p class="text-error"&gt;Donec ullamcorper nulla non metus auctor fringilla.&lt;/p&gt;\r\n&lt;p class="text-info"&gt;Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis.&lt;/p&gt;\r\n&lt;p class="text-success"&gt;Duis mollis, est non commodo luctus, nisi erat porttitor ligula.&lt;/p&gt;</pre>\r\n</section>\r\n</div>\r\n<!-- Labels and badges\r\n================================================== -->\r\n<div class="page-header">\r\n<h1>Labels and badges</h1>\r\n</div>\r\n<h3>Labels</h3>\r\n<table class="table table-bordered table-striped">\r\n<thead>\r\n<tr><th>Labels</th><th>Markup</th></tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td><span class="label">Default</span></td>\r\n<td><code>&lt;span class="label"&gt;Default&lt;/span&gt;</code></td>\r\n</tr>\r\n<tr>\r\n<td><span class="label label-success">Success</span></td>\r\n<td><code>&lt;span class="label label-success"&gt;Success&lt;/span&gt;</code></td>\r\n</tr>\r\n<tr>\r\n<td><span class="label label-warning">Warning</span></td>\r\n<td><code>&lt;span class="label label-warning"&gt;Warning&lt;/span&gt;</code></td>\r\n</tr>\r\n<tr>\r\n<td><span class="label label-important">Important</span></td>\r\n<td><code>&lt;span class="label label-important"&gt;Important&lt;/span&gt;</code></td>\r\n</tr>\r\n<tr>\r\n<td><span class="label label-info">Info</span></td>\r\n<td><code>&lt;span class="label label-info"&gt;Info&lt;/span&gt;</code></td>\r\n</tr>\r\n<tr>\r\n<td><span class="label label-inverse">Inverse</span></td>\r\n<td><code>&lt;span class="label label-inverse"&gt;Inverse&lt;/span&gt;</code></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h3>Badges</h3>\r\n<table class="table table-bordered table-striped">\r\n<thead>\r\n<tr><th>Name</th><th>Example</th><th>Markup</th></tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>Default</td>\r\n<td><span class="badge">1</span></td>\r\n<td><code>&lt;span class="badge"&gt;1&lt;/span&gt;</code></td>\r\n</tr>\r\n<tr>\r\n<td>Success</td>\r\n<td><span class="badge badge-success">2</span></td>\r\n<td><code>&lt;span class="badge badge-success"&gt;2&lt;/span&gt;</code></td>\r\n</tr>\r\n<tr>\r\n<td>Warning</td>\r\n<td><span class="badge badge-warning">4</span></td>\r\n<td><code>&lt;span class="badge badge-warning"&gt;4&lt;/span&gt;</code></td>\r\n</tr>\r\n<tr>\r\n<td>Important</td>\r\n<td><span class="badge badge-important">6</span></td>\r\n<td><code>&lt;span class="badge badge-important"&gt;6&lt;/span&gt;</code></td>\r\n</tr>\r\n<tr>\r\n<td>Info</td>\r\n<td><span class="badge badge-info">8</span></td>\r\n<td><code>&lt;span class="badge badge-info"&gt;8&lt;/span&gt;</code></td>\r\n</tr>\r\n<tr>\r\n<td>Inverse</td>\r\n<td><span class="badge badge-inverse">10</span></td>\r\n<td><code>&lt;span class="badge badge-inverse"&gt;10&lt;/span&gt;</code></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<!-- Code\r\n================================================== -->\r\n<div class="page-header">\r\n<h1>Code</h1>\r\n</div>\r\n<div class="accordion-body ">\r\n<div class=" first-child span6">\r\n<h2>Inline</h2>\r\n<p>Wrap inline snippets of code with <code>&lt;code&gt;</code>.</p>\r\n<div class="bs-docs-example">For example, <code>&lt;section&gt;</code> should be wrapped as inline.</div>\r\n<div class="prettyprint linenums"><ol class="linenums">\r\n<li class="L0"><span class="typ">For</span><span class="pln"> example</span><span class="pun">,</span><span class="pln"> </span><span class="str">&lt;code&gt;&lt;section&gt;</span><span class="pun">&lt;/</span><span class="pln">code</span><span class="pun">&gt;</span><span class="pln"> should be wrapped </span><span class="kwd">as</span><span class="pln"> </span><span class="kwd">inline</span><span class="pun">.</span></li>\r\n</ol></div>\r\n<p><strong>Note:</strong> Be sure to keep code within <code>&lt;pre&gt;</code> tags as close to the left as possible; it will render all tabs.</p>\r\n<p>You may optionally add the <code>.pre-scrollable</code> class which will set a max-height of 350px and provide a y-axis scrollbar.</p>\r\n</div>\r\n<div class="span6">\r\n<h2>Basic block</h2>\r\n<p>Use <code>&lt;pre&gt;</code> for multiple lines of code. Be sure to escape any angle brackets in the code for proper rendering.</p>\r\n<div class="bs-docs-example">\r\n<pre>   &lt;p&gt;Sample text here...&lt;/p&gt;</pre>\r\n</div>\r\n<pre class="prettyprint linenums" style="margin-bottom: 9px;">&lt;pre&gt;\r\n  &amp;lt;p&amp;gt;Sample text here...&amp;lt;/p&amp;gt;\r\n&lt;/pre&gt;</pre>\r\n</div>\r\n<div class="clear"> </div>\r\n<div class="span12">\r\n<h2>Prettify</h2>\r\n<p>To add colored syntax highlight to the <code>&lt;pre&gt;</code> tag, then use the <code>.prettyprint</code> class or the <code>.prettyprint linenums</code> class.</p>\r\n<div class="bs-docs-example">\r\n<pre class="prettyprint linenums">&lt;?php /** Begin Debug **/ if ($yt-&gt;countModules(''debug'')) : ?&gt;\r\n    &lt;div id="yt-debug"&gt;\r\n        &lt;div class="yt-container"&gt;\r\n            &lt;php echo $yt-&gt;displayModules(''debug'',''standard''); ?&gt;\r\n            &lt;div class="clear"&gt;&lt;/div&gt;\r\n        &lt;/div&gt;\r\n    &lt;/div&gt;\r\n&lt;?php /** End Debug **/ endif; ?&gt;</pre>\r\n</div>\r\n<pre class="prettyprint linenums" style="margin-bottom: 9px;">&amp;lt;?php /** Begin Debug **/ if ($yt-&gt;countModules(''debug'')) : ?&amp;gt;\r\n    &amp;lt;div id="yt-debug"&amp;gt;\r\n        &amp;lt;div class="yt-container"&amp;gt;\r\n            &amp;lt;php echo $yt-&gt;displayModules(''debug'',''standard''); ?&amp;gt;\r\n            &amp;lt;div class="clear"&amp;gt;&amp;lt;/div&amp;gt;\r\n        &amp;lt;/div&amp;gt;\r\n    &amp;lt;/div&amp;gt;\r\n&amp;lt;?php /** End Debug **/ endif; ?&amp;gt;</pre>\r\n</div>\r\n</div>\r\n</div>\r\n<section class="clearfix clear" style="padding: 2em 0;"><em>The documented typography above is a modified version of the reference guide available at: <a href="http://twitter.github.com/bootstrap/base-css.html">http://twitter.github.com/bootstrap/base-css.html</a></em></section>', '', 1, 9, '2011-10-31 10:10:56', 415, '', '2014-02-28 04:46:24', 315, 0, '0000-00-00 00:00:00', '2011-10-31 10:10:56', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 119, 11, '', '', 1, 588, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(155, 276, 'Page break example ', 'page-break-example', '<div class="gallery page-break">\r\n<h3>First paragraph</h3>\r\n<p>Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Maecenas libero odio, fringilla a elementum nec, iaculis a tortor. Praesent eget tortor leo. Cras bibendum mauris ut metus lacinia cursus. Aenean posuere diam quis quam aliquet nec dignissim orci convallis. Mauris molestie tincidunt convallis. Curabitur vestibulum vehicula erat eget placerat.Donec mattis, sapien id ornare interdum, orci nibh egestas nulla, at consectetur nunc libero eget nunc. Sed dignissim nisl at diam</p>\r\n<p>Kus eu laoreet nunc. Tincidunt nulla a Nulla eu convallis scelerisque sociis nulla interdum et. Cursus senectus alique.Ty fames pede elit nibh at risus tempus.Kus eu laoreet nunc. Cursus senectus alique.Ty fames pede elit nibh at risus tempus.</p>\r\n<hr title="The second page" class="system-pagebreak" />\r\n<h3>The second page</h3>\r\n<p>Nulla nec lectus tortor. Suspendisse nisl tellus, euismod non nulla vel, egestas viverra diam. Sed mi metus, lobortis sed tortor eu, vestibulum ornare leo. Proin id porttitor nulla. Suspendisse rhoncus et tortor vitae fermentum. Sed eleifend, velit et facilisis sagittis, lectus turpis posuere enim, euismod aliquam justo orci eu lorem.</p>\r\n<p>Nunc eu est iaculis; posuere nisi imperdiet, malesuada justo. Cras lacus sem, sagittis et commodo eu, tempor eleifend tellus. Nulla ac augue dapibus justo porttitor feugiat nec non velit. Duis eget blandit eros. Nullam non molestie nisi, quis bibendum purus. Etiam pellentesque risus sed eleifend adipiscing. Quisque consectetur nisl quis ullamcorper ullamcorper?</p>\r\n<hr title="The third page" class="system-pagebreak" />\r\n<h3>The third page</h3>\r\n<p>Cras mattis consectetur purus sit amet fermentum. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec id elit non mi porta gravida at eget metus. Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros.</p>\r\n<p>Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>\r\n<hr title="The fourth page" class="system-pagebreak" />\r\n<h3>The fourth page</h3>\r\n<p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Nullam id dolor id nibh ultricies vehicula ut id elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper.</p>\r\n<p>Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n</div>', '', 1, 91, '2012-11-30 03:50:46', 415, '', '2014-03-24 03:51:25', 660, 0, '0000-00-00 00:00:00', '2012-11-30 03:50:46', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 41, 4, '', '', 1, 214, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(176, 299, 'FAQ', 'faq', '<h5 class="title">Got Questions? We’ve Got Answers!</h5>\r\n<p>Asunt in anim uis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in anim id est laborum. Allamco laboris nisi ut aliquip ex ea commodo consequat. Aser velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in anim id est laborum.</p>\r\n<p>[space height=''20'']</p>\r\n<div class="row">\r\n<div class="col-lg-8">[accordion] [acc_item title="I do not have a Paypal account. Do you support other payment methods?"] Yes! You can pay through all of payment gateways that Paypal or 2Checkout supports including all major types of Credit cards. Visit Paypal and 2Checkout for more information. [/acc_item] [acc_item title="How can I join the SmartAddons Club for Products?"]\r\n<p><strong> Please try to do steps: </strong></p>\r\n[list type="smallnumber5"]\r\n<ul>\r\n<li>Click "Join Now", select the membership package and make your payment via Paypal or 2Checkout. Our "Special Offers" and "Promotions" also come at this page.</li>\r\n<li>If your payment is successful, login details to access the Member Download Area will be sent to your email and you can start downloading instantly. This process normally takes less than 5 minutes.</li>\r\n</ul>\r\n[/list] [/acc_item] [acc_item title="Which Joomla! membership package is the best for me?"]\r\n<p><strong> You are recommended to register the following packages as they will bring to you the best benefits: </strong></p>\r\n[list type="star"]\r\n<ul>\r\n<li>Joomla Template Club - Business License</li>\r\n<li>Joomla Template Club - Developer License</li>\r\n<li>Joomla Extension Club - Business License</li>\r\n<li>Joomla Extension Club - Developer License</li>\r\n</ul>\r\n[/list] [/acc_item] [acc_item title="How much does it cost?"] We have many Membership Packages for you to choose. Each package has different prices, durations and number of Supported domain. The membership duration starts instantly from the moment you make payment and receive login details from smartaddons.com. Visit our <b> <a href="../../register.html">Join Now</a></b> Page to view the various memberships available for the products with details.[/acc_item] [acc_item title="SmartAddons membership fee is one-time fee, or I have to pay extra?"] When your membership is expired, you can still use all our templates, extensions downloaded during your membership period without paying any extra fee. However, in order to continue downloading our new/update/upgrade templates/extensions or access to Download area, you should renewal your membership. [/acc_item] [/accordion]</div>\r\n<div class="col-lg-4">\r\n<h5>[icon name="envelope-alt" size="20" color="#666" ] One More Question?</h5>\r\n<p>Asunt in anim uis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in anim id est laborum. Allamco laboris nisi ut aliquip ex ea commodo consequat. Aser velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in anim id est laborum.</p>\r\n<p><a class="button " href="#" target="_blank" rel="slides[buttonlightbox]"><strong>Get in Touch</strong></a></p>\r\n</div>\r\n</div>', '', 1, 91, '2013-02-25 04:45:21', 415, '', '2014-01-24 09:56:22', 315, 0, '0000-00-00 00:00:00', '2013-02-25 04:45:21', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 34, 10, '', '', 1, 156, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(177, 300, 'Join now', 'join-now', '<div class="join-now">\r\n<h2><a href="index.php?option=com_content&amp;view=article&amp;id=177&amp;catid=91&amp;Itemid=787">Join now</a></h2>\r\n<p class="fontsize_l">6353+ people were not wrong choosing <strong>SmartAddons Club</strong>. Get access to all our clubs within 3 minutes.</p>\r\n<ul class="c-step">\r\n<li class="item1 active">\r\n<h3>Step 1</h3>\r\nSelect the right package</li>\r\n<li class="item2">\r\n<h3>Step 2</h3>\r\nOrder Info/Payment option</li>\r\n<li class="item3">\r\n<h3>Step 3</h3>\r\nComplete &amp; Receive download info</li>\r\n</ul>\r\n<p>[tabs style="blue"] [tab_item title="Joomla Templates Club"] [pricing columns="3" style="blue"] [plan title="JEC Personal" button_link="http://www.smartaddons.com/index.php?option=com_osemsc&amp;view=register&amp;Itemid=292&amp;step=step2&amp;layout=twocolumns&amp;msc_id=4" button_label="Join Now" price="$49 " featured="false" per="3 month"]</p>\r\n<ul class="pricing-list">\r\n<li><strong>1 </strong> Domains License <a class="boxtip" href="#" rel="tooltip" data-original-title="Number of domains supported: you are entitled to install our products. The membership you purchase specifies the total number of domains supported.">(?) </a></li>\r\n<li><strong>Access to All Templates <a class="boxtip" href="#" rel="tooltip" data-original-title="You can download and use any available templates.">(?) </a> </strong></li>\r\n<li><strong>Access to All Extensions <strong><a class="boxtip" href="#" rel="tooltip" data-original-title="You can download extensions included in templates only. All Extensions of SmartAddons can be downloaded with Developer Membership">(?) </a></strong> </strong></li>\r\n<li>Source Files (.psd)</li>\r\n<li>Copyright Removal <a class="boxtip" href="#" rel="tooltip" data-original-title="Personal members must keep the SmartAddons logo that is found on the footer of each template. If you want to remove Copyright by Smartaddons.Com, you can purchase Copyright Removal package..">(?) </a></li>\r\n<li>Access to AppStore Templates</li>\r\n<li>No Discount <a class="boxtip" href="#" rel="tooltip" data-original-title="In case you require to renew your membership after it has expired you can benefit from the discount options that we offer.">(?) </a></li>\r\n<li>Support Forum / Ticket</li>\r\n</ul>\r\n<p>[/plan] [plan title="JEC Business" button_link="http://www.smartaddons.com/index.php?option=com_osemsc&amp;view=register&amp;Itemid=292&amp;step=step2&amp;layout=twocolumns&amp;msc_id=5" button_label="Join Now" price="$79" featured="false" per="6 month"]</p>\r\n<ul class="pricing-list">\r\n<li><strong>5 </strong> Domains License <a class="boxtip" href="#" rel="tooltip" data-original-title="Number of domains supported: you are entitled to install our products. The membership you purchase specifies the total number of domains supported.">(?) </a></li>\r\n<li><strong>Access to All Templates <a class="boxtip" href="#" rel="tooltip" data-original-title="You can download and use any available templates.">(?) </a> </strong></li>\r\n<li><strong>Access to All Extensions <strong><a class="boxtip" href="#" rel="tooltip" data-original-title="You can download extensions included in templates only. All Extensions of SmartAddons can be downloaded with Developer Membership">(?) </a></strong> </strong></li>\r\n<li>Source Files (.psd)</li>\r\n<li>Copyright Removal <a class="boxtip" href="#" rel="tooltip" data-original-title="Personal members must keep the SmartAddons logo that is found on the footer of each template. If you want to remove Copyright by Smartaddons.Com, you can purchase Copyright Removal package..">(?) </a></li>\r\n<li>Access to AppStore Templates</li>\r\n<li>No Discount 10% <a class="boxtip" href="#" rel="tooltip" data-original-title="In case you require to renew your membership after it has expired you can benefit from the discount options that we offer.">(?) </a></li>\r\n<li>Support Forum / Ticket</li>\r\n</ul>\r\n<p>[/plan] [plan title="JEC Developer" button_link="http://www.smartaddons.com/index.php?option=com_osemsc&amp;view=register&amp;Itemid=292&amp;step=step2&amp;layout=twocolumns&amp;msc_id=6" button_label="Join Now" price="$199" featured="false" per="1 Year"]</p>\r\n<ul class="pricing-list">\r\n<li>Unlimited Domains License <a class="boxtip" href="#" rel="tooltip" data-original-title="Number of domains supported: you are entitled to install our products. The membership you purchase specifies the total number of domains supported.">(?) </a></li>\r\n<li><strong>Access to All Templates <a class="boxtip" href="#" rel="tooltip" data-original-title="You can download and use any available templates.">(?) </a> </strong></li>\r\n<li><strong>Access to All Extensions <strong><a class="boxtip" href="#" rel="tooltip" data-original-title="You can download extensions included in templates only. All Extensions of SmartAddons can be downloaded with Developer Membership">(?) </a></strong> </strong></li>\r\n<li>Source Files (.psd)</li>\r\n<li>Copyright Removal <a class="boxtip" href="#" rel="tooltip" data-original-title="Personal members must keep the SmartAddons logo that is found on the footer of each template. If you want to remove Copyright by Smartaddons.Com, you can purchase Copyright Removal package..">(?) </a></li>\r\n<li>Access to AppStore Templates</li>\r\n<li>No Discount 30% <a class="boxtip" href="#" rel="tooltip" data-original-title="In case you require to renew your membership after it has expired you can benefit from the discount options that we offer.">(?) </a></li>\r\n<li>Support Forum / Ticket</li>\r\n</ul>\r\n<p>[/plan] [/pricing] [/tab_item] [tab_item title="Joomla Extensions Club"] [pricing columns="3" style="blue"] [plan title="JEC Personal" button_link="http://www.smartaddons.com/index.php?option=com_osemsc&amp;view=register&amp;Itemid=292&amp;step=step2&amp;layout=twocolumns&amp;msc_id=1" button_label="Join Now" price="$49 " featured="false" per="3 month"]</p>\r\n<ul class="pricing-list">\r\n<li><strong>1 </strong> Domains Limit <a class="boxtip" href="#" rel="tooltip" data-original-title="Number of domains supported: you are entitled to install our products. The membership you purchase specifies the total number of domains supported.">(?) </a></li>\r\n<li><strong>Access to All Templates <a class="boxtip" href="#" rel="tooltip" data-original-title="You can download and use any available templates.">(?) </a> </strong></li>\r\n<li><strong>Access to All Extensions <strong><a class="boxtip" href="#" rel="tooltip" data-original-title="You can download extensions included in templates only. All Extensions of SmartAddons can be downloaded with Developer Membership">(?) </a></strong> </strong></li>\r\n<li>No Discount <a class="boxtip" href="#" rel="tooltip" data-original-title="In case you require to renew your membership after it has expired you can benefit from the discount options that we offer.">(?) </a></li>\r\n<li>Support Forum / Ticket</li>\r\n</ul>\r\n<p>[/plan] [plan title="JEC Business" button_link="http://www.smartaddons.com/index.php?option=com_osemsc&amp;view=register&amp;Itemid=292&amp;step=step2&amp;layout=twocolumns&amp;msc_id=2" button_label="Join Now" price="$79" featured="false" per="6 month"]</p>\r\n<ul class="pricing-list">\r\n<li><strong>5 </strong> Domains Limit <a class="boxtip" href="#" rel="tooltip" data-original-title="Number of domains supported: you are entitled to install our products. The membership you purchase specifies the total number of domains supported.">(?) </a></li>\r\n<li><strong>Access to All Templates <a class="boxtip" href="#" rel="tooltip" data-original-title="You can download and use any available templates.">(?) </a> </strong></li>\r\n<li><strong>Access to All Extensions <strong><a class="boxtip" href="#" rel="tooltip" data-original-title="You can download extensions included in templates only. All Extensions of SmartAddons can be downloaded with Developer Membership">(?) </a></strong> </strong></li>\r\n<li>No Discount 10% <a class="boxtip" href="#" rel="tooltip" data-original-title="In case you require to renew your membership after it has expired you can benefit from the discount options that we offer.">(?) </a></li>\r\n<li>Support Forum / Ticket</li>\r\n</ul>\r\n<p>[/plan] [plan title="JEC Developer" button_link="http://www.smartaddons.com/index.php?option=com_osemsc&amp;view=register&amp;Itemid=292&amp;step=step2&amp;layout=twocolumns&amp;msc_id=3" button_label="Join Now" price="$99" featured="false" per="1 Year"]</p>\r\n<ul class="pricing-list">\r\n<li>Domains Unlimited <a class="boxtip" href="#" rel="tooltip" data-original-title="Number of domains supported: you are entitled to install our products. The membership you purchase specifies the total number of domains supported.">(?) </a></li>\r\n<li><strong>Access to All Templates <a class="boxtip" href="#" rel="tooltip" data-original-title="You can download and use any available templates.">(?) </a> </strong></li>\r\n<li><strong>Access to All Extensions <strong><a class="boxtip" href="#" rel="tooltip" data-original-title="You can download extensions included in templates only. All Extensions of SmartAddons can be downloaded with Developer Membership">(?) </a></strong> </strong></li>\r\n<li>No Discount 30% <a class="boxtip" href="#" rel="tooltip" data-original-title="In case you require to renew your membership after it has expired you can benefit from the discount options that we offer.">(?) </a></li>\r\n<li>Support Forum / Ticket</li>\r\n</ul>\r\n<p>[/plan] [/pricing] [/tab_item] [/tabs]</p>\r\n<p>[space height="20"]</p>\r\n<h2 class="fontsize_l">Frequently Asked Questions</h2>\r\n<p>Frequently asked questions for our Joomla! Templates Club memberships.</p>\r\n<p>[accordion] [acc_item title="What will I get after I join a membership plan?"]</p>\r\n<p><strong>1. Template Membership</strong>: After you join the club, you will immediately access the download area of the templates. There you should find your favorite template and download it. You will see two parts for each download: The Source Files and The All In One Package. The All In One Package contains all the files that are necessary to install the template on the site: the Template file, the Cloner Installer to make your site exactly like the demo, all the modules, components and plug-ins included in that template and of course the documentation guide. The Source Files package contains the Adobe Photoshop files so that you can easily edit the design part of the template.</p>\r\n<p><strong>2. Extension Membership</strong>: After you join the club, you will immediately access the download area of the extensions. There you should find your favorite extension and download it.</p>\r\n<p>[/acc_item] [acc_item title="What payment methods do you accept?"] We accept PayPal payments, credit cards (major credit cards like Visa, MasterCard, Maestro, American express etc.). The payments are managed by 2CheckOut, one of the most powerful payment gateway systems. They are completely secure as you are the only one who has access to your financial information. You may also pay through bank transfer. Please, contact us for further details regarding the payment methods. [/acc_item] [acc_item title="What will happen after my membership expires?"] After your membership expires you may continue using the same template/extension you have downloaded and installed on your domain. In fact, you may use the same template/extension for lifetime if you wish. No other payment is required to keep the same template/extension. The payment is a one-time fee. However, you won''t be able to have support from SmartAddons after the expiry. Support is given as long as you are an active member. [/acc_item] [acc_item title="Membership fees are refundable?"] Yes, we have a money back program that refunds completely your payment, if it is asked for it up to 7 days after your subscription day. Although it is a money back program, we will need a valid reason to refund your payment. We can''t accept motives like "I didn''t notice this product was for Joomla" or "I didn''t realize this template doesn''t work with Joomla 1.5". Of course, we take our responsibility for any possible problem with our products and will refund your money if we haven''t delivered you the promised product. [/acc_item] [acc_item title="How many templates/extensions am I allowed to download/use? "] The number of the templates/extensions that you may use depends on the membership plan that you have joined. You are free to download as many templates/extensions as you consider appropriate in order to test and check them out, regardless the plan that you chose. However, you may not take advantage of every template/extensions that you have downloaded. The membership plan limits you to a specific number of domains in which you can install the templates/extensions. For Personal Membership this is two, meaning that you can use two domains. For Business Membership and Developer Membership the number is Unlimited, meaning that there is no limit in the number of domains to be created. [/acc_item] [acc_item title="Can I use the templates/extensions for non commercial and nonprofit sites? "] You may use the templates/extensions for commercial and non commercial purpose. You may use it to create your company''s or personal website. If you are a designer or a freelancer, you can use them for your clients. Our templates/extensions have been also used from non profits organizations and institutions, as well as churches. However, you may not use our templates/extensions to create sites which convey to inappropriate content like crime, violence, threatening etc. [/acc_item] [/accordion]</p>\r\n<p> </p>\r\n<p> </p>\r\n<p> </p>\r\n</div>', '', 1, 91, '2013-02-25 08:30:29', 415, '', '2014-03-24 02:41:48', 660, 0, '0000-00-00 00:00:00', '2013-02-25 08:30:29', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 67, 9, '', '', 1, 428, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(178, 301, 'About us', 'about-us', '<div class="about-page">\r\n<h2><span class="icon-user"> </span><a href="index.php?option=com_content&amp;view=article&amp;id=178&amp;catid=91&amp;Itemid=789">About us</a></h2>\r\n<div class="g-pageteam">\r\n<div class="b-block">[lightbox src="images/shortcode/a1.jpg" width="310" height="180" lightbox="off" title="Vestibulum id urna" align="right" ]\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec purus nibh, commodo ac pellentesque quis, vehicula ut leo. Suspendisse potenti. Sed rhoncus est ac arcu malesuada bibendum. Cras ut nisi id lacus aliquam sodales posuere egestas elit. Quisque sodales pulvinar dolor eu facilisis. Proin in feugiat nisi. Donec feugiat purus eget ipsum aliquet rhoncus.</p>\r\n<p>Aliquam aliquam consequat laoreet. Proin eu magna et odio facilisis viverra vitae et dolor. Fusce enim elit, pulvinar at vestibulum faucibus, eleifend sit amet massa. Vestibulum mattis felis a ante vestibulum varius. Ut in nisi eu mi semper interdum sit amet a magna. Curabitur eget sapien sem, non pretium augue.</p>\r\n</div>\r\n<div class="row content-about">\r\n<div class="span6">\r\n<div class="content"><a href="#"><span class="fa fa-desktop fa-3x">  </span></a>\r\n<h3 class="h-title"><a href="index.php?option=com_content&amp;view=article&amp;id=178&amp;catid=91&amp;Itemid=789">Computer Review teams</a></h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.</p>\r\n</div>\r\n<div class="content"><a href="#"><span class=" fa fa-tablet fa-3x"> </span></a>\r\n<h3 class="h-title"><a href="index.php?option=com_content&amp;view=article&amp;id=178&amp;catid=91&amp;Itemid=789">Tablet, Phablet Review teams</a></h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.</p>\r\n</div>\r\n</div>\r\n<div class="span6">\r\n<div class="content"><a href="#"><span class="fa fa-mobile fa-4x">  </span></a>\r\n<h3 class="h-title "><a href="index.php?option=com_content&amp;view=article&amp;id=178&amp;catid=91&amp;Itemid=789">Smartphone Review Teams</a></h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.</p>\r\n</div>\r\n<div class="content"><a href="#"><span class=" fa fa-camera-retro fa-3x">  </span></a>\r\n<h3 class="h-title"><a href="index.php?option=com_content&amp;view=article&amp;id=178&amp;catid=91&amp;Itemid=789">Camera Review Teams</a></h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', '', 1, 91, '2013-02-26 09:25:46', 415, '', '2014-03-24 02:55:40', 660, 0, '0000-00-00 00:00:00', '2013-02-26 09:25:46', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 125, 8, '', '', 1, 531, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(179, 302, 'Shortcodes', 'short-codes', '<div style="text-align: center;"><a href="http://www.smartaddons.com/joomla/extensions/commercial-extensions/item/564-yt-shortcode-joomla-plugin" target="_blank"><img src="images/shortcode/shortcode.jpg" alt="YT Shortcode" /> </a></div>\r\n<p>[space height="20"]</p>\r\n<div style="text-align: center;">\r\n<p>[button type="flat inverse" target="_blank" link="http://demo.smartaddons.com/extensions/yt-shortcode/index.php"] View all example YT Shortcode [/button]</p>\r\n</div>\r\n<p>The shortcodes supports users to make content for web pages. In Joomla administrator, Yt Shortcodes button will be appeared below the text-area, you can choose shortcodes for the text-area to make content. We will show <strong>bonus pages</strong> for sample in some templates using shortcodes from now.</p>\r\n<p class="text-error"><strong>Note:</strong> Shortcodes only works in <strong>detail</strong> article (joomla! content, k2 content), custom html module.</p>\r\n<p><strong>YT Shortcode User-guide:</strong></p>\r\n<p>Let''s go to <a style="color: #0291ff;" href="http://smartaddons.s3.amazonaws.com/images/userguide/Yt-Shortcodes/index.html" target="blank">here</a> for reading full help documentation of YT Shortcode Plugin</p>', '', 1, 9, '2013-03-07 07:14:55', 415, '', '2014-04-01 10:18:43', 660, 0, '0000-00-00 00:00:00', '2013-03-07 07:14:55', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 47, 7, '', '', 1, 625, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(180, 303, 'Testimonials', 'testimonials', '<div class="span12 testimonial">\r\n<h3 class="title">Testimonials</h3>\r\n<p>[space height=''30'']</p>\r\n<div class="span5">[testimonial author="Alycia E. Kelly" position="Kelly Financial Group" avatar="images/shortcode/avatar-2.jpg" ]\r\n<div class="content-testimonial">\r\n<div class="content-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin scelerisque, augue porttitor bibendum facilisis; quam sapien dapibus nisl, ac blandit sem metus quis mauris. Suspendisse in laoreet enim.</div>\r\n<div class="content-bottom"> </div>\r\n</div>\r\n<p>[/testimonial]</p>\r\n</div>\r\n<div class="span5">[testimonial style="blue" author="Alycia E. Kelly" position="Kelly Financial Group" avatar="images/shortcode/avatar-1.jpg" ]\r\n<div class="content-testimonial">\r\n<div class="content-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin scelerisque, augue porttitor bibendum facilisis; quam sapien dapibus nisl, ac blandit sem metus quis mauris. Suspendisse in laoreet enim.</div>\r\n<div class="content-bottom"> </div>\r\n</div>\r\n<p>[/testimonial]</p>\r\n</div>\r\n<div class="span5">[testimonial style="red" author="Alycia E. Kelly" position="Kelly Financial Group" avatar="images/shortcode/avatar-1.jpg" ]\r\n<div class="content-testimonial">\r\n<div class="content-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin scelerisque, augue porttitor bibendum facilisis; quam sapien dapibus nisl, ac blandit sem metus quis mauris. Suspendisse in laoreet enim.</div>\r\n<div class="content-bottom"> </div>\r\n</div>\r\n<p>[/testimonial]</p>\r\n</div>\r\n<div class="span5">[testimonial style="green" author="Alycia E. Kelly" position="Kelly Financial Group" avatar="images/shortcode/avatar-2.jpg" ]\r\n<div class="content-testimonial">\r\n<div class="content-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin scelerisque, augue porttitor bibendum facilisis; quam sapien dapibus nisl, ac blandit sem metus quis mauris. Suspendisse in laoreet enim.</div>\r\n<div class="content-bottom"> </div>\r\n</div>\r\n<p>[/testimonial]</p>\r\n</div>\r\n<div class="span5">[testimonial style="green" author="Alycia E. Kelly" position="Kelly Financial Group" avatar="images/shortcode/avatar-2.jpg" ]\r\n<div class="content-testimonial">\r\n<div class="content-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin scelerisque, augue porttitor bibendum facilisis; quam sapien dapibus nisl, ac blandit sem metus quis mauris. Suspendisse in laoreet enim.</div>\r\n<div class="content-bottom"> </div>\r\n</div>\r\n[/testimonial]</div>\r\n<div class="span5">[testimonial style="green" author="Alycia E. Kelly" position="Kelly Financial Group" avatar="images/shortcode/avatar-2.jpg" ]\r\n<div class="content-testimonial">\r\n<div class="content-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin scelerisque, augue porttitor bibendum facilisis; quam sapien dapibus nisl, ac blandit sem metus quis mauris. Suspendisse in laoreet enim.</div>\r\n<div class="content-bottom"> </div>\r\n</div>\r\n[/testimonial]</div>\r\n</div>', '', 1, 91, '2013-03-07 07:51:17', 415, '', '2014-03-24 03:37:00', 660, 660, '2014-04-04 02:34:19', '2013-03-07 07:51:17', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 48, 7, '', '', 1, 318, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(181, 304, 'Services', 'services', '<div class="page-service">\r\n<h2><a href="index.php?option=com_content&amp;view=article&amp;id=181&amp;catid=91&amp;Itemid=791">Services</a></h2>\r\n<div id="g-pageservices">\r\n<p>We provide professional services to small and medium sized businesses as well as to larger companies in Europe and abroad. Specialising in Web Development, we have helped many businesses make their online appearance and interactive campaigns a success. We are specialized in following services.</p>\r\n[space height=''20'']\r\n<div class="row">\r\n<div class="span4">[icon name="flask" align="left" size="39" color="#fff"]\r\n<article>\r\n<h3>Easy To Customize</h3>\r\n<p>Aliquam lacinia mi elit, ut accumsan orci. Ut nisl lorem, pharetra vitae sagittis non, commodo id orci. Sed interdum elit a mi ultricies ac lobortis tellus venenatis</p>\r\n<a class="detail" href="#"> Read More</a></article>\r\n</div>\r\n<div class="span4">[icon name="fa fa-cutlery" align="left" size="34" color="#fff"]\r\n<article>\r\n<h3>Ready to Use</h3>\r\n<p>Aliquam lacinia mi elit, ut accumsan orci. Ut nisl lorem, pharetra vitae sagittis non, commodo id orci. Sed interdum elit a mi ultricies ac lobortis tellus venenatis</p>\r\n<a class="detail" href="#"> Read More</a></article>\r\n</div>\r\n<div class="span4">[icon name="fa fa-tablet" align="left" size="42" color="#fff"]\r\n<article>\r\n<h3>Responsive Design</h3>\r\n<p>Aliquam lacinia mi elit, ut accumsan orci. Ut nisl lorem, pharetra vitae sagittis non, commodo id orci. Sed interdum elit a mi ultricies ac lobortis tellus venenatis</p>\r\n<a class="detail" href="#"> Read More</a></article>\r\n</div>\r\n[space height=''40'']\r\n<div class="span4 first">[icon name="fa fa-search" align="left" size="32" color="#fff"]\r\n<article>\r\n<h3>Search Engines (SEO)</h3>\r\n<p>Aliquam lacinia mi elit, ut accumsan orci. Ut nisl lorem, pharetra vitae sagittis non, commodo id orci. Sed interdum elit a mi ultricies ac lobortis tellus venenatis</p>\r\n<a class="detail" href="#"> Read More</a></article>\r\n</div>\r\n<div class="span4">[icon name="fa fa-globe" align="left" size="46" color="#fff"]\r\n<article>\r\n<h3>Web Marketing</h3>\r\n<p>Aliquam lacinia mi elit, ut accumsan orci. Ut nisl lorem, pharetra vitae sagittis non, commodo id orci. Sed interdum elit a mi ultricies ac lobortis tellus venenatis</p>\r\n<a class="detail" href="#"> Read More</a></article>\r\n</div>\r\n<div class="span4">[icon name="fa fa-twitter" align="left" size="32" color="#fff"]\r\n<article>\r\n<h3>Social Media</h3>\r\n<p>Aliquam lacinia mi elit, ut accumsan orci. Ut nisl lorem, pharetra vitae sagittis non, commodo id orci. Sed interdum elit a mi ultricies ac lobortis tellus venenatis</p>\r\n<a class="detail" href="#"> Read More</a></article>\r\n</div>\r\n</div>\r\n<hr />\r\n<h2>Who we are?</h2>\r\n<div class="b-block">[lightbox src="images/shortcode/a1.jpg" width="320" height="210" lightbox="off" title="Vestibulum id urna" align="left" ]\r\n<article>\r\n<h3>Cras eget congue arcu.</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec purus nibh, commodo ac pellentesque quis, vehicula ut leo. Suspendisse potenti. Sed rhoncus est ac arcu malesuada bibendum. Cras ut nisi id lacus aliquam sodales posuere egestas elit. Quisque sodales pulvinar dolor eu facilisis. Proin in feugiat nisi.</p>\r\n[list type="check"]\r\n<li>Donec feugiat purus eget ipsum</li>\r\n<li>pulvinar at vestibulum faucibus</li>\r\n<li>Aliquam aliquam consequat laoreet</li>\r\n<li>Curabitur eget sapien sem</li>\r\n<li>Vestibulum mattis felis a ante</li>\r\n[/list]</article>\r\n</div>\r\n<hr />\r\n<h2>What clients say</h2>\r\n<div class="span12 testimonial">\r\n<div class="span4">[testimonial style="red" author="Alycia E. Kelly" position="Kelly Financial Group" avatar="images/shortcode/avatar-1.jpg" ]\r\n<div class="content-testimonial">\r\n<div class="content-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin scelerisque, augue porttitor bibendum facilisis</div>\r\n<div class="content-bottom"> </div>\r\n </div>\r\n[/testimonial]</div>\r\n<div class="span4">[testimonial style="blue" author="Alycia E. Kelly" position="Kelly Financial Group" avatar="images/shortcode/avatar-2.jpg" ]\r\n<div class="content-testimonial">\r\n<div class="content-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin scelerisque, augue porttitor bibendum facilisis</div>\r\n<div class="content-bottom"> </div>\r\n </div>\r\n[/testimonial]</div>\r\n<div class="span4">[testimonial style="oranges" author="Alycia E. Kelly" position="Kelly Financial Group" avatar="images/shortcode/avatar-3.jpg" ]\r\n<div class="content-testimonial">\r\n<div class="content-text">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin scelerisque, augue porttitor bibendum facilisis</div>\r\n<div class="content-bottom"> </div>\r\n </div>\r\n[/testimonial]</div>\r\n<div class="span4"> </div>\r\n</div>\r\n</div>\r\n</div>', '', 1, 91, '2013-03-08 02:27:34', 415, '', '2014-03-24 03:27:55', 660, 0, '0000-00-00 00:00:00', '2013-03-08 02:27:34', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 67, 6, '', '', 1, 234, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(182, 305, 'Columns', 'columns', '<div id="g-pagecolumn">\r\n    <div class="row-fluid">\r\n        <div class="span12">\r\n            <h3>12 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis blandit purus non mollis. Morbi euismod ornare dictum. Pellentesque lorem odio, tincidunt eget tempus ac, sodales sit amet sem. Maecenas laoreet dolor sit amet justo posuere lacinia. Pellentesque placerat lobortis lorem vitae mollis? Morbi leo massa; rhoncus nec lobortis et; vestibulum in quam.Vivamus pellentesque accumsan tincidunt? Sed accumsan auctor dui ut pretium. Mauris dolor est, fringilla a luctus ut, congue ut erat? Ut ante lorem; bibendum a pharetra nec, iaculis at augue. Mauris id lectus lacus. \r\n        </p>  \r\n        </div>\r\n        \r\n        <hr/>\r\n        \r\n        <div class="span6 first-child">\r\n            <h3>6 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis blandit purus non mollis. Morbi euismod ornare dictum. Pellentesque lorem odio, tincidunt eget tempus ac, sodales sit amet sem. Maecenas laoreet dolor sit amet justo posuere lacinia. \r\n        </p>\r\n        </div>\r\n        \r\n        <div class="span6">\r\n            <h3>6 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis blandit purus non mollis. Morbi euismod ornare dictum. Pellentesque lorem odio, tincidunt eget tempus ac, sodales sit amet sem. Maecenas laoreet dolor sit amet justo posuere lacinia. \r\n        </p>  \r\n        </div>\r\n        \r\n        <hr/>\r\n        \r\n        <div class="span4 first-child">\r\n            <h3>4 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis blandit purus non mollis. Morbi euismod ornare dictum. \r\n        </p>\r\n        </div>\r\n        \r\n        <div class="span4">\r\n            <h3>4 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis blandit purus non mollis. Morbi euismod ornare dictum.\r\n        </p>\r\n        </div>\r\n        \r\n        <div class="span4">\r\n            <h3>4 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis blandit purus non mollis. Morbi euismod ornare dictum. \r\n        </p>\r\n        </div>\r\n        \r\n        <hr/>\r\n          \r\n         <div class="span3 first-child">\r\n            <h3>3 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis \r\n        </p>\r\n        </div>\r\n         \r\n        <div class="span3">\r\n            <h3>3 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis \r\n        </p>\r\n        </div>\r\n        \r\n        <div class="span3">\r\n            <h3>3 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis \r\n        </p>\r\n        </div>\r\n        \r\n        <div class="span3">\r\n            <h3>3 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis \r\n        </p>\r\n        </div>\r\n        \r\n        <hr/>\r\n        <div class="span8 first-child">\r\n            <h3>8 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis blandit purus non mollis. Morbi euismod ornare dictum. Pellentesque lorem odio, tincidunt eget tempus ac, sodales sit amet sem. Maecenas laoreet dolor sit amet justo posuere lacinia. Pellentesque placerat lobortis lorem vitae mollis\r\n            </p>\r\n        </div>\r\n        \r\n        <div class="span4">\r\n            <h3>4 Columns</h3>\r\n            <p>\r\n        Donec dapibus pretium auctor. Morbi eget ligula non elit mollis suscipit. Nunc ut sapien sed nisl vehicula molestie! In bibendum tellus purus. Nunc convallis blandit purus non mollis. \r\n            </p>\r\n        </div>\r\n        \r\n        \r\n        \r\n        \r\n    </div>\r\n\r\n</div>', '', 1, 91, '2013-03-08 04:12:49', 415, '', '2013-03-08 06:58:43', 42, 0, '0000-00-00 00:00:00', '2013-03-08 04:12:49', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 15, 5, '', '', 1, 32, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(183, 306, 'What''s new?', 'what-s-new', '<div id="g-pagewhatnew">\r\n<p>[message_box title="New UI for backend template" type="info" show_close="Yes"]From the YT Framework v2, we support UI for backend of template. We hope this will bring to you the best gratification.[/message_box]</p>\r\n<p>[message_box title="Renew, add new params" type="info" show_close="Yes"] With this version, you will get many renewing, many new added params.[/message_box]</p>\r\n<p>[message_box title="Support shortcodes, bonus pages" type="info" show_close="Yes"]From the YT Framework v2, we will support shortcodes and bonus pages. Let <a href="index.php?option=com_content&amp;view=article&amp;id=179&amp;Itemid=648">click here </a>for more info. [/message_box]</p>\r\n<h3 class="title">YT v2 screenshot</h3>\r\n[columns background="none"] [column_item col="4"]\r\n<div class="yt-lightbox curved  image-none  "><a href="images/yt/overview-desc.jpg" title="Template info &amp; desc" data-rel="prettyPhoto"><img src="images/yt/screenshot1.png" border="0" /></a></div>\r\n<h5 class="align-center">Template info &amp; desc</h5>\r\n[/column_item] [column_item col="4"]\r\n<div class="yt-lightbox curved  image-none  "><a href="images/yt/overview-version.jpg" title="Template version &amp; Framework version" data-rel="prettyPhoto"><img src="images/yt/screenshot2.png" border="0" /></a></div>\r\n<h5 class="align-center">Template version &amp; Framework version</h5>\r\n[/column_item] [column_item col="4"]\r\n<div class="yt-lightbox curved  image-none  "><a href="images/yt/layout-setting.jpg" title="Layout setting" data-rel="prettyPhoto"><img src="images/yt/screenshot3.png" border="0" /></a></div>\r\n<h5 class="align-center">Layout setting</h5>\r\n[/column_item] [/columns] [columns background="none"] [column_item col="4"]\r\n<div class="yt-lightbox curved  image-none  "><a href="images/yt/menu-setting.jpg" title="Menu setting" data-rel="prettyPhoto"><img src="images/yt/screenshot4.png" border="0" /></a></div>\r\n<h5 class="align-center">Menu setting</h5>\r\n[/column_item] [column_item col="4"]\r\n<div class="yt-lightbox curved  image-none  "><a href="images/yt/theme-setting.jpg" title="Theme setting" data-rel="prettyPhoto"><img src="images/yt/screenshot5.png" border="0" /></a></div>\r\n<h5 class="align-center">Theme setting</h5>\r\n[/column_item] [column_item col="4"]\r\n<div class="yt-lightbox curved  image-none  "><a href="images/yt/special-pos.jpg" title="Use special position" data-rel="prettyPhoto"><img src="images/yt/screenshot6.png" border="0" /></a></div>\r\n<h5 class="align-center">Use special position</h5>\r\n[/column_item] [/columns]\r\n<h3 class="title">Main Features</h3>\r\n<ul class="yt-list type-check" style="color: #6b82a2;">\r\n<li>Typography</li>\r\n<li>Shortcodes</li>\r\n<li>Bonus page</li>\r\n<li>Support cpanel</li>\r\n<li>Multiple Themes</li>\r\n<li>Responsive web design</li>\r\n<li>Integrate Bootstrap</li>\r\n<li>Support RTL/LTR language</li>\r\n<li>100% table-less design, using html5 css3</li>\r\n<li>Mega Menu, moo menu, dropline menu, css menu</li>\r\n<li>Joomla! 1.7 Joomla! 2.5 and Joomla! 3.0 Native</li>\r\n<li>Support Module Variations, set style for each module</li>\r\n<li>Multiple Layouts, support override layout for many menu item</li>\r\n<li>W3C XHTML 1.0 Transitional Valid; Optimize CSS/JS/HTML/Merge File</li>\r\n<li>Compatible with IE8+, Firefox 2+, Flock 0.7+, Netscape, Safari, Opera 9.5 and Chrome</li>\r\n</ul>\r\n</div>', '', 1, 91, '2013-03-09 08:05:17', 415, '', '2013-05-23 10:44:01', 42, 0, '0000-00-00 00:00:00', '2013-03-09 08:05:17', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 99, 3, '', '', 1, 305, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(184, 307, 'Photo Gallery ', 'photo-gallery', '<div class="gallery"><hr title="Smart Phone" alt="Smart Phone" class="system-pagebreak" />\r\n<p>[gallery width="258" height="186" columns="3"] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery01.jpg" video_addr="http://youtube.com/watch?v=B0ky-VMi9fI"] Nullam ultrices[/gallery_item] [gallery_item title="Aenean dictum commodo dictum" src="images/gallery/gallery02.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Cum sociis natoque penatibus " src="images/gallery/gallery03.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec aliquet dui pharetra" src="images/gallery/gallery04.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery05.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery06.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery07.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery08.jpg" video_addr="http://www.youtube.com/watch?v=n323WknTym8"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery09.jpg"]Nullam ultrices[/gallery_item][/gallery]</p>\r\n<hr title="Tablet" alt="Tablet" class="system-pagebreak" />\r\n<p> </p>\r\n<p>[gallery width="258" height="186" columns="3"] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery09.jpg" video_addr="http://youtube.com/watch?v=B0ky-VMi9fI"] Nullam ultrices[/gallery_item] [gallery_item title="Aenean dictum commodo dictum" src="images/gallery/gallery08.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Cum sociis natoque penatibus " src="images/gallery/gallery07.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec aliquet dui pharetra" src="images/gallery/gallery06.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery05.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery04.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery03.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery02.jpg" video_addr="http://www.youtube.com/watch?v=n323WknTym8"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery01.jpg"]Nullam ultrices[/gallery_item][/gallery]</p>\r\n<hr title="Phablet" alt="Phablet" class="system-pagebreak" />\r\n<p> </p>\r\n<p>[gallery width="258" height="186" columns="3"] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery06.jpg" video_addr="http://youtube.com/watch?v=B0ky-VMi9fI"] Nullam ultrices[/gallery_item] [gallery_item title="Aenean dictum commodo dictum" src="images/gallery/gallery09.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Cum sociis natoque penatibus " src="images/gallery/gallery07.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec aliquet dui pharetra" src="images/gallery/gallery04.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery02.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery06.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery01.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery08.jpg" video_addr="http://www.youtube.com/watch?v=n323WknTym8"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery03.jpg"]Nullam ultrices[/gallery_item][/gallery]</p>\r\n<hr title="Laptop" alt="Laptop" class="system-pagebreak" />\r\n<p> </p>\r\n<p>[gallery width="258" height="186" columns="3"] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery01.jpg" video_addr="http://youtube.com/watch?v=B0ky-VMi9fI"] Nullam ultrices[/gallery_item] [gallery_item title="Aenean dictum commodo dictum" src="images/gallery/gallery06.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Cum sociis natoque penatibus " src="images/gallery/gallery03.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec aliquet dui pharetra" src="images/gallery/gallery08.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery02.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery07.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery05.jpg"]Nullam ultrices[/gallery_item] [gallery_item title="Vivamus volutpat turpis" src="images/gallery/gallery04.jpg" video_addr="http://www.youtube.com/watch?v=n323WknTym8"]Nullam ultrices[/gallery_item] [gallery_item title="Donec semper dui ut risus" src="images/gallery/gallery09.jpg"]Nullam ultrices[/gallery_item][/gallery]</p>\r\n</div>', '', 1, 91, '2013-03-11 03:08:06', 415, '', '2014-03-12 02:12:11', 660, 0, '0000-00-00 00:00:00', '2013-03-11 03:08:06', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 31, 2, '', '', 1, 268, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(185, 308, 'Portfolio', 'portfolio', '<div id="g-pageportfolio">\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec purus nibh, commodo ac pellentesque quis, vehicula ut leo. Suspendisse potenti. Sed rhoncus est ac arcu malesuada bibendum. Cras ut nisi id lacus aliquam sodales posuere egestas</p>\r\n<div class="row">[space height="20"]\r\n<div class="span3 first">\r\n<div class="port-item"><a class="port-item-img" href="#"> [lightbox src="images/shortcode/p1.jpg" width="241" height="140" lightbox="off" title="Vestibulum id urna" align="none" border="yes" ] </a>\r\n<div class="port-item-content">\r\n<h4>SJ Bakery</h4>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean non metus et felis vulputate.</p>\r\n<a class="detail" href="#1">Visit Website</a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="port-item"><a class="port-item-img" href="#"> [lightbox src="images/shortcode/p2.jpg" width="241" height="140" lightbox="off" title="Vestibulum id urna" align="none" border="yes" ] </a>\r\n<div class="port-item-content">\r\n<h4>SJ Lotte</h4>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean non metus et felis vulputate.</p>\r\n<a class="detail" href="#1">Visit Website</a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="port-item"><a class="port-item-img" href="#"> [lightbox src="images/shortcode/p3.jpg" width="241" height="140" lightbox="off" title="Vestibulum id urna" align="none" border="yes" ] </a>\r\n<div class="port-item-content">\r\n<h4>SJ Wall Blog</h4>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean non metus et felis vulputate.</p>\r\n<a class="detail" href="#1">Visit Website</a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="port-item"><a class="port-item-img" href="#"> [lightbox src="images/shortcode/p4.jpg" width="241" height="140" lightbox="off" title="Vestibulum id urna" align="none" border="yes" ] </a>\r\n<div class="port-item-content">\r\n<h4>SJ Company</h4>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean non metus et felis vulputate.</p>\r\n<a class="detail" href="#1">Visit Website</a></div>\r\n</div>\r\n</div>\r\n[space height="30"]\r\n<div class="span3 first">\r\n<div class="port-item"><a class="port-item-img" href="#"> [lightbox src="images/shortcode/p5.jpg" width="241" height="140" lightbox="off" title="Vestibulum id urna" align="none" border="yes" ] </a>\r\n<div class="port-item-content">\r\n<h4>SJ eSport</h4>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean non metus et felis vulputate.</p>\r\n<a class="detail" href="#1">Visit Website</a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="port-item"><a class="port-item-img" href="#"> [lightbox src="images/shortcode/p6.jpg" width="241" height="140" lightbox="off" title="Vestibulum id urna" align="none" border="yes" ] </a>\r\n<div class="port-item-content">\r\n<h4>SJ AppStore HiTech</h4>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean non metus et felis vulputate.</p>\r\n<a class="detail" href="#1">Visit Website</a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="port-item"><a class="port-item-img" href="#"> [lightbox src="images/shortcode/p7.jpg" width="241" height="140" lightbox="off" title="Vestibulum id urna" align="none" border="yes" ] </a>\r\n<div class="port-item-content">\r\n<h4>SJ Health</h4>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean non metus et felis vulputate.</p>\r\n<a class="detail" href="#1">Visit Website</a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="port-item"><a class="port-item-img" href="#"> [lightbox src="images/shortcode/p8.jpg" width="241" height="140" lightbox="off" title="Vestibulum id urna" align="none" border="yes" ] </a>\r\n<div class="port-item-content">\r\n<h4>SJ Fashion Store</h4>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean non metus et felis vulputate.</p>\r\n<a class="detail" href="#1">Visit Website</a></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', '', 1, 91, '2013-03-11 08:16:31', 415, '', '2014-03-24 02:28:10', 660, 0, '0000-00-00 00:00:00', '2013-03-11 08:16:31', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 46, 1, '', '', 1, 337, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(187, 310, 'Bonus pages', 'bonus-pages', '<p style="margin-top:250px" >\r\nWe use shortcodes to do the bonus pages, and css file dedicated for bonus pages is joomla-page.less(path: ROOT/templates/YOUR_TEMPLATE/less/joomla-page.less)\r\n\r\n<p>', '', 1, 91, '2013-03-18 09:31:16', 415, '', '2013-05-10 10:08:13', 42, 0, '0000-00-00 00:00:00', '2013-03-18 09:31:16', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/shortcode\\/bonuspages.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 19, 0, '', '', 1, 142, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(193, 317, 'Coming Soon', 'coming-soon', 'Coming Soon', '', 1, 14, '2013-05-20 08:56:06', 415, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-05-20 08:56:06', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, '', '', 1, 17, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(198, 337, 'Powerfull Features', 'powerfull-features', '<div class="row-fluid ">\r\n<div class="span6">\r\n<h3>Joomla 2.5 and 3.0</h3>\r\n<p>YT Framework is available for Joomla 2.5 as well as Joomla 3.0 that means no matter which version of you joomla you like to use for developing your next website.</p>\r\n<p> </p>\r\n<h3>HTML5</h3>\r\n<p>We brought HTML5 in YT blank template to make elegant, modern and SEO friendly website that would be fully functional &amp; represents awesome typography.</p>\r\n<p> </p>\r\n<h3>Bootstrap</h3>\r\n<p><a href="joomla3/helix_ii/twitter.github.com/bootstrap/" target="_blank">Bootstrap</a> is made upon responsive CSS Designs with less code which enhances the overall look and feel of your website.</p>\r\n<p> </p>\r\n</div>\r\n<div class="span6">\r\n<p> </p>\r\n<h3>Wordpress</h3>\r\n<p>This is really great thing that YT Framework is available for most popular blogging platform Wordpress besides Joomla with tons of exciting features.  </p>\r\n<p> </p>\r\n<h3>CSS3</h3>\r\n<p>The latest CSS3 technology has been used in YT Framework - II to make the whole web development process easier and faster with lot of scopes.  </p>\r\n<p> </p>\r\n<h3>Presets</h3>\r\n<p>Presets manager give the flexibilty to change the design of your website without coding by selecting the desire color of your website background, header and footer etc.</p>\r\n</div>\r\n</div>', '', 1, 9, '2013-12-20 23:04:09', 415, '', '2014-03-11 04:55:47', 660, 0, '0000-00-00 00:00:00', '2013-12-20 23:04:09', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"0","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 0, '', '', 1, 3032, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(199, 440, 'Lorem ipsum dolor sit amet', 'lorem-ipsum-dolor-sit-amet', '<p>In iaculis a tortor sed pretium. Proin ornare orci quam, quis sodales tortor laoreet non. Integer elementum sed nisi in vehicula. Nullam a semper risus. Vivamus imperdiet lorem justo, at mollis nibh vulputate vel. Sed adipiscing, diam sed bibendum vestibulum, sem enim iaculis augue, ac dictum orci est at dolor. Vestibulum a enim quis leo interdum placerat. Aliquam sagittis elit eget faucibus tempor. Praesent vel ornare ipsum.</p>\r\n<p>Quisque pulvinar erat sit amet mattis bibendum. Donec sed augue suscipit, varius turpis vitae, scelerisque augue. Fusce congue congue sodales. Suspendisse euismod magna a magna interdum, sit amet venenatis est ornare. Aenean luctus enim adipiscing sapien pharetra, nec fringilla tellus eleifend. Quisque dictum id nibh et dapibus. Mauris nec diam velit. Etiam felis risus, porta vitae accumsan quis, dapibus vel urna. Suspendisse vehicula, leo sollicitudin aliquet mollis, quam massa viverra lorem, a feugiat orci lacus at eros. Ut id tristique lectus. Suspendisse vel cursus massa.</p>\r\n<p>Fusce in bibendum dolor. Praesent ut feugiat diam. Vestibulum sed scelerisque augue. Phasellus non lectus non dui semper lobortis. Duis in tortor ac nunc tempus volutpat. Ut sed nunc leo. Donec ultricies massa nisi, nec pharetra tellus lobortis vitae. Phasellus vel interdum massa. Praesent varius libero vestibulum, suscipit nibh ut, malesuada orci. Nulla in sem nec mi iaculis pretium. Nam dictum pretium dapibus. Morbi sagittis aliquet enim sit amet lacinia.</p>\r\n<p>Ut elementum eget lacus sed faucibus. Phasellus at vestibulum erat, non sollicitudin lectus. Integer quis elementum nibh, ac auctor arcu. Nunc eget nibh a orci sagittis dictum. Aenean luctus accumsan turpis, eget congue neque commodo sit amet. Mauris placerat dui et augue tincidunt molestie. Sed non elit mi. Proin hendrerit libero eu risus pharetra imperdiet id sed arcu. Nunc non enim augue. Integer ultrices luctus est, a ultricies nisi suscipit fermentum. Nam ut sagittis urna. Morbi ut elementum massa. Praesent condimentum lacus at metus suscipit, venenatis ullamcorper metus elementum. Aenean sed viverra justo. Curabitur nibh turpis, placerat quis blandit pulvinar, ullamcorper in sapien. Donec dapibus laoreet erat, ac interdum felis consectetur vel.</p>', '', 1, 92, '2014-03-17 08:40:24', 415, '', '2014-03-22 02:18:11', 660, 0, '0000-00-00 00:00:00', '2014-03-17 08:40:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/demo\\/2.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 3, '', '', 1, 15, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(200, 441, 'Fusce in bibendum dolor', 'fusce-in-bibendum-dolor', '<p>Ut elementum eget lacus sed faucibus. Phasellus at vestibulum erat, non sollicitudin lectus. Integer quis elementum nibh, ac auctor arcu. Nunc eget nibh a orci sagittis dictum. Aenean luctus accumsan turpis, eget congue neque commodo sit amet. Mauris placerat dui et augue tincidunt molestie. Sed non elit mi. Proin hendrerit libero eu risus pharetra imperdiet id sed arcu. Nunc non enim augue. Integer ultrices luctus est, a ultricies nisi suscipit fermentum. Nam ut sagittis urna. Morbi ut elementum massa. Praesent condimentum lacus at metus suscipit, venenatis ullamcorper metus elementum. Aenean sed viverra justo. Curabitur nibh turpis, placerat quis blandit pulvinar, ullamcorper in sapien. Donec dapibus laoreet erat, ac interdum felis consectetur vel.</p>\r\n<p>Cras dignissim dui mauris. Etiam vel sapien quis quam pellentesque aliquam. Sed et neque eu odio ultrices malesuada. Etiam varius quam mi. Cras volutpat nulla vel neque dapibus, ac sollicitudin ante lacinia. Nam lacus est, bibendum id porta vitae, egestas ac diam. Interdum et malesuada fames ac ante ipsum primis in faucibus. Integer imperdiet tempus tempus. In nibh nisi, venenatis ac dolor eu, rhoncus scelerisque massa. Quisque ac velit sit amet dui dapibus mollis vulputate eu tellus. Donec tempor porta odio nec vehicula. Vivamus scelerisque eget lectus id iaculis. Nullam commodo mi in vestibulum cursus.</p>\r\n<p>Aenean accumsan risus dolor, vel sagittis est dictum eget. Phasellus consequat erat in faucibus vehicula. Duis cursus sollicitudin cursus. Cras hendrerit sapien eros, nec aliquam arcu viverra ac. Sed vel sodales nunc. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer gravida consequat convallis. Aliquam id eros et lorem fringilla dapibus.</p>', '', 1, 92, '2014-03-17 09:22:49', 415, '', '2014-03-22 02:17:52', 660, 0, '0000-00-00 00:00:00', '2014-03-17 09:22:49', '0000-00-00 00:00:00', '{"image_intro":"images\\/demo\\/1.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 2, '', '', 1, 14, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(201, 447, 'Paze duma kire', 'paze-duma-kire', '<p>Kiten at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 1, 79, '2011-05-26 16:46:50', 415, '', '2014-03-17 15:42:42', 0, 0, '0000-00-00 00:00:00', '2011-05-26 16:46:50', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c5.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c5.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 1, '', '', 1, 29, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(202, 467, 'Lorem ipsum dolor sit amet', 'lorem-ipsum-dolor-sit-amet-2', '<p>In iaculis a tortor sed pretium. Proin ornare orci quam, quis sodales tortor laoreet non. Integer elementum sed nisi in vehicula. Nullam a semper risus. Vivamus imperdiet lorem justo, at mollis nibh vulputate vel. Sed adipiscing, diam sed bibendum vestibulum, sem enim iaculis augue, ac dictum orci est at dolor. Vestibulum a enim quis leo interdum placerat. Aliquam sagittis elit eget faucibus tempor. Praesent vel ornare ipsum.</p>\r\n<p>Quisque pulvinar erat sit amet mattis bibendum. Donec sed augue suscipit, varius turpis vitae, scelerisque augue. Fusce congue congue sodales. Suspendisse euismod magna a magna interdum, sit amet venenatis est ornare. Aenean luctus enim adipiscing sapien pharetra, nec fringilla tellus eleifend. Quisque dictum id nibh et dapibus. Mauris nec diam velit. Etiam felis risus, porta vitae accumsan quis, dapibus vel urna. Suspendisse vehicula, leo sollicitudin aliquet mollis, quam massa viverra lorem, a feugiat orci lacus at eros. Ut id tristique lectus. Suspendisse vel cursus massa.</p>\r\n<p>Fusce in bibendum dolor. Praesent ut feugiat diam. Vestibulum sed scelerisque augue. Phasellus non lectus non dui semper lobortis. Duis in tortor ac nunc tempus volutpat. Ut sed nunc leo. Donec ultricies massa nisi, nec pharetra tellus lobortis vitae. Phasellus vel interdum massa. Praesent varius libero vestibulum, suscipit nibh ut, malesuada orci. Nulla in sem nec mi iaculis pretium. Nam dictum pretium dapibus. Morbi sagittis aliquet enim sit amet lacinia.</p>\r\n<p>Ut elementum eget lacus sed faucibus. Phasellus at vestibulum erat, non sollicitudin lectus. Integer quis elementum nibh, ac auctor arcu. Nunc eget nibh a orci sagittis dictum. Aenean luctus accumsan turpis, eget congue neque commodo sit amet. Mauris placerat dui et augue tincidunt molestie. Sed non elit mi. Proin hendrerit libero eu risus pharetra imperdiet id sed arcu. Nunc non enim augue. Integer ultrices luctus est, a ultricies nisi suscipit fermentum. Nam ut sagittis urna. Morbi ut elementum massa. Praesent condimentum lacus at metus suscipit, venenatis ullamcorper metus elementum. Aenean sed viverra justo. Curabitur nibh turpis, placerat quis blandit pulvinar, ullamcorper in sapien. Donec dapibus laoreet erat, ac interdum felis consectetur vel.</p>', '', 1, 92, '2014-03-17 08:40:24', 415, '', '2014-03-22 02:18:34', 660, 0, '0000-00-00 00:00:00', '2014-03-17 08:40:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/demo\\/3.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 1, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(203, 468, 'Lorem ipsum dolor sit amet', 'lorem-ipsum-dolor-sit-amet-3', '<p>In iaculis a tortor sed pretium. Proin ornare orci quam, quis sodales tortor laoreet non. Integer elementum sed nisi in vehicula. Nullam a semper risus. Vivamus imperdiet lorem justo, at mollis nibh vulputate vel. Sed adipiscing, diam sed bibendum vestibulum, sem enim iaculis augue, ac dictum orci est at dolor. Vestibulum a enim quis leo interdum placerat. Aliquam sagittis elit eget faucibus tempor. Praesent vel ornare ipsum.</p>\r\n<p>Quisque pulvinar erat sit amet mattis bibendum. Donec sed augue suscipit, varius turpis vitae, scelerisque augue. Fusce congue congue sodales. Suspendisse euismod magna a magna interdum, sit amet venenatis est ornare. Aenean luctus enim adipiscing sapien pharetra, nec fringilla tellus eleifend. Quisque dictum id nibh et dapibus. Mauris nec diam velit. Etiam felis risus, porta vitae accumsan quis, dapibus vel urna. Suspendisse vehicula, leo sollicitudin aliquet mollis, quam massa viverra lorem, a feugiat orci lacus at eros. Ut id tristique lectus. Suspendisse vel cursus massa.</p>\r\n<p>Fusce in bibendum dolor. Praesent ut feugiat diam. Vestibulum sed scelerisque augue. Phasellus non lectus non dui semper lobortis. Duis in tortor ac nunc tempus volutpat. Ut sed nunc leo. Donec ultricies massa nisi, nec pharetra tellus lobortis vitae. Phasellus vel interdum massa. Praesent varius libero vestibulum, suscipit nibh ut, malesuada orci. Nulla in sem nec mi iaculis pretium. Nam dictum pretium dapibus. Morbi sagittis aliquet enim sit amet lacinia.</p>\r\n<p>Ut elementum eget lacus sed faucibus. Phasellus at vestibulum erat, non sollicitudin lectus. Integer quis elementum nibh, ac auctor arcu. Nunc eget nibh a orci sagittis dictum. Aenean luctus accumsan turpis, eget congue neque commodo sit amet. Mauris placerat dui et augue tincidunt molestie. Sed non elit mi. Proin hendrerit libero eu risus pharetra imperdiet id sed arcu. Nunc non enim augue. Integer ultrices luctus est, a ultricies nisi suscipit fermentum. Nam ut sagittis urna. Morbi ut elementum massa. Praesent condimentum lacus at metus suscipit, venenatis ullamcorper metus elementum. Aenean sed viverra justo. Curabitur nibh turpis, placerat quis blandit pulvinar, ullamcorper in sapien. Donec dapibus laoreet erat, ac interdum felis consectetur vel.</p>', '', 1, 92, '2014-03-17 08:40:24', 415, '', '2014-03-22 02:18:56', 660, 415, '2014-05-12 02:47:29', '2014-03-17 08:40:24', '0000-00-00 00:00:00', '{"image_intro":"images\\/demo\\/4.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(204, 475, 'Cinia Sed convallis urna 1111 (2)', 'lacinia-sed-convallis-urna-2', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus.</p>\r\n', '\r\n<p>Aenean vehicula vehicula aliquam. Aliquam lobortis cursus erat, in dictum neque suscipit id. In eget ante massa. Mauris ut mauris vel libero sagittis congue. Aenean id turpis lectus. Duis eget consequat velit. Suspendisse cursus nulla vel eros blandit placerat. Aliquam volutpat justo sit amet dui sollicitudin eget interdum nibh gravida. Cras nec placerat libero. Cras id risus sem. Maecenas sit amet ligula turpis, malesuada convallis dui. Ut ligula lorem, vestibulum sit amet fringilla lobortis, posuere at odio. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Integer egestas lectus egestas erat convallis et eleifend sapien tempor. Nulla aliquam nisi sed lorem rhoncus ut adipiscing leo semper. Vestibulum sit amet libero ante, a porta augue. Morbi ornare, leo a tristique rutrum, arcu nulla ornare purus, et pharetra tortor lectus at lectus. Cras congue rhoncus eros et facilisis. Maecenas vehicula pretium turpis, in volutpat mauris imperdiet vel. Nulla facilisi. Sed at justo sem, at iaculis ligula. Phasellus ligula tortor, porttitor in imperdiet et, dignissim in metus. Etiam vitae lorem at felis porta auctor. Nullam semper pharetra gravida.</p>\r\n<p>Quisque arcu elit, condimentum eu convallis nec, mattis vitae elit. Aliquam eu justo eu ipsum ultricies rutrum non eu sapien. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean congue porttitor ligula, in tempor ipsum sagittis ut. Suspendisse sit amet tortor urna, ut mattis massa. Curabitur eget elit leo. Integer mauris odio, semper quis aliquet id, mattis quis mauris. Proin consectetur vestibulum tellus eu tempor.</p>\r\n<p>Vestibulum sit amet libero vel neque dapibus ultrices. Sed sollicitudin est neque, ac dictum ipsum. Nullam lobortis, nisi ut pulvinar pellentesque, orci metus bibendum velit, et adipiscing felis sapien fermentum dui. Mauris vulputate lobortis hendrerit. Cras condimentum vulputate ante in imperdiet. Donec vitae massa orci. Fusce orci ligula, gravida vel tincidunt ut, pretium in dolor. Nulla in odio diam, eu malesuada nisl. Sed porta metus at est suscipit sagittis. Suspendisse elementum tortor sit amet lorem elementum ornare. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris venenatis, quam fringilla lobortis luctus, nulla sapien ultricies nisi, ut fermentum arcu tortor vel orci.</p>\r\n<p>Curabitur luctus tortor non quam gravida ultrices. In erat urna, tincidunt nec pulvinar ac, laoreet ut orci. Duis vestibulum, mi id malesuada pulvinar, arcu nibh facilisis augue, ut accumsan urna orci sagittis justo. Donec ut metus eros. Nulla at tortor et mauris accumsan adipiscing. Morbi pellentesque, dui ut blandit vehicula, lectus ligula aliquam nulla, sed mollis nunc odio at ipsum. Mauris scelerisque metus a justo facilisis ut semper ligula eleifend. Phasellus non odio nibh. Curabitur at tincidunt neque. Nunc euismod malesuada massa ac luctus. Pellentesque sed bibendum velit. Vivamus dictum pulvinar ipsum, vitae vestibulum eros ornare sit amet. Donec ut felis at sem auctor iaculis. Nullam hendrerit tempus tellus, ut fringilla diam vehicula quis. Nulla facilisi. Morbi at eros et leo pulvinar molestie at rutrum orci.</p>', 2, 79, '2011-05-26 16:46:50', 415, '', '2014-03-28 02:35:40', 660, 0, '0000-00-00 00:00:00', '2011-05-26 16:46:50', '0000-00-00 00:00:00', '{"image_intro":"images\\/SJ_iCenter\\/c2.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/SJ_iCenter\\/c2.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_tag` (`tag_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maps items from content tables to tags';

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 3, 80, 6, '2014-03-17 15:35:19', 1),
('com_content.article', 3, 80, 7, '2014-03-17 15:35:19', 1),
('com_content.article', 8, 81, 2, '2014-03-17 15:37:05', 1),
('com_content.article', 8, 81, 9, '2014-03-17 15:37:05', 1),
('com_content.article', 5, 82, 5, '2014-03-17 15:38:30', 1),
('com_content.article', 5, 82, 6, '2014-03-17 15:38:30', 1),
('com_content.article', 4, 83, 2, '2014-03-17 15:37:50', 1),
('com_content.article', 4, 83, 7, '2014-03-17 15:37:50', 1),
('com_content.article', 7, 85, 5, '2014-03-17 15:34:37', 1),
('com_content.article', 7, 85, 6, '2014-03-17 15:34:37', 1),
('com_content.article', 14, 86, 5, '2014-03-17 15:33:52', 1),
('com_content.article', 14, 86, 6, '2014-03-17 15:33:52', 1),
('com_content.article', 15, 87, 2, '2014-03-17 15:40:44', 1),
('com_content.article', 15, 87, 8, '2014-03-17 15:40:44', 1),
('com_content.article', 1, 91, 2, '2014-03-17 15:36:00', 1),
('com_content.article', 1, 91, 6, '2014-03-17 15:36:00', 1),
('com_content.article', 9, 115, 5, '2014-03-24 03:59:46', 1),
('com_content.article', 9, 115, 6, '2014-03-24 03:59:46', 1),
('com_weblinks.weblink', 11, 2, 11, '2013-05-28 08:35:11', 2),
('com_weblinks.weblink', 10, 3, 10, '2013-05-28 08:19:38', 2),
('com_newsfeeds.newsfeed', 12, 1, 12, '2013-05-28 08:38:36', 4),
('com_newsfeeds.newsfeed', 13, 4, 7, '2013-05-28 08:39:24', 4);

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(8, 10),
(35, 12),
(50, 11),
(78, 3),
(83, 5),
(84, 4),
(85, 1),
(91, 2),
(119, 7),
(120, 9),
(122, 8),
(126, 6);

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__content_rating` (`content_id`, `rating_sum`, `rating_count`, `lastip`) VALUES
(91, 5, 1, '::1'),
(96, 1, 1, '::1'),
(97, 3, 1, '::1'),
(115, 5, 2, '192.168.1.122'),
(129, 15, 3, '192.168.1.123'),
(130, 2, 1, '192.168.1.71'),
(131, 5, 1, '118.70.233.11'),
(179, 5, 1, '192.168.1.122');

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE IF NOT EXISTS `#__content_types` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `table` varchar(255) NOT NULL DEFAULT '',
  `rules` text NOT NULL,
  `field_mappings` text NOT NULL,
  `router` varchar(255) NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) NOT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{"special":{"dbtable":"#__content","key":"id","type":"Content","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"introtext", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"attribs", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"asset_id"}, "special": {"fulltext":"fulltext"}}', 'ContentHelperRoute::getArticleRoute', '{"formFile":"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml", "hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{"special":{"dbtable":"#__weblinks","key":"id","type":"Weblink","prefix":"WeblinksTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"url", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special": {}}', 'WeblinksHelperRoute::getWeblinkRoute', '{"formFile":"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","featured","images"], "ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"], "convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(3, 'Contact', 'com_contact.contact', '{"special":{"dbtable":"#__contact_details","key":"id","type":"Contact","prefix":"ContactTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"address", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"image", "core_urls":"webpage", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special": {"con_position":"con_position","suburb":"suburb","state":"state","country":"country","postcode":"postcode","telephone":"telephone","fax":"fax","misc":"misc","email_to":"email_to","default_con":"default_con","user_id":"user_id","mobile":"mobile","sortname1":"sortname1","sortname2":"sortname2","sortname3":"sortname3"}}', 'ContactHelperRoute::getContactRoute', '{"formFile":"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml","hideFields":["default_con","checked_out","checked_out_time","version","xreference"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[ {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{"special":{"dbtable":"#__newsfeeds","key":"id","type":"Newsfeed","prefix":"NewsfeedsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special": {"numarticles":"numarticles","cache_time":"cache_time","rtl":"rtl"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{"formFile":"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml","hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(5, 'User', 'com_users.user', '{"special":{"dbtable":"#__users","key":"id","type":"User","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"null","core_alias":"username","core_created_time":"registerdate","core_modified_time":"lastvisitDate","core_body":"null", "core_hits":"null","core_publish_up":"null","core_publish_down":"null","access":"null", "core_params":"params", "core_featured":"null", "core_metadata":"null", "core_language":"null", "core_images":"null", "core_urls":"null", "core_version":"null", "core_ordering":"null", "core_metakey":"null", "core_metadesc":"null", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special": {}}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'ContentHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(7, 'Contact Category', 'com_contact.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'ContactHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'WeblinksHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(10, 'Tag', 'com_tags.tag', '{"special":{"dbtable":"#__tags","key":"tag_id","type":"Tag","prefix":"TagsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path"}}', 'TagsHelperRoute::getTagRoute', '{"formFile":"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml", "hideFields":["checked_out","checked_out_time","version", "lft", "rgt", "level", "path", "urls", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(11, 'Banner', 'com_banners.banner', '{"special":{"dbtable":"#__banners","key":"id","type":"Banner","prefix":"BannersTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"null","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"null", "asset_id":"null"}, "special":{"imptotal":"imptotal", "impmade":"impmade", "clicks":"clicks", "clickurl":"clickurl", "custombannercode":"custombannercode", "cid":"cid", "purchase_type":"purchase_type", "track_impressions":"track_impressions", "track_clicks":"track_clicks"}}', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml", "hideFields":["checked_out","checked_out_time","version", "reset"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "imptotal", "impmade", "reset"], "convertToInt":["publish_up", "publish_down", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"cid","targetTable":"#__banner_clients","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(12, 'Banners Category', 'com_banners.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(13, 'Banner Client', 'com_banners.client', '{"special":{"dbtable":"#__banner_clients","key":"id","type":"Client","prefix":"BannersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml", "hideFields":["checked_out","checked_out_time"], "ignoreChanges":["checked_out", "checked_out_time"], "convertToInt":[], "displayLookup":[]}'),
(14, 'User Notes', 'com_users.note', '{"special":{"dbtable":"#__user_notes","key":"id","type":"Note","prefix":"UsersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml", "hideFields":["checked_out","checked_out_time", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time"], "convertToInt":["publish_up", "publish_down"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(15, 'User Notes Category', 'com_users.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}');

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__easyblog_acl`;
CREATE TABLE IF NOT EXISTS `#__easyblog_acl` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `default` tinyint(1) NOT NULL DEFAULT '1',
  `description` text NOT NULL,
  `published` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `easyblog_post_acl_action` (`action`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=38 ;

INSERT INTO `#__easyblog_acl` (`id`, `action`, `default`, `description`, `published`, `ordering`) VALUES
(1, 'add_entry', 1, 'If allowed, user is allowed to post a new blog post.', 1, 0),
(2, 'publish_entry', 1, 'If allowed, user is allowed to publish their blog post on the site. ', 1, 0),
(3, 'allow_feedburner', 1, 'If allowed, user can set their own Feedburner URL which will be linked to their own blog.', 1, 0),
(4, 'upload_avatar', 1, 'If allowed, user can upload their avatar.', 1, 0),
(5, 'manage_comment', 1, 'If allowed, user can manage any comments that are posted throughout the site.', 1, 0),
(6, 'update_twitter', 1, 'If allowed, user can post updates to their own Twitter account.', 1, 0),
(7, 'update_tweetmeme', 1, 'If allowed, user can update Tweetmeme settings. **Deprecated**', 0, 0),
(8, 'delete_entry', 1, 'If allowed, user can delete their own blog post.', 1, 0),
(9, 'add_trackback', 1, 'If allowed, user can specify trackback urls when creating a new blog post.', 1, 0),
(10, 'contribute_frontpage', 1, 'If allowed, user can publish their blog post on the front page of EasyBlog.', 1, 0),
(11, 'create_category', 1, 'If allowed, user can create a new category on the site.', 1, 0),
(12, 'create_tag', 1, 'If allowed, user can create new tags on the site.', 1, 0),
(13, 'add_adsense', 1, 'If allowed, user can set their own Google Adsense codes.', 1, 0),
(14, 'allow_shortcode', 1, 'If allowed, user can use short code URLs. **Deprecated**', 0, 0),
(15, 'allow_rss', 1, 'If allowed, user can use use custom RSS. **Deprecated**', 0, 0),
(16, 'custom_template', 1, 'If allowed, user can use a custom template. **Deprecated**', 0, 0),
(17, 'enable_privacy', 1, 'If allowed, user can specify a custom privacy option for their blog posts.', 1, 0),
(18, 'allow_comment', 1, 'If allowed, user can post a comment on the site.', 1, 0),
(19, 'allow_subscription', 1, 'If allowed, user can subscribe to the blog on the site.', 1, 0),
(20, 'manage_pending', 1, 'If allowed, user can manage pending blog posts.', 1, 0),
(21, 'upload_image', 1, 'If allowed, user can upload new images via the media manager.', 1, 0),
(23, 'upload_cavatar', 1, 'If allowed, user can upload a new avatar for the category.', 1, 0),
(24, 'update_linkedin', 1, 'If allowed, user can post updates to their own LinkedIn account.', 1, 0),
(25, 'change_setting_comment', 1, 'If allowed, user can toggle the ability to comment on their blog post.', 1, 0),
(26, 'change_setting_subscription', 1, 'If allowed, user can toggle the ability to allow subscriptions for their blog post.', 1, 0),
(27, 'update_facebook', 1, 'If allowed, user can post updates to their own Facebook account.', 1, 0),
(28, 'delete_category', 1, 'If allowed, user can delete their category.', 1, 0),
(29, 'moderate_entry', 1, 'If allowed, user can moderate all blog entries from the site.', 1, 0),
(30, 'edit_comment', 1, 'If allowed, user can edit comments from their dashboard area.', 1, 0),
(31, 'delete_comment', 1, 'If allowed, user can delete comments on their blogs.', 1, 0),
(32, 'feature_entry', 1, 'If allowed, user can feature blog posts on the site.', 1, 0),
(33, 'media_places_album', 1, 'If allowed, user can utilize the Albums in media manager.', 1, 0),
(34, 'media_places_flickr', 1, 'If allowed, user can utilize Flickr in media manager.', 1, 0),
(35, 'media_places_shared', 1, 'If allowed, user can access the shared folder in media manager.', 1, 0),
(36, 'allow_seo', 1, 'If allowed, user can set custom SEO options e.g. meta description and meta keywords in their pages.', 1, 0),
(37, 'access_toolbar', 1, 'If allowed, user can view the toolbar on the site.', 1, 0);

DROP TABLE IF EXISTS `#__easyblog_acl_filters`;
CREATE TABLE IF NOT EXISTS `#__easyblog_acl_filters` (
  `content_id` bigint(20) unsigned NOT NULL,
  `disallow_tags` text NOT NULL,
  `disallow_attributes` text NOT NULL,
  `type` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__easyblog_acl_filters` (`content_id`, `disallow_tags`, `disallow_attributes`, `type`) VALUES
(1, 'script,applet,iframe', 'onclick,onblur,onchange,onfocus,onreset,onselect,onsubmit,onabort,onkeydown,onkeypress,onkeyup,onmouseover,onmouseout,ondblclick,onmousemove,onmousedown,onmouseup,onerror,onload,onunload', 'group'),
(6, 'script,applet,iframe', 'onclick,onblur,onchange,onfocus,onreset,onselect,onsubmit,onabort,onkeydown,onkeypress,onkeyup,onmouseover,onmouseout,ondblclick,onmousemove,onmousedown,onmouseup,onerror,onload,onunload', 'group'),
(7, '', '', 'group'),
(2, 'script,applet,iframe', 'onclick,onblur,onchange,onfocus,onreset,onselect,onsubmit,onabort,onkeydown,onkeypress,onkeyup,onmouseover,onmouseout,ondblclick,onmousemove,onmousedown,onmouseup,onerror,onload,onunload', 'group'),
(3, 'script,applet,iframe', 'onclick,onblur,onchange,onfocus,onreset,onselect,onsubmit,onabort,onkeydown,onkeypress,onkeyup,onmouseover,onmouseout,ondblclick,onmousemove,onmousedown,onmouseup,onerror,onload,onunload', 'group'),
(4, 'script,applet,iframe', 'onclick,onblur,onchange,onfocus,onreset,onselect,onsubmit,onabort,onkeydown,onkeypress,onkeyup,onmouseover,onmouseout,ondblclick,onmousemove,onmousedown,onmouseup,onerror,onload,onunload', 'group'),
(5, 'script,applet,iframe', 'onclick,onblur,onchange,onfocus,onreset,onselect,onsubmit,onabort,onkeydown,onkeypress,onkeyup,onmouseover,onmouseout,ondblclick,onmousemove,onmousedown,onmouseup,onerror,onload,onunload', 'group'),
(10, 'script,applet,iframe', 'onclick,onblur,onchange,onfocus,onreset,onselect,onsubmit,onabort,onkeydown,onkeypress,onkeyup,onmouseover,onmouseout,ondblclick,onmousemove,onmousedown,onmouseup,onerror,onload,onunload', 'group'),
(12, 'script,applet,iframe', 'onclick,onblur,onchange,onfocus,onreset,onselect,onsubmit,onabort,onkeydown,onkeypress,onkeyup,onmouseover,onmouseout,ondblclick,onmousemove,onmousedown,onmouseup,onerror,onload,onunload', 'group'),
(8, '', '', 'group');

DROP TABLE IF EXISTS `#__easyblog_acl_group`;
CREATE TABLE IF NOT EXISTS `#__easyblog_acl_group` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` bigint(20) unsigned NOT NULL,
  `acl_id` bigint(20) unsigned NOT NULL,
  `status` tinyint(1) NOT NULL,
  `type` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `easyblog_post_acl_content_type` (`content_id`,`type`),
  KEY `easyblog_post_acl` (`acl_id`),
  KEY `acl_grp_acl_type` (`acl_id`,`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=361 ;

INSERT INTO `#__easyblog_acl_group` (`id`, `content_id`, `acl_id`, `status`, `type`) VALUES
(1, 1, 1, 0, 'group'),
(2, 1, 2, 0, 'group'),
(3, 1, 3, 0, 'group'),
(4, 1, 4, 0, 'group'),
(5, 1, 5, 0, 'group'),
(6, 1, 6, 0, 'group'),
(7, 1, 7, 0, 'group'),
(8, 1, 8, 0, 'group'),
(9, 1, 9, 0, 'group'),
(10, 1, 10, 0, 'group'),
(11, 1, 11, 0, 'group'),
(12, 1, 12, 0, 'group'),
(13, 1, 13, 0, 'group'),
(14, 1, 14, 0, 'group'),
(15, 1, 15, 0, 'group'),
(16, 1, 16, 0, 'group'),
(17, 1, 17, 0, 'group'),
(18, 1, 18, 0, 'group'),
(19, 1, 19, 1, 'group'),
(20, 1, 20, 0, 'group'),
(21, 1, 21, 0, 'group'),
(22, 1, 23, 0, 'group'),
(23, 1, 24, 0, 'group'),
(24, 1, 25, 0, 'group'),
(25, 1, 26, 0, 'group'),
(26, 1, 27, 0, 'group'),
(27, 1, 28, 0, 'group'),
(28, 1, 29, 0, 'group'),
(29, 1, 30, 0, 'group'),
(30, 1, 31, 0, 'group'),
(31, 1, 32, 0, 'group'),
(32, 1, 33, 0, 'group'),
(33, 1, 34, 0, 'group'),
(34, 1, 35, 0, 'group'),
(35, 1, 36, 0, 'group'),
(36, 6, 1, 1, 'group'),
(37, 6, 2, 1, 'group'),
(38, 6, 3, 1, 'group'),
(39, 6, 4, 1, 'group'),
(40, 6, 5, 1, 'group'),
(41, 6, 6, 1, 'group'),
(42, 6, 7, 1, 'group'),
(43, 6, 8, 1, 'group'),
(44, 6, 9, 1, 'group'),
(45, 6, 10, 1, 'group'),
(46, 6, 11, 1, 'group'),
(47, 6, 12, 1, 'group'),
(48, 6, 13, 1, 'group'),
(49, 6, 14, 1, 'group'),
(50, 6, 15, 1, 'group'),
(51, 6, 16, 1, 'group'),
(52, 6, 17, 1, 'group'),
(53, 6, 18, 1, 'group'),
(54, 6, 19, 1, 'group'),
(55, 6, 20, 0, 'group'),
(56, 6, 21, 1, 'group'),
(57, 6, 23, 1, 'group'),
(58, 6, 24, 1, 'group'),
(59, 6, 25, 1, 'group'),
(60, 6, 26, 1, 'group'),
(61, 6, 27, 1, 'group'),
(62, 6, 28, 1, 'group'),
(63, 6, 29, 0, 'group'),
(64, 6, 30, 0, 'group'),
(65, 6, 31, 0, 'group'),
(66, 6, 32, 0, 'group'),
(67, 6, 33, 1, 'group'),
(68, 6, 34, 1, 'group'),
(69, 6, 35, 1, 'group'),
(70, 6, 36, 1, 'group'),
(71, 7, 1, 1, 'group'),
(72, 7, 2, 1, 'group'),
(73, 7, 3, 1, 'group'),
(74, 7, 4, 1, 'group'),
(75, 7, 5, 1, 'group'),
(76, 7, 6, 1, 'group'),
(77, 7, 7, 1, 'group'),
(78, 7, 8, 1, 'group'),
(79, 7, 9, 1, 'group'),
(80, 7, 10, 1, 'group'),
(81, 7, 11, 1, 'group'),
(82, 7, 12, 1, 'group'),
(83, 7, 13, 1, 'group'),
(84, 7, 14, 1, 'group'),
(85, 7, 15, 1, 'group'),
(86, 7, 16, 1, 'group'),
(87, 7, 17, 1, 'group'),
(88, 7, 18, 1, 'group'),
(89, 7, 19, 1, 'group'),
(90, 7, 20, 1, 'group'),
(91, 7, 21, 1, 'group'),
(92, 7, 23, 1, 'group'),
(93, 7, 24, 1, 'group'),
(94, 7, 25, 1, 'group'),
(95, 7, 26, 1, 'group'),
(96, 7, 27, 1, 'group'),
(97, 7, 28, 1, 'group'),
(98, 7, 29, 1, 'group'),
(99, 7, 30, 1, 'group'),
(100, 7, 31, 1, 'group'),
(101, 7, 32, 1, 'group'),
(102, 7, 33, 1, 'group'),
(103, 7, 34, 1, 'group'),
(104, 7, 35, 1, 'group'),
(105, 7, 36, 1, 'group'),
(106, 2, 1, 1, 'group'),
(107, 2, 2, 1, 'group'),
(108, 2, 3, 1, 'group'),
(109, 2, 4, 1, 'group'),
(110, 2, 5, 1, 'group'),
(111, 2, 6, 1, 'group'),
(112, 2, 7, 1, 'group'),
(113, 2, 8, 1, 'group'),
(114, 2, 9, 1, 'group'),
(115, 2, 10, 1, 'group'),
(116, 2, 11, 1, 'group'),
(117, 2, 12, 1, 'group'),
(118, 2, 13, 1, 'group'),
(119, 2, 14, 1, 'group'),
(120, 2, 15, 1, 'group'),
(121, 2, 16, 1, 'group'),
(122, 2, 17, 1, 'group'),
(123, 2, 18, 1, 'group'),
(124, 2, 19, 1, 'group'),
(125, 2, 20, 0, 'group'),
(126, 2, 21, 1, 'group'),
(127, 2, 23, 1, 'group'),
(128, 2, 24, 1, 'group'),
(129, 2, 25, 1, 'group'),
(130, 2, 26, 1, 'group'),
(131, 2, 27, 1, 'group'),
(132, 2, 28, 1, 'group'),
(133, 2, 29, 0, 'group'),
(134, 2, 30, 0, 'group'),
(135, 2, 31, 0, 'group'),
(136, 2, 32, 0, 'group'),
(137, 2, 33, 1, 'group'),
(138, 2, 34, 1, 'group'),
(139, 2, 35, 1, 'group'),
(140, 2, 36, 1, 'group'),
(141, 3, 1, 1, 'group'),
(142, 3, 2, 1, 'group'),
(143, 3, 3, 1, 'group'),
(144, 3, 4, 1, 'group'),
(145, 3, 5, 1, 'group'),
(146, 3, 6, 1, 'group'),
(147, 3, 7, 1, 'group'),
(148, 3, 8, 1, 'group'),
(149, 3, 9, 1, 'group'),
(150, 3, 10, 1, 'group'),
(151, 3, 11, 1, 'group'),
(152, 3, 12, 1, 'group'),
(153, 3, 13, 1, 'group'),
(154, 3, 14, 1, 'group'),
(155, 3, 15, 1, 'group'),
(156, 3, 16, 1, 'group'),
(157, 3, 17, 1, 'group'),
(158, 3, 18, 1, 'group'),
(159, 3, 19, 1, 'group'),
(160, 3, 20, 0, 'group'),
(161, 3, 21, 1, 'group'),
(162, 3, 23, 1, 'group'),
(163, 3, 24, 1, 'group'),
(164, 3, 25, 1, 'group'),
(165, 3, 26, 1, 'group'),
(166, 3, 27, 1, 'group'),
(167, 3, 28, 1, 'group'),
(168, 3, 29, 0, 'group'),
(169, 3, 30, 0, 'group'),
(170, 3, 31, 0, 'group'),
(171, 3, 32, 0, 'group'),
(172, 3, 33, 1, 'group'),
(173, 3, 34, 1, 'group'),
(174, 3, 35, 1, 'group'),
(175, 3, 36, 1, 'group'),
(176, 4, 1, 1, 'group'),
(177, 4, 2, 1, 'group'),
(178, 4, 3, 1, 'group'),
(179, 4, 4, 1, 'group'),
(180, 4, 5, 1, 'group'),
(181, 4, 6, 1, 'group'),
(182, 4, 7, 1, 'group'),
(183, 4, 8, 1, 'group'),
(184, 4, 9, 1, 'group'),
(185, 4, 10, 1, 'group'),
(186, 4, 11, 1, 'group'),
(187, 4, 12, 1, 'group'),
(188, 4, 13, 1, 'group'),
(189, 4, 14, 1, 'group'),
(190, 4, 15, 1, 'group'),
(191, 4, 16, 1, 'group'),
(192, 4, 17, 1, 'group'),
(193, 4, 18, 1, 'group'),
(194, 4, 19, 1, 'group'),
(195, 4, 20, 0, 'group'),
(196, 4, 21, 1, 'group'),
(197, 4, 23, 1, 'group'),
(198, 4, 24, 1, 'group'),
(199, 4, 25, 1, 'group'),
(200, 4, 26, 1, 'group'),
(201, 4, 27, 1, 'group'),
(202, 4, 28, 1, 'group'),
(203, 4, 29, 0, 'group'),
(204, 4, 30, 0, 'group'),
(205, 4, 31, 0, 'group'),
(206, 4, 32, 0, 'group'),
(207, 4, 33, 1, 'group'),
(208, 4, 34, 1, 'group'),
(209, 4, 35, 1, 'group'),
(210, 4, 36, 1, 'group'),
(211, 5, 1, 1, 'group'),
(212, 5, 2, 1, 'group'),
(213, 5, 3, 1, 'group'),
(214, 5, 4, 1, 'group'),
(215, 5, 5, 1, 'group'),
(216, 5, 6, 1, 'group'),
(217, 5, 7, 1, 'group'),
(218, 5, 8, 1, 'group'),
(219, 5, 9, 1, 'group'),
(220, 5, 10, 1, 'group'),
(221, 5, 11, 1, 'group'),
(222, 5, 12, 1, 'group'),
(223, 5, 13, 1, 'group'),
(224, 5, 14, 1, 'group'),
(225, 5, 15, 1, 'group'),
(226, 5, 16, 1, 'group'),
(227, 5, 17, 1, 'group'),
(228, 5, 18, 1, 'group'),
(229, 5, 19, 1, 'group'),
(230, 5, 20, 0, 'group'),
(231, 5, 21, 1, 'group'),
(232, 5, 23, 1, 'group'),
(233, 5, 24, 1, 'group'),
(234, 5, 25, 1, 'group'),
(235, 5, 26, 1, 'group'),
(236, 5, 27, 1, 'group'),
(237, 5, 28, 1, 'group'),
(238, 5, 29, 0, 'group'),
(239, 5, 30, 0, 'group'),
(240, 5, 31, 0, 'group'),
(241, 5, 32, 0, 'group'),
(242, 5, 33, 1, 'group'),
(243, 5, 34, 1, 'group'),
(244, 5, 35, 1, 'group'),
(245, 5, 36, 1, 'group'),
(246, 10, 1, 1, 'group'),
(247, 10, 2, 1, 'group'),
(248, 10, 3, 1, 'group'),
(249, 10, 4, 1, 'group'),
(250, 10, 5, 1, 'group'),
(251, 10, 6, 1, 'group'),
(252, 10, 7, 1, 'group'),
(253, 10, 8, 1, 'group'),
(254, 10, 9, 1, 'group'),
(255, 10, 10, 1, 'group'),
(256, 10, 11, 1, 'group'),
(257, 10, 12, 1, 'group'),
(258, 10, 13, 1, 'group'),
(259, 10, 14, 1, 'group'),
(260, 10, 15, 1, 'group'),
(261, 10, 16, 1, 'group'),
(262, 10, 17, 1, 'group'),
(263, 10, 18, 1, 'group'),
(264, 10, 19, 1, 'group'),
(265, 10, 20, 0, 'group'),
(266, 10, 21, 1, 'group'),
(267, 10, 23, 1, 'group'),
(268, 10, 24, 1, 'group'),
(269, 10, 25, 1, 'group'),
(270, 10, 26, 1, 'group'),
(271, 10, 27, 1, 'group'),
(272, 10, 28, 1, 'group'),
(273, 10, 29, 0, 'group'),
(274, 10, 30, 0, 'group'),
(275, 10, 31, 0, 'group'),
(276, 10, 32, 0, 'group'),
(277, 10, 33, 1, 'group'),
(278, 10, 34, 1, 'group'),
(279, 10, 35, 1, 'group'),
(280, 10, 36, 1, 'group'),
(281, 12, 1, 1, 'group'),
(282, 12, 2, 1, 'group'),
(283, 12, 3, 1, 'group'),
(284, 12, 4, 1, 'group'),
(285, 12, 5, 1, 'group'),
(286, 12, 6, 1, 'group'),
(287, 12, 7, 1, 'group'),
(288, 12, 8, 1, 'group'),
(289, 12, 9, 1, 'group'),
(290, 12, 10, 1, 'group'),
(291, 12, 11, 1, 'group'),
(292, 12, 12, 1, 'group'),
(293, 12, 13, 1, 'group'),
(294, 12, 14, 1, 'group'),
(295, 12, 15, 1, 'group'),
(296, 12, 16, 1, 'group'),
(297, 12, 17, 1, 'group'),
(298, 12, 18, 1, 'group'),
(299, 12, 19, 1, 'group'),
(300, 12, 20, 0, 'group'),
(301, 12, 21, 1, 'group'),
(302, 12, 23, 1, 'group'),
(303, 12, 24, 1, 'group'),
(304, 12, 25, 1, 'group'),
(305, 12, 26, 1, 'group'),
(306, 12, 27, 1, 'group'),
(307, 12, 28, 1, 'group'),
(308, 12, 29, 0, 'group'),
(309, 12, 30, 0, 'group'),
(310, 12, 31, 0, 'group'),
(311, 12, 32, 0, 'group'),
(312, 12, 33, 1, 'group'),
(313, 12, 34, 1, 'group'),
(314, 12, 35, 1, 'group'),
(315, 12, 36, 1, 'group'),
(316, 8, 1, 1, 'group'),
(317, 8, 2, 1, 'group'),
(318, 8, 3, 1, 'group'),
(319, 8, 4, 1, 'group'),
(320, 8, 5, 1, 'group'),
(321, 8, 6, 1, 'group'),
(322, 8, 7, 1, 'group'),
(323, 8, 8, 1, 'group'),
(324, 8, 9, 1, 'group'),
(325, 8, 10, 1, 'group'),
(326, 8, 11, 1, 'group'),
(327, 8, 12, 1, 'group'),
(328, 8, 13, 1, 'group'),
(329, 8, 14, 1, 'group'),
(330, 8, 15, 1, 'group'),
(331, 8, 16, 1, 'group'),
(332, 8, 17, 1, 'group'),
(333, 8, 18, 1, 'group'),
(334, 8, 19, 1, 'group'),
(335, 8, 20, 1, 'group'),
(336, 8, 21, 1, 'group'),
(337, 8, 23, 1, 'group'),
(338, 8, 24, 1, 'group'),
(339, 8, 25, 1, 'group'),
(340, 8, 26, 1, 'group'),
(341, 8, 27, 1, 'group'),
(342, 8, 28, 1, 'group'),
(343, 8, 29, 1, 'group'),
(344, 8, 30, 1, 'group'),
(345, 8, 31, 1, 'group'),
(346, 8, 32, 1, 'group'),
(347, 8, 33, 1, 'group'),
(348, 8, 34, 1, 'group'),
(349, 8, 35, 1, 'group'),
(350, 8, 36, 1, 'group'),
(351, 1, 37, 1, 'group'),
(352, 6, 37, 1, 'group'),
(353, 7, 37, 1, 'group'),
(354, 2, 37, 1, 'group'),
(355, 3, 37, 1, 'group'),
(356, 4, 37, 1, 'group'),
(357, 5, 37, 1, 'group'),
(358, 10, 37, 1, 'group'),
(359, 12, 37, 1, 'group'),
(360, 8, 37, 1, 'group');

DROP TABLE IF EXISTS `#__easyblog_adsense`;
CREATE TABLE IF NOT EXISTS `#__easyblog_adsense` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `code` varchar(255) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `display` varchar(255) NOT NULL DEFAULT 'both',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `#__easyblog_adsense` (`id`, `user_id`, `code`, `published`, `display`) VALUES
(1, 660, '', 0, 'both');

DROP TABLE IF EXISTS `#__easyblog_autoarticle_map`;
CREATE TABLE IF NOT EXISTS `#__easyblog_autoarticle_map` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `content_id` bigint(20) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `autoarticle_map_post_id` (`post_id`),
  KEY `autoarticle_map_content_id` (`content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_blogger_subscription`;
CREATE TABLE IF NOT EXISTS `#__easyblog_blogger_subscription` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `blogger_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT '0',
  `fullname` varchar(255) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `easyblog_blogger_subscription_blogger_id` (`blogger_id`),
  KEY `easyblog_blogger_subscription_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_captcha`;
CREATE TABLE IF NOT EXISTS `#__easyblog_captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `response` varchar(5) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_category`;
CREATE TABLE IF NOT EXISTS `#__easyblog_category` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_by` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `parent_id` int(11) DEFAULT '0',
  `private` int(11) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `level` int(11) unsigned DEFAULT '0',
  `lft` int(11) unsigned DEFAULT '0',
  `rgt` int(11) unsigned DEFAULT '0',
  `default` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `easyblog_cat_published` (`published`),
  KEY `easyblog_cat_parentid` (`parent_id`),
  KEY `easyblog_cat_private` (`private`),
  KEY `easyblog_cat_lft` (`lft`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

INSERT INTO `#__easyblog_category` (`id`, `created_by`, `title`, `description`, `alias`, `avatar`, `parent_id`, `private`, `created`, `status`, `published`, `ordering`, `level`, `lft`, `rgt`, `default`) VALUES
(1, 660, 'Uncategorized', '', 'uncategorized', NULL, 0, 0, '2014-03-10 13:51:29', 0, 0, 0, 0, 1, 2, 1),
(2, 660, 'Easy Blog', '', 'easy-blog', NULL, 0, 0, '2014-03-13 04:31:21', 0, 0, 0, 0, 3, 4, 0),
(3, 660, 'Computer', '', 'computer', '3_computer.png', 0, 0, '2014-03-17 16:08:11', 0, 1, 0, 0, 11, 12, 0),
(4, 660, 'Tablet, Phablet', '', 'tablet-phablet', '4_tablet.png', 0, 0, '2014-03-17 16:08:40', 0, 1, 0, 0, 5, 6, 0),
(5, 660, 'Smartphone', '', 'smartphone', '5_smartphone.png', 0, 0, '2014-03-17 16:09:20', 0, 1, 0, 0, 7, 8, 0),
(6, 660, 'Camera', '', 'camera', '6_camera.png', 0, 0, '2014-03-17 16:09:53', 0, 1, 0, 0, 9, 10, 0);

DROP TABLE IF EXISTS `#__easyblog_category_acl`;
CREATE TABLE IF NOT EXISTS `#__easyblog_category_acl` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL,
  `acl_id` bigint(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `content_id` bigint(20) NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `easyblog_category_acl` (`category_id`),
  KEY `easyblog_category_acl_id` (`acl_id`),
  KEY `easyblog_content_type` (`content_id`,`type`),
  KEY `easyblog_category_content_type` (`category_id`,`content_id`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_category_acl_item`;
CREATE TABLE IF NOT EXISTS `#__easyblog_category_acl_item` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `description` text,
  `published` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `default` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO `#__easyblog_category_acl_item` (`id`, `action`, `description`, `published`, `default`) VALUES
(1, 'view', 'can view the category blog posts.', 1, 1),
(2, 'select', 'can select the category during blog post creation', 1, 1);

DROP TABLE IF EXISTS `#__easyblog_category_subscription`;
CREATE TABLE IF NOT EXISTS `#__easyblog_category_subscription` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT '0',
  `fullname` varchar(255) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `easyblog_category_subscription_category_id` (`category_id`),
  KEY `easyblog_category_subscription_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_comment`;
CREATE TABLE IF NOT EXISTS `#__easyblog_comment` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `comment` text,
  `name` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `ip` varchar(255) DEFAULT '',
  `created_by` bigint(20) unsigned DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime DEFAULT '0000-00-00 00:00:00',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vote` int(11) unsigned NOT NULL DEFAULT '0',
  `hits` int(11) unsigned NOT NULL DEFAULT '0',
  `sent` tinyint(1) DEFAULT '1',
  `parent_id` int(11) unsigned DEFAULT '0',
  `lft` int(11) unsigned NOT NULL DEFAULT '0',
  `rgt` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `easyblog_comment_postid` (`post_id`),
  KEY `easyblog_comment_parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

INSERT INTO `#__easyblog_comment` (`id`, `post_id`, `comment`, `name`, `title`, `email`, `url`, `ip`, `created_by`, `created`, `modified`, `published`, `publish_up`, `publish_down`, `ordering`, `vote`, `hits`, `sent`, `parent_id`, `lft`, `rgt`) VALUES
(3, 2, 'In tempor aliquet mollis. Mauris sem diam, sodales in ante a, lacinia consectetur libero. Aenean non ante vel metus facilisis tincidunt at ut mauris. Duis rhoncus nisi ac dictum ornare. Donec pretium orci purus, sit amet consequat sem semper sit amet. Suspendisse potenti. Vestibulum consectetur arcu vitae lectus elementum, ac posuere magna tincidunt.', 'Jobb', '', 'trungnt@ytcvn.com', 'http://www.smartaddons.com', '', 0, '2014-03-17 07:33:50', '2014-03-17 07:33:50', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 1, 0, 5, 6),
(2, 2, 'Nam malesuada mattis nisi at dictum. Ut mauris elit, convallis non semper quis, malesuada ac ligula. Vestibulum facilisis et quam id congue. Vivamus pulvinar, elit ac elementum semper, justo ante semper quam, eget porta urna magna id sem. Etiam eget urna id lorem placerat facilisis. Maecenas pellentesque tempus metus, non viverra arcu venenatis eget. Donec leo diam, adipiscing eu dolor nec, rhoncus interdum ipsum. Mauris faucibus,', 'Manager', '', 'trungnt@ytcvn.com', 'http://www.smartaddons.com', '', 0, '2014-03-17 05:00:07', '2014-03-17 05:00:07', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 1, 0, 3, 4),
(4, 26, 'Cras pretium tempor quam eget pretium. Curabitur nibh augue, pulvinar a sollicitudin at, dignissim ut quam. In hac habitasse platea dictumst. Morbi orci libero,', 'smartaddons', '', 'luannt@ytcvn.com', 'http://smartaddons.com/', '', 660, '2014-03-21 09:35:22', '2014-03-21 09:35:22', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 1, 0, 1, 2),
(5, 26, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean eleifend felis at lectus luctus eleifend. Pellentesque sollicitudin gravida est. Quisque euismod nisl eget tortor gravida, at imperdiet ipsum bibendum. Aliquam nec laoreet urna. Nulla ut dictum nisl. Nunc lectus purus...', 'smartaddons', '', 'luannt@ytcvn.com', '', '', 0, '2014-03-21 09:35:57', '2014-03-21 09:35:57', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 1, 0, 3, 6),
(6, 26, 'Curabitur imperdiet fermentum tellus, nec eleifend felis pharetra vel. Praesent lobortis, arcu eu tempor dapibus, justo quam sagittis turpis, in adipiscing felis enim sit amet sem.', 'smartaddons', '', 'luannt@ytcvn.com', '', '', 0, '2014-03-21 09:36:25', '2014-03-21 09:36:25', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 1, 0, 7, 8),
(7, 26, 'vfcryb hgtctv uhyc uyvgj bj uỳuvhj uỳty.', 'vyuvyu', '', 'guibuib', 'hụhbhi', '', 660, '2014-03-27 10:05:38', '2014-03-27 10:05:38', 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 0, 0, 9, 10),
(8, 26, 'sadasd sadssd sadsad sd a', 'asdsad', '', 'sadasd @gmail.com', 'dfdsfsf', '', 0, '2014-03-31 07:53:15', '2014-03-31 07:53:15', 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 0, 0, 11, 12),
(9, 26, 'sadasd sadssd sadsad sd a', 'asdsad', '', 'sadasd @gmail.com', 'dfdsfsf', '', 0, '2014-03-31 07:53:19', '2014-03-31 07:53:19', 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 0, 0, 13, 14),
(10, 26, 'ijuo', 'm;k', '', 'jkl.ouoi.com', '', '', 0, '2014-04-01 02:46:55', '2014-04-01 02:46:55', 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 0, 5, 4, 5);

DROP TABLE IF EXISTS `#__easyblog_configs`;
CREATE TABLE IF NOT EXISTS `#__easyblog_configs` (
  `name` varchar(255) NOT NULL,
  `params` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Store any configuration in key => params maps';

INSERT INTO `#__easyblog_configs` (`name`, `params`) VALUES
('config', 'main_global_title_enable=1\nmain_title="EasyBlog"\nmain_description="This is some blog description about this site"\nmain_multiblogger=1\nmain_comment="1"\nmain_comment_multiple="0"\nmain_trackbacks="0"\nmain_hits_session="1"\nmain_technorati=0\nmain_joomlauserparams="0"\nmain_hideintro_entryview="0"\nmain_twitter_message="Published a new blog entry {title} in {category}. {link}"\nmain_linkedin_message="Published a new blog entry {title} in {category}. {link}"\nmain_twitter_shorten_url=0\nmain_twitter_urlshortener_login=""\nmain_twitter_urlshortener_apikey=""\nmain_twitter_button="1"\nmain_twitter_button_style="vertical"\nmain_twitter_cards="1"\nmain_feedburner="1"\nmain_feedburnerblogger="1"\nmain_feedburnerurl=""\nmain_feedburnerfeedcount=""\nmain_feedburner_url=""\nmain_commentmoderatecomment=0\nmain_commentmoderateguestcomment=1\nmain_subscription="0"\nmain_mailqueueonpageload="1"\nmain_avatarpath="images/easyblog_avatar/"\nmain_bloggersubscription="0"\nmain_url_translation="0"\nmain_newblogonfrontpage="1"\nmain_showauthorinfo="0"\nmain_orphanitem_ownership="660"\nmain_dstoffset="0"\nmain_categorysubscription="0"\nmain_registeronsubscribe="0"\nmain_autofeatured="0"\nmain_image_path="images/easyblog_images/"\nmain_shared_path="images/easyblog_shared/"\nmain_categoryavatarpath="images/easyblog_cavatar/"\nmain_teamavatarpath="images/easyblog_tavatar/"\nmain_mailqueuehtmlformat="1"\nmain_blogpublishing="1"\nmain_ratings="1"\nmain_ratings_guests="1"\nmain_ratings_frontpage="1"\nmain_ratings_frontpage_locked="0"\nmain_ratings_display_raters="1"\nmain_ratings_display_raters_max=5\nmain_tags_sorting="ASC"\nmain_password_protect="1"\nmain_autodraft="1"\nmain_autodraft_interval="90"\nmain_blogprivacy="0"\nmain_blogprivacy_override="1"\nmain_allowguestcomment="1"\nmain_allowguestsubscribe="0"\nmain_googlebuzz=1\nmain_googlebuzz_position="right"\nmain_relatedpost="1"\nmain_max_relatedpost="5"\nmain_sitesubscription="0"\nmain_teamsubscription="0"\nmain_includeteamblogpost="1"\nmain_meta_autofillkeywords="1"\nmain_dashboard_editaccount="1"\nmain_googleone="1"\nmain_googleone_layout="tall"\nmain_categories_hideempty="1"\nmain_login_read="0"\nmain_meta_autofilldescription="1"\nmain_meta_autofilldescription_length="250"\nmain_google_profiles="1"\nmain_teaser_image_align="center"\nmain_locations_blog_language="en"\nmain_nonblogger_profile="0"\nmain_image_gallery_frontpage="1"\nmain_image_gallery_rowitems=3\nmain_image_gallery_maxwidth="128"\nmain_mailtitle_length="25"\nmain_mail_total="5"\nmain_blocked_words="fuck,suck,bastard,shit,bitch,slut"\nmain_copyrights="0"\nmain_login_provider="joomla"\nmain_anchor_nofollow="0"\nmain_multi_language="1"\nteamblog_allow_join="1"\nmain_reporting="1"\nmain_reporting_maxip="0"\nmain_reporting_guests="0"\nmain_truncate_ellipses="1"\nmain_truncate_media_position="top"\nmain_truncate_video_position="top"\nmain_truncate_image_position="top"\nmain_truncate_type="words"\nmain_truncate_maxtag="3"\nmain_locations="1"\nmain_locations_static_maps="0"\nmain_locations_blog_map_width="450"\nmain_locations_blog_map_height="300"\nmain_locations_blog_frontpage="0"\nmain_locations_blog_entry="1"\nmain_locations_map_type="ROADMAP"\nmain_locations_default_zoom_level="5"\nmain_locations_max_zoom_level="10"\nmain_locations_min_zoom_level="3"\nmain_teaser_image=0\nlayout_dashboard_blogimage="1"\nmain_post_min="0"\nmain_post_length="50"\nmain_sef="default"\nmain_sef_unicode="0"\nmain_sef_custom="%year_num%/%month_num%"\nsubscription_mailchimp="0"\nsubscription_mailchimp_key=""\nsubscription_mailchimp_listid=""\nsubscription_mailchimp_welcome="1"\nmain_rss_content="introtext"\nmain_digg_button="0"\nmain_digg_button_frontpage="0"\nmain_digg_button_style="medium"\nlayout_theme="sjicenter"\nlayout_comment_theme="default"\nlayout_dashboard_theme="system"\nlayout_exclude_bloggers=""\nlayout_exclude_categories=""\nlayout_toolbar="1"\nlayout_headers="1"\nlayout_headers_respect_author="1"\nlayout_nameformat="name"\nlayout_shortdateformat="%b %d"\nlayout_dateformat="%d %B %Y"\nlayout_timeformat="%I:%M:%S %p"\nlayout_avatar="1"\nlayout_avatarIntegration="default"\nlayout_phpbb_path=""\nlayout_avatar_in_read_blog=1\nlayout_editor="tinymce"\nlayout_latest="1"\nlayout_categories="1"\nlayout_tags="1"\nlayout_bloggers="1"\nlayout_teamblog="1"\nlayout_archive="0"\nlayout_search="1"\nlayout_option_toolbar="1"\nlayout_showcomment="0"\nlayout_showcommentcount="3"\nlayout_blogasintrotext="1"\nlayout_maxlengthasintrotext="50"\nlayout_categoryavatar="1"\nlayout_teamavatar="1"\nlayout_hits=1\nlayout_dashboarddisable=0\nlayout_dashboardhome="1"\nlayout_dashboardmain="1"\nlayout_dashboardblogs="1"\nlayout_dashboardcomments="1"\nlayout_dashboardcategories="1"\nlayout_dashboardtags="1"\nlayout_dashboardnewpost="1"\nlayout_dashboardsettings="1"\nlayout_dashboardlogout="1"\nlayout_enablebloggertheme="1"\nlayout_dashboarddrafts="1"\nlayout_dashboardintro=1\nlayout_dashboardseo="1"\nlayout_dashboardtrackback="1"\nlayout_dashboardquickpost=1\nlayout_availablebloggertheme="default"\nlayout_featured="1"\nlayout_featured_autorotate="1"\nlayout_featured_autorotate_interval="8"\nlayout_enabledashboardtoolbar="1"\nlayout_googlefont="site"\nlayout_postorder="latest"\nlayout_postsort="desc"\nlayout_dashboard_show_headers=0\nlayout_enableprint="1"\nlayout_enablepdf="1"\nlayout_enablebookmark="1"\nlayout_dashboardanchor="0"\nlayout_dashboard_zemanta="0"\nlayout_dashboard_zemanta_api=""\nlayout_respect_readmore="0"\nlayout_blogger_breadcrumb="1"\nlayout_login="1"\ntoolbar_logout="1"\nlayout_dashboardcategoryselect="select"\nlayout_featured_allpages="1"\nlayout_dashboardstats="1"\nlayout_navigation="0"\nlayout_avatar_link_name="1"\nlayout_featured_frontpage="0"\nlayout_dashboard_biography_editor="0"\ntoolbar_editprofile="1"\nlayout_listlength="0"\nlayout_pagination_bloggers="5"\nlayout_pagination_categories="5"\nlayout_pagination_categories_per_page="5"\nlayout_pagination_archive="5"\nmain_facebook_status=1\nmain_facebook_api=""\nmain_facebook_secret=""\nmain_facebook_like="0"\nmain_facebook_like_layout="box_count"\nmain_facebook_like_faces="1"\nmain_facebook_like_send="1"\nmain_facebook_like_width="450"\nmain_facebook_like_verb="like"\nmain_facebook_like_theme="light"\nmain_facebook_scripts="1"\nmain_facebook_opengraph="1"\nmain_facebook_like_position="0"\nlayout_sorting_category="ordering"\nnotification_from_name="sj_icenter"\nnotification_from_email="admin@admin.com"\nnotifications_title="sj_icenter"\nnotification_email=""\ncustom_email_as_admin="0"\nnotification_blogadmin="1"\nnotification_allmembers="0"\nnotification_blogsubscriber="1"\nnotification_commentadmin="1"\nnotification_commentauthor="1"\nnotification_commentid=1\nnotification_commentsubscriber="1"\nnotification_categorysubscriber="1"\nnotification_sitesubscriber="1"\nnotification_teamsubscriber="1"\nmain_comment_email=0\ncomment_facebook="0"\ncomment_facebook_colourscheme="light"\ncomment_mollom=0\ncomment_mollom_public=""\ncomment_mollom_private=""\ncomment_autopublish=1\ncomment_autohyperlink="1"\ncomment_moderatecomment="0"\ncomment_moderateauthorcomment="0"\ncomment_moderateguestcomment="1"\ncomment_tnc="0"\ncomment_tnc_users="2"\ncomment_tnctext="Before submitting the comment, you agree that:\\n\\na. To accept full responsibility for the comment that you submit.\\nb. To use this function only for lawful purposes.\\nc. Not to post defamatory, abusive, offensive, racist, sexist, threatening, vulgar, obscene, hateful or otherwise inappropriate comments, or to post comments which will constitute a criminal offence or give rise to civil liability.\\nd. Not to post or make available any material which is protected by copyright, trade mark or other proprietary right without the express permission of the owner of the copyright, trade mark or any other proprietary right.\\ne. To evaluate for yourself the accuracy of any opinion, advice or other content."\ncomment_recaptcha="0"\ncomment_recaptcha_ssl="0"\ncomment_recaptcha_public=""\ncomment_recaptcha_private=""\ncomment_recaptcha_theme="clean"\ncomment_recaptcha_lang="en"\ncomment_requiretitle="0"\ncomment_likes="0"\ncomment_maxthreadedlevel="5"\ncomment_autotitle="0"\ncomment_registeroncomment="1"\ncomment_bbcode="1"\ncomment_captcha="0"\ncomment_captcha_registered="0"\nprm_blogger=18\ncomment_intensedebate="0"\ncomment_disqus="0"\ncomment_livefyre="0"\ncomment_livefyre_siteid=""\ncomment_jomcomment=0\ncomment_jcomments=0\ncomment_rscomments=0\ncomment_easydiscuss=0\ncomment_komento=0\ncomment_akismet="0"\ncomment_akismet_trackback="0"\ncomment_require_email="0"\ncomment_require_website="0"\ncomment_show_email="1"\ncomment_show_website="1"\ncomment_compojoom="0"\nsocial_rtl="1"\nmain_socialbutton_position="right"\nsocial_show_frontpage=false\nfile_path="images"\nupload_extensions="bmp,gif,jpg,png,BMP,GIF,JPG,PNG"\ncheck_mime=1\nimage_extensions="bmp,gif,jpg,png"\nignore_extensions=""\nupload_mime="image/jpeg,image/gif,image/png,image/bmp"\nupload_mime_illegal="text/html"\nrestrict_uploads=1\nlayout_systemdateformat="%Y-%m-%d %H:%M:%S"\nsocial_provider="addthis"\nsocial_addthis_customcode="xa-4be11e1875bf6363"\nsocial_addthis_style="2"\nsocial_sharethis_publishers="42b7151d-c982-4f69-8414-846243c5c7ca"\nmain_alpha_userpoint="1"\nmain_alpha_userpoint_points="1"\nmain_alpha_userpoint_medals="1"\nmain_alpha_userpoint_ranks="1"\nmain_rss="0"\nintegrations_linkedin=0\nintegrations_linkedin_api_key=""\nintegrations_linkedin_secret_key=""\nintegrations_facebook=0\nintegrations_facebook_api_key=""\nintegrations_facebook_secret_key=""\nintegrations_facebook_default_message=""\nintegrations_facebook_show_in_listing="0"\nintegrations_facebook_page_id=""\nintegrations_facebook_blogs_length=350\nintegrations_facebook_impersonate_page=0\nintegrations_facebook_source="content"\nintegrations_twitter=0\nintegrations_twitter_api_key=""\nintegrations_twitter_secret_key=""\nintegrations_twitter_microblog="1"\nintegrations_twitter_microblog_hashes="#blogs,#easyblog"\nintegrations_twitter_microblog_category="1"\nintegrations_twitter_microblog_publish="1"\nintegrations_twitter_microblog_frontpage="1"\nintegrations_easydiscuss_points="1"\nintegrations_easydiscuss_badges="1"\nintegrations_easydiscuss_notification_blog="1"\nintegrations_easydiscuss_notification_comment="1"\nintegrations_easydiscuss_notification_rating="1"\nintegrations_easydiscuss_notification_comment_follower="1"\nintegrations_jomsocial_album="1"\nintegrations_jomsocial_blog_new_activity="1"\nintegrations_jomsocial_blog_update_activity="1"\nintegrations_jomsocial_comment_new_activity="1"\nintegrations_jomsocial_submit_content="1"\nintegrations_jomsocial_show_category="1"\nintegrations_jomsocial_blogger_status="1"\nintegrations_jomsocial_profile_link="1"\nintegrations_jomsocial_toolbar="0"\nintegrations_jomsocial_feature_blog_activity="1"\nintegrations_jomsocial_activity_comments="1"\nintegrations_jomsocial_activity_likes="1"\nintegrations_jomsocial_rss_import_activity="0"\nintegrations_jomsocial_blogs_length="250"\nintegrations_jomsocial_comments_length="250"\nintegrations_jomsocial_notification_blog="1"\nintegrations_jomsocial_notification_comment="1"\nintegrations_jomsocial_notification_rating=1\nintegrations_jomsocial_notification_comment_follower="1"\njomsocial_blog_title_length="80"\nmain_jomsocial_userpoint="1"\nmain_jomsocial_activity=1\nmain_jomsocial_messaging="1"\nmain_jomsocial_friends="1"\nmain_jomsocial_privacy="0"\nintegrations_twitter_centralized=0\nintegrations_twitter_centralized_userid=0\nintegrations_twitter_centralized_auto_post=0\nintegrations_twitter_centralized_send_updates=1\nintegrations_twitter_centralized_and_own=1\nintegrations_facebook_centralized=0\nintegrations_facebook_centralized_and_own=1\nintegrations_facebook_centralized_userid=0\nintegrations_facebook_centralized_auto_post=0\nintegrations_facebook_centralized_send_updates=0\nintegrations_linkedin_centralized=0\nintegrations_linkedin_centralized_userid=0\nintegrations_linkedin_centralized_auto_post=0\nintegrations_linkedin_centralized_send_updates=1\nintegrations_linkedin_centralized_and_own=1\nintegration_google_adsense_enable="1"\nintegration_google_adsense_centralized="0"\nintegrations_google_adsense_blogger="1"\nintegration_google_adsense_code=""\nintegration_google_adsense_display="both"\nintegration_google_adsense_display_access="both"\nintegrations_mighty_activity_new_blog="0"\nintegrations_mighty_activity_update_blog="0"\nintegrations_mighty_karma_new_blog="1"\nintegrations_mighty_karma_new_blog_points="5"\nintegrations_mighty_karma_remove_blog=1\nintegrations_mighty_karma_remove_blog_points="-5"\nmain_linkedin_button="1"\nmain_linkedin_button_style="vertical"\nmain_stumbleupon_button="1"\nmain_stumbleupon_button_style="vertical"\nmain_pinit_button="1"\nmain_pinit_button_style="vertical"\nintegrations_order_twitter="1"\nintegrations_order_facebook="2"\nintegrations_order_googleone="3"\nintegrations_order_digg="4"\nintegrations_order_linkedin="5"\nintegrations_order_stumbleupon="6"\nintegrations_order_pinit="7"\nintegrations_order_tweetmeme=8\nmain_remotepublishing_mailbox="0"\nmain_remotepublishing_mailbox_remotesystemname=""\nmain_remotepublishing_mailbox_service="imap"\nmain_remotepublishing_mailbox_port="143"\nmain_remotepublishing_mailbox_mailboxname="INBOX"\nmain_remotepublishing_mailbox_username=""\nmain_remotepublishing_mailbox_password=""\nmain_remotepublishing_mailbox_run_interval="5"\nmain_remotepublishing_mailbox_ssl="1"\nmain_remotepublishing_mailbox_prefix=""\nmain_remotepublishing_mailbox_userid="0"\nmain_remotepublishing_mailbox_categoryid="1"\nmain_remotepublishing_mailbox_publish="1"\nmain_remotepublishing_mailbox_frontpage="1"\nmain_remotepublishing_mailbox_fetch_limit="3"\nmain_remotepublishing_mailbox_next_run=0\nmain_remotepublishing_mailbox_type="intro"\nmain_remotepublishing_mailbox_format="html"\nmain_remotepublishing_mailbox_from_whitelist=""\nmain_remotepublishing_mailbox_image_attachment="1"\nmain_remotepublishing_mailbox_validate_cert="1"\nmain_remotepublishing_mailbox_syncuser="1"\nmain_remotepublishing_mailbox_privacy="0"\nmax_video_width="400"\nmax_video_height="225"\ndashboard_video_width="400"\ndashboard_video_height="225"\ndashboard_tags_listing="1"\nmax_tags_allowed="5"\nintegrations_mighty_blogs_length="250"\nlayout_zero_as_plural="1"\nmain_routing="currentactive"\nmain_routing_itemid=""\nmain_pagetitle_autoappend="1"\nmain_routing_order_bloggerstandalone="1"\nmain_routing_order_entry="2"\nmain_routing_order_category="3"\nmain_routing_order_blogger="4"\nmain_routing_order_teamblog="5"\nmain_routing_order_bloggerstandalone_ignore="1"\nmain_routing_order_entry_ignore="1"\nmain_routing_order_category_ignore="1"\nmain_routing_order_blogger_ignore="1"\nmain_routing_order_teamblog_ignore="1"\nlayout_copyrights="0"\nmain_microblog="1"\nmain_microblog_photo=1\nmain_microblog_video=1\nmain_microblog_quote=1\nmain_microblog_link=1\nlayout_media_flickr="0"\nintegrations_flickr_api_key="ed9c66c60eb8c975bcbe2ff4a60852bf"\nintegrations_flickr_secret_key="df665d37e9a425bd"\nmain_canonical_entry="1"\nmain_scribeseo_key=""\nlayout_streamtimeformat="%I:%M %p"\neasyblog_environment="production"\ndebug_javascript=1\nmain_media_extensions="jpg,png,gif,3g2,3gp,aac,f4a,f4v,flv,m4a,m4v,mov,mp3,mp4,zip,rar,7z,pdf,doc,docx,ppt,pptx,xls,xlsx"\nmain_upload_image_size="8"\nmain_image_quality="90"\nmain_original_image_width="1280"\nmain_original_image_height="960"\nmain_original_image_quality="80"\nmain_resize_original_image="0"\nmain_thumbnail_width="250"\nmain_thumbnail_height="250"\nmain_thumbnail_quality="80"\nmedia_icon_width=128\nmedia_icon_height=128\nmedia_icon_quality=70\nmain_media_lightbox_preview="1"\nmain_media_show_lightbox_caption="1"\nmain_media_lightbox_caption_strip_extension="0"\nmain_media_lightbox_enforce_size="0"\nmain_media_lightbox_max_width="640"\nmain_media_lightbox_max_height="480"\nmain_media_manager="1"\nmain_media_manager_place_shared_media="1"\nmain_media_manager_items_per_page="100"\nmain_media_manager_image_panel_enable_lightbox="0"\nmain_media_manager_image_panel_enforce_image_dimension="0"\nmain_media_manager_image_panel_enforce_image_width="400"\nmain_media_manager_image_panel_enforce_image_height="400"\nmain_media_manager_image_panel_max_variation_image_width="2000"\nmain_media_manager_image_panel_max_variation_image_height="2000"\nmain_twitter_button_via_screen_name=""\nmain_script_versioning="0"\nintegrations_jomsocial_unpublish_remove_activity="0"\ncomment_autosubscribe="0"\ncomment_show_title="0"\ncomment_akismet_key=""\ncomment_easyblog="0"\ncomment_intensedebate_code=""\ncomment_disqus_code=""\nintegrations_mighty_activity_feature_blog="0"\nintegrations_mighty_submit_content="0"\nintegrations_mighty_show_category="0"\nintegrations_mighty_karma_update_blog="0"\nmain_phocapdf_enable="0"\nmain_pingomatic="0"\nmain_twitter_button_frontpage="0"\nmain_facebook_like_admin=""\nmain_facebook_like_appid=""\nmain_googleone_frontpage="0"\nmain_linkedin_button_frontpage="0"\nmain_stumbleupon_button_frontpage="0"\nmain_pinit_button_frontpage="0"\n7694fac33d2e9976a213c7cdbb8e8ff5="1"\nactive=""\nactivechild=""\n5d5de9cab0d94a4ea56276445813650c="1"\n841f8fd52b5ba767982950ea26948c53="1"\naf25676da2da644c2e6588a3b1c848d9="1"\n6ca1b5ad2068e8c40a5c9eec256ccc2a="1"\ne62e8d5a037e99caca543fefb1e41895="1"\n84ad07acf8c896d0251189f0d5ec3015="1"\n62268ea849b3d025eab3dfce0cd0e228="1"\n3f5492e06d297763d3ee991fc4dca2d0="1"'),
('default', 'show_headers_latestentries="1"\nshow_author="1"\nshow_created_date="1"\nshow_last_modified="1"\nshow_category="1"\nshow_tags="1"\nshow_tags_frontpage="1"\nshow_avatar_frontpage="0"\nshow_avatar_entry="0"\nshow_hits="1"\nshow_comments="1"\nshow_fontchanger="1"\nshow_blogger_filterbar="1"\nshow_bloggerstats="0"\nshow_bloggerstatsitem="0"\nshow_categorystats="1"\nshow_categorystatsitem="0"\nshow_teamblogstats="0"\nshow_teamblogstatsitem="0"\nshow_teamblogavatar="1"\nshow_category_bloggers_avatar="1"\nshow_category_header="1"\nblogimage_entry="1"\nblogimage_frontpage="1"'),
('sjicenter', 'show_headers_latestentries="1"\nshow_author="1"\nshow_created_date="1"\nshow_last_modified="1"\nshow_category="1"\nshow_tags="1"\nshow_tags_frontpage="1"\nshow_avatar_frontpage="0"\nshow_avatar_entry="0"\nshow_hits="1"\nshow_comments="1"\nshow_fontchanger="1"\nshow_blogger_filterbar="1"\nshow_bloggerstats="0"\nshow_bloggerstatsitem="0"\nshow_categorystats="1"\nshow_categorystatsitem="0"\nshow_teamblogstats="0"\nshow_teamblogstatsitem="0"\nshow_teamblogavatar="1"\nshow_category_bloggers_avatar="1"\nshow_category_header="1"\nblogimage_entry="1"\nblogimage_frontpage="1"');

DROP TABLE IF EXISTS `#__easyblog_drafts`;
CREATE TABLE IF NOT EXISTS `#__easyblog_drafts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `title` text,
  `permalink` text NOT NULL,
  `content` longtext NOT NULL,
  `intro` longtext NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  `published` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime DEFAULT '0000-00-00 00:00:00',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vote` int(11) unsigned NOT NULL DEFAULT '0',
  `hits` int(11) unsigned NOT NULL DEFAULT '0',
  `private` int(11) unsigned NOT NULL DEFAULT '0',
  `allowcomment` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `subscription` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `frontpage` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `isnew` tinyint(3) unsigned DEFAULT '0' COMMENT 'To indicate whether the post is new created or already been edited',
  `ispending` tinyint(1) DEFAULT '0',
  `issitewide` tinyint(1) DEFAULT '1',
  `blogpassword` varchar(255) NOT NULL,
  `tags` text NOT NULL,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `trackbacks` text NOT NULL,
  `blog_contribute` tinyint(1) NOT NULL,
  `autopost` text NOT NULL,
  `autopost_centralized` text NOT NULL,
  `pending_approval` tinyint(3) DEFAULT '0',
  `latitude` varchar(255) DEFAULT NULL,
  `longitude` varchar(255) DEFAULT NULL,
  `address` text,
  `external_source` text,
  `external_group_id` int(11) DEFAULT NULL,
  `robots` text,
  `copyrights` text,
  `language` char(7) NOT NULL,
  `source` varchar(255) NOT NULL,
  `image` text NOT NULL,
  `send_notification_emails` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `easyblog_post_catid` (`category_id`),
  KEY `easyblog_post_published` (`published`),
  KEY `easyblog_post_created_by` (`created_by`),
  KEY `easyblog_post_pending_approval` (`pending_approval`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_external`;
CREATE TABLE IF NOT EXISTS `#__easyblog_external` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `source` text NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `uid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `external_groups_post_id` (`post_id`),
  KEY `external_groups_group_id` (`uid`),
  KEY `external_groups_posts` (`uid`,`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_external_groups`;
CREATE TABLE IF NOT EXISTS `#__easyblog_external_groups` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `source` text NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `external_groups_post_id` (`post_id`),
  KEY `external_groups_group_id` (`group_id`),
  KEY `external_groups_posts` (`group_id`,`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_featured`;
CREATE TABLE IF NOT EXISTS `#__easyblog_featured` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` bigint(20) unsigned NOT NULL,
  `type` varchar(255) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `easyblog_featured_content_type` (`content_id`,`type`),
  KEY `easyblog_content` (`content_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

INSERT INTO `#__easyblog_featured` (`id`, `content_id`, `type`, `created`) VALUES
(1, 42, 'post', '2014-03-21 09:53:16'),
(2, 39, 'post', '2014-03-21 09:53:18'),
(3, 41, 'post', '2014-03-21 09:53:27'),
(4, 40, 'post', '2014-03-21 09:53:47');

DROP TABLE IF EXISTS `#__easyblog_feedburner`;
CREATE TABLE IF NOT EXISTS `#__easyblog_feedburner` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `userid` bigint(20) unsigned NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `#__easyblog_feedburner` (`id`, `userid`, `url`) VALUES
(1, 660, '');

DROP TABLE IF EXISTS `#__easyblog_feeds`;
CREATE TABLE IF NOT EXISTS `#__easyblog_feeds` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `url` text NOT NULL,
  `interval` int(11) NOT NULL,
  `cron` tinyint(3) NOT NULL,
  `item_creator` int(11) NOT NULL,
  `item_category` bigint(20) NOT NULL,
  `item_frontpage` tinyint(3) NOT NULL,
  `item_published` tinyint(3) NOT NULL,
  `item_content` text NOT NULL,
  `item_get_fulltext` tinyint(3) NOT NULL DEFAULT '0',
  `author` tinyint(3) NOT NULL,
  `params` text NOT NULL,
  `published` tinyint(3) NOT NULL,
  `created` datetime NOT NULL,
  `last_import` datetime NOT NULL,
  `flag` tinyint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cron` (`cron`),
  KEY `item_creator` (`item_creator`),
  KEY `author` (`author`),
  KEY `item_frontpage` (`item_frontpage`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_feeds_history`;
CREATE TABLE IF NOT EXISTS `#__easyblog_feeds_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `feed_id` bigint(20) NOT NULL,
  `post_id` int(11) NOT NULL,
  `uid` text NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_post_id` (`feed_id`,`post_id`),
  KEY `feed_uids` (`feed_id`,`uid`(255))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_hashkeys`;
CREATE TABLE IF NOT EXISTS `#__easyblog_hashkeys` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `uid` bigint(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `key` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `type` (`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

INSERT INTO `#__easyblog_hashkeys` (`id`, `uid`, `type`, `key`) VALUES
(1, 1, 'comments', 'acffeb86b130'),
(2, 2, 'comments', '291e78aae209'),
(3, 3, 'comments', 'ee9f9793290c'),
(4, 4, 'comments', 'dddc89dfede5'),
(5, 5, 'comments', '92d2616b7a68'),
(6, 6, 'comments', '8b2db5c02d40'),
(7, 7, 'comments', 'b663584d9b04'),
(8, 8, 'comments', 'bc8e7f09a244'),
(9, 9, 'comments', '9054d8c466d4'),
(10, 10, 'comments', '9beab8a4b41c');

DROP TABLE IF EXISTS `#__easyblog_likes`;
CREATE TABLE IF NOT EXISTS `#__easyblog_likes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `content_id` int(11) NOT NULL,
  `created_by` bigint(20) unsigned DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `easyblog_content_type` (`type`,`content_id`),
  KEY `easyblog_contentid` (`content_id`),
  KEY `easyblog_createdby` (`created_by`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_mailq`;
CREATE TABLE IF NOT EXISTS `#__easyblog_mailq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mailfrom` varchar(255) DEFAULT NULL,
  `fromname` varchar(255) DEFAULT NULL,
  `recipient` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `created` datetime NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `easyblog_mailq_status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=21 ;

DROP TABLE IF EXISTS `#__easyblog_mediamanager`;
CREATE TABLE IF NOT EXISTS `#__easyblog_mediamanager` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  FULLTEXT KEY `path` (`path`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

DROP TABLE IF EXISTS `#__easyblog_meta`;
CREATE TABLE IF NOT EXISTS `#__easyblog_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `content_id` int(11) NOT NULL,
  `keywords` text,
  `description` text,
  `indexing` int(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=73 ;

INSERT INTO `#__easyblog_meta` (`id`, `type`, `content_id`, `keywords`, `description`, `indexing`) VALUES
(1, 'view', 1, '', '', 1),
(2, 'view', 2, '', '', 1),
(3, 'view', 3, '', '', 1),
(4, 'view', 4, '', '', 1),
(5, 'view', 5, '', '', 1),
(6, 'view', 6, '', '', 1),
(7, 'view', 7, '', '', 1),
(30, 'view', 30, '', '', 1),
(31, 'post', 2, '', '', 1),
(32, 'post', 3, '', '', 1),
(33, 'post', 4, '', '', 1),
(34, 'post', 5, '', '', 1),
(35, 'post', 6, '', '', 1),
(36, 'post', 7, '', '', 1),
(37, 'post', 8, '', '', 1),
(38, 'post', 9, '', '', 1),
(39, 'post', 10, '', '', 1),
(40, 'post', 11, '', '', 1),
(41, 'post', 12, '', '', 1),
(42, 'post', 13, '', '', 1),
(43, 'post', 14, '', '', 1),
(44, 'post', 15, '', '', 1),
(45, 'post', 16, '', '', 1),
(46, 'post', 17, '', '', 1),
(47, 'post', 18, '', '', 1),
(48, 'post', 19, '', '', 1),
(49, 'post', 20, '', '', 1),
(50, 'post', 21, '', '', 1),
(51, 'post', 22, '', '', 1),
(52, 'post', 23, '', '', 1),
(53, 'post', 24, '', '', 1),
(54, 'post', 25, '', '', 1),
(55, 'post', 26, '', '', 1),
(56, 'post', 27, '', '', 1),
(57, 'post', 28, '', '', 1),
(58, 'post', 29, '', '', 1),
(59, 'post', 30, '', '', 1),
(60, 'post', 31, '', '', 1),
(61, 'post', 32, '', '', 1),
(62, 'post', 33, '', '', 1),
(63, 'post', 34, '', '', 1),
(64, 'post', 35, '', '', 1),
(65, 'post', 36, '', '', 1),
(66, 'post', 37, '', '', 1),
(67, 'post', 38, '', '', 1),
(68, 'post', 39, '', '', 1),
(69, 'post', 40, '', '', 1),
(70, 'post', 41, '', '', 1),
(71, 'post', 42, '', '', 1),
(72, 'post', 43, '', '', 1),
(8, 'view', 8, '', '', 1);

DROP TABLE IF EXISTS `#__easyblog_migrate_content`;
CREATE TABLE IF NOT EXISTS `#__easyblog_migrate_content` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `session_id` varchar(255) NOT NULL,
  `component` varchar(255) NOT NULL DEFAULT 'com_content',
  `filename` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `post_id` (`post_id`),
  KEY `session_id` (`session_id`),
  KEY `component_content` (`content_id`,`component`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Store migrated joomla content id and map with eblog post id.' AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_oauth`;
CREATE TABLE IF NOT EXISTS `#__easyblog_oauth` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `auto` tinyint(1) NOT NULL,
  `request_token` text NOT NULL,
  `access_token` text NOT NULL,
  `message` text NOT NULL,
  `created` datetime NOT NULL,
  `private` tinyint(4) NOT NULL,
  `params` text NOT NULL,
  `system` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `easyblog_oauth_user_type` (`user_id`,`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `#__easyblog_oauth` (`id`, `user_id`, `type`, `auto`, `request_token`, `access_token`, `message`, `created`, `private`, `params`, `system`) VALUES
(1, 0, '', 0, '', '', 'Published a new blog entry {title} in {category}. {link}', '0000-00-00 00:00:00', 0, '', 0);

DROP TABLE IF EXISTS `#__easyblog_oauth_posts`;
CREATE TABLE IF NOT EXISTS `#__easyblog_oauth_posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oauth_id` int(11) NOT NULL,
  `post_id` int(11) NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `sent` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `easyblog_oauth_posts_ids` (`oauth_id`,`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_post`;
CREATE TABLE IF NOT EXISTS `#__easyblog_post` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_by` bigint(20) unsigned NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `title` text,
  `permalink` text NOT NULL,
  `content` longtext NOT NULL,
  `intro` longtext NOT NULL,
  `excerpt` text,
  `category_id` bigint(20) unsigned NOT NULL,
  `published` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime DEFAULT '0000-00-00 00:00:00',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vote` int(11) unsigned NOT NULL DEFAULT '0',
  `hits` int(11) unsigned NOT NULL DEFAULT '0',
  `private` int(11) unsigned NOT NULL DEFAULT '0',
  `allowcomment` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `subscription` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `frontpage` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `isnew` tinyint(3) unsigned DEFAULT '0' COMMENT 'To indicate whether the post is new created or already been edited',
  `ispending` tinyint(1) DEFAULT '0',
  `issitewide` tinyint(1) DEFAULT '1',
  `blogpassword` varchar(100) NOT NULL DEFAULT '',
  `latitude` varchar(255) DEFAULT NULL,
  `longitude` varchar(255) DEFAULT NULL,
  `address` text,
  `system` tinyint(3) unsigned DEFAULT '0',
  `source` varchar(255) NOT NULL,
  `robots` text,
  `copyrights` text,
  `image` text,
  `language` char(7) NOT NULL,
  `send_notification_emails` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `easyblog_post_catid` (`category_id`),
  KEY `easyblog_post_published` (`published`),
  KEY `easyblog_post_created_by` (`created_by`),
  KEY `easyblog_post_blogger_list` (`published`,`id`,`created_by`),
  KEY `easyblog_post_search` (`private`,`published`,`issitewide`,`created`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=44 ;

INSERT INTO `#__easyblog_post` (`id`, `created_by`, `created`, `modified`, `title`, `permalink`, `content`, `intro`, `excerpt`, `category_id`, `published`, `publish_up`, `publish_down`, `ordering`, `vote`, `hits`, `private`, `allowcomment`, `subscription`, `frontpage`, `isnew`, `ispending`, `issitewide`, `blogpassword`, `latitude`, `longitude`, `address`, `system`, `source`, `robots`, `copyrights`, `image`, `language`, `send_notification_emails`) VALUES
(1, 660, '2014-03-10 13:51:29', '2014-03-10 13:51:29', 'Congratulations! You have successfully installed EasyBlog!', 'congratulations-you-have-successfully-installed-easyblog', '<h2>With EasyBlog, you can be assured of quality blogging with the following features:</h2><ol><li> <strong><span style="text-decoration: underline;">Blog now, post later</span></strong><br />You can compose a blog now, suffer temporal writer''s block, save and write again, later.</li><li> <strong><span style="text-decoration: underline;">Social media sharing</span></strong><br />Automatically post into your <em><strong>Twitter</strong></em>, <em><strong>Facebook</strong></em> and <em><strong>LinkedIn</strong></em> whenever you create new blog entries.</li><li> <strong><span style="text-decoration: underline;">Browse media</span></strong><br />Embedding images and videos is fast and easy.</li><li> <strong><span style="text-decoration: underline;">More third party integrations</span></strong><br />Having other Joomla! plugins and extensions to work with EasyBlog is just a few clicks away.</li><li> <strong><span style="text-decoration: underline;">Blog rating</span></strong><br />Users can show intensity of their favorite blog post by rating them with stars.</li></ol><p>And many more powerful features that you can use to make your blog work beautifully and professionally!</p><p> </p><p>We welcome any inquiries and feedback from you. Feel free to send us an email to <a href="mailto:support@stackideas.com" target="_blank">support@stackideas.com</a> for immediate attention. Or, you can also refer to our Documentations and FAQs from our website at <a href="http://stackideas.com" target="_blank">http://stackideas.com</a></p>', '<h2>Thank you for making the right decision to start blogging in your Joomla! website.</h2><p><img src="http://stackideas.com/images/eblog/install_success35.png" border="0" style="align:center;" /></p><p> </p>', '<h2>Thank you for making the right decision to start blogging in your Joomla! website.</h2><p><img src="http://stackideas.com/images/eblog/install_success35.png" border="0" style="align:center;" /></p><p> </p>', 1, 0, '2014-03-10 13:51:29', '0000-00-00 00:00:00', 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, '', NULL, NULL, NULL, 0, '', NULL, NULL, NULL, '', 1),
(2, 660, '2014-03-13 04:32:26', '2014-03-17 04:21:27', 'Aliquam consectetur', 'aliquam-consectetur', '', '<p>Suspendisse vitae erat eget magna tincidunt elementum vitae at augue. Integer interdum mauris vel purus hendrerit egestas. Maecenas ullamcorper nisi leo, quis adipiscing massa viverra in. Pellentesque iaculis quam sit amet lacus porta, quis egestas leo eleifend. Donec ullamcorper, leo sed tristique feugiat, tortor dui dictum ipsum, non consectetur tellus est et lectus. Pellentesque hendrerit est eu pharetra mollis. Integer sed sodales leo. Integer lacinia condimentum augue non cursus.</p>\r\n<p>Nam malesuada mattis nisi at dictum. Ut mauris elit, convallis non semper quis, malesuada ac ligula. Vestibulum facilisis et quam id congue. Vivamus pulvinar, elit ac elementum semper, justo ante semper quam, eget porta urna magna id sem. Etiam eget urna id lorem placerat facilisis. Maecenas pellentesque tempus metus, non viverra arcu venenatis eget. Donec leo diam, adipiscing eu dolor nec, rhoncus interdum ipsum. Mauris faucibus, dui vel consectetur pulvinar, magna lacus suscipit mauris, sit amet luctus mi lectus eu arcu. Phasellus rutrum enim tortor, in sagittis magna accumsan ut. Fusce suscipit eget urna at tincidunt. Curabitur eget nunc quis velit blandit lobortis. Nunc magna augue, commodo eu pretium vitae, tempor ac sem. Donec a condimentum lectus. Vestibulum eget purus vel orci tempor aliquam non non purus. Morbi vel diam sapien. Quisque sollicitudin rutrum velit ac egestas.</p>\r\n<p>Suspendisse euismod nibh ut ullamcorper laoreet. Sed accumsan eros ut dui lobortis aliquet. In placerat hendrerit nulla, ut ullamcorper nisi molestie id. In vestibulum erat in erat pellentesque placerat. Suspendisse ornare ante urna, sit amet aliquet ligula gravida at. Curabitur vel metus sit amet velit volutpat venenatis ut quis odio. Pellentesque mollis varius massa eget faucibus. Nunc pharetra, justo sed tincidunt eleifend, lacus nunc pretium urna, a auctor dui quam eu nisi. Nulla quis vestibulum nisl. Etiam facilisis dignissim leo, tempor adipiscing turpis ultricies sit amet. Proin sed varius nisi. In lobortis eget orci ut pharetra. Vivamus ut est in eros posuere tempus feugiat sed libero. Pellentesque laoreet enim vel quam iaculis, nec imperdiet neque scelerisque. Nunc vitae consectetur libero, et feugiat turpis.</p>', NULL, 2, 1, '2014-03-13 04:32:26', '0000-00-00 00:00:00', 0, 0, 11, 0, 1, 1, 0, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"easy1.png","mime":"image/png","url":"http://sj_icenter.wp/images/easyblog_images/660/blog/easy1.png","dateCreated":"Thursday, 13 March 2014","dateModified":1394698341,"path":"\\\\blog\\\\easy1.png","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_easy1.png","mime":"image/png","filesize":"100.86 KB","url":"http://sj_icenter.wp/images/easyblog_images/660/blog/b2ap3_thumbnail_easy1.png","dateCreated":"Thursday, 13 March 2014","dateModified":1394698342,"path":"\\\\blog\\\\b2ap3_thumbnail_easy1.png","place":"user:660","thumbnail":{"url":"http://sj_icenter.wp/images/easyblog_images/660/blog/b2ap3_thumbnail_easy1.png"},"icon":{"url":"http://sj_icenter.wp/images/easyblog_images/660/blog/b2ap3_thumbnail_easy1.png"},"name":"thumbnail","width":250,"height":291,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_easy1.png","mime":"image/png","filesize":"22.92 KB","url":"http://sj_icenter.wp/images/easyblog_images/660/blog/b2ap3_icon_easy1.png","dateCreated":"Thursday, 13 March 2014","dateModified":1394698342,"path":"\\\\blog\\\\b2ap3_icon_easy1.png","place":"user:660","thumbnail":{"url":"http://sj_icenter.wp/images/easyblog_images/660/blog/b2ap3_icon_easy1.png"},"icon":{"url":"http://sj_icenter.wp/images/easyblog_images/660/blog/b2ap3_icon_easy1.png"},"name":"icon","width":109,"height":128,"canDelete":false,"default":false},{"type":"image","title":"easy1.png","mime":"image/png","filesize":"88.31 KB","url":"http://sj_icenter.wp/images/easyblog_images/660/blog/easy1.png","dateCreated":"Thursday, 13 March 2014","dateModified":1394698341,"path":"\\\\blog\\\\easy1.png","place":"user:660","thumbnail":{"url":"http://sj_icenter.wp/images/easyblog_images/660/blog/b2ap3_thumbnail_easy1.png"},"icon":{"url":"http://sj_icenter.wp/images/easyblog_images/660/blog/b2ap3_icon_easy1.png"},"name":"original","width":250,"height":291,"canDelete":false,"default":false}],"thumbnail":{"url":"http://sj_icenter.wp/images/easyblog_images/660/blog/b2ap3_thumbnail_easy1.png"},"icon":{"url":"http://sj_icenter.wp/images/easyblog_images/660/blog/b2ap3_icon_easy1.png"},"key":"user:660|\\\\blog\\\\easy1.png","hash":"07539995762560048","group":"files","parentKey":"user:660|\\\\blog","friendlyPath":"My Media\\\\blog\\\\easy1.png"}', '', 1),
(3, 660, '2014-03-17 16:11:39', '2014-03-17 16:19:38', 'Pazen mase pika', 'pazen-mase-pika', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed vel dignissim urna. Maecenas a lectus eget nisi feugiat gravida vitae sit amet tortor. Vestibulum nec pharetra ipsum. Etiam feugiat tempor nisi pulvinar tincidunt. Phasellus tincidunt ultricies fermentum. Ut aliquet mi a porttitor sollicitudin. Phasellus fermentum nunc risus, ac interdum justo sollicitudin at. Nullam non dolor sagittis, eleifend orci quis, condimentum nisi. Cras eu nulla ac dui ullamcorper facilisis eu in nulla.</p>\r\n<p>Praesent ornare tristique est, in lacinia metus. Fusce dignissim in magna ac rhoncus. Duis aliquam, lectus vel sodales ultrices, nisi lorem euismod diam, non fermentum nulla lacus nec velit. Morbi ac lacus dolor. Etiam volutpat magna vitae ultricies elementum. Duis eget felis sit amet augue sagittis interdum. Quisque commodo eu lacus blandit facilisis. Integer eget purus quam. Maecenas magna felis, scelerisque vitae eros quis, volutpat aliquet justo. Donec bibendum, eros eget laoreet fermentum, sem leo tincidunt dolor, sed rhoncus purus massa a leo. Donec pulvinar tortor eu felis mollis, a venenatis nunc mollis.</p>\r\n<p>Morbi ut ullamcorper odio, vitae dictum libero. Mauris nec magna eget enim vehicula aliquet. Nam et accumsan justo. Fusce ac nisl ut nulla gravida vehicula nec id libero. Quisque consectetur justo vel risus tincidunt venenatis. Etiam fringilla metus tempus, porta purus sit amet, hendrerit est. Integer vel commodo metus. Ut vel tincidunt dui. Phasellus libero nunc, eleifend a bibendum sed, dapibus id est. Morbi malesuada gravida erat. In malesuada enim sit amet purus lobortis, in elementum nulla facilisis.</p>', NULL, 3, 1, '2014-03-17 16:11:39', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"c14.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/c14.jpg","dateCreated":"Monday, 17 March 2014","dateModified":1395073147,"path":"\\\\Sj_icenter\\\\c14.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_c14.jpg","mime":"image/jpeg","filesize":"8.7 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/b2ap3_thumbnail_c14.jpg","dateCreated":"Monday, 17 March 2014","dateModified":1395073147,"path":"\\\\Sj_icenter\\\\b2ap3_thumbnail_c14.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/b2ap3_thumbnail_c14.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/b2ap3_thumbnail_c14.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_c14.jpg","mime":"image/jpeg","filesize":"2.22 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/b2ap3_icon_c14.jpg","dateCreated":"Monday, 17 March 2014","dateModified":1395073147,"path":"\\\\Sj_icenter\\\\b2ap3_icon_c14.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/b2ap3_icon_c14.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/b2ap3_icon_c14.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"c14.jpg","mime":"image/jpeg","filesize":"151.98 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/c14.jpg","dateCreated":"Monday, 17 March 2014","dateModified":1395073147,"path":"\\\\Sj_icenter\\\\c14.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/b2ap3_thumbnail_c14.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/b2ap3_icon_c14.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/b2ap3_thumbnail_c14.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Sj_icenter/b2ap3_icon_c14.jpg"},"key":"user:660|\\\\Sj_icenter\\\\c14.jpg","hash":"033394610113464296","group":"files","parentKey":"user:660|\\\\Sj_icenter","friendlyPath":"My Media\\\\Sj_icenter\\\\c14.jpg"}', 'en-GB', 1),
(4, 660, '2014-03-19 00:41:23', '2014-03-19 00:44:34', 'Vivamus sed elit ut tortor', 'vivamus-sed-elit-ut-tortor', '', '<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare. Proin sollicitudin nisi quis erat commodo, ac aliquam nibh egestas.</p>\r\n<p>In eu lectus elementum, porttitor nisi id, scelerisque quam. Curabitur congue orci luctus quam sagittis, pulvinar mattis lacus auctor. Nam ac rutrum ante</p>', NULL, 3, 1, '2014-03-19 00:41:23', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo1.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo1.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395189816,"path":"\\\\blo1.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo1.jpg","mime":"image/jpeg","filesize":"9.41 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo1.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395189816,"path":"\\\\b2ap3_thumbnail_blo1.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo1.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo1.jpg","mime":"image/jpeg","filesize":"2.08 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo1.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395189816,"path":"\\\\b2ap3_icon_blo1.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo1.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo1.jpg","mime":"image/jpeg","filesize":"146.1 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo1.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395189816,"path":"\\\\blo1.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo1.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo1.jpg"},"key":"user:660|\\\\blo1.jpg","hash":"017659217305481434","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo1.jpg"}', '', 1),
(5, 660, '2014-03-19 00:44:42', '2014-03-19 00:45:48', 'Ganse mika lipon', 'ganse-mika-lipon', '', '<p>Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare. Proin sollicitudin nisi quis erat commodo, ac aliquam nibh egestas.</p>\r\n<p>In eu lectus elementum, porttitor nisi id, scelerisque quam. Curabitur congue orci luctus quam sagittis, pulvinar mattis lacus auctor. Nam ac rutrum ante. Fusce dui tortor, tempus id congue et, interdum ut ante. Praesent mi sapien, interdum sed imperdiet at, porta in mi. Nunc dignissim</p>', NULL, 3, 1, '2014-03-19 00:44:42', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"Bllo3.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Bllo3.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395189937,"path":"\\\\Bllo3.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_Bllo3.jpg","mime":"image/jpeg","filesize":"9.74 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Bllo3.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395189937,"path":"\\\\b2ap3_thumbnail_Bllo3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Bllo3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Bllo3.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_Bllo3.jpg","mime":"image/jpeg","filesize":"2.26 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Bllo3.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395189937,"path":"\\\\b2ap3_icon_Bllo3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Bllo3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Bllo3.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"Bllo3.jpg","mime":"image/jpeg","filesize":"156.14 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Bllo3.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395189937,"path":"\\\\Bllo3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Bllo3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Bllo3.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Bllo3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Bllo3.jpg"},"key":"user:660|\\\\Bllo3.jpg","hash":"020485526509582996","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\Bllo3.jpg"}', '', 1),
(6, 660, '2014-03-19 00:45:49', '2014-03-19 00:47:02', 'Sika lima nure', 'sika-lima-nure', '', '<p>Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare. Proin sollicitudin nisi quis erat commodo, ac aliquam nibh egestas.</p>\r\n<p>In eu lectus elementum, porttitor nisi id, scelerisque quam. Curabitur congue orci luctus quam sagittis, pulvinar mattis lacus auctor. Nam ac rutrum ante. Fusce dui tortor, tempus id congue et, interdum ut ante. Praesent mi sapien, interdum sed imperdiet at, porta in mi. Nunc dignissim, nibh non ullamcorper semper, sapien nisl ultrices sem, in ornare felis neque ac mauris</p>', NULL, 3, 1, '2014-03-19 00:45:49', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo2.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo2.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190014,"path":"\\\\blo2.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo2.jpg","mime":"image/jpeg","filesize":"16.41 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo2.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190014,"path":"\\\\b2ap3_thumbnail_blo2.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo2.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo2.jpg","mime":"image/jpeg","filesize":"3.4 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo2.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190014,"path":"\\\\b2ap3_icon_blo2.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo2.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo2.jpg","mime":"image/jpeg","filesize":"212.29 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo2.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190014,"path":"\\\\blo2.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo2.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo2.jpg"},"key":"user:660|\\\\blo2.jpg","hash":"09556042912881821","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo2.jpg"}', '', 1),
(7, 660, '2014-03-19 00:47:03', '2014-03-19 00:48:21', 'Seka kima nuren', 'seka-kima-nuren', '', '<p>Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare. Proin sollicitudin nisi quis erat commodo, ac aliquam nibh egestas.</p>', NULL, 3, 1, '2014-03-19 00:47:03', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo3.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo3.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190078,"path":"\\\\blo3.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo3.jpg","mime":"image/jpeg","filesize":"15.26 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo3.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190078,"path":"\\\\b2ap3_thumbnail_blo3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo3.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo3.jpg","mime":"image/jpeg","filesize":"2.95 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo3.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190078,"path":"\\\\b2ap3_icon_blo3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo3.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo3.jpg","mime":"image/jpeg","filesize":"268.03 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo3.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190078,"path":"\\\\blo3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo3.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo3.jpg"},"key":"user:660|\\\\blo3.jpg","hash":"010398464766331017","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo3.jpg"}', '', 1),
(8, 660, '2014-03-19 00:48:22', '2014-03-19 00:49:52', 'Buren mase jites', 'buren-mase-jites', '', '<p>Sed semper aliquam quam sit amet aliquet. Cras at laoreet tortor, id viverra nibh. Etiam aliquam mattis purus non posuere. Integer et tellus feugiat, pellentesque sapien id, laoreet eros. In gravida sapien in sem pulvinar, quis dictum sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>', NULL, 3, 1, '2014-03-19 00:48:22', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo4.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo4.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190184,"path":"\\\\blo4.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo4.jpg","mime":"image/jpeg","filesize":"11.33 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo4.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190184,"path":"\\\\b2ap3_thumbnail_blo4.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo4.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo4.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo4.jpg","mime":"image/jpeg","filesize":"2.44 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo4.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190184,"path":"\\\\b2ap3_icon_blo4.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo4.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo4.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo4.jpg","mime":"image/jpeg","filesize":"159.06 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo4.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190184,"path":"\\\\blo4.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo4.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo4.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo4.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo4.jpg"},"key":"user:660|\\\\blo4.jpg","hash":"035749397124163806","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo4.jpg"}', '', 1),
(9, 660, '2014-03-19 00:49:53', '2014-03-19 00:51:39', 'Mire mase loten', 'mire-mase-loten', '', '<p>Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare. Proin sollicitudin nisi quis erat commodo, ac aliquam nibh egestas.</p>\r\n<p>In eu lectus elementum, porttitor nisi id, scelerisque quam. Curabitur congue orci luctus quam sagittis, pulvinar mattis lacus auctor. Nam ac rutrum ante. Fusce dui tortor, tempus id congue et, interdum ut ante. Praesent mi sapien, interdum sed imperdiet at, porta in mi. Nunc dignissim</p>', NULL, 3, 1, '2014-03-19 00:49:53', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"Blo5.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo5.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190287,"path":"\\\\Blo5.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_Blo5.jpg","mime":"image/jpeg","filesize":"12.53 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo5.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190287,"path":"\\\\b2ap3_thumbnail_Blo5.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo5.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo5.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_Blo5.jpg","mime":"image/jpeg","filesize":"2.71 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo5.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190287,"path":"\\\\b2ap3_icon_Blo5.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo5.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo5.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"Blo5.jpg","mime":"image/jpeg","filesize":"158.02 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo5.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190287,"path":"\\\\Blo5.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo5.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo5.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo5.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo5.jpg"},"key":"user:660|\\\\Blo5.jpg","hash":"09975812898483127","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\Blo5.jpg"}', '', 1),
(10, 660, '2014-03-19 00:51:40', '2014-03-19 00:53:13', 'Proin sollicitudin nisi quis', 'proin-sollicitudin-nisi-quis', '', '<p>Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare. Proin sollicitudin nisi quis erat commodo, ac aliquam nibh egestas.</p>\r\n<p>In eu lectus elementum, porttitor nisi id, scelerisque quam. Curabitur congue orci luctus quam sagittis, pulvinar mattis lacus auctor. Nam ac rutrum ante. Fusce dui tortor, tempus id congue et, interdum ut ante. Praesent mi sapien, interdum sed imperdiet at, porta in mi. Nunc dignissim, nibh non ullamcorper semper, sapien nisl ultrices sem, in ornare felis neque ac mauris. Sed ornare augue quis libero scelerisque bibendum. Mauris faucibus enim urna, rhoncus scelerisque purus convallis placerat. Quisque congue eros ut est luctus, vitae consectetur nisi laoreet.</p>', NULL, 3, 1, '2014-03-19 00:51:40', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"Blo6.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo6.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190367,"path":"\\\\Blo6.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_Blo6.jpg","mime":"image/jpeg","filesize":"11.6 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo6.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190368,"path":"\\\\b2ap3_thumbnail_Blo6.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo6.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo6.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_Blo6.jpg","mime":"image/jpeg","filesize":"2.52 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo6.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190368,"path":"\\\\b2ap3_icon_Blo6.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo6.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo6.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"Blo6.jpg","mime":"image/jpeg","filesize":"147.41 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo6.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190367,"path":"\\\\Blo6.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo6.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo6.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo6.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo6.jpg"},"key":"user:660|\\\\Blo6.jpg","hash":"08361865172628313","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\Blo6.jpg"}', '', 1),
(11, 660, '2014-03-19 00:53:14', '2014-03-19 00:54:49', 'Mauris pulvinar pellentesque', 'mauris-pulvinar-pellentesque', '', '<p>Etiam aliquam mattis purus non posuere. Integer et tellus feugiat, pellentesque sapien id, laoreet eros. In gravida sapien in sem pulvinar, quis dictum sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare. Proin sollicitudin nisi quis erat commodo, ac aliquam nibh egestas.</p>', NULL, 3, 1, '2014-03-19 00:53:14', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo7.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo7.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190481,"path":"\\\\blo7.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo7.jpg","mime":"image/jpeg","filesize":"14.23 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo7.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190481,"path":"\\\\b2ap3_thumbnail_blo7.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo7.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo7.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo7.jpg","mime":"image/jpeg","filesize":"2.88 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo7.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190481,"path":"\\\\b2ap3_icon_blo7.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo7.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo7.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo7.jpg","mime":"image/jpeg","filesize":"174.22 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo7.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190481,"path":"\\\\blo7.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo7.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo7.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo7.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo7.jpg"},"key":"user:660|\\\\blo7.jpg","hash":"03854188115801662","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo7.jpg"}', '', 1);
INSERT INTO `#__easyblog_post` (`id`, `created_by`, `created`, `modified`, `title`, `permalink`, `content`, `intro`, `excerpt`, `category_id`, `published`, `publish_up`, `publish_down`, `ordering`, `vote`, `hits`, `private`, `allowcomment`, `subscription`, `frontpage`, `isnew`, `ispending`, `issitewide`, `blogpassword`, `latitude`, `longitude`, `address`, `system`, `source`, `robots`, `copyrights`, `image`, `language`, `send_notification_emails`) VALUES
(12, 660, '2014-03-19 00:54:50', '2014-03-19 00:55:47', 'Zuna maten pozan', 'zuna-maten-pozan', '', '<p>Integer et tellus feugiat, pellentesque sapien id, laoreet eros. In gravida sapien in sem pulvinar, quis dictum sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue</p>', NULL, 3, 1, '2014-03-19 00:54:50', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo8.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo8.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190540,"path":"\\\\blo8.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo8.jpg","mime":"image/jpeg","filesize":"9.53 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo8.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190540,"path":"\\\\b2ap3_thumbnail_blo8.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo8.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo8.jpg","mime":"image/jpeg","filesize":"2.2 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo8.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190540,"path":"\\\\b2ap3_icon_blo8.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo8.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo8.jpg","mime":"image/jpeg","filesize":"138.92 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo8.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190540,"path":"\\\\blo8.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo8.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo8.jpg"},"key":"user:660|\\\\blo8.jpg","hash":"07236019857227802","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo8.jpg"}', '', 1),
(13, 660, '2014-03-19 00:55:48', '2014-03-19 00:57:39', 'Tuson mazo liten', 'tuson-mazo-liten', '', '<p>Sed semper aliquam quam sit amet aliquet. Cras at laoreet tortor, id viverra nibh. Etiam aliquam mattis purus non posuere. Integer et tellus feugiat, pellentesque sapien id, laoreet eros. In gravida sapien in sem pulvinar, quis dictum sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>', NULL, 4, 1, '2014-03-19 00:55:48', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo9.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo9.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190646,"path":"\\\\blo9.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo9.jpg","mime":"image/jpeg","filesize":"17.48 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo9.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190646,"path":"\\\\b2ap3_thumbnail_blo9.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo9.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo9.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo9.jpg","mime":"image/jpeg","filesize":"3.62 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo9.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190646,"path":"\\\\b2ap3_icon_blo9.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo9.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo9.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo9.jpg","mime":"image/jpeg","filesize":"230.15 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo9.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190646,"path":"\\\\blo9.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo9.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo9.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo9.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo9.jpg"},"key":"user:660|\\\\blo9.jpg","hash":"05841110532637686","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo9.jpg"}', '', 1),
(14, 660, '2014-03-19 00:57:40', '2014-03-19 00:58:49', 'Jase duma loten', 'jase-duma-loten', '', '<p>Cras at laoreet tortor, id viverra nibh. Etiam aliquam mattis purus non posuere. Integer et tellus feugiat, pellentesque sapien id, laoreet eros. In gravida sapien in sem pulvinar, quis dictum sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue</p>', NULL, 4, 1, '2014-03-19 00:57:40', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo10.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo10.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190722,"path":"\\\\blo10.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo10.jpg","mime":"image/jpeg","filesize":"16.24 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo10.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190722,"path":"\\\\b2ap3_thumbnail_blo10.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo10.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo10.jpg","mime":"image/jpeg","filesize":"3.24 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo10.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190722,"path":"\\\\b2ap3_icon_blo10.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo10.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo10.jpg","mime":"image/jpeg","filesize":"216.04 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo10.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190722,"path":"\\\\blo10.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo10.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo10.jpg"},"key":"user:660|\\\\blo10.jpg","hash":"07918201694265008","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo10.jpg"}', '', 1),
(15, 660, '2014-03-19 00:58:50', '2014-03-19 01:01:18', 'Posen makin late', 'posen-makin-late', '', '<p>Gravida sapien in sem pulvinar, quis dictum sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare. Proin sollicitudin nisi quis erat commodo, ac aliquam nibh egestas.</p>', NULL, 4, 1, '2014-03-19 00:58:50', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"Blo11.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo11.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190872,"path":"\\\\Blo11.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_Blo11.jpg","mime":"image/jpeg","filesize":"12.76 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo11.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190872,"path":"\\\\b2ap3_thumbnail_Blo11.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo11.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo11.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_Blo11.jpg","mime":"image/jpeg","filesize":"2.68 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo11.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190872,"path":"\\\\b2ap3_icon_Blo11.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo11.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo11.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"Blo11.jpg","mime":"image/jpeg","filesize":"156.35 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo11.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190872,"path":"\\\\Blo11.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo11.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo11.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo11.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo11.jpg"},"key":"user:660|\\\\Blo11.jpg","hash":"031033544428646564","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\Blo11.jpg"}', '', 1),
(16, 660, '2014-03-19 01:01:19', '2014-03-19 01:02:26', 'Jise rika maonza', 'jise-rika-maonza', '', '<p>Pazon id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac.&nbsp;</p>', NULL, 4, 1, '2014-03-19 01:01:19', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"Blo12.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo12.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190940,"path":"\\\\Blo12.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_Blo12.jpg","mime":"image/jpeg","filesize":"12.87 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo12.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190940,"path":"\\\\b2ap3_thumbnail_Blo12.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo12.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo12.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_Blo12.jpg","mime":"image/jpeg","filesize":"3.17 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo12.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190940,"path":"\\\\b2ap3_icon_Blo12.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo12.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo12.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"Blo12.jpg","mime":"image/jpeg","filesize":"177.96 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo12.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395190940,"path":"\\\\Blo12.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo12.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo12.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo12.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo12.jpg"},"key":"user:660|\\\\Blo12.jpg","hash":"06645305540878326","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\Blo12.jpg"}', '', 1),
(17, 660, '2014-03-19 01:02:27', '2014-03-19 01:03:45', 'Kosan mapi katen', 'kosan-mapi-katen', '', '<p>Dimentum rhoncus felis, consectetur commodo nisl. Sed semper aliquam quam sit amet aliquet. Cras at laoreet tortor, id viverra nibh. Etiam aliquam mattis purus non posuere. Integer et tellus feugiat, pellentesque sapien id, laoreet eros. In gravida sapien in sem pulvinar, quis dictum sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac</p>', NULL, 4, 1, '2014-03-19 01:02:27', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"Blo13.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo13.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191020,"path":"\\\\Blo13.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_Blo13.jpg","mime":"image/jpeg","filesize":"14.97 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo13.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191021,"path":"\\\\b2ap3_thumbnail_Blo13.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo13.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo13.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_Blo13.jpg","mime":"image/jpeg","filesize":"3.13 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo13.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191021,"path":"\\\\b2ap3_icon_Blo13.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo13.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo13.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"Blo13.jpg","mime":"image/jpeg","filesize":"183.76 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo13.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191020,"path":"\\\\Blo13.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo13.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo13.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo13.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo13.jpg"},"key":"user:660|\\\\Blo13.jpg","hash":"07979638003744185","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\Blo13.jpg"}', '', 1),
(18, 660, '2014-03-19 01:03:46', '2014-03-19 01:05:18', 'Koma sikan lite', 'koma-sikan-lite', '', '<p>Blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue.</p>', NULL, 4, 1, '2014-03-19 01:03:46', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"Blo14.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo14.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191104,"path":"\\\\Blo14.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_Blo14.jpg","mime":"image/jpeg","filesize":"16.37 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo14.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191104,"path":"\\\\b2ap3_thumbnail_Blo14.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo14.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo14.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_Blo14.jpg","mime":"image/jpeg","filesize":"3.07 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo14.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191104,"path":"\\\\b2ap3_icon_Blo14.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo14.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo14.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"Blo14.jpg","mime":"image/jpeg","filesize":"108.69 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blo14.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191104,"path":"\\\\Blo14.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo14.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo14.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blo14.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blo14.jpg"},"key":"user:660|\\\\Blo14.jpg","hash":"07592660037335008","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\Blo14.jpg"}', '', 1),
(19, 660, '2014-03-19 01:05:19', '2014-03-19 01:07:06', 'Chuken mazen dima', 'chuken-mazen-dima', '', '<p>Cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare</p>', NULL, 4, 1, '2014-03-19 01:05:19', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo15.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo15.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191220,"path":"\\\\blo15.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo15.jpg","mime":"image/jpeg","filesize":"14.85 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo15.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191221,"path":"\\\\b2ap3_thumbnail_blo15.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo15.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo15.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo15.jpg","mime":"image/jpeg","filesize":"3 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo15.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191221,"path":"\\\\b2ap3_icon_blo15.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo15.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo15.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo15.jpg","mime":"image/jpeg","filesize":"214.34 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo15.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191220,"path":"\\\\blo15.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo15.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo15.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo15.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo15.jpg"},"key":"user:660|\\\\blo15.jpg","hash":"02232570385094732","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo15.jpg"}', '', 1),
(20, 660, '2014-03-19 01:07:07', '2014-03-19 01:08:45', 'Kizab mapon katen', 'kizab-mapon-katen', '', '<p>Pulvinar, quis dictum sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue</p>', NULL, 4, 1, '2014-03-19 01:07:07', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo16.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo16.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191319,"path":"\\\\blo16.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo16.jpg","mime":"image/jpeg","filesize":"15.55 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo16.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191319,"path":"\\\\b2ap3_thumbnail_blo16.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo16.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo16.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo16.jpg","mime":"image/jpeg","filesize":"3.24 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo16.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191319,"path":"\\\\b2ap3_icon_blo16.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo16.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo16.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo16.jpg","mime":"image/jpeg","filesize":"256.1 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo16.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191319,"path":"\\\\blo16.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo16.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo16.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo16.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo16.jpg"},"key":"user:660|\\\\blo16.jpg","hash":"00612086346372962","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo16.jpg"}', '', 1),
(21, 660, '2014-03-19 01:08:46', '2014-03-19 01:11:39', 'Nipon kite rima', 'nipon-kite-rima', '', '<p>Tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare.&nbsp;</p>', NULL, 4, 1, '2014-03-19 01:08:46', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blog11.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blog11.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191487,"path":"\\\\blog11.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blog11.jpg","mime":"image/jpeg","filesize":"12.92 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blog11.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191487,"path":"\\\\b2ap3_thumbnail_blog11.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blog11.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blog11.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blog11.jpg","mime":"image/jpeg","filesize":"2.95 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blog11.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191487,"path":"\\\\b2ap3_icon_blog11.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blog11.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blog11.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blog11.jpg","mime":"image/jpeg","filesize":"190.83 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blog11.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191487,"path":"\\\\blog11.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blog11.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blog11.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blog11.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blog11.jpg"},"key":"user:660|\\\\blog11.jpg","hash":"003918054257519543","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blog11.jpg"}', '', 1);
INSERT INTO `#__easyblog_post` (`id`, `created_by`, `created`, `modified`, `title`, `permalink`, `content`, `intro`, `excerpt`, `category_id`, `published`, `publish_up`, `publish_down`, `ordering`, `vote`, `hits`, `private`, `allowcomment`, `subscription`, `frontpage`, `isnew`, `ispending`, `issitewide`, `blogpassword`, `latitude`, `longitude`, `address`, `system`, `source`, `robots`, `copyrights`, `image`, `language`, `send_notification_emails`) VALUES
(22, 660, '2014-03-19 01:11:40', '2014-03-19 01:13:41', 'Bize dukam mazim', 'bize-dukam-mazim', '', '<p>Kauris id ullamcorper dui. Fusce porttitor mauris sed varius semper. Phasellus condimentum rhoncus felis, consectetur commodo nisl. Sed semper aliquam quam sit amet aliquet. Cras at laoreet tortor, id viverra nibh. Etiam aliquam mattis purus non posuere. Integer et tellus feugiat, pellentesque sapien id, laoreet eros. In gravida sapien in sem pulvinar, quis dictum sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac</p>', NULL, 4, 1, '2014-03-19 01:11:40', '0000-00-00 00:00:00', 0, 0, 2, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"Blog17.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blog17.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191612,"path":"\\\\Blog17.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_Blog17.jpg","mime":"image/jpeg","filesize":"11.93 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blog17.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191612,"path":"\\\\b2ap3_thumbnail_Blog17.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blog17.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blog17.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_Blog17.jpg","mime":"image/jpeg","filesize":"2.68 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blog17.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191612,"path":"\\\\b2ap3_icon_Blog17.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blog17.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blog17.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"Blog17.jpg","mime":"image/jpeg","filesize":"162.77 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blog17.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191612,"path":"\\\\Blog17.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blog17.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blog17.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blog17.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blog17.jpg"},"key":"user:660|\\\\Blog17.jpg","hash":"02882190791424364","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\Blog17.jpg"}', '', 1),
(23, 660, '2014-03-19 01:13:43', '2014-03-19 01:14:56', 'Fisen mazon pokan', 'fisen-mazon-pokan', '', '<p>Sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue</p>', NULL, 5, 1, '2014-03-19 01:13:43', '0000-00-00 00:00:00', 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"Blog18.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blog18.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191688,"path":"\\\\Blog18.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_Blog18.jpg","mime":"image/jpeg","filesize":"18.4 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blog18.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191688,"path":"\\\\b2ap3_thumbnail_Blog18.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blog18.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blog18.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_Blog18.jpg","mime":"image/jpeg","filesize":"3.84 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blog18.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191688,"path":"\\\\b2ap3_icon_Blog18.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blog18.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blog18.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"Blog18.jpg","mime":"image/jpeg","filesize":"237.58 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/Blog18.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395191688,"path":"\\\\Blog18.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blog18.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blog18.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_Blog18.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_Blog18.jpg"},"key":"user:660|\\\\Blog18.jpg","hash":"05420529474504292","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\Blog18.jpg"}', '', 1),
(24, 660, '2014-03-19 01:19:25', '2014-03-19 01:20:51', 'Koren pizan suka', 'koren-pizan-suka', '', '<p>Pizan aliquam quam sit amet aliquet. Cras at laoreet tortor, id viverra nibh. Etiam aliquam mattis purus non posuere. Integer et tellus feugiat, pellentesque sapien id, laoreet eros. In gravida sapien in sem pulvinar, quis dictum sapien imperdiet. Curabitur cursus blandit risus, ut tincidunt tortor pulvinar vel. Sed sed varius quam, a dictum leo. Quisque id sollicitudin lorem. Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus</p>', NULL, 5, 1, '2014-03-19 01:19:25', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"c31.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/c31.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192043,"path":"\\\\c31.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_c31.jpg","mime":"image/jpeg","filesize":"11.9 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_c31.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192044,"path":"\\\\b2ap3_thumbnail_c31.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_c31.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_c31.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_c31.jpg","mime":"image/jpeg","filesize":"2.66 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_c31.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192044,"path":"\\\\b2ap3_icon_c31.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_c31.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_c31.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"c31.jpg","mime":"image/jpeg","filesize":"222.56 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/c31.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192043,"path":"\\\\c31.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_c31.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_c31.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_c31.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_c31.jpg"},"key":"user:660|\\\\c31.jpg","hash":"07426269939169288","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\c31.jpg"}', '', 1),
(25, 660, '2014-03-19 01:20:52', '2014-03-19 01:23:17', 'Chiren mapon makin', 'chiren-mapon-makin', '', '<p>Dosuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue. Aliquam tincidunt urna id sagittis ornare. Proin sollicitudin nisi quis erat commodo, ac aliquam nibh egestas.</p>\r\n<p>In eu lectus elementum, porttitor nisi id, scelerisque quam. Curabitur congue orci luctus quam sagittis, pulvinar mattis lacus auctor. Nam ac rutrum ante. Fusce dui tortor, tempus id congue et, interdum ut ante. Praesent mi sapien, interdum sed imperdiet at, porta in mi. Nunc dignissim, nibh non ullamcorper semper, sapien nisl ultrices sem, in ornare felis neque ac mauris</p>', NULL, 5, 1, '2014-03-19 01:20:52', '0000-00-00 00:00:00', 0, 0, 2, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"c32.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/c32.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192188,"path":"\\\\c32.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_c32.jpg","mime":"image/jpeg","filesize":"16.46 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_c32.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192188,"path":"\\\\b2ap3_thumbnail_c32.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_c32.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_c32.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_c32.jpg","mime":"image/jpeg","filesize":"3.19 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_c32.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192189,"path":"\\\\b2ap3_icon_c32.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_c32.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_c32.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"c32.jpg","mime":"image/jpeg","filesize":"261.55 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/c32.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192188,"path":"\\\\c32.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_c32.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_c32.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_c32.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_c32.jpg"},"key":"user:660|\\\\c32.jpg","hash":"005816562497057021","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\c32.jpg"}', '', 1),
(26, 660, '2014-03-19 01:25:27', '2014-03-19 01:26:27', 'Gizan suma kiten', 'gizan-suma-kiten', '', '<p>Morbi dapibus tortor non lacus porta, a aliquet dui ullamcorper. Nunc rutrum elit urna, ac porttitor dolor suscipit nec. Vestibulum euismod, ante eu mattis lobortis, ante tellus fermentum dolor, ut laoreet purus nisl vitae tellus. Etiam id sapien aliquet, semper felis accumsan, porta ipsum. Nam condimentum ante eget vulputate elementum.</p>\r\n<p>Fusce adipiscing risus eget mi varius venenatis. Sed id metus hendrerit neque auctor rutrum. Mauris pulvinar pellentesque leo at semper. Cras convallis convallis risus malesuada mattis. Nam quam massa, tristique sit amet volutpat vel, mattis nec massa. Maecenas in posuere mauris, eu pulvinar felis. Vivamus sed elit ut tortor feugiat posuere. Etiam eget orci ut sem pharetra ultricies vel sollicitudin tortor. Suspendisse scelerisque euismod augue, non interdum velit vehicula sed. Sed interdum libero leo, vitae vestibulum mi fringilla quis.</p>\r\n<p>Aliquam interdum sem neque, ac vulputate nibh elementum ac. Vivamus in enim et sapien venenatis euismod. Quisque vitae mattis ipsum. Aenean molestie molestie volutpat. Cras tempor ipsum nec augue rhoncus convallis. Nam feugiat viverra pellentesque. Integer dignissim tempus lacus, et varius arcu lacinia placerat. Sed sit amet metus vitae enim adipiscing vulputate. Nulla facilisi.</p>\r\n<p>Aenean a malesuada enim, ut eleifend sem. Mauris velit metus, facilisis ullamcorper laoreet vel, cursus vitae velit. Maecenas rutrum ligula enim, et interdum tortor mollis ac. Morbi auctor nunc feugiat ligula ultricies, sed fringilla mi ullamcorper. Vivamus posuere pharetra augue.</p>', NULL, 1, 1, '2014-03-19 01:25:27', '0000-00-00 00:00:00', 0, 0, 69, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo19.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo19.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192379,"path":"\\\\blo19.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_blo19.jpg","mime":"image/jpeg","filesize":"10.9 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo19.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192380,"path":"\\\\b2ap3_thumbnail_blo19.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo19.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo19.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_blo19.jpg","mime":"image/jpeg","filesize":"2.54 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo19.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192380,"path":"\\\\b2ap3_icon_blo19.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo19.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo19.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"blo19.jpg","mime":"image/jpeg","filesize":"197.46 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/blo19.jpg","dateCreated":"Wednesday, 19 March 2014","dateModified":1395192379,"path":"\\\\blo19.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo19.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo19.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo19.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo19.jpg"},"key":"user:660|\\\\blo19.jpg","hash":"004489623405970633","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo19.jpg"}', '', 1),
(27, 660, '2014-03-20 00:43:55', '2014-03-20 00:45:34', 'Haxe duna pozan', 'haxe-duna-pozan', '', '<p>Aliquam sit amet lectus libero. Aliquam magna tortor, porttitor a arcu quis, congue sollicitudin nisl. Nam eu orci a velit viverra posuere. Quisque ante eros, suscipit in sodales non, malesuada in mi. In in sem vel nunc tempus ultricies. Sed ac viverra purus. Maecenas in mauris dapibus mauris rhoncus dictum. Maecenas quis ipsum augue. Nunc sed felis libero.</p>\r\n<p>In id elit nibh. Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>', NULL, 6, 1, '2014-03-20 00:43:55', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"d1.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d1.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276317,"path":"\\\\d1.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_d1.jpg","mime":"image/jpeg","filesize":"12.62 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d1.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276317,"path":"\\\\b2ap3_thumbnail_d1.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d1.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_d1.jpg","mime":"image/jpeg","filesize":"2.27 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d1.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276317,"path":"\\\\b2ap3_icon_d1.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d1.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"d1.jpg","mime":"image/jpeg","filesize":"285.59 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d1.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276317,"path":"\\\\d1.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d1.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d1.jpg"},"key":"user:660|\\\\d1.jpg","hash":"09576567101757973","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\d1.jpg"}', '', 1),
(28, 660, '2014-03-20 00:45:44', '2014-03-20 00:46:57', 'Vestibulum luctus erat leo', 'vestibulum-luctus-erat-leo', '', '<p>Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>\r\n<p>Sed malesuada volutpat diam quis faucibus. Aliquam ultricies placerat dolor, et aliquam magna dictum eu. Integer volutpat posuere tortor non interdum. Integer non mi eros. Integer posuere quam turpis, a condimentum nisl posuere id. Integer feugiat dui id nisi eleifend ultricies. Suspendisse vehicula sapien sollicitudin venenatis hendrerit. Fusce id rutrum leo. Donec malesuada arcu nec sem varius, quis venenatis quam dictum.</p>', NULL, 6, 1, '2014-03-20 00:45:44', '0000-00-00 00:00:00', 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"d2.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d2.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276405,"path":"\\\\d2.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_d2.jpg","mime":"image/jpeg","filesize":"18.86 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d2.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276405,"path":"\\\\b2ap3_thumbnail_d2.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d2.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_d2.jpg","mime":"image/jpeg","filesize":"3.42 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d2.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276405,"path":"\\\\b2ap3_icon_d2.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d2.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"d2.jpg","mime":"image/jpeg","filesize":"298.37 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d2.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276405,"path":"\\\\d2.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d2.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d2.jpg"},"key":"user:660|\\\\d2.jpg","hash":"08643928768578917","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\d2.jpg"}', '', 1),
(29, 660, '2014-03-20 00:45:44', '2014-03-20 00:48:10', 'Kiren poka litem', 'vestibulum-luctus-erat-leo-1', '', '<p>Kerun egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>\r\n<p>Sed malesuada volutpat diam quis faucibus. Aliquam ultricies placerat dolor, et aliquam magna dictum eu. Integer volutpat posuere tortor non interdum. Integer non mi eros. Integer posuere quam turpis, a condimentum nisl posuere id. Integer feugiat dui id nisi eleifend ultricies. Suspendisse vehicula sapien sollicitudin venenatis hendrerit. Fusce id rutrum leo. Donec malesuada arcu nec sem varius, quis venenatis quam dictum.</p>', NULL, 6, 1, '2014-03-20 00:45:44', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"d3.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d3.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276463,"path":"\\\\d3.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_d3.jpg","mime":"image/jpeg","filesize":"20.93 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d3.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276463,"path":"\\\\b2ap3_thumbnail_d3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d3.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_d3.jpg","mime":"image/jpeg","filesize":"3.57 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d3.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276463,"path":"\\\\b2ap3_icon_d3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d3.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"d3.jpg","mime":"image/jpeg","filesize":"330.05 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d3.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276463,"path":"\\\\d3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d3.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d3.jpg"},"key":"user:660|\\\\d3.jpg","hash":"06863048549275845","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\d3.jpg"}', '', 1),
(30, 660, '2014-03-20 00:48:16', '2014-03-20 00:49:16', 'Hure capin katen', 'hure-capin-katen', '', '<p>&nbsp;Vestibulum luctus erat leo. Nullam aliquam ultrices massa eu eleifend. Nullam id enim vel nisi malesuada ornare non in risus. Aliquam sit amet lectus libero. Aliquam magna tortor, porttitor a arcu quis, congue sollicitudin nisl. Nam eu orci a velit viverra posuere. Quisque ante eros, suscipit in sodales non, malesuada in mi. In in sem vel nunc tempus ultricies. Sed ac viverra purus. Maecenas in mauris dapibus mauris rhoncus dictum. Maecenas quis ipsum augue. Nunc sed felis libero.</p>\r\n<p>In id elit nibh. Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>', NULL, 6, 1, '2014-03-20 00:48:16', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"d4.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d4.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276550,"path":"\\\\d4.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_d4.jpg","mime":"image/jpeg","filesize":"12.18 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d4.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276550,"path":"\\\\b2ap3_thumbnail_d4.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d4.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d4.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_d4.jpg","mime":"image/jpeg","filesize":"2.49 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d4.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276550,"path":"\\\\b2ap3_icon_d4.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d4.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d4.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"d4.jpg","mime":"image/jpeg","filesize":"270.23 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d4.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276550,"path":"\\\\d4.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d4.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d4.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d4.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d4.jpg"},"key":"user:660|\\\\d4.jpg","hash":"07654597072396427","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\d4.jpg"}', '', 1),
(31, 660, '2014-03-20 00:49:26', '2014-03-20 00:50:31', 'Jucas rupin karum', 'jucas-rupin-karum', '', '<p>Aliquam sit amet lectus libero. Aliquam magna tortor, porttitor a arcu quis, congue sollicitudin nisl. Nam eu orci a velit viverra posuere. Quisque ante eros, suscipit in sodales non, malesuada in mi. In in sem vel nunc tempus ultricies. Sed ac viverra purus. Maecenas in mauris dapibus mauris rhoncus dictum. Maecenas quis ipsum augue. Nunc sed felis libero.</p>\r\n<p>In id elit nibh. Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>', NULL, 6, 1, '2014-03-20 00:49:26', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"d5.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d5.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276624,"path":"\\\\d5.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_d5.jpg","mime":"image/jpeg","filesize":"18.72 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d5.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276624,"path":"\\\\b2ap3_thumbnail_d5.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d5.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d5.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_d5.jpg","mime":"image/jpeg","filesize":"2.82 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d5.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276624,"path":"\\\\b2ap3_icon_d5.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d5.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d5.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"d5.jpg","mime":"image/jpeg","filesize":"318.77 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d5.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276624,"path":"\\\\d5.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d5.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d5.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d5.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d5.jpg"},"key":"user:660|\\\\d5.jpg","hash":"05278268142137676","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\d5.jpg"}', '', 1);
INSERT INTO `#__easyblog_post` (`id`, `created_by`, `created`, `modified`, `title`, `permalink`, `content`, `intro`, `excerpt`, `category_id`, `published`, `publish_up`, `publish_down`, `ordering`, `vote`, `hits`, `private`, `allowcomment`, `subscription`, `frontpage`, `isnew`, `ispending`, `issitewide`, `blogpassword`, `latitude`, `longitude`, `address`, `system`, `source`, `robots`, `copyrights`, `image`, `language`, `send_notification_emails`) VALUES
(32, 660, '2014-03-20 00:50:37', '2014-03-20 00:51:38', 'Vurom nuca loten', 'vurom-nuca-loten', '', '<p>Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>\r\n<p>Sed malesuada volutpat diam quis faucibus. Aliquam ultricies placerat dolor, et aliquam magna dictum eu. Integer volutpat posuere tortor non interdum. Integer non mi eros. Integer posuere quam turpis, a condimentum nisl posuere id. Integer feugiat dui id nisi eleifend ultricies. Suspendisse vehicula sapien sollicitudin venenatis hendrerit. Fusce id rutrum leo. Donec malesuada arcu nec sem varius</p>', NULL, 6, 1, '2014-03-20 00:50:37', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"d6.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d6.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276692,"path":"\\\\d6.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_d6.jpg","mime":"image/jpeg","filesize":"12.62 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d6.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276692,"path":"\\\\b2ap3_thumbnail_d6.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d6.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d6.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_d6.jpg","mime":"image/jpeg","filesize":"2.52 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d6.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276692,"path":"\\\\b2ap3_icon_d6.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d6.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d6.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"d6.jpg","mime":"image/jpeg","filesize":"232.56 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d6.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276692,"path":"\\\\d6.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d6.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d6.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d6.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d6.jpg"},"key":"user:660|\\\\d6.jpg","hash":"07216434094589204","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\d6.jpg"}', '', 1),
(33, 660, '2014-03-20 00:51:46', '2014-03-20 00:52:43', 'Wacer tina puka', 'wacer-tina-puka', '', '<p>Praesent in est dictum, viverra nunc vitae, feugiat risus. Vestibulum luctus erat leo. Nullam aliquam ultrices massa eu eleifend. Nullam id enim vel nisi malesuada ornare non in risus. Aliquam sit amet lectus libero. Aliquam magna tortor, porttitor a arcu quis, congue sollicitudin nisl. Nam eu orci a velit viverra posuere. Quisque ante eros, suscipit in sodales non, malesuada in mi. In in sem vel nunc tempus ultricies. Sed ac viverra purus. Maecenas in mauris dapibus mauris rhoncus dictum. Maecenas quis ipsum augue. Nunc sed felis libero.</p>\r\n<p>In id elit nibh. Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>', NULL, 6, 1, '2014-03-20 00:51:46', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"d7.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d7.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276756,"path":"\\\\d7.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_d7.jpg","mime":"image/jpeg","filesize":"12.81 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d7.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276756,"path":"\\\\b2ap3_thumbnail_d7.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d7.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d7.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_d7.jpg","mime":"image/jpeg","filesize":"2.61 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d7.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276756,"path":"\\\\b2ap3_icon_d7.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d7.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d7.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"d7.jpg","mime":"image/jpeg","filesize":"225.79 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d7.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276756,"path":"\\\\d7.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d7.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d7.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d7.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d7.jpg"},"key":"user:660|\\\\d7.jpg","hash":"07322195095475763","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\d7.jpg"}', '', 1),
(34, 660, '2014-03-20 00:52:51', '2014-03-20 00:53:58', 'Vura duma piken', 'vura-duma-piken', '', '<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>\r\n<p>Sed malesuada volutpat diam quis faucibus. Aliquam ultricies placerat dolor, et aliquam magna dictum eu. Integer volutpat posuere tortor non interdum. Integer non mi eros. Integer posuere quam turpis, a condimentum nisl posuere id. Integer feugiat dui id nisi eleifend ultricies. Suspendisse vehicula sapien sollicitudin venenatis hendrerit. Fusce id rutrum leo. Donec malesuada arcu nec sem varius, quis venenatis quam dictum. Fusce accumsan, turpis sit amet congue ultricies, eros mi hendrerit neque, sit amet semper velit metus vulputate velit. Nulla commodo sed justo at venenatis.&nbsp;</p>\r\n<p>Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>', NULL, 6, 1, '2014-03-20 00:52:51', '0000-00-00 00:00:00', 0, 0, 2, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"d8.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d8.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276831,"path":"\\\\d8.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_d8.jpg","mime":"image/jpeg","filesize":"14.58 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d8.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276832,"path":"\\\\b2ap3_thumbnail_d8.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d8.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_d8.jpg","mime":"image/jpeg","filesize":"2.99 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d8.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276832,"path":"\\\\b2ap3_icon_d8.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d8.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"d8.jpg","mime":"image/jpeg","filesize":"258.84 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d8.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276831,"path":"\\\\d8.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d8.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d8.jpg"},"key":"user:660|\\\\d8.jpg","hash":"06505269028712064","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\d8.jpg"}', '', 1),
(35, 660, '2014-03-20 00:54:04', '2014-03-20 00:55:08', 'Horec nirem xatem', 'horec-nirem-xatem', '', '<p>Quisque ante eros, suscipit in sodales non, malesuada in mi. In in sem vel nunc tempus ultricies. Sed ac viverra purus. Maecenas in mauris dapibus mauris rhoncus dictum. Maecenas quis ipsum augue. Nunc sed felis libero.</p>\r\n<p>In id elit nibh. Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>\r\n<p>Sed malesuada volutpat diam quis faucibus. Aliquam ultricies placerat dolor, et aliquam magna dictum eu. Integer volutpat posuere tortor non interdum. Integer non mi eros. Integer posuere quam turpis, a condimentum nisl posuere id. Integer feugiat dui id nisi eleifend ultricies</p>', NULL, 6, 1, '2014-03-20 00:54:04', '0000-00-00 00:00:00', 0, 0, 2, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"d9.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d9.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276901,"path":"\\\\d9.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_d9.jpg","mime":"image/jpeg","filesize":"10.3 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d9.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276901,"path":"\\\\b2ap3_thumbnail_d9.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d9.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d9.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_d9.jpg","mime":"image/jpeg","filesize":"2.62 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d9.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276901,"path":"\\\\b2ap3_icon_d9.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d9.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d9.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"d9.jpg","mime":"image/jpeg","filesize":"177.1 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d9.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276901,"path":"\\\\d9.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d9.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d9.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d9.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d9.jpg"},"key":"user:660|\\\\d9.jpg","hash":"033810770441778004","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\d9.jpg"}', '', 1),
(36, 660, '2014-03-20 00:55:09', '2014-03-20 00:56:02', 'Noka lire poka', 'noka-lire-poka', '', '<p>Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>\r\n<p>Sed malesuada volutpat diam quis faucibus. Aliquam ultricies placerat dolor, et aliquam magna dictum eu. Integer volutpat posuere tortor non interdum. Integer non mi eros. Integer posuere quam turpis, a condimentum nisl posuere id. Integer feugiat dui id nisi eleifend ultricies. Suspendisse vehicula sapien sollicitudin venenatis hendrerit. Fusce id rutrum leo. Donec malesuada arcu nec sem varius, quis venenatis quam dictum. Fusce accumsan, turpis sit amet congue ultricies, eros mi hendrerit neque, sit amet semper velit metus vulputate velit. Nulla commodo sed justo at venenatis. Proin vitae mi quis sem euismod interdum nec id nisi.</p>', NULL, 6, 1, '2014-03-20 00:55:09', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"d10.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d10.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276951,"path":"\\\\d10.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_d10.jpg","mime":"image/jpeg","filesize":"12.25 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d10.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276951,"path":"\\\\b2ap3_thumbnail_d10.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d10.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_d10.jpg","mime":"image/jpeg","filesize":"2.62 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d10.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276951,"path":"\\\\b2ap3_icon_d10.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d10.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"d10.jpg","mime":"image/jpeg","filesize":"250.58 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/d10.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395276951,"path":"\\\\d10.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d10.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_d10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_d10.jpg"},"key":"user:660|\\\\d10.jpg","hash":"014335527713410556","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\d10.jpg"}', '', 1),
(37, 660, '2014-03-20 00:56:43', '2014-03-20 00:58:10', 'Poza suma jetac', 'poza-suma-jetac', '', '<p>Vestibulum luctus erat leo. Nullam aliquam ultrices massa eu eleifend. Nullam id enim vel nisi malesuada ornare non in risus. Aliquam sit amet lectus libero. Aliquam magna tortor, porttitor a arcu quis, congue sollicitudin nisl. Nam eu orci a velit viverra posuere. Quisque ante eros, suscipit in sodales non, malesuada in mi. In in sem vel nunc tempus ultricies. Sed ac viverra purus. Maecenas in mauris dapibus mauris rhoncus dictum. Maecenas quis ipsum augue. Nunc sed felis libero.</p>\r\n<p>In id elit nibh. Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et</p>', NULL, 5, 1, '2014-03-20 00:56:43', '0000-00-00 00:00:00', 0, 0, 2, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"1.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/1.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277084,"path":"\\\\1.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_1.jpg","mime":"image/jpeg","filesize":"10.26 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_1.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277084,"path":"\\\\b2ap3_thumbnail_1.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_1.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_1.jpg","mime":"image/jpeg","filesize":"2.34 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_1.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277084,"path":"\\\\b2ap3_icon_1.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_1.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"1.jpg","mime":"image/jpeg","filesize":"430.37 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/1.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277084,"path":"\\\\1.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_1.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_1.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_1.jpg"},"key":"user:660|\\\\1.jpg","hash":"01019121534191072","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\1.jpg"}', '', 1),
(38, 660, '2014-03-20 00:58:17', '2014-03-20 00:59:07', 'Piza suma pokam', 'piza-suma-pokam', '', '<p>Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>\r\n<p>Sed malesuada volutpat diam quis faucibus. Aliquam ultricies placerat dolor, et aliquam magna dictum eu. Integer volutpat posuere tortor non interdum. Integer non mi eros. Integer posuere quam turpis, a condimentum nisl posuere id. Integer feugiat dui id nisi eleifend ultricies. Suspendisse vehicula sapien sollicitudin venenatis hendrerit. Fusce id rutrum leo. Donec malesuada arcu nec sem varius, quis venenatis quam dictum.</p>', NULL, 5, 1, '2014-03-20 00:58:17', '0000-00-00 00:00:00', 0, 0, 5, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"2.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/2.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277141,"path":"\\\\2.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_2.jpg","mime":"image/jpeg","filesize":"10.27 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_2.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277141,"path":"\\\\b2ap3_thumbnail_2.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_2.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_2.jpg","mime":"image/jpeg","filesize":"2.26 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_2.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277141,"path":"\\\\b2ap3_icon_2.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_2.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"2.jpg","mime":"image/jpeg","filesize":"113.24 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/2.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277141,"path":"\\\\2.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_2.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_2.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_2.jpg"},"key":"user:660|\\\\2.jpg","hash":"00921639078296721","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\2.jpg"}', '', 1),
(39, 660, '2014-03-20 00:59:08', '2014-03-20 01:01:02', 'Gace ruma poza', 'gace-ruma-poza', '', '<p>Vestibulum luctus erat leo. Nullam aliquam ultrices massa eu eleifend. Nullam id enim vel nisi malesuada ornare non in risus. Aliquam sit amet lectus libero. Aliquam magna tortor, porttitor a arcu quis, congue sollicitudin nisl. Nam eu orci a velit viverra posuere. Quisque ante eros, suscipit in sodales non, malesuada in mi. In in sem vel nunc tempus ultricies. Sed ac viverra purus. Maecenas in mauris dapibus mauris rhoncus dictum. Maecenas quis ipsum augue. Nunc sed felis libero.</p>\r\n<p>In id elit nibh. Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo.</p>', NULL, 5, 1, '2014-03-20 00:59:08', '0000-00-00 00:00:00', 0, 0, 6, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"3.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/3.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277257,"path":"\\\\3.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_3.jpg","mime":"image/jpeg","filesize":"7.78 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_3.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277257,"path":"\\\\b2ap3_thumbnail_3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_3.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_3.jpg","mime":"image/jpeg","filesize":"1.87 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_3.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277257,"path":"\\\\b2ap3_icon_3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_3.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"3.jpg","mime":"image/jpeg","filesize":"101.33 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/3.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277257,"path":"\\\\3.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_3.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_3.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_3.jpg"},"key":"user:660|\\\\3.jpg","hash":"036690307571552694","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\3.jpg"}', '', 1),
(40, 660, '2014-03-20 00:59:08', '2014-03-21 07:32:28', 'Meru jace face', 'meru-jace-face', '', '<p>Pikan luctus erat leo. Nullam aliquam ultrices massa eu eleifend. Nullam id enim vel nisi malesuada ornare non in risus. Aliquam sit amet lectus libero. Aliquam magna tortor, porttitor a arcu quis, congue sollicitudin nisl. Nam eu orci a velit viverra posuere. Quisque ante eros, suscipit in sodales non, malesuada in mi. In in sem vel nunc tempus ultricies. Sed ac viverra purus. Maecenas in mauris dapibus mauris rhoncus dictum. Maecenas quis ipsum augue. Nunc sed felis libero.</p>\r\n<p>In id elit nibh. Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo.</p>', NULL, 5, 1, '2014-03-20 00:59:08', '0000-00-00 00:00:00', 0, 0, 4, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"10.jpg","mime":"image/jpeg","url":"http://localhost/joomla32/sj_icenter/images/easyblog_images/660/10.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395298827,"path":"\\\\10.jpg","place":"user:660","thumbnail":{"url":"http://localhost/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_10.jpg"},"icon":{"url":"http://localhost/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_10.jpg"},"key":"user:660|\\\\10.jpg","hash":"04604949625208974","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\10.jpg"}', '', 1),
(43, 660, '2014-03-13 04:32:26', '2014-04-07 08:02:41', 'Aliquam consectetur', 'aliquam-consectetur-1', '', '<p>Suspendisse vitae erat eget magna tincidunt elementum vitae at augue. Integer interdum mauris vel purus hendrerit egestas. Maecenas ullamcorper nisi leo, quis adipiscing massa viverra in. Pellentesque iaculis quam sit amet lacus porta, quis egestas leo eleifend. Donec ullamcorper, leo sed tristique feugiat, tortor dui dictum ipsum, non consectetur tellus est et lectus. Pellentesque hendrerit est eu pharetra mollis. Integer sed sodales leo. Integer lacinia condimentum augue non cursus.</p>\r\n<p>Nam malesuada mattis nisi at dictum. Ut mauris elit, convallis non semper quis, malesuada ac ligula. Vestibulum facilisis et quam id congue. Vivamus pulvinar, elit ac elementum semper, justo ante semper quam, eget porta urna magna id sem. Etiam eget urna id lorem placerat facilisis. Maecenas pellentesque tempus metus, non viverra arcu venenatis eget. Donec leo diam, adipiscing eu dolor nec, rhoncus interdum ipsum. Mauris faucibus, dui vel consectetur pulvinar, magna lacus suscipit mauris, sit amet luctus mi lectus eu arcu. Phasellus rutrum enim tortor, in sagittis magna accumsan ut. Fusce suscipit eget urna at tincidunt. Curabitur eget nunc quis velit blandit lobortis. Nunc magna augue, commodo eu pretium vitae, tempor ac sem. Donec a condimentum lectus. Vestibulum eget purus vel orci tempor aliquam non non purus. Morbi vel diam sapien. Quisque sollicitudin rutrum velit ac egestas.</p>\r\n<p>Suspendisse euismod nibh ut ullamcorper laoreet. Sed accumsan eros ut dui lobortis aliquet. In placerat hendrerit nulla, ut ullamcorper nisi molestie id. In vestibulum erat in erat pellentesque placerat. Suspendisse ornare ante urna, sit amet aliquet ligula gravida at. Curabitur vel metus sit amet velit volutpat venenatis ut quis odio. Pellentesque mollis varius massa eget faucibus. Nunc pharetra, justo sed tincidunt eleifend, lacus nunc pretium urna, a auctor dui quam eu nisi. Nulla quis vestibulum nisl. Etiam facilisis dignissim leo, tempor adipiscing turpis ultricies sit amet. Proin sed varius nisi. In lobortis eget orci ut pharetra. Vivamus ut est in eros posuere tempus feugiat sed libero. Pellentesque laoreet enim vel quam iaculis, nec imperdiet neque scelerisque. Nunc vitae consectetur libero, et feugiat turpis.</p>', NULL, 5, 1, '2014-03-13 04:32:26', '0000-00-00 00:00:00', 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"blo1.jpg","mime":"image/jpeg","url":"http://localhost/sj_icenter/images/easyblog_images/660/blo1.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395291472,"path":"\\\\blo1.jpg","place":"user:660","thumbnail":{"url":"http://localhost/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_blo1.jpg"},"icon":{"url":"http://localhost/sj_icenter/images/easyblog_images/660/b2ap3_icon_blo1.jpg"},"key":"user:660|\\\\blo1.jpg","hash":"07076158944983035","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\blo1.jpg"}', '', 1),
(41, 660, '2014-03-20 01:01:27', '2014-03-20 01:02:26', 'Ture face virem', 'ture-face-virem', '', '<p>Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et. Fusce suscipit justo id cursus posuere. Phasellus ornare lorem vel odio consectetur hendrerit. Cras vel suscipit est.</p>\r\n<p>Sed malesuada volutpat diam quis faucibus. Aliquam ultricies placerat dolor, et aliquam magna dictum eu. Integer volutpat posuere tortor non interdum. Integer non mi eros. Integer posuere quam turpis, a condimentum nisl posuere id. Integer feugiat dui id nisi eleifend ultricies. Suspendisse vehicula sapien sollicitudin venenatis hendrerit. Fusce id rutrum leo. Donec malesuada arcu nec sem varius, quis venenatis quam dictum.</p>', NULL, 5, 1, '2014-03-20 01:01:27', '0000-00-00 00:00:00', 0, 0, 6, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"8.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/8.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277327,"path":"\\\\8.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_8.jpg","mime":"image/jpeg","filesize":"8.62 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_8.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277328,"path":"\\\\b2ap3_thumbnail_8.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_8.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_8.jpg","mime":"image/jpeg","filesize":"2.27 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_8.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277328,"path":"\\\\b2ap3_icon_8.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_8.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"8.jpg","mime":"image/jpeg","filesize":"92.66 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/8.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277327,"path":"\\\\8.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_8.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_8.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_8.jpg"},"key":"user:660|\\\\8.jpg","hash":"005291136144660413","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\8.jpg"}', '', 1);
INSERT INTO `#__easyblog_post` (`id`, `created_by`, `created`, `modified`, `title`, `permalink`, `content`, `intro`, `excerpt`, `category_id`, `published`, `publish_up`, `publish_down`, `ordering`, `vote`, `hits`, `private`, `allowcomment`, `subscription`, `frontpage`, `isnew`, `ispending`, `issitewide`, `blogpassword`, `latitude`, `longitude`, `address`, `system`, `source`, `robots`, `copyrights`, `image`, `language`, `send_notification_emails`) VALUES
(42, 660, '2014-03-20 01:02:29', '2014-03-20 01:03:36', 'Jaso hare mopan', 'jaso-hare-mopan', '', '<p>Aliquam magna tortor, porttitor a arcu quis, congue sollicitudin nisl. Nam eu orci a velit viverra posuere. Quisque ante eros, suscipit in sodales non, malesuada in mi. In in sem vel nunc tempus ultricies. Sed ac viverra purus. Maecenas in mauris dapibus mauris rhoncus dictum. Maecenas quis ipsum augue. Nunc sed felis libero.</p>\r\n<p>In id elit nibh. Aenean ut mauris at erat adipiscing accumsan. Curabitur in egestas erat. Praesent porttitor vel enim vitae fringilla. Aenean libero nibh, congue id tellus vitae, rhoncus pellentesque ante. Donec in mollis odio. Integer congue enim at bibendum egestas. Donec hendrerit sagittis diam. Curabitur purus enim, consectetur non volutpat quis, egestas sit amet est. Pellentesque interdum auctor nisl, eget interdum dui mollis feugiat. Morbi pretium mauris ut tortor porttitor, ac sollicitudin arcu aliquet. Praesent risus justo, consequat ut interdum sodales, imperdiet sit amet justo.</p>\r\n<p>Morbi sit amet consequat libero. Nam sollicitudin venenatis purus eu imperdiet. Aliquam sodales, nibh a porta sagittis, tortor nibh fermentum justo, sed ultrices massa erat ut augue. Sed ac ullamcorper justo. Donec erat lectus, sodales sed nisl nec, facilisis suscipit purus. Proin tristique nulla ante. Cras imperdiet, erat id posuere cursus, nulla lacus molestie est, id hendrerit lacus sem a mi. Phasellus vitae sollicitudin nibh. Proin sollicitudin semper enim, quis sollicitudin ante aliquam sit amet. Nunc nisi augue, hendrerit ut bibendum cursus, aliquam quis diam. Sed in pharetra nibh.</p>\r\n<p>Nulla pretium diam ut elementum congue. Vivamus porttitor, nisi ac hendrerit congue, enim mi vehicula elit, vitae ultricies sapien nibh eget sem. Quisque in risus ac est facilisis rhoncus sed non mi. Cras id justo diam. Maecenas pharetra mi ut augue porta volutpat. Sed id nisi ut nulla pharetra commodo. Donec auctor est urna, a suscipit leo tempus at. Duis pharetra sapien dolor, eu feugiat turpis consequat et.</p>', NULL, 5, 1, '2014-03-20 01:02:29', '0000-00-00 00:00:00', 0, 0, 21, 0, 1, 1, 1, 0, 0, 1, '', '', '', '', 0, '', '', '', '{"type":"image","title":"10.jpg","mime":"image/jpeg","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/10.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277408,"path":"\\\\10.jpg","place":"user:660","variations":[{"type":"image","title":"b2ap3_thumbnail_10.jpg","mime":"image/jpeg","filesize":"10.83 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_10.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277408,"path":"\\\\b2ap3_thumbnail_10.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_10.jpg"},"name":"thumbnail","width":400,"height":257,"canDelete":false,"default":true},{"type":"image","title":"b2ap3_icon_10.jpg","mime":"image/jpeg","filesize":"2.54 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_10.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277408,"path":"\\\\b2ap3_icon_10.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_10.jpg"},"name":"icon","width":128,"height":82,"canDelete":false,"default":false},{"type":"image","title":"10.jpg","mime":"image/jpeg","filesize":"132.1 KB","url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/10.jpg","dateCreated":"Thursday, 20 March 2014","dateModified":1395277408,"path":"\\\\10.jpg","place":"user:660","thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_10.jpg"},"name":"original","width":700,"height":450,"canDelete":false,"default":false}],"thumbnail":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_thumbnail_10.jpg"},"icon":{"url":"http://dev.ytcvn.com/ytc_templates/joomla32/sj_icenter/images/easyblog_images/660/b2ap3_icon_10.jpg"},"key":"user:660|\\\\10.jpg","hash":"02532150954939425","group":"files","parentKey":"user:660|\\\\","friendlyPath":"My Media\\\\10.jpg"}', '', 1);

DROP TABLE IF EXISTS `#__easyblog_post_rejected`;
CREATE TABLE IF NOT EXISTS `#__easyblog_post_rejected` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `draft_id` bigint(20) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `message` text NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `draft_id` (`draft_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_post_subscription`;
CREATE TABLE IF NOT EXISTS `#__easyblog_post_subscription` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT '0',
  `fullname` varchar(255) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `easyblog_post_subscription_post_id` (`post_id`),
  KEY `easyblog_post_subscription_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_post_tag`;
CREATE TABLE IF NOT EXISTS `#__easyblog_post_tag` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `easyblog_post_tag_tag_id` (`tag_id`),
  KEY `easyblog_post_tag_post_id` (`post_id`),
  KEY `easyblog_post_tagpost_id` (`tag_id`,`post_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

INSERT INTO `#__easyblog_post_tag` (`id`, `tag_id`, `post_id`, `created`) VALUES
(1, 1, 1, '2014-03-10 13:51:29'),
(2, 2, 1, '2014-03-10 13:51:29'),
(3, 3, 2, '2014-03-17 04:21:27'),
(4, 4, 2, '2014-03-17 04:21:27'),
(5, 5, 2, '2014-03-17 04:21:27'),
(6, 3, 43, '2014-04-07 08:02:41'),
(7, 4, 43, '2014-04-07 08:02:41'),
(8, 5, 43, '2014-04-07 08:02:41');

DROP TABLE IF EXISTS `#__easyblog_ratings`;
CREATE TABLE IF NOT EXISTS `#__easyblog_ratings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `created_by` int(11) NOT NULL,
  `sessionid` varchar(200) NOT NULL,
  `value` int(11) NOT NULL,
  `ip` varchar(50) NOT NULL,
  `published` tinyint(3) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `post_id` (`uid`),
  KEY `created_by` (`created_by`),
  KEY `rating` (`value`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

INSERT INTO `#__easyblog_ratings` (`id`, `uid`, `type`, `created_by`, `sessionid`, `value`, `ip`, `published`, `created`) VALUES
(1, 2, 'entry', 0, 'icg23p3pqqf0ekt6pu3kl0eki5', 9, '127.0.0.1', 1, '2014-03-13 07:36:03'),
(2, 6, 'entry', 0, 'hqoq5gnu33e8mfag39q8i0bhr3', 1, '::1', 1, '2014-03-19 03:11:04'),
(3, 42, 'entry', 0, 'icg23p3pqqf0ekt6pu3kl0eki5', 10, '127.0.0.1', 1, '2014-03-20 08:30:03'),
(4, 26, 'entry', 0, 'tqm75cnl6voha7c84qls7l0n14', 9, '127.0.0.1', 1, '2014-03-21 09:20:47'),
(5, 26, 'entry', 0, 'irqciblnnkadovmi6b0i0ddht4', 5, '192.168.1.101', 1, '2014-04-08 01:42:46'),
(6, 41, 'entry', 0, 'e8rab5i0d8pcc4tva8m3l18503', 6, '192.168.1.115', 1, '2014-04-08 03:00:58'),
(7, 39, 'entry', 0, 'oi2tk5dsrodrepdf6c1tmlkia0', 2, '::1', 1, '2014-04-08 03:14:49'),
(8, 42, 'entry', 0, 'nb0kl35s2bjmr0nbjo63r1dqj1', 10, '127.0.0.1', 1, '2014-05-09 09:56:16'),
(9, 43, 'entry', 0, 'nb0kl35s2bjmr0nbjo63r1dqj1', 10, '127.0.0.1', 1, '2014-05-09 09:56:42'),
(10, 41, 'entry', 0, 'nb0kl35s2bjmr0nbjo63r1dqj1', 10, '127.0.0.1', 1, '2014-05-09 10:10:06'),
(11, 24, 'entry', 0, 'nb0kl35s2bjmr0nbjo63r1dqj1', 10, '127.0.0.1', 1, '2014-05-09 10:10:23'),
(12, 38, 'entry', 0, 'nb0kl35s2bjmr0nbjo63r1dqj1', 10, '127.0.0.1', 1, '2014-05-09 10:16:49'),
(13, 39, 'entry', 0, 'nb0kl35s2bjmr0nbjo63r1dqj1', 10, '127.0.0.1', 1, '2014-05-09 10:23:24');

DROP TABLE IF EXISTS `#__easyblog_reports`;
CREATE TABLE IF NOT EXISTS `#__easyblog_reports` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `obj_id` bigint(20) NOT NULL,
  `obj_type` varchar(255) NOT NULL,
  `reason` text NOT NULL,
  `created_by` int(11) NOT NULL,
  `created` datetime NOT NULL,
  `ip` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `obj_id` (`obj_id`,`created_by`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_site_subscription`;
CREATE TABLE IF NOT EXISTS `#__easyblog_site_subscription` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT '0',
  `fullname` varchar(255) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `easyblog_site_subscription_user_id` (`user_id`),
  KEY `easyblog_site_subscription_email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_stream`;
CREATE TABLE IF NOT EXISTS `#__easyblog_stream` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `actor_id` bigint(20) unsigned NOT NULL,
  `target_id` bigint(20) unsigned DEFAULT '0',
  `context_type` varchar(255) DEFAULT '',
  `context_id` bigint(20) unsigned DEFAULT '0',
  `verb` text,
  `source_id` bigint(20) unsigned DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `uuid` text,
  PRIMARY KEY (`id`),
  KEY `easyblog_stream_actor` (`actor_id`),
  KEY `easyblog_stream_actor_timeline` (`actor_id`,`created`),
  KEY `easyblog_stream_target_timeline` (`target_id`,`created`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=102 ;

INSERT INTO `#__easyblog_stream` (`id`, `actor_id`, `target_id`, `context_type`, `context_id`, `verb`, `source_id`, `created`, `uuid`) VALUES
(1, 660, 0, 'category', 2, 'add', 0, '2014-03-13 04:31:43', 'Easy Blog'),
(2, 660, 0, 'category', 2, 'update', 0, '2014-03-13 04:31:56', 'Easy Blog'),
(3, 660, 0, 'post', 2, 'add', 0, '2014-03-13 04:39:49', 'Aliquam consectetur'),
(4, 660, 0, 'post', 2, 'update', 0, '2014-03-13 04:40:00', 'Aliquam consectetur'),
(5, 660, 0, 'post', 2, 'update', 0, '2014-03-13 04:42:11', 'Aliquam consectetur'),
(6, 660, 0, 'post', 2, 'update', 0, '2014-03-13 04:42:19', 'Aliquam consectetur'),
(7, 660, 0, 'post', 2, 'update', 0, '2014-03-13 08:12:28', 'Aliquam consectetur'),
(8, 660, 0, 'post', 2, 'update', 0, '2014-03-17 04:21:27', 'Aliquam consectetur'),
(9, 660, 0, 'tag', 3, 'add', 0, '2014-03-17 04:21:27', 'Joomla Templates'),
(10, 660, 0, 'tag', 4, 'add', 0, '2014-03-17 04:21:27', 'Smartaddons'),
(11, 660, 0, 'tag', 5, 'add', 0, '2014-03-17 04:21:27', 'Laptop'),
(12, 0, 660, 'comment', 1, 'add', 2, '2014-03-17 04:52:21', 'O:8:"stdClass":4:{s:7:"comment";s:73:"If you would like to register, please fill in the username and name field";s:13:"commentauthor";s:5:"trung";s:9:"blogtitle";s:19:"Aliquam consectetur";s:9:"blogautor";s:10:"Super User";}'),
(13, 0, 660, 'comment', 2, 'add', 2, '2014-03-17 05:00:07', 'O:8:"stdClass":4:{s:7:"comment";s:434:"Nam malesuada mattis nisi at dictum. Ut mauris elit, convallis non semper quis, malesuada ac ligula. Vestibulum facilisis et quam id congue. Vivamus pulvinar, elit ac elementum semper, justo ante semper quam, eget porta urna magna id sem. Etiam eget urna id lorem placerat facilisis. Maecenas pellentesque tempus metus, non viverra arcu venenatis eget. Donec leo diam, adipiscing eu dolor nec, rhoncus interdum ipsum. Mauris faucibus,";s:13:"commentauthor";s:7:"Manager";s:9:"blogtitle";s:19:"Aliquam consectetur";s:9:"blogautor";s:10:"Super User";}'),
(14, 0, 660, 'comment', 2, 'add', 2, '2014-03-17 05:01:12', 'O:8:"stdClass":4:{s:7:"comment";s:434:"Nam malesuada mattis nisi at dictum. Ut mauris elit, convallis non semper quis, malesuada ac ligula. Vestibulum facilisis et quam id congue. Vivamus pulvinar, elit ac elementum semper, justo ante semper quam, eget porta urna magna id sem. Etiam eget urna id lorem placerat facilisis. Maecenas pellentesque tempus metus, non viverra arcu venenatis eget. Donec leo diam, adipiscing eu dolor nec, rhoncus interdum ipsum. Mauris faucibus,";s:13:"commentauthor";s:7:"Manager";s:9:"blogtitle";s:19:"Aliquam consectetur";s:9:"blogautor";s:10:"Super User";}'),
(15, 0, 660, 'comment', 3, 'add', 2, '2014-03-17 07:33:50', 'O:8:"stdClass":4:{s:7:"comment";s:352:"In tempor aliquet mollis. Mauris sem diam, sodales in ante a, lacinia consectetur libero. Aenean non ante vel metus facilisis tincidunt at ut mauris. Duis rhoncus nisi ac dictum ornare. Donec pretium orci purus, sit amet consequat sem semper sit amet. Suspendisse potenti. Vestibulum consectetur arcu vitae lectus elementum, ac posuere magna tincidunt.";s:13:"commentauthor";s:4:"Jobb";s:9:"blogtitle";s:19:"Aliquam consectetur";s:9:"blogautor";s:10:"Super User";}'),
(16, 0, 660, 'comment', 3, 'add', 2, '2014-03-17 07:34:21', 'O:8:"stdClass":4:{s:7:"comment";s:352:"In tempor aliquet mollis. Mauris sem diam, sodales in ante a, lacinia consectetur libero. Aenean non ante vel metus facilisis tincidunt at ut mauris. Duis rhoncus nisi ac dictum ornare. Donec pretium orci purus, sit amet consequat sem semper sit amet. Suspendisse potenti. Vestibulum consectetur arcu vitae lectus elementum, ac posuere magna tincidunt.";s:13:"commentauthor";s:4:"Jobb";s:9:"blogtitle";s:19:"Aliquam consectetur";s:9:"blogautor";s:10:"Super User";}'),
(17, 660, 0, 'profile', 660, 'update', 0, '2014-03-17 07:51:12', ''),
(18, 660, 0, 'category', 3, 'add', 0, '2014-03-17 16:08:33', 'categories 1'),
(19, 660, 0, 'category', 4, 'add', 0, '2014-03-17 16:08:59', 'Categories  2 '),
(20, 660, 0, 'category', 3, 'update', 0, '2014-03-17 16:09:14', 'Categories 1'),
(21, 660, 0, 'category', 5, 'add', 0, '2014-03-17 16:09:41', 'Categories 3'),
(22, 660, 0, 'category', 6, 'add', 0, '2014-03-17 16:10:10', 'Categories 4'),
(23, 660, 0, 'post', 3, 'add', 0, '2014-03-17 16:19:38', 'Pazen mase pika'),
(24, 660, 0, 'post', 4, 'add', 0, '2014-03-19 00:44:15', 'Vivamus sed elit ut tortor'),
(25, 660, 0, 'post', 4, 'update', 0, '2014-03-19 00:44:34', 'Vivamus sed elit ut tortor'),
(26, 660, 0, 'post', 5, 'add', 0, '2014-03-19 00:45:48', 'Ganse mika lipon'),
(27, 660, 0, 'post', 6, 'add', 0, '2014-03-19 00:47:02', 'Sika lima nure'),
(28, 660, 0, 'post', 7, 'add', 0, '2014-03-19 00:48:21', 'Seka kima nuren'),
(29, 660, 0, 'post', 8, 'add', 0, '2014-03-19 00:49:52', 'Buren mase jites'),
(30, 660, 0, 'post', 9, 'add', 0, '2014-03-19 00:51:39', 'Mire mase loten'),
(31, 660, 0, 'post', 10, 'add', 0, '2014-03-19 00:53:13', 'Proin sollicitudin nisi quis'),
(32, 660, 0, 'post', 11, 'add', 0, '2014-03-19 00:54:49', 'Mauris pulvinar pellentesque'),
(33, 660, 0, 'post', 12, 'add', 0, '2014-03-19 00:55:47', 'Zuna maten pozan'),
(34, 660, 0, 'post', 13, 'add', 0, '2014-03-19 00:57:39', 'Tuson mazo liten'),
(35, 660, 0, 'post', 14, 'add', 0, '2014-03-19 00:58:49', 'Jase duma loten'),
(36, 660, 0, 'post', 15, 'add', 0, '2014-03-19 01:01:18', 'Posen makin late'),
(37, 660, 0, 'post', 16, 'add', 0, '2014-03-19 01:02:26', 'Jise rika maonza'),
(38, 660, 0, 'post', 17, 'add', 0, '2014-03-19 01:03:45', 'Kosan mapi katen'),
(39, 660, 0, 'post', 18, 'add', 0, '2014-03-19 01:05:18', 'Koma sikan lite'),
(40, 660, 0, 'post', 19, 'add', 0, '2014-03-19 01:07:06', 'Chuken mazen dima'),
(41, 660, 0, 'post', 20, 'add', 0, '2014-03-19 01:08:45', 'Kizab mapon katen'),
(42, 660, 0, 'post', 21, 'add', 0, '2014-03-19 01:11:39', 'Nipon kite rima'),
(43, 660, 0, 'post', 22, 'add', 0, '2014-03-19 01:13:41', 'Bize dukam mazim'),
(44, 660, 0, 'post', 23, 'add', 0, '2014-03-19 01:14:56', 'Fisen mazon pokan'),
(45, 660, 0, 'post', 24, 'add', 0, '2014-03-19 01:20:51', 'Koren pizan suka'),
(46, 660, 0, 'post', 25, 'add', 0, '2014-03-19 01:23:17', 'Chiren mapon makin'),
(47, 660, 0, 'post', 26, 'add', 0, '2014-03-19 01:26:27', 'Gizan suma kiten'),
(48, 660, 0, 'category', 3, 'update', 0, '2014-03-19 09:55:46', 'Computer'),
(49, 660, 0, 'category', 4, 'update', 0, '2014-03-19 09:56:08', 'Tablet, Phablet'),
(50, 660, 0, 'category', 5, 'update', 0, '2014-03-19 09:56:22', 'Smartphone'),
(51, 660, 0, 'category', 6, 'update', 0, '2014-03-19 09:56:37', 'Camera'),
(52, 660, 0, 'post', 27, 'add', 0, '2014-03-20 00:45:34', 'Haxe duna pozan'),
(53, 660, 0, 'post', 28, 'add', 0, '2014-03-20 00:46:57', 'Vestibulum luctus erat leo'),
(54, 660, 0, 'post', 29, 'add', 0, '2014-03-20 00:46:57', 'Vestibulum luctus erat leo'),
(55, 660, 0, 'post', 29, 'update', 0, '2014-03-20 00:48:10', 'Kiren poka litem'),
(56, 660, 0, 'post', 30, 'add', 0, '2014-03-20 00:49:16', 'Hure capin katen'),
(57, 660, 0, 'post', 31, 'add', 0, '2014-03-20 00:50:31', 'Jucas rupin karum'),
(58, 660, 0, 'post', 32, 'add', 0, '2014-03-20 00:51:38', 'Vurom nuca loten'),
(59, 660, 0, 'post', 33, 'add', 0, '2014-03-20 00:52:43', 'Wacer tina puka'),
(60, 660, 0, 'post', 34, 'add', 0, '2014-03-20 00:53:58', 'Vura duma piken'),
(61, 660, 0, 'post', 35, 'add', 0, '2014-03-20 00:55:08', 'Horec nirem xatem'),
(62, 660, 0, 'post', 36, 'add', 0, '2014-03-20 00:56:02', 'Noka lire poka'),
(63, 660, 0, 'post', 37, 'add', 0, '2014-03-20 00:58:10', 'Poza suma jetac'),
(64, 660, 0, 'post', 38, 'add', 0, '2014-03-20 00:59:07', 'Piza suma pokam'),
(65, 660, 0, 'post', 39, 'add', 0, '2014-03-20 01:01:02', 'Gace ruma poza'),
(66, 660, 0, 'post', 40, 'add', 0, '2014-03-20 01:01:03', 'Gace ruma poza'),
(67, 660, 0, 'post', 41, 'add', 0, '2014-03-20 01:02:26', 'Ture face virem'),
(68, 660, 0, 'post', 42, 'add', 0, '2014-03-20 01:03:36', 'Jaso hare mopan'),
(69, 660, 0, 'post', 40, 'update', 0, '2014-03-20 05:32:49', 'Meru jace face'),
(70, 660, 0, 'post', 40, 'update', 0, '2014-03-21 07:32:28', 'Meru jace face'),
(71, 660, 0, 'category', 3, 'update', 0, '2014-03-21 08:54:02', 'Computer'),
(72, 660, 0, 'category', 6, 'update', 0, '2014-03-21 08:54:31', 'Camera'),
(73, 660, 0, 'category', 5, 'update', 0, '2014-03-21 08:54:45', 'Smartphone'),
(74, 660, 0, 'category', 4, 'update', 0, '2014-03-21 08:54:58', 'Tablet, Phablet'),
(75, 660, 660, 'comment', 4, 'add', 26, '2014-03-21 09:35:22', 'O:8:"stdClass":4:{s:7:"comment";s:160:"Cras pretium tempor quam eget pretium. Curabitur nibh augue, pulvinar a sollicitudin at, dignissim ut quam. In hac habitasse platea dictumst. Morbi orci libero,";s:13:"commentauthor";s:11:"smartaddons";s:9:"blogtitle";s:16:"Gizan suma kiten";s:9:"blogautor";s:10:"Super User";}'),
(76, 0, 660, 'comment', 5, 'add', 26, '2014-03-21 09:35:57', 'O:8:"stdClass":4:{s:7:"comment";s:284:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean eleifend felis at lectus luctus eleifend. Pellentesque sollicitudin gravida est. Quisque euismod nisl eget tortor gravida, at imperdiet ipsum bibendum. Aliquam nec laoreet urna. Nulla ut dictum nisl. Nunc lectus purus...";s:13:"commentauthor";s:11:"smartaddons";s:9:"blogtitle";s:16:"Gizan suma kiten";s:9:"blogautor";s:10:"Super User";}'),
(77, 0, 660, 'comment', 6, 'add', 26, '2014-03-21 09:36:25', 'O:8:"stdClass":4:{s:7:"comment";s:180:"Curabitur imperdiet fermentum tellus, nec eleifend felis pharetra vel. Praesent lobortis, arcu eu tempor dapibus, justo quam sagittis turpis, in adipiscing felis enim sit amet sem.";s:13:"commentauthor";s:11:"smartaddons";s:9:"blogtitle";s:16:"Gizan suma kiten";s:9:"blogautor";s:10:"Super User";}'),
(78, 0, 660, 'comment', 5, 'add', 26, '2014-03-21 09:42:56', 'O:8:"stdClass":4:{s:7:"comment";s:284:"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean eleifend felis at lectus luctus eleifend. Pellentesque sollicitudin gravida est. Quisque euismod nisl eget tortor gravida, at imperdiet ipsum bibendum. Aliquam nec laoreet urna. Nulla ut dictum nisl. Nunc lectus purus...";s:13:"commentauthor";s:11:"smartaddons";s:9:"blogtitle";s:16:"Gizan suma kiten";s:9:"blogautor";s:10:"Super User";}'),
(79, 0, 660, 'comment', 6, 'add', 26, '2014-03-21 09:45:43', 'O:8:"stdClass":4:{s:7:"comment";s:180:"Curabitur imperdiet fermentum tellus, nec eleifend felis pharetra vel. Praesent lobortis, arcu eu tempor dapibus, justo quam sagittis turpis, in adipiscing felis enim sit amet sem.";s:13:"commentauthor";s:11:"smartaddons";s:9:"blogtitle";s:16:"Gizan suma kiten";s:9:"blogautor";s:10:"Super User";}'),
(80, 660, 660, 'comment', 4, 'add', 26, '2014-03-21 09:45:43', 'O:8:"stdClass":4:{s:7:"comment";s:160:"Cras pretium tempor quam eget pretium. Curabitur nibh augue, pulvinar a sollicitudin at, dignissim ut quam. In hac habitasse platea dictumst. Morbi orci libero,";s:13:"commentauthor";s:11:"smartaddons";s:9:"blogtitle";s:16:"Gizan suma kiten";s:9:"blogautor";s:10:"Super User";}'),
(81, 660, 0, 'category', 4, 'update', 0, '2014-03-22 04:59:46', 'Tablet, Phablet'),
(82, 660, 0, 'category', 4, 'update', 0, '2014-03-22 04:59:46', 'Tablet, Phablet'),
(83, 660, 0, 'category', 5, 'update', 0, '2014-03-22 05:00:03', 'Smartphone'),
(84, 660, 0, 'category', 5, 'update', 0, '2014-03-22 05:00:03', 'Smartphone'),
(85, 660, 0, 'category', 6, 'update', 0, '2014-03-22 05:00:19', 'Camera'),
(86, 660, 0, 'category', 6, 'update', 0, '2014-03-22 05:00:19', 'Camera'),
(87, 660, 0, 'category', 3, 'update', 0, '2014-03-22 05:00:33', 'Computer'),
(88, 660, 0, 'category', 3, 'update', 0, '2014-03-22 05:00:33', 'Computer'),
(89, 660, 0, 'category', 4, 'update', 0, '2014-03-24 09:55:02', 'Tablet, Phablet'),
(90, 660, 0, 'category', 5, 'update', 0, '2014-03-24 09:55:10', 'Smartphone'),
(91, 660, 0, 'category', 6, 'update', 0, '2014-03-24 09:55:20', 'Camera'),
(92, 660, 0, 'category', 3, 'update', 0, '2014-03-24 09:55:27', 'Computer'),
(93, 660, 0, 'category', 4, 'update', 0, '2014-03-25 01:29:17', 'Tablet, Phablet'),
(94, 660, 0, 'category', 5, 'update', 0, '2014-03-25 01:29:25', 'Smartphone'),
(95, 660, 0, 'category', 6, 'update', 0, '2014-03-25 01:29:33', 'Camera'),
(96, 660, 0, 'category', 3, 'update', 0, '2014-03-25 01:29:41', 'Computer'),
(97, 660, 660, 'comment', 7, 'add', 26, '2014-03-27 10:05:38', 'O:8:"stdClass":4:{s:7:"comment";s:44:"vfcryb hgtctv uhyc uyvgj bj uỳuvhj uỳty.";s:13:"commentauthor";s:6:"vyuvyu";s:9:"blogtitle";s:16:"Gizan suma kiten";s:9:"blogautor";s:10:"Super User";}'),
(98, 0, 660, 'comment', 8, 'add', 26, '2014-03-31 07:53:15', 'O:8:"stdClass":4:{s:7:"comment";s:25:"sadasd sadssd sadsad sd a";s:13:"commentauthor";s:6:"asdsad";s:9:"blogtitle";s:16:"Gizan suma kiten";s:9:"blogautor";s:10:"Super User";}'),
(99, 0, 660, 'comment', 9, 'add', 26, '2014-03-31 07:53:19', 'O:8:"stdClass":4:{s:7:"comment";s:25:"sadasd sadssd sadsad sd a";s:13:"commentauthor";s:6:"asdsad";s:9:"blogtitle";s:16:"Gizan suma kiten";s:9:"blogautor";s:10:"Super User";}'),
(100, 0, 660, 'comment', 10, 'add', 26, '2014-04-01 02:46:55', 'O:8:"stdClass":4:{s:7:"comment";s:4:"ijuo";s:13:"commentauthor";s:3:"m;k";s:9:"blogtitle";s:16:"Gizan suma kiten";s:9:"blogautor";s:10:"Super User";}'),
(101, 660, 0, 'post', 43, 'add', 0, '2014-04-07 08:02:41', 'Aliquam consectetur');

DROP TABLE IF EXISTS `#__easyblog_tag`;
CREATE TABLE IF NOT EXISTS `#__easyblog_tag` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_by` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `default` tinyint(1) NOT NULL DEFAULT '0',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `easyblog_tag_title` (`title`),
  KEY `easyblog_tag_published` (`published`),
  KEY `easyblog_tag_alias` (`alias`),
  KEY `easyblog_tag_query1` (`published`,`id`,`title`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

INSERT INTO `#__easyblog_tag` (`id`, `created_by`, `title`, `alias`, `created`, `status`, `published`, `default`, `ordering`) VALUES
(1, 660, 'Thank You', 'thank-you', '2014-03-10 13:51:29', 0, 1, 0, 0),
(2, 660, 'Congratulations', 'congratulations', '2014-03-10 13:51:29', 0, 1, 0, 0),
(3, 660, 'Joomla Templates', 'joomla-templates', '2014-03-17 04:21:27', 0, 1, 0, 0),
(4, 660, 'Smartaddons', 'smartaddons', '2014-03-17 04:21:27', 0, 1, 0, 0),
(5, 660, 'Laptop', 'laptop', '2014-03-17 04:21:27', 0, 1, 0, 0);

DROP TABLE IF EXISTS `#__easyblog_team`;
CREATE TABLE IF NOT EXISTS `#__easyblog_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `description` text NOT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `access` tinyint(1) DEFAULT '1',
  `published` tinyint(1) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_team_groups`;
CREATE TABLE IF NOT EXISTS `#__easyblog_team_groups` (
  `team_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  KEY `team_id` (`team_id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__easyblog_team_post`;
CREATE TABLE IF NOT EXISTS `#__easyblog_team_post` (
  `team_id` int(11) NOT NULL,
  `post_id` bigint(11) NOT NULL,
  KEY `easyblog_teampost_tid` (`team_id`),
  KEY `easyblog_teampost_pid` (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__easyblog_team_request`;
CREATE TABLE IF NOT EXISTS `#__easyblog_team_request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `team_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `ispending` tinyint(1) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `easyblog_team_request_teamid` (`team_id`),
  KEY `easyblog_team_request_userid` (`user_id`),
  KEY `easyblog_team_request_pending` (`ispending`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_team_subscription`;
CREATE TABLE IF NOT EXISTS `#__easyblog_team_subscription` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `team_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT '0',
  `fullname` varchar(255) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `easyblog_team_subscription_team_id` (`team_id`),
  KEY `easyblog_team_subscription_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_team_users`;
CREATE TABLE IF NOT EXISTS `#__easyblog_team_users` (
  `team_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `isadmin` tinyint(1) DEFAULT '0',
  KEY `easyblog_team_id` (`team_id`),
  KEY `easyblog_team_userid` (`user_id`),
  KEY `easyblog_team_isadmin` (`team_id`,`user_id`,`isadmin`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__easyblog_trackback`;
CREATE TABLE IF NOT EXISTS `#__easyblog_trackback` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `ip` varchar(25) NOT NULL DEFAULT '',
  `title` text NOT NULL,
  `excerpt` text NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `blog_name` text NOT NULL,
  `charset` varchar(45) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `option` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `easyblog_tb_post_id` (`post_id`),
  KEY `easyblog_tb_url` (`url`),
  KEY `easyblog_tb_ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_trackback_sent`;
CREATE TABLE IF NOT EXISTS `#__easyblog_trackback_sent` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `url` varchar(255) NOT NULL,
  `sent` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `easyblog_tb_sent_post_id` (`post_id`),
  KEY `easyblog_tb_sent_url` (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__easyblog_twitter_microblog`;
CREATE TABLE IF NOT EXISTS `#__easyblog_twitter_microblog` (
  `id_str` text NOT NULL,
  `oauth_id` int(11) NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `created` datetime NOT NULL,
  `tweet_author` text NOT NULL,
  KEY `post_id` (`post_id`),
  FULLTEXT KEY `id_str` (`id_str`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__easyblog_users`;
CREATE TABLE IF NOT EXISTS `#__easyblog_users` (
  `id` bigint(20) unsigned NOT NULL,
  `nickname` varchar(255) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `description` text,
  `url` varchar(255) DEFAULT NULL,
  `params` text,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `title` varchar(255) NOT NULL DEFAULT '',
  `biography` text,
  `permalink` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `easyblog_users_permalink` (`permalink`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__easyblog_users` (`id`, `nickname`, `avatar`, `description`, `url`, `params`, `published`, `title`, `biography`, `permalink`) VALUES
(660, 'Super User', 'default_blogger.png', '', 'http://', '{"google_profile_url":"","show_google_profile_url":"0"}', 1, '', '<p>Cras pretium tempor quam eget pretium. Curabitur nibh augue, pulvinar a sollicitudin at, dignissim ut quam. In hac habitasse platea dictumst. Morbi orci libero, consectetur sit amet est non, commodo iaculis odio. Quisque elementum erat at imperdiet cursus.</p>', 'admin');

DROP TABLE IF EXISTS `#__easyblog_xml_wpdata`;
CREATE TABLE IF NOT EXISTS `#__easyblog_xml_wpdata` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `session_id` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `source` varchar(15) NOT NULL,
  `data` longtext NOT NULL,
  `comments` longtext,
  PRIMARY KEY (`id`),
  KEY `xml_wpdate_session` (`session_id`),
  KEY `xml_wpdate_post_source` (`post_id`,`source`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE IF NOT EXISTS `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  `access` int(10) unsigned DEFAULT NULL,
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` text NOT NULL,
  `params` text NOT NULL,
  `custom_data` text NOT NULL,
  `system_data` text NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10144 ;

INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{"name":"com_mailto","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MAILTO_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{"name":"com_wrapper","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WRAPPER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{"name":"com_admin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_ADMIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{"name":"com_banners","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_BANNERS_XML_DESCRIPTION","group":""}', '{"purchase_type":"3","track_impressions":"0","track_clicks":"0","metakey_prefix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{"name":"com_cache","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CACHE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{"name":"com_categories","type":"component","creationDate":"December 2007","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{"name":"com_checkin","type":"component","creationDate":"Unknown","author":"Joomla! Project","copyright":"(C) 2005 - 2008 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CHECKIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{"name":"com_contact","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTACT_XML_DESCRIPTION","group":""}', '{"contact_layout":"_:default","show_contact_category":"hide","show_contact_list":"0","presentation_style":"plain","show_name":"1","show_position":"1","show_email":"1","show_street_address":"1","show_suburb":"1","show_state":"1","show_postcode":"1","show_country":"1","show_telephone":"1","show_mobile":"1","show_fax":"1","show_webpage":"1","show_misc":"1","show_image":"1","image":"","allow_vcard":"0","show_articles":"0","show_profile":"1","show_links":"1","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","contact_icons":"1","icon_address":"","icon_email":"","icon_telephone":"","icon_mobile":"","icon_fax":"","icon_misc":"","category_layout":"_:default","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"0","show_empty_categories":"0","show_subcat_desc":"0","show_cat_items":"0","show_base_description":"0","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"0","show_cat_items_cat":"0","show_pagination_limit":"1","show_headings":"1","show_position_headings":"1","show_email_headings":"1","show_telephone_headings":"1","show_mobile_headings":"1","show_fax_headings":"1","show_suburb_headings":"1","show_state_headings":"1","show_country_headings":"1","show_pagination":"2","show_pagination_results":"1","initial_sort":"ordering","captcha":"","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"0","custom_reply":"0","redirect":"","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{"name":"com_cpanel","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CPANEL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{"name":"com_installer","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_INSTALLER_XML_DESCRIPTION","group":""}', '{"cachetimeout":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{"name":"com_languages","type":"component","creationDate":"2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LANGUAGES_XML_DESCRIPTION","group":""}', '{"administrator":"en-GB","site":"en-GB"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{"name":"com_login","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{"name":"com_media","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MEDIA_XML_DESCRIPTION","group":""}', '{"upload_extensions":"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10","file_path":"images","image_path":"images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp,gif,jpg,png","ignore_extensions":"","upload_mime":"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip","upload_mime_illegal":"text\\/html","enable_flash":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{"name":"com_menus","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MENUS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{"name":"com_messages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MESSAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{"name":"com_modules","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MODULES_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{"name":"com_newsfeeds","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_NEWSFEEDS_XML_DESCRIPTION","group":""}', '{"newsfeed_layout":"_:default","save_history":"0","history_limit":5,"show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_character_count":"50","feed_display_order":"des","float_first":"right","float_second":"right","show_tags":"1","category_layout":"_:default","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"0","show_cat_items":"1","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_items_cat":"1","filter_field":"hide","show_pagination_limit":"0","show_headings":"1","show_articles":"0","show_link":"1","show_pagination":"1","show_pagination_results":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{"name":"com_plugins","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_PLUGINS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{"name":"com_search","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_SEARCH_XML_DESCRIPTION","group":""}', '{"enabled":"1","search_areas":"1","show_date":"1","opensearch_name":"Search ","opensearch_description":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{"name":"com_templates","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_TEMPLATES_XML_DESCRIPTION","group":""}', '{"template_positions_display":"1","upload_limit":"2","image_formats":"gif,bmp,jpg,jpeg,png","source_formats":"txt,less,ini,xml,js,php,css","font_formats":"woff,ttf,otf","compressed_formats":"zip"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(21, 'com_weblinks', 'component', 'com_weblinks', '', 1, 1, 1, 0, '{"name":"com_weblinks","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WEBLINKS_XML_DESCRIPTION","group":""}', '{"target":"0","save_history":"0","history_limit":5,"count_clicks":"1","icons":1,"link_icons":"","float_first":"right","float_second":"right","show_tags":"1","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"0","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"0","show_cat_num_links":"0","show_cat_tags":"1","show_base_description":"0","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"0","show_cat_num_links_cat":"0","filter_field":"1","show_pagination_limit":"0","show_headings":"1","show_link_description":"1","show_link_hits":"1","show_pagination":"2","show_pagination_results":"0","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{"name":"com_content","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTENT_XML_DESCRIPTION","group":""}', '{"article_layout":"_:default","show_title":"1","link_titles":"1","show_intro":"1","info_block_position":"0","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"1","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"1","show_readmore":"1","show_readmore_title":"0","readmore_limit":"100","show_tags":"0","show_icons":"1","show_print_icon":"1","show_email_icon":"1","show_hits":"0","show_noauth":"0","urls_position":"0","show_publishing_options":"1","show_article_options":"1","save_history":"0","history_limit":10,"show_urls_images_frontend":"1","show_urls_images_backend":"1","targeta":0,"targetb":0,"targetc":0,"float_intro":"left","float_fulltext":"none","category_layout":"_:blog","show_category_heading_title_text":"1","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"1","show_empty_categories":"0","show_no_articles":"1","show_subcat_desc":"1","show_cat_num_articles":"0","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_articles_cat":"1","num_leading_articles":"0","num_intro_articles":"3","num_columns":"1","num_links":"0","multi_column_order":"0","show_subcategory_content":"0","show_pagination_limit":"0","filter_field":"hide","show_headings":"1","list_show_date":"0","date_format":"","list_show_hits":"1","list_show_author":"1","orderby_pri":"order","orderby_sec":"order","order_date":"published","show_pagination":"2","show_pagination_results":"0","show_feed_link":"1","feed_summary":"0","feed_show_readmore":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{"name":"com_config","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONFIG_XML_DESCRIPTION","group":""}', '{"filters":{"1":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"6":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"7":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"2":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"3":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"4":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"5":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"10":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"12":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{"name":"com_redirect","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_REDIRECT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{"name":"com_users","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_USERS_XML_DESCRIPTION","group":""}', '{"allowUserRegistration":"1","new_usertype":"2","guest_usergroup":"1","sendpassword":"1","useractivation":"1","mail_to_admin":"1","captcha":"0","frontend_userparams":"1","site_language":"0","change_login_name":"0","reset_count":"10","reset_time":"1","minimum_length":"4","minimum_integers":"0","minimum_symbols":"0","minimum_uppercase":"0","save_history":"0","history_limit":5,"mailSubjectPrefix":"","mailBodySuffix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{"legacy":false,"name":"com_joomlaupdate","type":"component","creationDate":"February 2012","author":"Joomla! Project","copyright":"(C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.2","description":"COM_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{"name":"com_tags","type":"component","creationDate":"December 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"COM_TAGS_XML_DESCRIPTION","group":""}', '{"tag_layout":"_:default","save_history":"0","history_limit":5,"show_tag_title":"1","tag_list_show_tag_image":"1","tag_list_show_tag_description":"1","tag_list_image":"","show_tag_num_items":"1","tag_list_orderby":"c.core_title","tag_list_orderby_direction":"ASC","show_headings":"1","tag_list_show_date":"created","tag_list_show_item_image":"1","tag_list_show_item_description":"1","tag_list_item_maximum_characters":0,"return_any_or_all":"1","include_children":"0","maximum":200,"tag_list_language_filter":"all","tags_layout":"_:default","all_tags_orderby":"title","all_tags_orderby_direction":"ASC","all_tags_show_tag_image":"1","all_tags_show_tag_descripion":"1","all_tags_tag_maximum_characters":0,"all_tags_show_tag_hits":"0","filter_field":"0","show_pagination_limit":"0","show_pagination":"2","show_pagination_results":"1","tag_field_ajax_mode":"1","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{"name":"com_contenthistory","type":"component","creationDate":"May 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_CONTENTHISTORY_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 0, '{"name":"com_ajax","type":"component","creationDate":"August 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_AJAX_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{"name":"com_postinstall","type":"component","creationDate":"September 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_POSTINSTALL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(100, 'PHPMailer', 'library', 'phpmailer', '', 0, 1, 1, 1, '{"name":"PHPMailer","type":"library","creationDate":"2001","author":"PHPMailer","copyright":"(c) 2001-2003, Brent R. Matzelle, (c) 2004-2009, Andy Prevost. All Rights Reserved., (c) 2010-2013, Jim Jagielski. All Rights Reserved.","authorEmail":"jimjag@gmail.com","authorUrl":"https:\\/\\/github.com\\/PHPMailer\\/PHPMailer","version":"5.2.6","description":"LIB_PHPMAILER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(101, 'SimplePie', 'library', 'simplepie', '', 0, 1, 1, 1, '{"name":"SimplePie","type":"library","creationDate":"2004","author":"SimplePie","copyright":"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon","authorEmail":"","authorUrl":"http:\\/\\/simplepie.org\\/","version":"1.2","description":"LIB_SIMPLEPIE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 'phputf8', 'library', 'phputf8', '', 0, 1, 1, 1, '{"name":"phputf8","type":"library","creationDate":"2006","author":"Harry Fuecks","copyright":"Copyright various authors","authorEmail":"hfuecks@gmail.com","authorUrl":"http:\\/\\/sourceforge.net\\/projects\\/phputf8","version":"0.5","description":"LIB_PHPUTF8_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 'Joomla! Platform', 'library', 'joomla', '', 0, 1, 1, 1, '{"name":"Joomla! Platform","type":"library","creationDate":"2008","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"http:\\/\\/www.joomla.org","version":"13.1","description":"LIB_JOOMLA_XML_DESCRIPTION","group":""}', '{"mediaversion":"31fa53db35b52fdebe98e8036d6a723c"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 'IDNA Convert', 'library', 'idna_convert', '', 0, 1, 1, 1, '{"name":"IDNA Convert","type":"library","creationDate":"2004","author":"phlyLabs","copyright":"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de","authorEmail":"phlymail@phlylabs.de","authorUrl":"http:\\/\\/phlylabs.de","version":"0.8.0","description":"LIB_IDNA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{"name":"FOF","type":"library","creationDate":"2014-03-09 12:54:48","author":"Nicholas K. Dionysopoulos \\/ Akeeba Ltd","copyright":"(C)2011-2014 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"2.2.1","description":"LIB_FOF_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{"name":"mod_articles_archive","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters.\\n\\t\\tAll rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{"name":"mod_articles_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_NEWS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{"name":"mod_articles_popular","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{"name":"mod_banners","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BANNERS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{"name":"mod_breadcrumbs","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BREADCRUMBS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{"name":"mod_footer","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FOOTER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{"name":"mod_menu","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{"name":"mod_articles_news","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_NEWS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{"name":"mod_random_image","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RANDOM_IMAGE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{"name":"mod_related_items","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RELATED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{"name":"mod_search","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SEARCH_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{"name":"mod_stats","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{"name":"mod_syndicate","type":"module","creationDate":"May 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SYNDICATE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{"name":"mod_users_latest","type":"module","creationDate":"December 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_USERS_LATEST_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(217, 'mod_weblinks', 'module', 'mod_weblinks', '', 0, 1, 1, 0, '{"name":"mod_weblinks","type":"module","creationDate":"July 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WEBLINKS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{"name":"mod_whosonline","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WHOSONLINE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{"name":"mod_wrapper","type":"module","creationDate":"October 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WRAPPER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{"name":"mod_articles_category","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{"name":"mod_articles_categories","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{"name":"mod_languages","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LANGUAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{"name":"mod_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{"name":"mod_logged","type":"module","creationDate":"January 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGGED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"March 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{"name":"mod_menu","type":"module","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(306, 'mod_online', 'module', 'mod_online', '', 1, 1, 1, 0, '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{"name":"mod_popular","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{"name":"mod_quickicon","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_QUICKICON_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{"name":"mod_status","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATUS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{"name":"mod_submenu","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SUBMENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{"name":"mod_title","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TITLE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{"name":"mod_toolbar","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TOOLBAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 'mod_unread', 'module', 'mod_unread', '', 1, 1, 1, 0, '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{"name":"mod_stats_admin","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":""}', '{"serverinfo":"0","siteinfo":"0","counter":"0","increase":"0","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{"name":"mod_tags_popular","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_POPULAR_XML_DESCRIPTION","group":""}', '{"maximum":"5","timeframe":"alltime","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{"name":"mod_tags_similar","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_SIMILAR_XML_DESCRIPTION","group":""}', '{"maximum":"5","matchtype":"any","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_gmail","type":"plugin","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_GMAIL_XML_DESCRIPTION","group":""}', '{"applysuffix":"0","suffix":"","verifypeer":"1","user_blacklist":""}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{"name":"plg_authentication_joomla","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_JOOMLA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_ldap","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LDAP_XML_DESCRIPTION","group":""}', '{"host":"","port":"389","use_ldapV3":"0","negotiate_tls":"0","no_referrals":"0","auth_method":"bind","base_dn":"","search_string":"","users_dn":"","username":"admin","password":"bobby7","ldap_fullname":"fullName","ldap_email":"mail","ldap_uid":"uid"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(404, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{"name":"plg_content_emailcloak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION","group":""}', '{"mode":"1"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(405, 'plg_content_geshi', 'plugin', 'geshi', 'content', 0, 0, 1, 0, '{"legacy":false,"name":"plg_content_geshi","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"","authorUrl":"qbnz.com\\/highlighter","version":"3.0.0","description":"PLG_CONTENT_GESHI_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(406, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{"name":"plg_content_loadmodule","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOADMODULE_XML_DESCRIPTION","group":""}', '{"style":"none"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(407, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagebreak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION","group":""}', '{"title":"1","article_index":"1","article_index_text":"Article Index","multipage_toc":"1","showall":"1","style":"tabs"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagenavigation","type":"plugin","creationDate":"January 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_PAGENAVIGATION_XML_DESCRIPTION","group":""}', '{"position":"1"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{"name":"plg_content_vote","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_VOTE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_codemirror","type":"plugin","creationDate":"28 March 2011","author":"Marijn Haverbeke","copyright":"","authorEmail":"N\\/A","authorUrl":"","version":"3.15","description":"PLG_CODEMIRROR_XML_DESCRIPTION","group":""}', '{"lineNumbers":"1","lineWrapping":"1","matchTags":"1","matchBrackets":"1","marker-gutter":"1","autoCloseTags":"1","autoCloseBrackets":"1","autoFocus":"1","theme":"default","tabmode":"indent"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_none","type":"plugin","creationDate":"August 2004","author":"Unknown","copyright":"","authorEmail":"N\\/A","authorUrl":"","version":"3.0.0","description":"PLG_NONE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{"name":"plg_editors_tinymce","type":"plugin","creationDate":"2005-2013","author":"Moxiecode Systems AB","copyright":"Moxiecode Systems AB","authorEmail":"N\\/A","authorUrl":"tinymce.moxiecode.com","version":"4.0.22","description":"PLG_TINY_XML_DESCRIPTION","group":""}', '{"mode":"2","skin":"0","mobile":"0","entity_encoding":"raw","lang_mode":"0","text_direction":"ltr","content_css":"1","content_css_custom":"","relative_urls":"1","newlines":"0","invalid_elements":"script,applet,iframe","extended_elements":"","html_height":"550","html_width":"750","element_path":"1","fonts":"1","paste":"1","searchreplace":"1","insertdate":"1","colors":"1","table":"1","smilies":"1","hr":"1","link":"1","media":"1","print":"1","directionality":"1","fullscreen":"1","alignment":"1","visualchars":"1","visualblocks":"1","nonbreaking":"1","template":"1","blockquote":"1","wordcount":"1","image_advtab":"1","advlist":"1","autosave":"1","contextmenu":"1","inlinepopups":"1","custom_plugin":"","custom_button":""}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 1, '{"name":"plg_editors-xtd_article","type":"plugin","creationDate":"October 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_ARTICLE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_image","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_IMAGE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_pagebreak","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_readmore","type":"plugin","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_READMORE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{"name":"plg_search_categories","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{"name":"plg_search_contacts","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTACTS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{"name":"plg_search_content","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTENT_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(420, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{"name":"plg_search_newsfeeds","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(421, 'plg_search_weblinks', 'plugin', 'weblinks', 'search', 0, 1, 1, 0, '{"name":"plg_search_weblinks","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 1, 1, 1, '{"name":"plg_system_languagefilter","type":"plugin","creationDate":"July 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION","group":""}', '{"detect_browser":"0","automatic_change":"1","item_associations":"1","remove_default_prefix":"1","lang_cookie":"0","alternate_meta":"1"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{"name":"plg_system_p3p","type":"plugin","creationDate":"September 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_P3P_XML_DESCRIPTION","group":""}', '{"headers":"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{"name":"plg_system_cache","type":"plugin","creationDate":"February 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CACHE_XML_DESCRIPTION","group":""}', '{"browsercache":"0","cachetime":"15"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(425, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{"name":"plg_system_debug","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_DEBUG_XML_DESCRIPTION","group":""}', '{"profile":"1","queries":"1","memory":"1","language_files":"1","language_strings":"1","strip-first":"1","strip-prefix":"","strip-suffix":""}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{"name":"plg_system_log","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOG_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 1, 1, 1, '{"name":"plg_system_redirect","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REDIRECT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{"name":"plg_system_remember","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REMEMBER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{"name":"plg_system_sef","type":"plugin","creationDate":"December 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEF_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(430, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{"name":"plg_system_logout","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(431, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{"name":"plg_user_contactcreator","type":"plugin","creationDate":"August 2009","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTACTCREATOR_XML_DESCRIPTION","group":""}', '{"autowebpage":"","category":"34","autopublish":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{"name":"plg_user_joomla","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2009 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_JOOMLA_XML_DESCRIPTION","group":""}', '{"autoregister":"1"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 0, '{"name":"plg_user_profile","type":"plugin","creationDate":"January 2008","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_PROFILE_XML_DESCRIPTION","group":""}', '{"register-require_address1":"1","register-require_address2":"1","register-require_city":"1","register-require_region":"1","register-require_country":"1","register-require_postal_code":"1","register-require_phone":"1","register-require_website":"1","register-require_favoritebook":"1","register-require_aboutme":"1","register-require_tos":"1","register-require_dob":"1","profile-require_address1":"1","profile-require_address2":"1","profile-require_city":"1","profile-require_region":"1","profile-require_country":"1","profile-require_postal_code":"1","profile-require_phone":"1","profile-require_website":"1","profile-require_favoritebook":"1","profile-require_aboutme":"1","profile-require_tos":"1","profile-require_dob":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{"name":"plg_extension_joomla","type":"plugin","creationDate":"May 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{"name":"plg_content_joomla","type":"plugin","creationDate":"November 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_JOOMLA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(447, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_tags","type":"plugin","creationDate":"February 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_TAGS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_totp","type":"plugin","creationDate":"August 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{"name":"plg_authentication_cookie","type":"plugin","creationDate":"July 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_COOKIE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_yubikey","type":"plugin","creationDate":"Se[ptember 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 0, 1, 0, '{"name":"plg_search_tags","type":"plugin","creationDate":"March 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_TAGS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","show_tagged_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 'English (United Kingdom)', 'language', 'en-GB', '', 0, 1, 1, 1, '{"name":"English (United Kingdom)","type":"language","creationDate":"2013-03-07","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.3.0","description":"en-GB site language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 'English (United Kingdom)', 'language', 'en-GB', '', 1, 1, 1, 1, '{"name":"English (United Kingdom)","type":"language","creationDate":"2013-03-07","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.3.0","description":"en-GB administrator language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{"name":"files_joomla","type":"file","creationDate":"April 2014","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.3.0","description":"FILES_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10005, 'PKG_JOOMLA', 'package', 'pkg_joomla', '', 0, 1, 1, 1, '{"legacy":false,"name":"PKG_JOOMLA","type":"package","creationDate":"2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"http:\\/\\/www.joomla.org","version":"2.5.0","description":"PKG_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10011, 'YT Framework', 'plugin', 'yt', 'system', 0, 1, 1, 0, '{"name":"YT Framework","type":"plugin","creationDate":"01 March 2014","author":"YouTech Company","copyright":"","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"2.2.4","description":"YT_DESC","group":""}', '{"show_sjhelp":1,"no_jquery":"com_virtuemart"}', '', '', 315, '2014-02-28 10:21:43', 0, 0),
(10037, 'VM - Search, Virtuemart Product', 'plugin', 'virtuemart', 'search', 0, 1, 1, 0, '{"legacy":false,"name":"plg_search_virtuemart","type":"plugin","creationDate":"Febuary 2010","author":"P.Kohl - Studio42","copyright":"Copyright (C) 2010 Virtuemart. All rights reserved.","authorEmail":"contact@st42.fr","authorUrl":"www.virtuemart.net","version":"1.5","description":"Allows Searching of VirtueMart Component","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10048, 'com_finder', 'component', 'com_finder', '', 1, 1, 1, 0, '{"legacy":false,"name":"com_finder","type":"component","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_FINDER_XML_DESCRIPTION","group":""}', '{"enabled":"0","show_description":"0","description_length":255,"allow_empty_query":"0","show_url":"1","show_autosuggest":"0","show_advanced":"1","show_advanced_tips":"1","expand_advanced":"0","show_date_filters":"0","sort_order":"relevance","sort_direction":"desc","highlight_terms":"1","opensearch_name":"","opensearch_description":"","batch_size":"10","memory_table_limit":30000,"title_multiplier":"1.7","text_multiplier":"0.7","meta_multiplier":"1.2","path_multiplier":"2.0","misc_multiplier":"0.3","stem":"1","stemmer":"snowball","enable_logging":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10049, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_finder","type":"module","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_FINDER_XML_DESCRIPTION","group":""}', '{"searchfilter":"","show_autosuggest":"1","show_advanced":"0","moduleclass_sfx":"","field_size":"25","show_label":"1","label_pos":"top","show_button":"0","button_pos":"right","opensearch":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10050, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{"name":"mod_multilangstatus","type":"module","creationDate":"September 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MULTILANGSTATUS_XML_DESCRIPTION","group":""}', '{"cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10051, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_version","type":"module","creationDate":"January 2012","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_VERSION_XML_DESCRIPTION","group":""}', '{"format":"short","product":"1","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10052, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 1, 1, 0, '{"name":"plg_captcha_recaptcha","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION","group":""}', '{"public_key":"6Ld7TM4SAAAAAFZzsZ9ujKCLFyYVQzAd0HTzQ7V_","private_key":"6Ld7TM4SAAAAABsGZDz2hllR0VD6hihcZeAiRdiL","theme":"clean"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10053, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 1, 1, 0, '{"legacy":false,"name":"plg_content_finder","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_CONTENT_FINDER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10054, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_categories","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CATEGORIES_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10055, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_contacts","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTACTS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10056, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_content","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTENT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10057, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_newsfeeds","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10058, 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_weblinks","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_WEBLINKS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10059, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 0, '{"name":"plg_quickicon_extensionupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION","group":""}', '{"context":"mod_quickicon"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10060, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 0, '{"name":"plg_quickicon_joomlaupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '{"context":"mod_quickicon"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10061, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 0, 1, 0, '{"legacy":false,"name":"plg_system_highlight","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10062, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 1, 1, 0, '{"name":"plg_system_languagecode","type":"plugin","creationDate":"November 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10079, 'Sj Content Related News', 'plugin', 'relatednews', 'content', 0, 1, 1, 0, '{"legacy":false,"name":"Sj Content Related News","type":"plugin","creationDate":"January 2012","author":"YouTech Company","copyright":"Copyright (c) 2012 YouTech Company","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"1.0","description":"SJ_XML_DESCRIPTION","group":""}', '{"depends":["78","79","80","81"],"title":"Related Items:","show_child_category_articles":"0","levels":"1","show_front":"show","article_ordering":"fp.ordering","article_ordering_direction":"ASC","count":"4","item_title_max_characs":"25","item_image_display":"1","item_date_display":"0","imgcfg_from_image_intro":"1","imgcfg_from_image_fulltext":"1","imgcfg_from_inline_introtext":"1","imgcfg_from_inline_fulltext":"1","imgcfg_from_external":"1","imgcfg_external_url":"images","imgcfg_order":"image_intro, image_fulltext, inline_introtext, inline_fulltext, external","imgcfg_function":"resize_stretch","imgcfg_type":"","imgcfg_transparency":"0","imgcfg_width":"185","imgcfg_height":"85","imgcfg_background":"#000000","imgcfg_cache":"cache\\/resized","imgcfg_cache_url":"cache\\/resized\\/","imgcfg_placeholder":"1","imgcfg_placeholder_path":"plugins\\/content\\/relatednews\\/assets\\/images\\/nophoto.png","item_link_target":"_self","usecss":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10084, 'YT Shortcodes', 'plugin', 'ytshortcodes', 'system', 0, 1, 1, 0, '{"name":"YT Shortcodes","type":"plugin","creationDate":"01 Marc 2013","author":"YouTech Company","copyright":"Copyright (C) 2010 YouTech Company","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"1.2.1","description":"YT_DESC","group":""}', '{"show_sjawesome":1,"show_sjbootstrap":0,"show_sjjquery":0,"show_sjprettify":1}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10091, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{"name":"isis","type":"template","creationDate":"3\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_ISIS_XML_DESCRIPTION","group":""}', '{"templateColor":"","logoFile":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10092, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{"name":"protostar","type":"template","creationDate":"4\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_PROTOSTAR_XML_DESCRIPTION","group":""}', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10094, 'plg_installer_webinstaller', 'plugin', 'webinstaller', 'installer', 0, 1, 1, 0, '{"name":"plg_installer_webinstaller","type":"plugin","creationDate":"18 December 2013","author":"Joomla! Project","copyright":"Copyright (C) 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"1.0.5","description":"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION","group":""}', '{"tab_position":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10095, 'jw_disqus', 'component', 'com_jw_disqus', '', 1, 0, 0, 0, '{"name":"JW_DISQUS","type":"component","creationDate":"October 2nd, 2013","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"3.4","description":"Thank you for installing DISQUS Comments for Joomla! (by JoomlaWorks).","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10096, 'DISQUS Comments for Joomla! (by JoomlaWorks)', 'plugin', 'jw_disqus', 'content', 0, 1, 1, 0, '{"name":"DISQUS Comments for Joomla! (by JoomlaWorks)","type":"plugin","creationDate":"October 2nd, 2013","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"3.4","description":"JW_DISQUS_THANK_YOU_FOR_INSTALLING_JOOMLAWORKS_DISQUS_COMMENTS_FOR_JOOMLA","group":""}', '{"disqusSubDomain":"smartaddons","disqusLanguage":"","selectedCategories":["78","79","80","81"],"selectedMenus":[""],"disqusListingCounter":"0","disqusArticleCounter":"0","disqusDevMode":"0"}', '', '', 0, '0000-00-00 00:00:00', 99, 0),
(10097, 'System - DISQUS Comments for Joomla! (by JoomlaWorks)', 'plugin', 'jw_disqus', 'system', 0, 1, 1, 0, '{"name":"System - DISQUS Comments for Joomla! (by JoomlaWorks)","type":"plugin","creationDate":"October 2nd, 2013","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"3.4","description":"JW_DISQUS_SYSTEM_PLUGIN_DESC","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 99, 0),
(10100, 'ArabicUnitag', 'language', 'ar-AA', '', 0, 1, 0, 0, '{"name":"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)","type":"language","creationDate":"25 February 2014","author":"Dr. Ashraf Damra\\/Abu Nidal","copyright":"Copyright (C) 2005 - 2014 Dr. Ashraf Damra\\/Abu Nidal and Open Source Matters. All rights reserved.","authorEmail":"","authorUrl":"","version":"3.2.3","description":"Arabic Unitag site language pack for Joomla! 3.1.5 \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\\/\\u0627\\u0644\\u0645\\u0648\\u0642\\u0639","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10101, 'ArabicUnitag', 'language', 'ar-AA', '', 1, 1, 0, 0, '{"name":"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)","type":"language","creationDate":"25 February 2014","author":"Dr. Ashraf Damra\\/Abu Nidal","copyright":"Copyright (C) 2005 - 2014 Dr. Ashraf Damra\\/Abu Nidal and Open Source Matters. All rights reserved.","authorEmail":"dr.d.ashraf@gmail.com","authorUrl":"www.jarabic.com","version":"3.2.3","description":"Arabic Unitag Administrator language 3.2 \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\\/\\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10102, 'ar-AA', 'package', 'pkg_ar-AA', '', 0, 1, 1, 0, '{"name":"Arabic Unitag Language Package - \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629","type":"package","creationDate":"25 February 2014","author":"Dr. Ashraf Damra\\/Abu Nidal","copyright":"Copyright (C) 2005 - 2014 Open Source Matters & Dr. Ashraf Damra\\/Abu Nidal. All rights reserved.","authorEmail":"dr.d.ashraf@gmail.com","authorUrl":"www.jarabic.com","version":"3.2.3.1","description":"\\n\\t    <h3>\\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629 \\u0644\\u0646\\u0638\\u0627\\u0645 \\u062c\\u0648\\u0645\\u0644\\u0627! 3.2.3 \\u0627\\u0644\\u0627\\u0635\\u062f\\u0627\\u0631 1<\\/h3>\\n\\t\\t<h3>Arabic Unitag Language Package for Joomla! 3.2.3 version 1<\\/h3>\\n\\t\\t\\n   ","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10103, 'Frenchfr-FR', 'language', 'fr-FR', '', 0, 1, 0, 0, '{"name":"French (fr-FR)","type":"language","creationDate":"February 2014","author":"French translation team : joomla.fr","copyright":"Copyright (C) 2005 - 2014 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s","authorEmail":"traduction@joomla.fr","authorUrl":"www.joomla.fr","version":"3.2.3.1","description":"fr-FR site language for 3.2","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10104, 'Frenchfr-FR', 'language', 'fr-FR', '', 1, 1, 0, 0, '{"name":"French (fr-FR)","type":"language","creationDate":"February 2014","author":"French translation team : joomla.fr","copyright":"Copyright (C) 2005 - 2014 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s","authorEmail":"traduction@joomla.fr","authorUrl":"www.joomla.fr","version":"3.2.3.1","description":"fr-FR administrator language","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10105, 'fr-FR', 'package', 'pkg_fr-FR', '', 0, 1, 1, 0, '{"name":"French Language Pack","type":"package","creationDate":"February 2014","author":"French translation team : joomla.fr","copyright":"Copyright (C) 2005 - 2014 joomla.fr et Open Source Matters. Tous droits r\\u00e9serv\\u00e9s","authorEmail":"traduction@joomla.fr","authorUrl":"www.joomla.fr","version":"3.2.3.1","description":"\\n\\t\\t\\n\\t\\t<div style=\\"text-align:left;\\">\\n\\t\\t<h3>Joomla! 3.2.3 Full French (fr-FR) Language Package - Version 3.2.3v1<\\/h3>\\n\\t\\t<h3>Paquet de langue Joomla! 3.2.3 fran\\u00e7ais (fr-FR) complet - Version 3.2.3v1<\\/h3>\\n\\t\\t<\\/div>\\n\\t\\t\\n\\t","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10107, 'com_easyblog', 'component', 'com_easyblog', '', 1, 1, 0, 0, '{"name":"com_easyblog","type":"component","creationDate":"12\\/02\\/2010","author":"Stack Ideas","copyright":"Copyright 2009-2012 Stack Ideas. All rights reserved","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/www.stackideas.com","version":"3.9.15633","description":"\\n\\t\\tEasyBlog is a Joomla! blogging component that transforms your Joomla! site into a powerful multi-blogging website.\\n\\t","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10108, 'plg_system_k2_reslisting_ajax', 'plugin', 'k2_reslisting_ajax', 'system', 0, 1, 1, 0, '{"name":"plg_system_k2_reslisting_ajax","type":"plugin","creationDate":"March 2013","author":"YouTech Company","copyright":"Copyright (c) 2009-2013 YouTech Company. All rights reserved.","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"2.5","description":"TPL_YTFRAMEWORK_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10109, 'sj_icenter', 'template', 'sj_icenter', '', 0, 1, 1, 0, '{"name":"sj_icenter","type":"template","creationDate":"2\\/4\\/14","author":"YouTech Company","copyright":"","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"1.0.0","description":"TPL_YTFRAMEWORK_XML_DESCRIPTION","group":"yt_framework"}', '{"hideComponentHomePage":"0","responsive":"1","templateLayout":"main-left-right","menutype":"mainmenu","menustyle":"mega","keepMenu":"1","fancyMenu":"1","responsiveMenu":"mega","moofx":"easeInOutCirc","moofxduration":"500","startlevel":"0","endlevel":"9","templateColor":"blue","logoType":"image","logoText":"SmartAddons.Com","sloganText":"The high quality products","typelayout":"wide","bgcolor":"#ffffff","linkcolor":"#0083e8","textcolor":"#666666","bgimage":"pattern3","header-bgcolor":"#f1f1f1","header-bgimage":"pattern1","footer-bgcolor":"#141414","footer-bgimage":"pattern4","fontSize":"14px","fontName":"arial","googleWebFont":"Titillium Web","googleWebFontTargets":"h1,h2,h3,h4,h5,h6","direction":"ltr","thumbnail":"1","thumbnail_front_page":"1","leading_width":"540","leading_height":"290","intro_width":"540","intro_height":"290","thumbnail_background":"#000000","thumbnail_mode":"stretch","developing":"1","compileLess":"server","optimizeMergeFile":"0","optimizeCSS":"0","optimizeCSSExclude":"","optimizeJS":"0","optimizeJSExclude":"respond.min.js","optimizeFolder":"yt-assets","showBacktotop":"1","showCpanel":"1","useSpecialPositions":"1","activeNotice":"1","setGeneratorTag":"SmartAddons.Com - the high quality products!","enableGoogleAnalytics":"1","googleAnalyticsTrackingID":"","includeLazyload":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10110, 'com_k2', 'component', 'com_k2', '', 1, 1, 0, 0, '{"name":"COM_K2","type":"component","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"Thank you for installing K2 by JoomlaWorks, the powerful content extension for Joomla!","group":""}', '{"enable_css":"1","jQueryHandling":"1.8remote","backendJQueryHandling":"local","userName":"1","userImage":"1","userDescription":"1","userURL":"1","userEmail":"0","userFeedLink":"0","userFeedIcon":"0","userItemCount":"4","userItemTitle":"1","userItemTitleLinked":"1","userItemDateCreated":"1","userItemImage":"1","userItemIntroText":"1","userItemCategory":"0","userItemTags":"0","userItemCommentsAnchor":"1","userItemReadMore":"0","userItemK2Plugins":"1","tagItemCount":"4","tagItemTitle":"1","tagItemTitleLinked":"1","tagItemDateCreated":"1","tagItemImage":"1","tagItemIntroText":"1","tagItemCategory":"0","tagItemReadMore":"0","tagItemExtraFields":"0","tagOrdering":"","tagFeedLink":"0","tagFeedIcon":"0","genericItemCount":"4","genericItemTitle":"1","genericItemTitleLinked":"1","genericItemDateCreated":"1","genericItemImage":"0","genericItemIntroText":"1","genericItemCategory":"0","genericItemReadMore":"1","genericItemExtraFields":"0","genericFeedLink":"0","genericFeedIcon":"0","feedLimit":"10","feedItemImage":"1","feedImgSize":"S","feedItemIntroText":"1","feedTextWordLimit":"100","feedItemFullText":"1","feedItemTags":"0","feedItemVideo":"0","feedItemGallery":"0","feedItemAttachments":"0","feedBogusEmail":"","introTextCleanup":"0","introTextCleanupExcludeTags":"","introTextCleanupTagAttr":"","fullTextCleanup":"0","fullTextCleanupExcludeTags":"","fullTextCleanupTagAttr":"","xssFiltering":"0","linkPopupWidth":"900","linkPopupHeight":"600","imagesQuality":"100","itemImageXS":"200","itemImageS":"250","itemImageM":"400","itemImageL":"600","itemImageXL":"900","itemImageGeneric":"500","catImageWidth":"100","catImageDefault":"1","userImageWidth":"100","userImageDefault":"1","commenterImgWidth":"48","onlineImageEditor":"splashup","imageTimestamp":"0","imageMemoryLimit":"","socialButtonCode":"","twitterUsername":"","facebookImage":"XSmall","comments":"1","commentsOrdering":"DESC","commentsLimit":"3","commentsFormPosition":"below","commentsPublishing":"1","commentsReporting":"2","commentsReportRecipient":"","inlineCommentsModeration":"0","gravatar":"0","antispam":"0","recaptchaForRegistered":"0","akismetForRegistered":"0","commentsFormNotes":"1","commentsFormNotesText":"","frontendEditing":"1","showImageTab":"1","showImageGalleryTab":"1","showVideoTab":"1","showExtraFieldsTab":"1","showAttachmentsTab":"1","showK2Plugins":"1","sideBarDisplayFrontend":"0","mergeEditors":"1","sideBarDisplay":"1","attachmentsFolder":"","hideImportButton":"0","googleSearch":"0","googleSearchContainer":"k2GoogleSearchContainer","K2UserProfile":"0","redirect":"701","adminSearch":"simple","cookieDomain":"","taggingSystem":"1","lockTags":"0","showTagFilter":"0","k2TagNorm":"0","k2TagNormCase":"lower","k2TagNormAdditionalReplacements":"","recaptcha_public_key":"","recaptcha_private_key":"","recaptcha_theme":"clean","recaptchaOnRegistration":"0","akismetApiKey":"","stopForumSpam":"0","stopForumSpamApiKey":"","showItemsCounterAdmin":"1","showChildCatItems":"1","disableCompactOrdering":"0","metaDescLimit":"150","enforceSEFReplacements":"0","SEFReplacements":"\\u00c0|A, \\u00c1|A, \\u00c2|A, \\u00c3|A, \\u00c4|A, \\u00c5|A, \\u00e0|a, \\u00e1|a, \\u00e2|a, \\u00e3|a, \\u00e4|a, \\u00e5|a, \\u0100|A, \\u0101|a, \\u0102|A, \\u0103|a, \\u0104|A, \\u0105|a, \\u00c7|C, \\u00e7|c, \\u0106|C, \\u0107|c, \\u0108|C, \\u0109|c, \\u010a|C, \\u010b|c, \\u010c|C, \\u010d|c, \\u00d0|D, \\u00f0|d, \\u010e|D, \\u010f|d, \\u0110|D, \\u0111|d, \\u00c8|E, \\u00c9|E, \\u00ca|E, \\u00cb|E, \\u00e8|e, \\u00e9|e, \\u00ea|e, \\u00eb|e, \\u0112|E, \\u0113|e, \\u0114|E, \\u0115|e, \\u0116|E, \\u0117|e, \\u0118|E, \\u0119|e, \\u011a|E, \\u011b|e, \\u011c|G, \\u011d|g, \\u011e|G, \\u011f|g, \\u0120|G, \\u0121|g, \\u0122|G, \\u0123|g, \\u0124|H, \\u0125|h, \\u0126|H, \\u0127|h, \\u00cc|I, \\u00cd|I, \\u00ce|I, \\u00cf|I, \\u00ec|i, \\u00ed|i, \\u00ee|i, \\u00ef|i, \\u0128|I, \\u0129|i, \\u012a|I, \\u012b|i, \\u012c|I, \\u012d|i, \\u012e|I, \\u012f|i, \\u0130|I, \\u0131|i, \\u0134|J, \\u0135|j, \\u0136|K, \\u0137|k, \\u0138|k, \\u0139|L, \\u013a|l, \\u013b|L, \\u013c|l, \\u013d|L, \\u013e|l, \\u013f|L, \\u0140|l, \\u0141|L, \\u0142|l, \\u00d1|N, \\u00f1|n, \\u0143|N, \\u0144|n, \\u0145|N, \\u0146|n, \\u0147|N, \\u0148|n, \\u0149|n, \\u014a|N, \\u014b|n, \\u00d2|O, \\u00d3|O, \\u00d4|O, \\u00d5|O, \\u00d6|O, \\u00d8|O, \\u00f2|o, \\u00f3|o, \\u00f4|o, \\u00f5|o, \\u00f6|o, \\u00f8|o, \\u014c|O, \\u014d|o, \\u014e|O, \\u014f|o, \\u0150|O, \\u0151|o, \\u0154|R, \\u0155|r, \\u0156|R, \\u0157|r, \\u0158|R, \\u0159|r, \\u015a|S, \\u015b|s, \\u015c|S, \\u015d|s, \\u015e|S, \\u015f|s, \\u0160|S, \\u0161|s, \\u017f|s, \\u0162|T, \\u0163|t, \\u0164|T, \\u0165|t, \\u0166|T, \\u0167|t, \\u00d9|U, \\u00da|U, \\u00db|U, \\u00dc|U, \\u00f9|u, \\u00fa|u, \\u00fb|u, \\u00fc|u, \\u0168|U, \\u0169|u, \\u016a|U, \\u016b|u, \\u016c|U, \\u016d|u, \\u016e|U, \\u016f|u, \\u0170|U, \\u0171|u, \\u0172|U, \\u0173|u, \\u0174|W, \\u0175|w, \\u00dd|Y, \\u00fd|y, \\u00ff|y, \\u0176|Y, \\u0177|y, \\u0178|Y, \\u0179|Z, \\u017a|z, \\u017b|Z, \\u017c|z, \\u017d|Z, \\u017e|z, \\u03b1|a, \\u03b2|b, \\u03b3|g, \\u03b4|d, \\u03b5|e, \\u03b6|z, \\u03b7|h, \\u03b8|th, \\u03b9|i, \\u03ba|k, \\u03bb|l, \\u03bc|m, \\u03bd|n, \\u03be|x, \\u03bf|o, \\u03c0|p, \\u03c1|r, \\u03c3|s, \\u03c4|t, \\u03c5|y, \\u03c6|f, \\u03c7|ch, \\u03c8|ps, \\u03c9|w, \\u0391|A, \\u0392|B, \\u0393|G, \\u0394|D, \\u0395|E, \\u0396|Z, \\u0397|H, \\u0398|Th, \\u0399|I, \\u039a|K, \\u039b|L, \\u039c|M, \\u039e|X, \\u039f|O, \\u03a0|P, \\u03a1|R, \\u03a3|S, \\u03a4|T, \\u03a5|Y, \\u03a6|F, \\u03a7|Ch, \\u03a8|Ps, \\u03a9|W, \\u03ac|a, \\u03ad|e, \\u03ae|h, \\u03af|i, \\u03cc|o, \\u03cd|y, \\u03ce|w, \\u0386|A, \\u0388|E, \\u0389|H, \\u038a|I, \\u038c|O, \\u038e|Y, \\u038f|W, \\u03ca|i, \\u0390|i, \\u03cb|y, \\u03c2|s, \\u0410|A, \\u04d0|A, \\u04d2|A, \\u04d8|E, \\u04da|E, \\u04d4|E, \\u0411|B, \\u0412|V, \\u0413|G, \\u0490|G, \\u0403|G, \\u0492|G, \\u04f6|G, y|Y, \\u0414|D, \\u0415|E, \\u0400|E, \\u0401|YO, \\u04d6|E, \\u04bc|E, \\u04be|E, \\u0404|YE, \\u0416|ZH, \\u04c1|DZH, \\u0496|ZH, \\u04dc|DZH, \\u0417|Z, \\u0498|Z, \\u04de|DZ, \\u04e0|DZ, \\u0405|DZ, \\u0418|I, \\u040d|I, \\u04e4|I, \\u04e2|I, \\u0406|I, \\u0407|JI, \\u04c0|I, \\u0419|Y, \\u048a|Y, \\u0408|J, \\u041a|K, \\u049a|Q, \\u049e|Q, \\u04a0|K, \\u04c3|Q, \\u049c|K, \\u041b|L, \\u04c5|L, \\u0409|L, \\u041c|M, \\u04cd|M, \\u041d|N, \\u04c9|N, \\u04a2|N, \\u04c7|N, \\u04a4|N, \\u040a|N, \\u041e|O, \\u04e6|O, \\u04e8|O, \\u04ea|O, \\u04a8|O, \\u041f|P, \\u04a6|PF, \\u0420|P, \\u048e|P, \\u0421|S, \\u04aa|S, \\u0422|T, \\u04ac|TH, \\u040b|T, \\u040c|K, \\u0423|U, \\u040e|U, \\u04f2|U, \\u04f0|U, \\u04ee|U, \\u04ae|U, \\u04b0|U, \\u0424|F, \\u0425|H, \\u04b2|H, \\u04ba|H, \\u0426|TS, \\u04b4|TS, \\u0427|CH, \\u04f4|CH, \\u04b6|CH, \\u04cb|CH, \\u04b8|CH, \\u040f|DZ, \\u0428|SH, \\u0429|SHT, \\u042a|A, \\u042b|Y, \\u04f8|Y, \\u042c|Y, \\u048c|Y, \\u042d|E, \\u04ec|E, \\u042e|YU, \\u042f|YA, \\u0430|a, \\u04d1|a, \\u04d3|a, \\u04d9|e, \\u04db|e, \\u04d5|e, \\u0431|b, \\u0432|v, \\u0433|g, \\u0491|g, \\u0453|g, \\u0493|g, \\u04f7|g, y|y, \\u0434|d, \\u0435|e, \\u0450|e, \\u0451|yo, \\u04d7|e, \\u04bd|e, \\u04bf|e, \\u0454|ye, \\u0436|zh, \\u04c2|dzh, \\u0497|zh, \\u04dd|dzh, \\u0437|z, \\u0499|z, \\u04df|dz, \\u04e1|dz, \\u0455|dz, \\u0438|i, \\u045d|i, \\u04e5|i, \\u04e3|i, \\u0456|i, \\u0457|ji, \\u04c0|i, \\u0439|y, \\u048b|y, \\u0458|j, \\u043a|k, \\u049b|q, \\u049f|q, \\u04a1|k, \\u04c4|q, \\u049d|k, \\u043b|l, \\u04c6|l, \\u0459|l, \\u043c|m, \\u04ce|m, \\u043d|n, \\u04ca|n, \\u04a3|n, \\u04c8|n, \\u04a5|n, \\u045a|n, \\u043e|o, \\u04e7|o, \\u04e9|o, \\u04eb|o, \\u04a9|o, \\u043f|p, \\u04a7|pf, \\u0440|p, \\u048f|p, \\u0441|s, \\u04ab|s, \\u0442|t, \\u04ad|th, \\u045b|t, \\u045c|k, \\u0443|u, \\u045e|u, \\u04f3|u, \\u04f1|u, \\u04ef|u, \\u04af|u, \\u04b1|u, \\u0444|f, \\u0445|h, \\u04b3|h, \\u04bb|h, \\u0446|ts, \\u04b5|ts, \\u0447|ch, \\u04f5|ch, \\u04b7|ch, \\u04cc|ch, \\u04b9|ch, \\u045f|dz, \\u0448|sh, \\u0449|sht, \\u044a|a, \\u044b|y, \\u04f9|y, \\u044c|y, \\u048d|y, \\u044d|e, \\u04ed|e, \\u044e|yu, \\u044f|ya","k2Sef":"0","k2SefLabelCat":"content","k2SefLabelTag":"tag","k2SefLabelUser":"author","k2SefLabelSearch":"search","k2SefLabelDate":"date","k2SefLabelItem":"0","k2SefLabelItemCustomPrefix":"","k2SefInsertItemId":"1","k2SefItemIdTitleAliasSep":"dash","k2SefUseItemTitleAlias":"1","k2SefInsertCatId":"1","k2SefCatIdTitleAliasSep":"dash","k2SefUseCatTitleAlias":"1","sh404SefLabelCat":"","sh404SefLabelUser":"blog","sh404SefLabelItem":"2","sh404SefTitleAlias":"alias","sh404SefModK2ContentFeedAlias":"feed","sh404SefInsertItemId":"0","sh404SefInsertUniqueItemId":"0","cbIntegration":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10111, 'plg_finder_k2', 'plugin', 'k2', 'finder', 0, 0, 1, 0, '{"name":"plg_finder_k2","type":"plugin","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"PLG_FINDER_K2_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10112, 'Search - K2', 'plugin', 'k2', 'search', 0, 1, 1, 0, '{"name":"Search - K2","type":"plugin","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_THIS_PLUGIN_EXTENDS_THE_DEFAULT_JOOMLA_SEARCH_FUNCTIONALITY_TO_K2_CONTENT","group":""}', '{"search_limit":"50","search_tags":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10113, 'System - K2', 'plugin', 'k2', 'system', 0, 1, 1, 0, '{"name":"System - K2","type":"plugin","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_THE_K2_SYSTEM_PLUGIN_IS_USED_TO_ASSIST_THE_PROPER_FUNCTIONALITY_OF_THE_K2_COMPONENT_SITE_WIDE_MAKE_SURE_ITS_ALWAYS_PUBLISHED_WHEN_THE_K2_COMPONENT_IS_INSTALLED","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10114, 'User - K2', 'plugin', 'k2', 'user', 0, 1, 1, 0, '{"name":"User - K2","type":"plugin","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_A_USER_SYNCHRONIZATION_PLUGIN_FOR_K2","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10115, 'Josetta - K2 Categories', 'plugin', 'k2category', 'josetta_ext', 0, 1, 1, 0, '{"name":"Josetta - K2 Categories","type":"plugin","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10116, 'Josetta - K2 Items', 'plugin', 'k2item', 'josetta_ext', 0, 1, 1, 0, '{"name":"Josetta - K2 Items","type":"plugin","creationDate":"June 7th, 2012","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10117, 'K2 Comments', 'module', 'mod_k2_comments', '', 0, 1, 0, 0, '{"name":"K2 Comments","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"MOD_K2_COMMENTS_DESCRIPTION","group":""}', '{"moduleclass_sfx":"","module_usage":"","":"K2_TOP_COMMENTERS","catfilter":"0","category_id":"","comments_limit":"5","comments_word_limit":"10","commenterName":"1","commentAvatar":"1","commentAvatarWidthSelect":"custom","commentAvatarWidth":"50","commentDate":"1","commentDateFormat":"absolute","commentLink":"1","itemTitle":"1","itemCategory":"1","feed":"1","commenters_limit":"5","commenterNameOrUsername":"1","commenterAvatar":"1","commenterAvatarWidthSelect":"custom","commenterAvatarWidth":"50","commenterLink":"1","commenterCommentsCounter":"1","commenterLatestComment":"1","cache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10118, 'K2 Content', 'module', 'mod_k2_content', '', 0, 1, 0, 0, '{"name":"K2 Content","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_MOD_K2_CONTENT_DESCRIPTION","group":""}', '{"moduleclass_sfx":"","getTemplate":"Default","source":"filter","":"K2_OTHER_OPTIONS","catfilter":"0","category_id":"","getChildren":"0","itemCount":"5","itemsOrdering":"","FeaturedItems":"1","popularityRange":"","videosOnly":"0","item":"","items":"","itemTitle":"1","itemAuthor":"1","itemAuthorAvatar":"1","itemAuthorAvatarWidthSelect":"custom","itemAuthorAvatarWidth":"50","userDescription":"1","itemIntroText":"1","itemIntroTextWordLimit":"","itemImage":"1","itemImgSize":"Small","itemVideo":"1","itemVideoCaption":"1","itemVideoCredits":"1","itemAttachments":"1","itemTags":"1","itemCategory":"1","itemDateCreated":"1","itemHits":"1","itemReadMore":"1","itemExtraFields":"0","itemCommentsCounter":"1","feed":"1","itemPreText":"","itemCustomLink":"0","itemCustomLinkTitle":"","itemCustomLinkURL":"http:\\/\\/","itemCustomLinkMenuItem":"","K2Plugins":"1","JPlugins":"1","cache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10119, 'K2 Tools', 'module', 'mod_k2_tools', '', 0, 1, 0, 0, '{"name":"K2 Tools","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_TOOLS","group":""}', '{"moduleclass_sfx":"","module_usage":"0","":"K2_CUSTOM_CODE_SETTINGS","archiveItemsCounter":"1","archiveCategory":"","authors_module_category":"","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"","home":"","seperator":"","root_id":"","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"1","root_id2":"","catfilter":"0","category_id":"","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":"0","cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10120, 'K2 Users', 'module', 'mod_k2_users', '', 0, 1, 0, 0, '{"name":"K2 Users","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_MOD_K2_USERS_DESCRTIPTION","group":""}', '{"moduleclass_sfx":"","getTemplate":"Default","source":"0","":"K2_DISPLAY_OPTIONS","filter":"1","K2UserGroup":"","ordering":"1","limit":"4","userIDs":"","userName":"1","userAvatar":"1","userAvatarWidthSelect":"custom","userAvatarWidth":"50","userDescription":"1","userDescriptionWordLimit":"","userURL":"1","userEmail":"0","userFeed":"1","userItemCount":"1","cache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10121, 'K2 User', 'module', 'mod_k2_user', '', 0, 1, 0, 0, '{"name":"K2 User","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_MOD_K2_USER_DESCRIPTION","group":""}', '{"moduleclass_sfx":"","pretext":"","":"K2_LOGIN_LOGOUT_REDIRECTION","name":"1","userAvatar":"1","userAvatarWidthSelect":"custom","userAvatarWidth":"50","menu":"","login":"","logout":"","usesecure":"0","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10122, 'K2 Quick Icons (admin)', 'module', 'mod_k2_quickicons', '', 1, 1, 2, 0, '{"name":"K2 Quick Icons (admin)","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_QUICKICONS_FOR_USE_IN_THE_JOOMLA_CONTROL_PANEL_DASHBOARD_PAGE","group":""}', '{"modCSSStyling":"1","modLogo":"1","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10123, 'K2 Stats (admin)', 'module', 'mod_k2_stats', '', 1, 1, 2, 0, '{"name":"K2 Stats (admin)","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_STATS_FOR_USE_IN_THE_K2_DASHBOARD_PAGE","group":""}', '{"latestItems":"1","popularItems":"1","mostCommentedItems":"1","latestComments":"1","statistics":"1","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10125, 'Sj K2 Extra Slider', 'module', 'mod_sj_k2_extraslider', '', 0, 1, 0, 0, '{"name":"Sj K2 Extra Slider","type":"module","creationDate":"July 2013","author":"YouTech Company","copyright":"Copyright (c) 2013 YouTech Company","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"3.0.1","description":"TPL_YTFRAMEWORK_XML_DESCRIPTION","group":""}', '{"item_link_target":"_self","button_page":"","theme":"style4","nb-column1":"6","nb-column2":"4","nb-column3":"2","nb-column4":"1","items_page":"4","source":"filter","":"K2_SELECT_SPECIFIC_ITEMS","catfilter":"0","category_id":"","getChildren":"0","itemCount":"5","itemsOrdering":"","FeaturedItems":"1","item":"","items":"","title_slider_display":"1","title_slider":"Latest News","item_title_display":"1","item_title_max_characs":"20","item_desc_display":"1","item_desc_max_characs":"50","item_tags_display":"0","item_readmore_display":"1","item_readmore_text":"Read more","imgcfg_from_k2_image":"1","imgcfg_from_inline_introtext":"1","imgcfg_from_inline_fulltext":"1","imgcfg_from_external":"1","imgcfg_external_url":"images\\/k2\\/{id}.jpg","imgcfg_order":"k2_image, inline_introtext, inline_fulltext, external","imgcfg_function":"resize_stretch","imgcfg_type":"","imgcfg_transparency":"1","imgcfg_width":"960","imgcfg_height":"400","imgcfg_background":"#FFFFFF","imgcfg_placeholder_path":"modules\\/mod_sj_k2_extraslider\\/assets\\/images\\/nophoto.jpg","play":"0","interval":"5000","pause_hover":"hover","effect":"slide","swipe_enable":"1","include_jquery":"0","pretext":"","posttext":"","owncache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10126, 'Sj Responsive Listing for K2', 'module', 'mod_sj_k2_reslisting', '', 0, 1, 0, 0, '{"name":"Sj Responsive Listing for K2","type":"module","creationDate":"March 2012","author":"YouTech Company","copyright":"Copyright (c) 2013 YouTech Company","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"2.5.0","description":"TPL_YTFRAMEWORK_XML_DESCRIPTION","group":""}', '{"nb-column1":"6","nb-column2":"4","nb-column3":"2","nb-column4":"1","sort_byform_display":"1","layout_select_display":"1","default_view":"1","catfilter":"0","category_id":"","category_preload":"","itemCount":"5","itemsOrdering_display":"","itemsOrdering":"","FeaturedItems":"1","tab_all_display":"1","tal_max_characters":"25","count_items_display":"0","category_ordering":"name","item_title_display":"1","item_title_max_characters":"25","item_description_display":"1","item_des_maxlength_layout_grid":"150","item_des_maxlength_layout_list":"200","item_hits_display":"1","item_created_display":"1","item_cat_display":"1","item_readmore_display":"1","link_target":"_self","imgcfg_from_k2_image":"1","imgcfg_from_inline_introtext":"1","imgcfg_from_inline_fulltext":"1","imgcfg_from_external":"1","imgcfg_external_url":"images\\/k2\\/{id}.jpg","imgcfg_order":"k2_image, inline_introtext, inline_fulltext, external","imgcfg_type":"","imgcfg_transparency":"1","imgcfg_width":"600","imgcfg_height":"400","imgcfg_background":"","imgcfg_placeholder":"1","imgcfg_placeholder_path":"modules\\/mod_sj_k2_reslisting\\/assets\\/images\\/nophoto.png","moduleclass_sfx":"","include_jquery":"0","pretext":"","posttext":"","owncache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10127, 'Sj Module Tabs', 'module', 'mod_sj_moduletabs', '', 0, 1, 0, 0, '{"name":"Sj Module Tabs","type":"module","creationDate":"November 2012","author":"YouTech Company","copyright":"Copyright (c) 2009-2012 YouTech Company","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"1.0","description":"SJ_XML_DESCRIPTION","group":""}', '{"position":"","nb_module":"","tab_position":"top","moduleclass_sfx":"","layout":"basic","include_jquery":"0","owncache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10128, 'plg_system_plg_sj_content_listing_ajax', 'plugin', 'plg_sj_content_listing_ajax', 'system', 0, 1, 1, 0, '{"name":"plg_system_plg_sj_content_listing_ajax","type":"plugin","creationDate":"November 2013","author":"YouTech Company","copyright":"Copyright (c) 2009-2013 YouTech Company. All rights reserved.","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"1.0.0","description":"TPL_YTFRAMEWORK_XML_DESCRIPTION","group":""}', '{"limit":"4","cls_items_leading1":" items-leading ","cls_items_leading2":" item span12","cls_items_row1":"items-row","cls_items_row2":"item span12","cls_items_more":"items-more","path_blog_category":"templates\\/sj_icenter\\/html\\/com_content\\/category","patt_blog_featured":"templates\\/sj_icenter\\/html\\/com_content\\/featured","display_pagination":"0","include_jquery":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10129, 'plg_system_plg_sj_k2_listing_ajax', 'plugin', 'plg_sj_k2_listing_ajax', 'system', 0, 1, 1, 0, '{"name":"plg_system_plg_sj_k2_listing_ajax","type":"plugin","creationDate":"October 2013","author":"YouTech Company","copyright":"Copyright (c) 2009-2013 YouTech Company. All rights reserved.","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"1.0.0","description":"TPL_YTFRAMEWORK_XML_DESCRIPTION","group":""}', '{"limit":"2","path_template":"templates\\/sj_icenter\\/html\\/com_k2\\/templates\\/sj-template","display_pagination":"0","include_jquery":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10132, 'EasyBlog Archive', 'module', 'mod_easyblogarchive', '', 0, 1, 0, 0, '{"name":"EasyBlog Archive","type":"module","creationDate":"14\\/05\\/2012","author":"StackIdeas","copyright":"Copyright 2009 - 2012 Stack Ideas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/stackideas.com","version":"3.9.1","description":"\\n\\t\\t\\n\\t\\tThe module displays a list of archived months in years for blog posts created within EasyBlog.\\n\\t\\t\\n\\t","group":""}', '{"menuitemid":"","count":"0","showfuture":"1","showempty":"1","showemptyyear":"1","collapse":"0","order":"asc","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10133, 'Blog Categories', 'module', 'mod_easyblogcategories', '', 0, 1, 0, 0, '{"name":"Blog Categories","type":"module","creationDate":"11th May 2010","author":"StackIdeas","copyright":"Copyright 2009 - 2011 StackIdeas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/stackideas.com","version":"3.8.3","description":"Lists down categories which are created in EasyBlog.","group":""}', '{"routingtype":"default","menuitemid":"","order":"popular","catid":"","sort":"desc","count":"0","showcount":"0","hideemptypost":"1","showcavatar":"1","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10134, 'EasyBlog Welcome', 'module', 'mod_easyblogwelcome', '', 0, 1, 0, 0, '{"name":"EasyBlog Welcome","type":"module","creationDate":"May 2010","author":"StackIdeas","copyright":"Copyright 2009 - 2011 Stack Ideas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/www.stackideas.com","version":"3.9.1","description":"A module that provides users login and will welcome the users if they are already logged in. Also consist of all sort of shortcut for easy access to EasyBlog''s features.","group":""}', '{"routingtype":"default","menuitemid":"","display_avatar":"1","enable_login":"1","name":"0","usesecure":"0","login":"none","logout":"none","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10135, 'EasyBlog Latest Blogs', 'module', 'mod_latestblogs', '', 0, 1, 0, 0, '{"name":"EasyBlog Latest Blogs","type":"module","creationDate":"16\\/05\\/2012","author":"StackIdeas","copyright":"Copyright 2009 - 2012 Stack Ideas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/stackideas.com","version":"3.9.1","description":"Latest blogs by module for your EasyBlog''s component.","group":""}', '{"type":"0","routingtype":"default","menuitemid":"","catid":"","usefeatured":"0","bloggerlisttype":"include","bloggerlist":"","showbavatar":"1","showwebsite":"1","showbcount":"1","biography_length":"50","cid":"0","showcavatar":"1","showccount":"1","tagid":"","showtcount":"1","tid":"","showtavatar":"1","striptags":"0","dateformat":"%d %B %Y","count":"5","showintro":"-1","textcount":"0","showcontent":"1","showauthor":"1","showavatar":"1","showcommentcount":"1","showratings":"1","enableratings":"1","showhits":"1","showreadmore":"1","showdate":"1","showcategory":"1","includesubcategory":"0","sortby":"0","video_show":"1","video_width":"250","video_height":"250","photo_show":"1","photo_width":"250","photo_height":"250","alignment":"default","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10136, 'EasyBlog Calendar', 'module', 'mod_easyblogcalendar', '', 0, 1, 0, 0, '{"name":"EasyBlog Calendar","type":"module","creationDate":"May 2010","author":"StackIdeas","copyright":"Copyright 2009 - 2010 Stack Ideas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/www.stackideas.com","version":"3.9.1","description":"A archive module for EasyBlog in a calendar form.","group":""}', '{"routingtype":"default","menuitemid":"","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10139, 'EasyBlog Tag Cloud', 'module', 'mod_easyblogtagcloud', '', 0, 1, 0, 0, '{"name":"EasyBlog Tag Cloud","type":"module","creationDate":"11th May 2010","author":"StackIdeas","copyright":"Copyright 2009 - 2011 StackIdeas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/www.stackideas.com","version":"3.9.1","description":"This module will list down tags created through EasyBlog in a tag cloud layout.","group":""}', '{"routingtype":"default","menuitemid":"","layout":"tagcloud","order":"postcount","sort":"desc","count":"0","shuffleTags":"1","minsize":"10","maxsize":"30","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10140, 'Noo Google Map', 'module', 'mod_noo_maps', '', 0, 1, 0, 0, '{"name":"Noo Google Map","type":"module","creationDate":"August 2013","author":"NooTheme","copyright":"Copyright (C) 2013 NooTheme. All rights reserved.","authorEmail":"admin@nootheme.com","authorUrl":"http:\\/\\/nootheme.com","version":"1.1.2","description":"\\n\\t\\t\\n\\t\\t\\t<span style=\\"color: #008000;\\"><strong>Noo Google Map Module for Joomla 3!<\\/strong><\\/span><br \\/>\\n\\t\\t\\t<div style=''font-weight:normal''>\\n\\t\\t\\tThis module allows you to quickly and easily add the Google Map to your Joomla 3 website. It allows you set your address information in a HTML format on the map module with a bubble.\\n\\t\\t\\t<p>Copyright 2013 <a href=\\"http:\\/\\/nootheme.com\\" title=\\"Visit nootheme.com\\">NooTheme.com<\\/a>.<\\/p>\\n\\t\\t\\t<\\/div>\\n\\t\\t \\n\\t","group":""}', '{"lang":"en","zoom":"14","width":"940","height":"500","alw_infowindow":"1","scrollwheel":"1","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10141, 'Sj K2 Slider', 'module', 'mod_sj_k2_slider', '', 0, 1, 0, 0, '{"name":"Sj K2 Slider","type":"module","creationDate":"August 2013","author":"YouTech Company","copyright":"Copyright (c) 2013 YouTech Company","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"3.0.0","description":"TPL_YTFRAMEWORK_XML_DESCRIPTION","group":""}', '{"title_slider_display":"0","slider_title_text":"Title of slider","item_link_target":"_blank","theme":"theme1","button_display":"1","control":"style","anchor":"top","source":"filter","":"IMAGE_OPTIONS","catfilter":"0","category_id":"","getChildren":"0","itemCount":"5","itemsOrdering":"","FeaturedItems":"1","popularityRange":"","item":"","items":"","item_title_display":"1","item_title_max_characs":"25","item_title_ending_char":"","item_desc_display":"1","item_desc_max_characs":"120","item_desc_ending_char":"","item_tags_display":"0","item_readmore_display":"1","item_readmore_text":"Read more","imgcfg_from_k2_image":"1","imgcfg_from_inline_introtext":"1","imgcfg_from_inline_fulltext":"1","imgcfg_from_external":"1","imgcfg_external_url":"images\\/k2\\/{id}.jpg","imgcfg_order":"k2_image, inline_introtext, inline_fulltext, external","imgcfg_placeholder":"1","imgcfg_placeholder_path":"modules\\/mod_sj_k2_slider\\/assets\\/images\\/nophoto.png","imgcfg_function":"resize_stretch","imgcfg_type":"","imgcfg_transparency":"1","imgcfg_width":"200","imgcfg_height":"200","imgcfg_background":"#FFFFFF","play":"1","effect":"slide","swipe_enable":"1","start":"1","scroll":"1","duration":"1000","delay":"2500","pause_hover":"hover","include_jquery":"0","layout":"basic","deviceclass_sfx1":"4","deviceclass_sfx2":"3","deviceclass_sfx3":"2","deviceclass_sfx4":"2","deviceclass_sfx5":"1","pretext":"","posttext":"","owncache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10142, 'User - EasyBlog Users', 'plugin', 'easyblogusers', 'user', 0, 1, 1, 0, '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10143, 'Sj K2 Slick Slider', 'module', 'mod_sj_k2_slickslider', '', 0, 1, 0, 0, '{"name":"Sj K2 Slick Slider","type":"module","creationDate":"August 2013","author":"YouTech Company","copyright":"Copyright (c) 2013 YouTech Company","authorEmail":"contact@ytcvn.com","authorUrl":"http:\\/\\/www.smartaddons.com","version":"3.0.0","description":"TPL_YTFRAMEWORK_XML_DESCRIPTION","group":""}', '{"theme":"basic1","button_theme":"number","item_link_target":"_blank","button_position":"number","source":"filter","":"BIG_IMAGE_OPTIONS","catfilter":"0","category_id":"","getChildren":"0","itemCount":"5","itemsOrdering":"","FeaturedItems":"1","popularityRange":"","item":"","items":"","item_title_display":"1","item_title_max_characs":"25","item_title_ending_char":"","item_desc_display":"1","item_desc_max_characs":"120","item_desc_ending_char":"","item_tags_display":"0","item_readmore_display":"1","item_readmore_text":"Read more","item_image_position":"left","imgcfg_from_k2_image":"1","imgcfg_from_inline_introtext":"1","imgcfg_from_inline_fulltext":"1","imgcfg_from_external":"1","imgcfg_external_url":"images\\/k2\\/{id}.jpg","imgcfg_order":"k2_image, inline_introtext, inline_fulltext, external","imgcfg_placeholder":"1","imgcfg_placeholder_path":"modules\\/mod_sj_k2_slickslider\\/assets\\/images\\/nophoto.jpg","imgcfg_function":"resize_stretch","imgcfg_type":"","imgcfg_transparency":"1","imgcfg_width":"600","imgcfg_height":"400","imgcfg_background":"#FFFFFF","start":"1","pause_hover":"hover","play":"1","interval":"5000","effect":"1","swipe":"1","include_jquery":"0","pretext":"","posttext":"","owncache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

DROP TABLE IF EXISTS `#__finder_filters`;
CREATE TABLE IF NOT EXISTS `#__finder_filters` (
  `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL,
  `created_by_alias` varchar(255) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map_count` int(10) unsigned NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  `params` mediumtext,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__finder_links`;
CREATE TABLE IF NOT EXISTS `#__finder_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `route` varchar(255) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int(5) DEFAULT '1',
  `access` int(5) DEFAULT '0',
  `language` varchar(8) NOT NULL,
  `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `list_price` double unsigned NOT NULL DEFAULT '0',
  `sale_price` double unsigned NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_title` (`title`),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__finder_links_terms0`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms0` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms1`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms1` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms2`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms2` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms3`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms3` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms4`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms4` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms5`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms5` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms6`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms6` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms7`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms7` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms8`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms8` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms9`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms9` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsa`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsa` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsb`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsb` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsc`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsc` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsd`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsd` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termse`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termse` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsf`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsf` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_taxonomy`;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `state` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `access` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `state` (`state`),
  KEY `ordering` (`ordering`),
  KEY `access` (`access`),
  KEY `idx_parent_published` (`parent_id`,`state`,`access`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `#__finder_taxonomy` (`id`, `parent_id`, `title`, `state`, `access`, `ordering`) VALUES
(1, 0, 'ROOT', 0, 0, 0);

DROP TABLE IF EXISTS `#__finder_taxonomy_map`;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy_map` (
  `link_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`node_id`),
  KEY `link_id` (`link_id`),
  KEY `node_id` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_terms`;
CREATE TABLE IF NOT EXISTS `#__finder_terms` (
  `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '0',
  `soundex` varchar(75) NOT NULL,
  `links` int(10) NOT NULL DEFAULT '0',
  `language` char(3) NOT NULL DEFAULT '',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term` (`term`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__finder_terms_common`;
CREATE TABLE IF NOT EXISTS `#__finder_terms_common` (
  `term` varchar(75) NOT NULL,
  `language` varchar(3) NOT NULL,
  KEY `idx_word_lang` (`term`,`language`),
  KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__finder_terms_common` (`term`, `language`) VALUES
('a', 'en'),
('about', 'en'),
('after', 'en'),
('ago', 'en'),
('all', 'en'),
('am', 'en'),
('an', 'en'),
('and', 'en'),
('ani', 'en'),
('any', 'en'),
('are', 'en'),
('aren''t', 'en'),
('as', 'en'),
('at', 'en'),
('be', 'en'),
('but', 'en'),
('by', 'en'),
('for', 'en'),
('from', 'en'),
('get', 'en'),
('go', 'en'),
('how', 'en'),
('if', 'en'),
('in', 'en'),
('into', 'en'),
('is', 'en'),
('isn''t', 'en'),
('it', 'en'),
('its', 'en'),
('me', 'en'),
('more', 'en'),
('most', 'en'),
('must', 'en'),
('my', 'en'),
('new', 'en'),
('no', 'en'),
('none', 'en'),
('not', 'en'),
('noth', 'en'),
('nothing', 'en'),
('of', 'en'),
('off', 'en'),
('often', 'en'),
('old', 'en'),
('on', 'en'),
('onc', 'en'),
('once', 'en'),
('onli', 'en'),
('only', 'en'),
('or', 'en'),
('other', 'en'),
('our', 'en'),
('ours', 'en'),
('out', 'en'),
('over', 'en'),
('page', 'en'),
('she', 'en'),
('should', 'en'),
('small', 'en'),
('so', 'en'),
('some', 'en'),
('than', 'en'),
('thank', 'en'),
('that', 'en'),
('the', 'en'),
('their', 'en'),
('theirs', 'en'),
('them', 'en'),
('then', 'en'),
('there', 'en'),
('these', 'en'),
('they', 'en'),
('this', 'en'),
('those', 'en'),
('thus', 'en'),
('time', 'en'),
('times', 'en'),
('to', 'en'),
('too', 'en'),
('true', 'en'),
('under', 'en'),
('until', 'en'),
('up', 'en'),
('upon', 'en'),
('use', 'en'),
('user', 'en'),
('users', 'en'),
('veri', 'en'),
('version', 'en'),
('very', 'en'),
('via', 'en'),
('want', 'en'),
('was', 'en'),
('way', 'en'),
('were', 'en'),
('what', 'en'),
('when', 'en'),
('where', 'en'),
('whi', 'en'),
('which', 'en'),
('who', 'en'),
('whom', 'en'),
('whose', 'en'),
('why', 'en'),
('wide', 'en'),
('will', 'en'),
('with', 'en'),
('within', 'en'),
('without', 'en'),
('would', 'en'),
('yes', 'en'),
('yet', 'en'),
('you', 'en'),
('your', 'en'),
('yours', 'en');

DROP TABLE IF EXISTS `#__finder_tokens`;
CREATE TABLE IF NOT EXISTS `#__finder_tokens` (
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '1',
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `language` char(3) NOT NULL DEFAULT '',
  KEY `idx_word` (`term`),
  KEY `idx_context` (`context`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_tokens_aggregate`;
CREATE TABLE IF NOT EXISTS `#__finder_tokens_aggregate` (
  `term_id` int(10) unsigned NOT NULL,
  `map_suffix` char(1) NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `term_weight` float unsigned NOT NULL,
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `context_weight` float unsigned NOT NULL,
  `total_weight` float unsigned NOT NULL,
  `language` char(3) NOT NULL DEFAULT '',
  KEY `token` (`term`),
  KEY `keyword_id` (`term_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_types`;
CREATE TABLE IF NOT EXISTS `#__finder_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `mime` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

INSERT INTO `#__finder_types` (`id`, `title`, `mime`) VALUES
(1, 'Category', ''),
(2, 'Contact', ''),
(3, 'Article', ''),
(4, 'News Feed', ''),
(5, 'Web Link', ''),
(6, 'K2 Item', ''),
(7, 'Tag', '');

DROP TABLE IF EXISTS `#__k2_attachments`;
CREATE TABLE IF NOT EXISTS `#__k2_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `itemID` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `titleAttribute` text NOT NULL,
  `hits` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `itemID` (`itemID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__k2_categories`;
CREATE TABLE IF NOT EXISTS `#__k2_categories` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `parent` int(11) DEFAULT '0',
  `extraFieldsGroup` int(11) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `image` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `trash` smallint(6) NOT NULL DEFAULT '0',
  `plugins` text NOT NULL,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category` (`published`,`access`,`trash`),
  KEY `parent` (`parent`),
  KEY `ordering` (`ordering`),
  KEY `published` (`published`),
  KEY `access` (`access`),
  KEY `trash` (`trash`),
  KEY `language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28 ;

INSERT INTO `#__k2_categories` (`id`, `name`, `alias`, `description`, `parent`, `extraFieldsGroup`, `published`, `access`, `ordering`, `image`, `params`, `trash`, `plugins`, `language`) VALUES
(1, 'Smartphone', 'smartphone', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit.</p>', 10, 0, 1, 1, 1, '', '{"inheritFrom":"0","theme":"sj-template","num_leading_items":"0","num_leading_columns":"0","leadingImgSize":"Medium","num_primary_items":"4","num_primary_columns":"1","primaryImgSize":"Medium","num_secondary_items":"0","num_secondary_columns":"0","secondaryImgSize":"Medium","num_links":"0","num_links_columns":"0","linksImgSize":"Medium","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"0","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"0","subCatColumns":"2","subCatOrdering":"","subCatTitle":"0","subCatTitleItemCounter":"0","subCatDescription":"1","subCatImage":"0","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"0","catItemDateCreated":"1","catItemRating":"1","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"100","catItemExtraFields":"1","catItemHits":"1","catItemCategory":"0","catItemTags":"0","catItemAttachments":"1","catItemAttachmentsCounter":"1","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"0","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"0","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"0","itemTags":"1","itemAttachments":"0","itemAttachmentsCounter":"0","itemVideo":"0","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"0","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"0","itemRelatedLimit":"5","itemRelatedTitle":"0","itemRelatedCategory":"0","itemRelatedImageSize":"XSmall","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(2, 'Tablet', 'tablet', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit.</p>', 10, 0, 1, 1, 2, '', '{"inheritFrom":"0","theme":"sj-template","num_leading_items":"0","num_leading_columns":"0","leadingImgSize":"Medium","num_primary_items":"4","num_primary_columns":"1","primaryImgSize":"Medium","num_secondary_items":"0","num_secondary_columns":"0","secondaryImgSize":"Medium","num_links":"0","num_links_columns":"0","linksImgSize":"Medium","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"0","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"0","subCatColumns":"2","subCatOrdering":"","subCatTitle":"0","subCatTitleItemCounter":"0","subCatDescription":"1","subCatImage":"0","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"0","catItemDateCreated":"1","catItemRating":"1","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"100","catItemExtraFields":"1","catItemHits":"1","catItemCategory":"0","catItemTags":"0","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"0","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"0","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"0","itemTags":"1","itemAttachments":"0","itemAttachmentsCounter":"0","itemVideo":"0","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"0","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"0","itemRelatedLimit":"5","itemRelatedTitle":"0","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(3, 'Phablet', 'phablet', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit.</p>', 10, 0, 1, 1, 3, '', '{"inheritFrom":"0","theme":"sj-template","num_leading_items":"0","num_leading_columns":"0","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"1","primaryImgSize":"Medium","num_secondary_items":"0","num_secondary_columns":"0","secondaryImgSize":"Small","num_links":"0","num_links_columns":"0","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"0","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"0","subCatColumns":"2","subCatOrdering":"","subCatTitle":"0","subCatTitleItemCounter":"0","subCatDescription":"1","subCatImage":"0","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"0","catItemDateCreated":"1","catItemRating":"1","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"100","catItemExtraFields":"1","catItemHits":"1","catItemCategory":"0","catItemTags":"0","catItemAttachments":"1","catItemAttachmentsCounter":"1","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"0","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"0","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"0","itemTags":"1","itemAttachments":"0","itemAttachmentsCounter":"0","itemVideo":"0","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"0","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"0","itemRelatedLimit":"5","itemRelatedTitle":"0","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(4, 'Laptop', 'laptop', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit.</p>', 10, 0, 1, 1, 4, '', '{"inheritFrom":"0","theme":"sj-template","num_leading_items":"0","num_leading_columns":"0","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"1","primaryImgSize":"Medium","num_secondary_items":"0","num_secondary_columns":"0","secondaryImgSize":"Small","num_links":"0","num_links_columns":"0","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"0","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"0","subCatColumns":"2","subCatOrdering":"","subCatTitle":"0","subCatTitleItemCounter":"0","subCatDescription":"0","subCatImage":"0","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"0","catItemDateCreated":"1","catItemRating":"1","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"100","catItemExtraFields":"1","catItemHits":"1","catItemCategory":"0","catItemTags":"0","catItemAttachments":"0","catItemAttachmentsCounter":"1","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"0","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"0","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"0","itemTags":"0","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"0","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"0","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"0","itemRelatedLimit":"5","itemRelatedTitle":"0","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(5, 'Laptop', 'laptop', '', 0, 0, 1, 1, 5, '', '{"inheritFrom":"0","theme":"","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(6, 'Video', 'video', '', 0, 1, 1, 1, 1, '', '{"inheritFrom":"0","theme":"sj-template","num_leading_items":"0","num_leading_columns":"0","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"1","primaryImgSize":"Medium","num_secondary_items":"0","num_secondary_columns":"0","secondaryImgSize":"Small","num_links":"0","num_links_columns":"0","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"0","subCatColumns":"2","subCatOrdering":"","subCatTitle":"0","subCatTitleItemCounter":"0","subCatDescription":"0","subCatImage":"0","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"0","catItemDateCreated":"1","catItemRating":"1","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"0","catItemTags":"0","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"0","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"0","itemTags":"1","itemAttachments":"0","itemAttachmentsCounter":"0","itemVideo":"0","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"0","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"0","itemRelatedLimit":"5","itemRelatedTitle":"0","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(7, 'Our Team', 'our-team', '', 0, 3, 1, 1, 2, '', '{"inheritFrom":"0","theme":"sj-template","num_leading_items":"0","num_leading_columns":"0","leadingImgSize":"Medium","num_primary_items":"4","num_primary_columns":"1","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"0","num_links_columns":"0","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"0","subCatColumns":"2","subCatOrdering":"","subCatTitle":"0","subCatTitleItemCounter":"0","subCatDescription":"0","subCatImage":"0","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"0","catItemDateCreated":"1","catItemRating":"1","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"0","catItemTags":"0","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"0","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"0","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"0","itemDateModified":"1","itemHits":"1","itemCategory":"0","itemTags":"1","itemAttachments":"0","itemAttachmentsCounter":"0","itemVideo":"0","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"0","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"0","itemRelatedLimit":"5","itemRelatedTitle":"0","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(8, 'Partner', 'partner', '', 0, 2, 1, 1, 4, '', '{"inheritFrom":"0","theme":"sj-template","num_leading_items":"0","num_leading_columns":"0","leadingImgSize":"Medium","num_primary_items":"4","num_primary_columns":"1","primaryImgSize":"Medium","num_secondary_items":"0","num_secondary_columns":"0","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"0","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"0","subCatColumns":"2","subCatOrdering":"","subCatTitle":"0","subCatTitleItemCounter":"0","subCatDescription":"0","subCatImage":"0","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"0","catItemDateCreated":"1","catItemRating":"1","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"0","catItemTags":"0","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"0","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"0","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"0","itemDateModified":"1","itemHits":"1","itemCategory":"0","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"0","itemVideo":"0","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"0","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"0","itemRelatedLimit":"5","itemRelatedTitle":"0","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(9, 'Slideshow', 'slideshow', '', 0, 0, 1, 1, 8, '', '{"inheritFrom":"0","theme":"","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(10, 'Technology', 'technology', '', 0, 0, 1, 1, 5, '', '{"inheritFrom":"0","theme":"sj-template","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(11, 'Copy of Smartphone', 'smartphone', '<p>Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit.</p>', 1, 0, 1, 1, 1, '', '{"inheritFrom":"0","theme":"sj-template","num_leading_items":"0","num_leading_columns":"0","leadingImgSize":"Medium","num_primary_items":"4","num_primary_columns":"1","primaryImgSize":"Medium","num_secondary_items":"0","num_secondary_columns":"0","secondaryImgSize":"Medium","num_links":"0","num_links_columns":"0","linksImgSize":"Medium","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"0","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"0","subCatColumns":"2","subCatOrdering":"","subCatTitle":"0","subCatTitleItemCounter":"0","subCatDescription":"1","subCatImage":"0","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"0","catItemDateCreated":"1","catItemRating":"1","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"100","catItemExtraFields":"1","catItemHits":"1","catItemCategory":"0","catItemTags":"0","catItemAttachments":"1","catItemAttachmentsCounter":"1","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"0","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"0","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"0","itemTags":"1","itemAttachments":"0","itemAttachmentsCounter":"0","itemVideo":"0","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"0","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"0","itemRelatedLimit":"5","itemRelatedTitle":"0","itemRelatedCategory":"0","itemRelatedImageSize":"XSmall","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(12, 'Sample Data-Articles', 'sample-data-articles', '', 0, 0, -2, 1, 2, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(13, 'Joomla!', 'joomla', '', 12, 0, -2, 1, 1, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(14, 'Extensions', 'extensions', '<p>The Joomla! content management system lets you create webpages of various types using extensions. There are 5 basic types of extensions: components, modules, templates, languages, and plugins. Your website includes the extensions you need to create a basic website in English, but thousands of additional extensions of all types are available. The <a href="http://extensions.joomla.org" style="color: #1b57b1; text-decoration: none; font-weight: normal;">Joomla! Extensions Directory</a> is the largest directory of Joomla! extensions.</p>', 13, 0, -2, 1, 1, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(15, 'Components', 'components', '<p><img src="administrator/templates/bluestork/images/header/icon-48-component.png" class="image-left" alt="Component Image" />Components are larger extensions that produce the major content for your site. Each component has one or more "views" that control how content is displayed.In the Joomla! administrator there are additional extensions suce as Menus, Redirection, and the extension managers.</p>', 14, 0, -2, 1, 1, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(16, 'Modules', 'modules', '<p><img src="administrator/templates/bluestork/images/header/icon-48-module.png" alt="Media Image" class="image-left" />Modules are small blocks of content that can be displayed in positions on a web page. The menus on this site are displayed in modules. The core of Joomla! includes 17 separate modules ranging from login to search to random images. Each module has a name that starts mod_ but when it displays it has a title. In the descriptions in this section, the titles are the same as the names.</p>', 14, 0, -2, 1, 2, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*');
INSERT INTO `#__k2_categories` (`id`, `name`, `alias`, `description`, `parent`, `extraFieldsGroup`, `published`, `access`, `ordering`, `image`, `params`, `trash`, `plugins`, `language`) VALUES
(17, 'Plugins', 'plugins', '<p><img src="administrator/templates/bluestork/images/header/icon-48-plugin.png" border="0" alt="Plugin Image" align="left" />Plugins are small task oriented extensions that enhance the Joomla! framework. Some are associated with particular extensions and others, such as editors, are used across all of Joomla!. Most beginning users do not need to change any of the plugins that install with Joomla!. <a href="http://help.joomla.org/proxy/index.php?option=com_help&keyref=Help16:Extensions_Plugin_Manager_Edit">Help</a></p>', 14, 0, -2, 1, 3, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(18, 'Display Modules', 'display-modules', '<p>These modules display information from components other than content and user. These include weblinks, news feeds and the media manager.</p>', 16, 0, -2, 1, 1, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(19, 'Explore', 'explore', '\r\n', 0, 0, 1, 1, 2, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(20, 'Content Category 1', 'content-category-1', '<p> Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit. </p>', 24, 0, 1, 1, 1, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(21, 'Content Category 2', 'content-category-2', ' Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit. ', 24, 0, 1, 1, 2, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(22, 'Content Category 3', 'content-category-3', ' Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit. ', 24, 0, 1, 1, 3, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(23, 'Content Category 4', 'content-category-4', ' Suspendisse at libero porttitor nisi aliquet vulputate vitae at velit. Aliquam eget arcu magna, vel congue dui. Nunc auctor mauris tempor leo aliquam vel porta ante sodales. Nulla facilisi. In accumsan mattis odio vel luctus. Fusce egestas, augue in fermentum euismod, quam ante mattis lorem, a tempor ipsum mi sed elit. ', 24, 0, 1, 1, 4, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(24, 'Yt Sample Data', 'yt-sample-data', '', 0, 0, 1, 1, 2, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(25, 'Joomla page', 'joomla-page', '<div class="jf_typo_accord_container" style="display: block;">Dignissim nec odio pid etiam sagittis aliquet sed dis, tincidunt, etiam rhoncus odio mus proin amet vel, sit urna? Lundium, auctor integer elementum vel dolor! Etiam? Et a enim nunc non massa porta, sed, dolor tincidunt magna penatibus vut purus nec nisi, duis enim et odio! In turpis, montes scelerisque proin nec urna sit, aliquet augue turpis, phasellus lundium tristique.</div>', 0, 0, 1, 1, 2, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*'),
(26, 'Slideshow', 'slideshow', '', 0, 4, 1, 1, 3, '', '{"inheritFrom":"0","theme":"","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(27, 'Shortcodes', 'shortcodes', '', 0, 0, 1, 1, 2, '', '{"theme":"default","num_leading_items":"2","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"4","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"4","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"1","catDescription":"1","catImage":"1","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 1, '', '*');

DROP TABLE IF EXISTS `#__k2_comments`;
CREATE TABLE IF NOT EXISTS `#__k2_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `itemID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `userName` varchar(255) NOT NULL,
  `commentDate` datetime NOT NULL,
  `commentText` text NOT NULL,
  `commentEmail` varchar(255) NOT NULL,
  `commentURL` varchar(255) NOT NULL,
  `published` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `itemID` (`itemID`),
  KEY `userID` (`userID`),
  KEY `published` (`published`),
  KEY `latestComments` (`published`,`commentDate`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

INSERT INTO `#__k2_comments` (`id`, `itemID`, `userID`, `userName`, `commentDate`, `commentText`, `commentEmail`, `commentURL`, `published`) VALUES
(3, 6, 0, 'Smartaddons', '2014-03-12 07:22:12', 'Maecenas sit amet nunc nec nulla molestie hendrerit. Curabitur ultricies, nunc quis sodales facilisis, nisi purus malesuada mauris, aliquet semper enim elit vitae elit. Nullam lobortis, elit nec vehicula iaculis, nibh diam vehicula purus, quis eleifend lacus turpis eget erat. Aenean aliquam, mi non congue blandit, felis tellus aliquam odio, id ultrices urna justo eu augue. Sed ultrices imperdiet mauris, at vulputate metus. Maecenas a dolor dignissim, auctor nibh eget, facilisis lectus. Fusce elementum massa sit amet ipsum euismod auctor eget blandit sapien. Morbi sit amet varius erat. In scelerisque iaculis vestibulum.', 'abc@gmail.com', 'http://www.smartaddons.com', 1),
(4, 5, 0, 'Smartaddons', '2014-03-12 07:22:31', 'Integer tellus massa, consequat quis sagittis sit amet, fermentum ac ante. Phasellus interdum blandit lorem sodales semper. Etiam vel sapien vitae orci eleifend blandit ut eu felis. Quisque pretium velit a rutrum varius. Cras suscipit vehicula mauris, at euismod mi congue vel. In cursus vulputate metus, vel aliquam sem scelerisque condimentum. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque tempus erat sit amet sem consectetur mollis. In iaculis eget lectus ut faucibus. Suspendisse vel ipsum tincidunt, convallis massa sit amet, elementum neque. Curabitur eget pretium ligula.', 'abc@gmail.com', 'http://www.smartaddons.com', 1),
(13, 6, 0, 'all', '2014-03-21 07:20:24', 'hi all', 'hi@all.com', 'http://dantri.com', 1),
(15, 25, 0, 'nam', '2014-03-21 07:21:47', 'skdfsdf', 'name@name.com', 'http://dantri.com', 1),
(16, 39, 0, 'fgd', '2014-03-21 07:22:25', 'fgfdg', 'ss@ss.com', 'http://dantri.com', 1),
(17, 56, 0, 'ff', '2014-03-21 07:23:14', 'fdgfdg', 'gg@gg.com', 'http://dantri.com', 1),
(24, 7, 0, 'Smartaddons Templates', '2014-03-22 09:52:40', 'Duis ultrices pretium molestie. Mauris ullamcorper leo ullamcorper libero laoreet malesuada. Maecenas et dapibus turpis. Vivamus laoreet velit non varius pharetra. Vestibulum sed erat non arcu aliquam placerat. Proin ipsum nisl, condimentum quis nisi eu, pharetra fermentum ligula. Morbi semper hendrerit neque non elementum. Donec id aliquam arcu.', 'abcx@gmail.com', 'http://www.smartaddons.com', 1),
(25, 7, 0, 'Joomla Templates', '2014-03-22 09:53:23', 'Morbi sollicitudin accumsan ultricies. Cras eget nulla at sapien imperdiet commodo. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Aenean non eros auctor, tincidunt ipsum in, convallis lectus. Phasellus scelerisque tortor et dui pulvinar blandit. In vitae sapien ac velit vehicula placerat.', 'abcd@gmail.com', 'http://www.smartaddons.com', 1),
(26, 28, 0, 'Alex Nguyen', '2014-03-22 10:16:55', 'Forem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque convallis ligula eget tellus lacinia tristique. Vivamus convallis tristique fringilla. Pellentesque pharetra, lacus tincidunt pulvinar facilisis', 'a@admin.com', 'http://dantri.com', 1),
(27, 28, 0, 'Mr John', '2014-03-22 10:17:50', 'Forem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque convallis ligula eget tellus lacinia tristique. Vivamus convallis tristique fringilla. Pellentesque pharetra, lacus tincidunt pulvinar facilisis', 'dd@admin.com', 'http://dantri.com', 1),
(28, 28, 0, 'Peter', '2014-03-28 03:42:07', 'Forem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque convallis ligula eget tellus lacinia tristique. Vivamus convallis tristique fringilla. Pellentesque pharetra, lacus tincidunt pulvinar facilisis', 'abd@gmail.com', '', 1);

DROP TABLE IF EXISTS `#__k2_extra_fields`;
CREATE TABLE IF NOT EXISTS `#__k2_extra_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `group` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `group` (`group`),
  KEY `published` (`published`),
  KEY `ordering` (`ordering`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

INSERT INTO `#__k2_extra_fields` (`id`, `name`, `value`, `type`, `group`, `published`, `ordering`) VALUES
(1, 'Video', '[{"name":null,"value":"","editor":null,"rows":"","cols":"","target":null,"alias":"","required":1,"showNull":0}]', 'textarea', 1, 1, 1),
(2, 'Link', '[{"name":"","value":"","target":"same","alias":"","required":1,"showNull":0}]', 'link', 2, 1, 1),
(3, 'Regency', '[{"name":null,"value":"","target":null,"alias":"","required":1,"showNull":0}]', 'textfield', 3, 1, 1),
(4, 'Facebook', '[{"name":null,"value":"","target":null,"alias":"Facebook","required":0,"showNull":0}]', 'textfield', 3, 1, 2),
(5, 'Twitter', '[{"name":null,"value":"","target":null,"alias":"Twitter","required":0,"showNull":0}]', 'textfield', 3, 1, 4),
(6, 'Skype', '[{"name":null,"value":"","target":null,"alias":"SkYpe","required":0,"showNull":0}]', 'textfield', 3, 1, 5),
(7, 'Google Plus', '[{"name":null,"value":"","target":null,"alias":"","required":0,"showNull":0}]', 'textfield', 3, 1, 3),
(8, 'Slideshow', '[{"name":null,"value":"","target":null,"alias":"","required":1,"showNull":0}]', 'image', 4, 1, 1);

DROP TABLE IF EXISTS `#__k2_extra_fields_groups`;
CREATE TABLE IF NOT EXISTS `#__k2_extra_fields_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

INSERT INTO `#__k2_extra_fields_groups` (`id`, `name`) VALUES
(1, 'Video'),
(2, 'Partner'),
(3, 'Our Team'),
(4, 'Slideshow');

DROP TABLE IF EXISTS `#__k2_items`;
CREATE TABLE IF NOT EXISTS `#__k2_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `catid` int(11) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `video` text,
  `gallery` varchar(255) DEFAULT NULL,
  `extra_fields` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `extra_fields_search` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL,
  `checked_out` int(10) unsigned NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL,
  `publish_down` datetime NOT NULL,
  `trash` smallint(6) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `featured` smallint(6) NOT NULL DEFAULT '0',
  `featured_ordering` int(11) NOT NULL DEFAULT '0',
  `image_caption` text NOT NULL,
  `image_credits` varchar(255) NOT NULL,
  `video_caption` text NOT NULL,
  `video_credits` varchar(255) NOT NULL,
  `hits` int(10) unsigned NOT NULL,
  `params` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `metakey` text NOT NULL,
  `plugins` text NOT NULL,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `item` (`published`,`publish_up`,`publish_down`,`trash`,`access`),
  KEY `catid` (`catid`),
  KEY `created_by` (`created_by`),
  KEY `ordering` (`ordering`),
  KEY `featured` (`featured`),
  KEY `featured_ordering` (`featured_ordering`),
  KEY `hits` (`hits`),
  KEY `created` (`created`),
  KEY `language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=133 ;

INSERT INTO `#__k2_items` (`id`, `title`, `alias`, `catid`, `published`, `introtext`, `fulltext`, `video`, `gallery`, `extra_fields`, `extra_fields_search`, `created`, `created_by`, `created_by_alias`, `checked_out`, `checked_out_time`, `modified`, `modified_by`, `publish_up`, `publish_down`, `trash`, `access`, `ordering`, `featured`, `featured_ordering`, `image_caption`, `image_credits`, `video_caption`, `video_credits`, `hits`, `params`, `metadesc`, `metadata`, `metakey`, `plugins`, `language`) VALUES
(1, 'Duis hendrerit', 'duis-hendrerit', 1, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc facilisis tellus ligula, id sollicitudin augue sagittis vitae. Integer convallis arcu non ipsum elementum, eget commodo purus imperdiet.</p>\r\n', '\r\n<p>Donec elit nulla, egestas quis ornare id, luctus in lacus. Phasellus sed dui nec nibh congue rutrum. Fusce eget tortor rhoncus, commodo tortor at, egestas urna. Pellentesque at sem placerat, venenatis arcu ac, vestibulum ante. Sed at dui ac libero sagittis semper. Suspendisse potenti. Aenean luctus dignissim velit, sed posuere augue convallis vel. Praesent vitae ante consectetur, varius nisi in, feugiat turpis. Sed sit amet nibh dolor. Duis hendrerit elementum dictum. Aliquam vulputate felis eu vulputate tincidunt.</p>\r\n<p>Fusce et vehicula felis. Sed ut purus tellus. Quisque quis purus velit. Sed fringilla magna ut augue ultrices interdum. Sed convallis dolor massa, a rutrum urna vulputate ut. Praesent fermentum lacus eu tellus ullamcorper, sit amet bibendum nunc sollicitudin. Nulla facilisi.</p>\r\n<p>Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Sed convallis eros tempus justo posuere accumsan. Cras aliquet, odio sed sodales tristique, nibh dolor tristique ante, quis sodales nisl turpis et nulla. Praesent vehicula tempus sagittis. Integer condimentum sem at leo laoreet, venenatis faucibus ligula venenatis. Vestibulum fringilla nisl eget nisi tempor, nec aliquet felis lacinia. Cras fringilla nulla at viverra tristique. Aliquam ultrices ultricies nunc et tincidunt. Maecenas rutrum lacus nec lacus viverra sollicitudin. Sed eu lacus convallis, feugiat erat in, facilisis arcu.</p>\r\n<p>Fusce egestas nisi vel congue vehicula. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Phasellus justo massa, dapibus ultrices sodales in, sodales sed nulla. Aenean mi libero, ullamcorper et quam elementum, pellentesque hendrerit lorem. Nulla fringilla massa nec diam luctus, convallis gravida lectus varius. Quisque commodo nisl nunc, non pretium turpis fermentum ut. Nam pretium id velit sit amet porttitor. Aliquam ut bibendum justo. Suspendisse feugiat lorem velit, vitae sodales eros ullamcorper quis.</p>', NULL, NULL, '[]', '', '2014-03-11 04:59:51', 660, '', 0, '0000-00-00 00:00:00', '2014-03-21 09:42:58', 660, '2014-03-11 04:59:51', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 15, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(2, 'Suspendisse potenti', 'suspendisse-potenti', 1, 1, '<p>Sed dapibus neque eget risus sollicitudin, sed elementum nisl accumsan. Pellentesque at elementum quam, ut fermentum elit. Nam luctus lectus a est placerat, vitae fringilla nulla volutpat.</p>\r\n', '\r\n<p>Nulla facilisi. Suspendisse potenti. Ut nisl diam, malesuada a luctus nec, condimentum facilisis eros. Morbi rutrum pulvinar fringilla. Sed arcu dolor, posuere quis mi sed, elementum fermentum eros.</p>\r\n<p>Nunc sed mattis neque. Mauris quis vestibulum sapien, non tincidunt dui. Pellentesque dictum ipsum lorem, ac vestibulum dui convallis vitae. Donec id aliquam leo. Donec at sollicitudin eros. Quisque sit amet mollis leo. Proin euismod magna eget commodo consequat. Maecenas ornare sagittis volutpat. Pellentesque euismod nunc eu massa ultrices accumsan. Sed sagittis non lorem eu ornare. Aenean lacinia sodales neque, sed commodo eros scelerisque nec. Nunc et consequat est. Nulla sed vulputate nulla, vitae ultrices nulla. Praesent at luctus diam, et bibendum lacus. Donec ultrices urna magna, ut faucibus nisi rutrum sit amet. Cras interdum orci ac pulvinar hendrerit.</p>\r\n<p>Nunc pulvinar molestie sem, auctor malesuada turpis vulputate non. Nullam a libero in lorem eleifend egestas. Morbi lobortis consequat lacus, et porta purus fermentum ut. Sed eu nisl et mauris vulputate malesuada. Vivamus sit amet ullamcorper justo, at pretium risus. Praesent ac lobortis sapien. Ut dolor turpis, varius at egestas vel, bibendum vitae dolor. Maecenas quis libero risus.</p>', NULL, NULL, '[]', '', '2014-03-11 06:47:30', 660, '', 0, '0000-00-00 00:00:00', '2014-03-19 01:35:08', 660, '2014-03-11 06:47:30', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 1, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(3, 'Vivamus metus', 'vivamus-metus', 1, 1, '<p>Fusce pulvinar fermentum accumsan. In ultricies lacus rhoncus sem egestas faucibus. Fusce posuere sed sapien quis condimentum. Nunc ac nisi ac nulla auctor luctus eu mattis arcu.</p>\r\n', '\r\n<p>Morbi egestas condimentum erat, vel eleifend turpis rutrum eu. Curabitur eu lacus eget ante laoreet gravida. In mi mi, venenatis ut placerat et, luctus et odio. Pellentesque mollis accumsan sapien, aliquam gravida dolor dapibus a. In facilisis dui ac metus suscipit euismod. Maecenas ullamcorper, arcu at tincidunt auctor, justo augue vehicula sapien, at aliquam nisi felis et sapien.</p>\r\n<p>Curabitur tempus lacus sit amet ipsum sagittis, vel vulputate orci luctus. Vivamus metus enim, adipiscing vel eros et, adipiscing rutrum neque. Aenean vitae porta velit. Nullam in consectetur nibh. Donec euismod arcu eu lacus condimentum condimentum. Etiam elementum pulvinar ante. Pellentesque pharetra interdum purus et euismod. Integer sed est eget enim gravida tristique. Donec ut lacus tincidunt, tempor eros non, dignissim neque. Nam vehicula, nulla vitae tristique varius, nunc justo ullamcorper nisl, et tempus tellus ipsum viverra tellus. Quisque gravida, purus a posuere porta, odio justo vehicula orci, a sodales risus dolor at dui. Nam in odio dictum, semper augue eu, bibendum lectus. Donec eu nunc risus. Duis et massa eu neque scelerisque imperdiet. Donec fringilla sollicitudin tristique. Maecenas eu mi ullamcorper mi luctus venenatis ac ac dolor.</p>\r\n<p>In quam sem, blandit nec mauris eu, faucibus interdum ante. Donec viverra at nibh pulvinar elementum. Integer bibendum pulvinar augue nec imperdiet. Pellentesque elementum nulla in arcu consequat, at consectetur tortor egestas. Fusce vestibulum orci a risus dignissim molestie. Phasellus nec metus non sem condimentum lacinia. Morbi vitae libero non eros congue congue. Nulla pharetra lorem eu tortor cursus rhoncus. Mauris at purus a dolor convallis luctus. Suspendisse ultricies, orci vestibulum sodales iaculis, ante elit scelerisque metus, sit amet rhoncus orci arcu quis velit. Praesent malesuada ante quis sem fermentum tristique. Donec molestie facilisis tellus, et dictum mi tincidunt a.</p>', NULL, NULL, '[]', '', '2014-03-11 06:56:52', 660, '', 660, '2014-03-27 03:16:36', '2014-03-19 01:33:30', 660, '2014-03-11 06:56:52', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', '', '', 3, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(4, 'Aliquam consectetur', 'aliquam-consectetur', 1, 1, '<p>Rumas pulvinar fermentum accumsan. In ultricies lacus rhoncus sem egestas faucibus. Fusce posuere sed sapien quis condimentum. Nunc ac nisi ac nulla auctor luctus eu mattis arcu.</p>\r\n', '\r\n<p>Morbi egestas condimentum erat, vel eleifend turpis rutrum eu. Curabitur eu lacus eget ante laoreet gravida. In mi mi, venenatis ut placerat et, luctus et odio. Pellentesque mollis accumsan sapien, aliquam gravida dolor dapibus a. In facilisis dui ac metus suscipit euismod. Maecenas ullamcorper, arcu at tincidunt auctor, justo augue vehicula sapien, at aliquam nisi felis et sapien.</p>\r\n<p>Curabitur tempus lacus sit amet ipsum sagittis, vel vulputate orci luctus. Vivamus metus enim, adipiscing vel eros et, adipiscing rutrum neque. Aenean vitae porta velit. Nullam in consectetur nibh. Donec euismod arcu eu lacus condimentum condimentum. Etiam elementum pulvinar ante. Pellentesque pharetra interdum purus et euismod. Integer sed est eget enim gravida tristique. Donec ut lacus tincidunt, tempor eros non, dignissim neque. Nam vehicula, nulla vitae tristique varius, nunc justo ullamcorper nisl, et tempus tellus ipsum viverra tellus. Quisque gravida, purus a posuere porta, odio justo vehicula orci, a sodales risus dolor at dui. Nam in odio dictum, semper augue eu, bibendum lectus. Donec eu nunc risus. Duis et massa eu neque scelerisque imperdiet. Donec fringilla sollicitudin tristique. Maecenas eu mi ullamcorper mi luctus venenatis ac ac dolor.</p>\r\n<p>In quam sem, blandit nec mauris eu, faucibus interdum ante. Donec viverra at nibh pulvinar elementum. Integer bibendum pulvinar augue nec imperdiet. Pellentesque elementum nulla in arcu consequat, at consectetur tortor egestas. Fusce vestibulum orci a risus dignissim molestie. Phasellus nec metus non sem condimentum lacinia. Morbi vitae libero non eros congue congue. Nulla pharetra lorem eu tortor cursus rhoncus. Mauris at purus a dolor convallis luctus. Suspendisse ultricies, orci vestibulum sodales iaculis, ante elit scelerisque metus, sit amet rhoncus orci arcu quis velit. Praesent malesuada ante quis sem fermentum tristique. Donec molestie facilisis tellus, et dictum mi tincidunt a.</p>', NULL, NULL, '[]', '', '2014-03-11 06:58:19', 660, '', 0, '0000-00-00 00:00:00', '2014-03-24 09:40:39', 660, '2014-03-11 06:58:19', '0000-00-00 00:00:00', 0, 1, 9, 0, 0, '', '', '', '', 158, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(5, 'Quisque risus ligula', 'quisque-risus-ligula', 2, 1, '<p>Sed iaculis laoreet neque, at euismod est eleifend vitae. Nunc mattis dignissim ante nec vehicula. Pellentesque id quam hendrerit diam tristique gravida ut eget tortor. Donec consequat eget odio et convallis.</p>\r\n', '\r\n<p>Vestibulum scelerisque lorem sed neque hendrerit, eu dictum ipsum sollicitudin. Proin scelerisque, quam nec auctor pharetra, turpis purus sollicitudin nunc, quis ornare metus ante quis erat. Curabitur hendrerit gravida luctus. Vivamus posuere accumsan interdum. Nulla volutpat enim at est pellentesque, non cursus felis malesuada. Nulla nec erat nec nisl viverra feugiat. Praesent ac risus egestas, lobortis eros vitae, semper quam. In malesuada id felis quis imperdiet. Phasellus non felis molestie, porttitor justo et, ultricies erat. Phasellus luctus ornare hendrerit.</p>\r\n<p>Suspendisse sodales felis vitae mi vestibulum, quis lobortis neque ultrices. Quisque risus ligula, malesuada eget blandit at, venenatis id orci. Vivamus adipiscing nibh eu turpis interdum blandit vitae in odio. Fusce non justo vel lectus vulputate eleifend et eget turpis. Aliquam semper neque at turpis dapibus scelerisque. Maecenas at varius risus. Nulla sagittis sit amet leo a iaculis. Sed adipiscing eros nec semper sagittis. Ut viverra tellus at mollis dignissim. Fusce at blandit nibh. Sed convallis, risus non eleifend bibendum, lorem diam mattis lectus, vitae faucibus est lectus at justo.</p>\r\n<p>Nunc fringilla pulvinar lacus eget gravida. Pellentesque feugiat eros nisi, id pharetra lectus molestie ut. Curabitur felis metus, accumsan ac eros eget, consequat malesuada nisi. Phasellus condimentum volutpat dolor, in adipiscing libero molestie in. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Suspendisse nec ullamcorper libero. In eget aliquam odio. Quisque viverra massa sit amet justo mattis interdum.</p>', NULL, NULL, '[]', '', '2014-03-11 06:59:18', 660, '', 0, '0000-00-00 00:00:00', '2014-03-22 09:56:59', 660, '2014-03-11 06:59:18', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 7, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(6, 'Hisa nace ruma', 'hisa-nace-ruma', 4, 1, '<p>Wirem pulvinar fermentum accumsan. In ultricies lacus rhoncus sem egestas faucibus. Fusce posuere sed sapien quis condimentum. Nunc ac nisi ac nulla auctor luctus eu mattis arcu.</p>\r\n', '\r\n<p>Morbi egestas condimentum erat, vel eleifend turpis rutrum eu. Curabitur eu lacus eget ante laoreet gravida. In mi mi, venenatis ut placerat et, luctus et odio. Pellentesque mollis accumsan sapien, aliquam gravida dolor dapibus a. In facilisis dui ac metus suscipit euismod. Maecenas ullamcorper, arcu at tincidunt auctor, justo augue vehicula sapien, at aliquam nisi felis et sapien.</p>\r\n<p>Curabitur tempus lacus sit amet ipsum sagittis, vel vulputate orci luctus. Vivamus metus enim, adipiscing vel eros et, adipiscing rutrum neque. Aenean vitae porta velit. Nullam in consectetur nibh. Donec euismod arcu eu lacus condimentum condimentum. Etiam elementum pulvinar ante. Pellentesque pharetra interdum purus et euismod. Integer sed est eget enim gravida tristique. Donec ut lacus tincidunt, tempor eros non, dignissim neque. Nam vehicula, nulla vitae tristique varius, nunc justo ullamcorper nisl, et tempus tellus ipsum viverra tellus. Quisque gravida, purus a posuere porta, odio justo vehicula orci, a sodales risus dolor at dui. Nam in odio dictum, semper augue eu, bibendum lectus. Donec eu nunc risus. Duis et massa eu neque scelerisque imperdiet. Donec fringilla sollicitudin tristique. Maecenas eu mi ullamcorper mi luctus venenatis ac ac dolor.</p>\r\n<p>In quam sem, blandit nec mauris eu, faucibus interdum ante. Donec viverra at nibh pulvinar elementum. Integer bibendum pulvinar augue nec imperdiet. Pellentesque elementum nulla in arcu consequat, at consectetur tortor egestas. Fusce vestibulum orci a risus dignissim molestie. Phasellus nec metus non sem condimentum lacinia. Morbi vitae libero non eros congue congue. Nulla pharetra lorem eu tortor cursus rhoncus. Mauris at purus a dolor convallis luctus. Suspendisse ultricies, orci vestibulum sodales iaculis, ante elit scelerisque metus, sit amet rhoncus orci arcu quis velit. Praesent malesuada ante quis sem fermentum tristique. Donec molestie facilisis tellus, et dictum mi tincidunt a.</p>', NULL, NULL, '[]', '', '2014-03-11 09:39:24', 660, '', 0, '0000-00-00 00:00:00', '2014-03-28 09:11:52', 660, '2014-03-11 09:39:24', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 12, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(7, 'Aliqua ut terdum', 'aliquam-ut-inte', 3, 1, '<p>Proin vel hendrerit velit. Etiam mollis sapien sed euismod ullamcorper. Praesent nisl urna, sagittis vel volutpat sed, dignissim ut purus. Aenean vehicula convallis egestas. Aliquam quis pharetra mi, auctor blandit</p>\r\n', '\r\n<p>tortor. Mauris cursus interdum nunc fermentum suscipit. Vestibulum a libero at quam scelerisque luctus eget sed urna.</p>\r\n<p>Integer luctus quam vel ipsum bibendum, at adipiscing felis condimentum. Aliquam ut interdum lectus, sed blandit ligula. Sed at mauris vel dui lacinia venenatis at eget turpis. Fusce felis tortor, blandit at malesuada sed, luctus quis massa. Nullam vitae ipsum facilisis, convallis nisi nec, rhoncus justo. Sed facilisis risus non nunc porttitor lacinia. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nullam ac erat et orci rutrum rhoncus ut vitae quam.</p>\r\n<p>Vestibulum nisl purus, tincidunt ut neque vel, dictum congue turpis. Duis hendrerit elit augue, nec feugiat leo feugiat et. Morbi quam mi, convallis non euismod eget, congue eget lectus. Cras dignissim nisl vitae risus laoreet rhoncus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Aliquam mattis ac sapien ut placerat. Vivamus in quam lectus. Suspendisse ac mauris pulvinar, malesuada dolor sed, suscipit sapien.</p>\r\n<p>Donec sollicitudin, mi quis eleifend lobortis, tellus diam luctus tortor, quis posuere arcu metus id erat. Vivamus consectetur lacinia leo, ac porttitor diam mollis a. Nam vitae felis nibh. Donec dapibus mattis semper. Nunc euismod tincidunt malesuada. Etiam scelerisque lacus sed blandit venenatis. Duis dolor quam, mollis non magna non, porta blandit augue. Phasellus sagittis ipsum at sollicitudin ultricies. Integer semper dictum gravida. Sed nec porttitor turpis, in lobortis mi. Nunc aliquam nulla id arcu venenatis, eu vehicula felis placerat. Morbi feugiat quam vitae aliquam posuere. Nullam felis diam, suscipit sodales vulputate semper, consectetur vitae libero.</p>', NULL, NULL, '[]', '', '2014-03-11 09:46:29', 660, '', 0, '0000-00-00 00:00:00', '2014-03-22 10:01:38', 660, '2014-03-11 09:46:29', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 35, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(8, 'Nulla ultrices congue', 'nulla-ultrices-congue', 2, 1, '<p>Wirem pulvinar fermentum accumsan. In ultricies lacus rhoncus sem egestas faucibus. Fusce posuere sed sapien quis condimentum. Nunc ac nisi ac nulla auctor luctus eu mattis arcu.</p>\r\n', '\r\n<p>Morbi egestas condimentum erat, vel eleifend turpis rutrum eu. Curabitur eu lacus eget ante laoreet gravida. In mi mi, venenatis ut placerat et, luctus et odio. Pellentesque mollis accumsan sapien, aliquam gravida dolor dapibus a. In facilisis dui ac metus suscipit euismod. Maecenas ullamcorper, arcu at tincidunt auctor, justo augue vehicula sapien, at aliquam nisi felis et sapien.</p>\r\n<p>Curabitur tempus lacus sit amet ipsum sagittis, vel vulputate orci luctus. Vivamus metus enim, adipiscing vel eros et, adipiscing rutrum neque. Aenean vitae porta velit. Nullam in consectetur nibh. Donec euismod arcu eu lacus condimentum condimentum. Etiam elementum pulvinar ante. Pellentesque pharetra interdum purus et euismod. Integer sed est eget enim gravida tristique. Donec ut lacus tincidunt, tempor eros non, dignissim neque. Nam vehicula, nulla vitae tristique varius, nunc justo ullamcorper nisl, et tempus tellus ipsum viverra tellus. Quisque gravida, purus a posuere porta, odio justo vehicula orci, a sodales risus dolor at dui. Nam in odio dictum, semper augue eu, bibendum lectus. Donec eu nunc risus. Duis et massa eu neque scelerisque imperdiet. Donec fringilla sollicitudin tristique. Maecenas eu mi ullamcorper mi luctus venenatis ac ac dolor.</p>\r\n<p>In quam sem, blandit nec mauris eu, faucibus interdum ante. Donec viverra at nibh pulvinar elementum. Integer bibendum pulvinar augue nec imperdiet. Pellentesque elementum nulla in arcu consequat, at consectetur tortor egestas. Fusce vestibulum orci a risus dignissim molestie. Phasellus nec metus non sem condimentum lacinia. Morbi vitae libero non eros congue congue. Nulla pharetra lorem eu tortor cursus rhoncus. Mauris at purus a dolor convallis luctus. Suspendisse ultricies, orci vestibulum sodales iaculis, ante elit scelerisque metus, sit amet rhoncus orci arcu quis velit. Praesent malesuada ante quis sem fermentum tristique. Donec molestie facilisis tellus, et dictum mi tincidunt a.</p>', NULL, NULL, '[]', '', '2014-03-11 09:55:15', 660, '', 0, '0000-00-00 00:00:00', '2014-03-28 09:10:55', 660, '2014-03-11 09:55:15', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', '', '', 33, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(9, 'Nunc odio dolor', 'nunc-odio-dolor', 2, 1, '<p>Duis in feugiat est. Nunc odio dolor, tincidunt sit amet ornare vitae, semper sed eros. Praesent pharetra dictum facilisis. Aliquam vel enim sed justo feugiat egestas. Suspendisse potenti. Suspendisse sed</p>\r\n', '\r\n<p>scelerisque ipsum. Proin ac mattis lorem. Sed vestibulum sapien eu mauris scelerisque tristique. In elit est, egestas non erat nec, sollicitudin tempor metus. Fusce ipsum arcu, malesuada eget tempor aliquet, accumsan sed lorem. Maecenas placerat ligula laoreet accumsan rhoncus. Suspendisse lectus ante, suscipit ut sollicitudin quis, euismod vitae nisi. Aliquam diam erat, posuere eget fringilla a, pulvinar id tortor. Ut sit amet magna viverra arcu viverra iaculis.</p>\r\n<p>Duis vitae arcu est. Praesent condimentum dui non gravida sodales. Duis eget dolor quis ipsum vehicula suscipit eu in odio. Suspendisse pulvinar metus eu nunc facilisis, feugiat eleifend nisl laoreet. Morbi et massa id mi egestas tincidunt non ac ante. Mauris porttitor metus ut ipsum consectetur vulputate. Pellentesque ornare convallis lacus, non cursus leo commodo at. Quisque mattis mauris at turpis accumsan, non euismod purus porta. Sed laoreet, mi ut fermentum suscipit, magna velit dapibus justo, et auctor tellus sapien id turpis. Nunc cursus, tortor non vulputate posuere, risus eros vestibulum nunc, mattis tempus est justo non dolor. Fusce viverra tortor at tincidunt mattis. Quisque pharetra, lorem non pretium venenatis, ante purus tincidunt augue, in feugiat leo risus at sapien.</p>\r\n<p>Suspendisse sit amet quam eleifend, dictum ipsum vel, blandit metus. Mauris blandit orci et ligula aliquet consequat. Curabitur faucibus egestas ultrices. Praesent ut venenatis mauris. Proin vehicula lacus vitae risus pellentesque, ut fringilla risus elementum. Curabitur nec nunc congue, aliquet elit at, placerat neque. Mauris ut imperdiet dui, sit amet iaculis lorem. Integer venenatis tincidunt turpis porta faucibus. Nunc varius ac tortor ut vulputate. Donec gravida mi leo, id fermentum neque commodo eu.</p>\r\n<p>Vestibulum eget massa non lacus auctor placerat non at dui. Pellentesque pharetra suscipit ultricies. Duis dictum purus eget nulla sollicitudin sollicitudin. Proin mollis ornare felis non tristique. Nunc consectetur quis arcu vitae accumsan. Morbi feugiat semper quam, at rhoncus ligula. Mauris posuere in lacus quis gravida. Aenean et felis nisi. Duis quam sem, placerat ac neque sed, ornare dignissim nisl.</p>', NULL, NULL, '[]', '', '2014-03-11 09:59:17', 660, '', 0, '0000-00-00 00:00:00', '2014-03-22 09:56:36', 660, '2014-03-11 09:59:17', '0000-00-00 00:00:00', 0, 1, 8, 0, 0, '', '', '', '', 0, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(10, 'Morbi varius justo', 'morbi-varius-justo', 6, 1, '<p>Donec ac felis ut nisl vulputate bibendum non nec arcu. Morbi varius justo in lectus semper, at pellentesque nulla semper. Aenean mattis diam ac urna sagittis, eu molestie lacus egestas. Duis ut convallis leo. Aenean fermentum dictum felis ut sodales. Vestibulum dapibus eros in imperdiet aliquam. Donec id imperdiet odio. Sed ac blandit justo. Nullam at erat ac diam porta rutrum. Aliquam sodales turpis ac dapibus tempus. Pellentesque adipiscing odio quam, ac tristique lorem feugiat ac. Maecenas nulla tortor, fringilla non diam quis, aliquam tristique sapien.</p>\r\n<p>Etiam rutrum feugiat velit, viverra viverra felis ullamcorper a. Nunc vel dolor ligula. Ut eget orci sit amet magna vestibulum faucibus et nec magna. Integer pulvinar pretium turpis at rutrum. Mauris ac tortor ornare massa pulvinar facilisis quis eu tellus. Nullam felis tellus, pellentesque id fringilla at, porta vitae orci. Duis dapibus euismod lacus eu commodo. Proin rutrum ipsum eget tempor sagittis. Pellentesque non tempor nisl. Vivamus dignissim augue vel mi mollis luctus. Nulla in diam adipiscing quam pharetra feugiat sit amet et velit. Aenean ligula orci, tristique in porttitor nec, facilisis ullamcorper ligula. Duis a pellentesque arcu.</p>\r\n<p>Fusce fringilla varius lacinia. Sed congue vestibulum volutpat. Nunc hendrerit purus eros, sit amet dictum ante fringilla at. Fusce in consequat nulla, at laoreet tortor. Fusce at ornare massa. Sed adipiscing, ligula et semper pharetra, ipsum magna rhoncus augue, ut tincidunt libero turpis vel lacus. Praesent porta est eu ante pharetra dapibus. Nullam eu diam porttitor, mattis erat ut, eleifend metus. Nullam non euismod purus, vel consectetur velit. Morbi id velit commodo, hendrerit odio et, lacinia elit. Quisque fermentum posuere dolor vel aliquet. Nam quis nisi eu velit feugiat aliquam ut at orci. Ut odio dolor, hendrerit eget sollicitudin id, tempus sed est.</p>\r\n<p>Proin dignissim tortor massa, ut iaculis mauris consequat in. Maecenas viverra laoreet mi, ac hendrerit purus aliquet non. Cras vulputate iaculis dignissim. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Cras et lacus nec dui consectetur imperdiet. Pellentesque sed neque id sapien tincidunt porta ut at sapien. Aliquam erat volutpat. Pellentesque bibendum purus ut enim aliquam, id eleifend sem molestie. Sed a pellentesque nunc. Mauris tellus tortor, sagittis sit amet vehicula et, hendrerit ac nunc. Aliquam ultricies purus sodales nunc pretium accumsan. Ut urna sapien, accumsan eu mauris ac, placerat mollis justo. Morbi et tellus aliquam, varius tortor et, aliquet sapien. In volutpat, nunc non feugiat eleifend, libero elit commodo sapien, in adipiscing augue eros aliquet ligula.</p>', '', NULL, NULL, '[{"id":"1","value":"<iframe src=\\"\\/\\/player.vimeo.com\\/video\\/77403038\\" width=\\"680\\" height=\\"383\\" frameborder=\\"0\\" webkitallowfullscreen mozallowfullscreen allowfullscreen><\\/iframe>"}]', '<iframe src="//player.vimeo.com/video/77403038" width="680" height="383" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe> ', '2014-03-11 10:13:33', 660, '', 0, '0000-00-00 00:00:00', '2014-03-12 03:41:39', 660, '2014-03-11 10:13:33', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 1, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(11, 'Mauris orci elit', 'mauris-orci-elit', 6, 1, '<p>Praesent sed consequat purus. Mauris orci elit, cursus id justo sed, semper condimentum sapien. Integer suscipit eros quis tortor aliquam, vitae interdum mi congue. Nam dictum pellentesque felis non volutpat. Sed in fermentum diam. Suspendisse varius quis libero id elementum. Cras vel hendrerit urna. Pellentesque ultrices consectetur libero, varius faucibus enim mattis non. Donec in libero ante. Nunc sit amet arcu mi. Morbi consequat consequat erat a laoreet. Nulla ornare egestas magna, ultricies elementum tortor pulvinar et. Maecenas pretium congue turpis, ut viverra nisi aliquet in.</p>\r\n<p>Sed leo velit, porttitor et volutpat id, rhoncus quis nunc. Vestibulum et aliquam nulla, vitae commodo augue. Quisque posuere purus eu vulputate laoreet. Suspendisse potenti. Aliquam suscipit est at molestie pretium. Integer nec dui gravida, cursus enim bibendum, accumsan ante. Suspendisse vel enim libero. Aenean posuere id lorem vel porttitor. Donec id dolor mauris. Pellentesque faucibus diam eget mi interdum pretium. Proin at rhoncus odio. Sed sit amet malesuada dolor. Maecenas eget gravida nisi.</p>\r\n<p>Donec nec lorem dapibus, sagittis velit ac, varius arcu. Curabitur gravida metus est, ac lobortis libero vulputate eu. Phasellus vestibulum, nibh in tempor rhoncus, lectus elit venenatis lorem, nec egestas est lectus ac risus. Sed id sapien risus. Aenean porttitor magna vel congue adipiscing. Nunc in condimentum quam. Morbi viverra vestibulum libero, in aliquam odio dignissim sit amet.</p>\r\n<p>Nunc porttitor ante at elit placerat, quis dapibus urna euismod. Aliquam erat volutpat. Nulla ornare leo eu dictum feugiat. Integer eget auctor dolor. Nullam facilisis nisl sed ligula sodales porta. In erat purus, dignissim ultricies felis et, faucibus consequat quam. Aenean mattis a augue in aliquam. Fusce molestie, dui sed bibendum lacinia, metus nisi vestibulum risus, quis placerat orci justo sed mauris. Nullam congue leo eget pretium tempor. Fusce bibendum tellus vitae neque tempus, sed posuere nulla commodo. Aliquam vehicula lacus et tempor sagittis. Praesent gravida feugiat elit vitae sollicitudin. Ut aliquet consectetur lectus, ac auctor mauris dignissim non. Sed pulvinar magna nec odio egestas, id eleifend augue adipiscing. Pellentesque ut tempus sem.</p>', '', NULL, NULL, '[{"id":"1","value":"<iframe src=\\"\\/\\/player.vimeo.com\\/video\\/52100865?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff\\" width=\\"680\\" height=\\"383\\" frameborder=\\"0\\" webkitallowfullscreen mozallowfullscreen allowfullscreen><\\/iframe>"}]', '<iframe src="//player.vimeo.com/video/52100865?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff" width="680" height="383" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe> ', '2014-03-12 02:56:33', 660, '', 0, '0000-00-00 00:00:00', '2014-03-12 03:41:28', 660, '2014-03-12 02:56:33', '0000-00-00 00:00:00', 0, 1, 3, 0, 0, '', '', '', '', 1, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*');
INSERT INTO `#__k2_items` (`id`, `title`, `alias`, `catid`, `published`, `introtext`, `fulltext`, `video`, `gallery`, `extra_fields`, `extra_fields_search`, `created`, `created_by`, `created_by_alias`, `checked_out`, `checked_out_time`, `modified`, `modified_by`, `publish_up`, `publish_down`, `trash`, `access`, `ordering`, `featured`, `featured_ordering`, `image_caption`, `image_credits`, `video_caption`, `video_credits`, `hits`, `params`, `metadesc`, `metadata`, `metakey`, `plugins`, `language`) VALUES
(12, 'Nunc quis consectetur', 'nunc-quis-consectetur', 6, 1, '<p>Nulla vel justo dignissim, imperdiet lacus a, lobortis tortor. Duis ultrices mollis risus at posuere. Donec lacinia tempor viverra. Suspendisse id lacinia sem. Sed fringilla sollicitudin nibh eget consectetur. In hac habitasse platea dictumst. Donec sollicitudin dolor nec adipiscing venenatis. Integer fringilla ante in pharetra ultricies. Nulla facilisi. Proin mattis convallis nisl id varius. Etiam commodo arcu quam, sit amet dictum neque viverra et. Aliquam neque sapien, suscipit sit amet sollicitudin sed, lobortis id orci.</p>\r\n<p>Etiam sollicitudin faucibus feugiat. Nunc quis consectetur massa. Phasellus ultricies tincidunt nisi at posuere. Fusce viverra odio ac mattis viverra. Maecenas arcu nulla, laoreet sit amet odio at, malesuada facilisis est. Nulla luctus lorem nec lorem semper, id posuere sem consequat. Nunc luctus orci lorem, eu malesuada felis molestie at. Cras quis facilisis turpis. Vivamus ullamcorper neque vitae nisl consectetur euismod porta in nisi. Aenean est nisi, rhoncus a ligula accumsan, elementum egestas magna. Suspendisse eros neque, dictum id pulvinar sed, aliquet nec sem. Sed quis magna dolor.</p>\r\n<p>Nam eu imperdiet eros. Duis nec mattis enim, vitae pulvinar odio. Vivamus vel nunc risus. In in odio quis metus hendrerit faucibus in eget lectus. Mauris adipiscing, felis a facilisis luctus, turpis libero convallis urna, id cursus orci justo vel arcu. Fusce sed dapibus eros, eu interdum dui. Curabitur non nulla facilisis, tristique orci eget, congue tellus. Suspendisse ut bibendum enim. Sed sodales leo sed facilisis convallis. Donec sodales metus orci, quis tincidunt tellus imperdiet et. Sed facilisis quis mauris sit amet imperdiet.</p>\r\n<p>In fringilla ornare nunc vitae placerat. Sed tempor blandit risus, quis ornare est scelerisque ac. Ut sed dolor mi. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed nec mi vitae ante vulputate lobortis. Curabitur vitae ornare sem, quis venenatis erat. Vivamus tincidunt scelerisque massa, id placerat lorem elementum in. Integer quis diam lacus.</p>', '', NULL, NULL, '[{"id":"1","value":"<iframe src=\\"\\/\\/player.vimeo.com\\/video\\/34796235\\" width=\\"680\\" height=\\"383\\" frameborder=\\"0\\" webkitallowfullscreen mozallowfullscreen allowfullscreen><\\/iframe>"}]', '<iframe src="//player.vimeo.com/video/34796235" width="680" height="383" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe> ', '2014-03-12 02:58:47', 660, '', 0, '0000-00-00 00:00:00', '2014-03-21 09:46:36', 660, '2014-03-12 02:58:47', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', '', '', 0, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(13, 'Nokia', 'nokia', 8, 1, '', '', NULL, NULL, '[{"id":"2","value":["Nokia","http:\\/\\/www.nokia.com\\/","new"]}]', 'Nokia http://www.nokia.com/  ', '2014-03-12 08:38:04', 660, '', 0, '0000-00-00 00:00:00', '2014-03-22 01:42:30', 660, '2014-03-12 08:38:04', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 0, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(14, 'Samsung', 'samsung', 8, 1, '', '', NULL, NULL, '[{"id":"2","value":["Samsung","http:\\/\\/www.samsung.com\\/","new"]}]', 'Samsung http://www.samsung.com/  ', '2014-03-12 08:44:19', 660, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '2014-03-12 08:44:19', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', '', '', 0, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(15, 'Apple Store', 'app-store', 8, 1, '', '', NULL, NULL, '[{"id":"2","value":["Sony Ericsson","http:\\/\\/www.sonymobile.com\\/","new"]}]', 'Sony Ericsson http://www.sonymobile.com/  ', '2014-03-12 08:45:40', 660, '', 0, '0000-00-00 00:00:00', '2014-03-22 01:41:05', 660, '2014-03-12 08:45:40', '0000-00-00 00:00:00', 0, 1, 7, 0, 0, '', '', '', '', 0, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(16, 'HTC', 'htc', 8, 1, '', '', NULL, NULL, '[{"id":"2","value":["HTC","http:\\/\\/www.htc.com\\/","new"]}]', 'HTC http://www.htc.com/  ', '2014-03-12 08:47:21', 660, '', 0, '0000-00-00 00:00:00', '2014-03-22 01:44:34', 660, '2014-03-12 08:47:21', '0000-00-00 00:00:00', 0, 1, 8, 0, 0, '', '', '', '', 0, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(17, 'Oppo', 'oppo', 8, 1, '', '', NULL, NULL, '[{"id":"2","value":["Oppo","https:\\/\\/oppo.com","new"]}]', 'Oppo https://oppo.com  ', '2014-03-12 08:48:44', 660, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '2014-03-12 08:48:44', '0000-00-00 00:00:00', 0, 1, 9, 0, 0, '', '', '', '', 0, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterBut