<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */
defined('_JEXEC') or die('Restricted access');

// $extraClass     = 'blog-meta';

// Altium
// If view is entry, use 'fsm'
// If view is latest or other, use mbm
// if type is micro use micro , else twitter or email

// Default
// If view is not entry use 'mbm'
// If view is not entry and microtype use class 'micro'
// If twitter use 'twitter'
?>
<?php if( $this->getParam( 'show_author') || $this->getParam( 'show_created_date') || $this->getParam( 'show_category') ) { ?>
	<?php if( $this->getParam( 'show_created_date' ) ){ ?>
	<li>
		<!-- Creation date -->
		<span class="blog-created">
			<time datetime="<?php echo $this->formatDate( '%Y-%m-%d' , $row->{$this->getParam( 'creation_source')} ); ?>">
				<span><?php echo $this->formatDate( $system->config->get('layout_dateformat') , $row->{$this->getParam( 'creation_source')} ); ?></span>
			</time>
		</span>
	</li>
	<?php } ?>
	
	<?php if( $system->config->get( 'main_ratings' ) ) { ?>
	<li>
		<!-- Blog ratings -->
		<div class="in">
			<?php echo $this->fetch( 'blog.rating.php' , array( 'row' => $blog ) ); ?>
		</div>
	</li>
	<?php } ?>
	
	<?php if( $this->getParam( 'show_author') ){ ?>
	<li>
		<!-- Author information -->
		<span class="blog-author">
			<?php echo JText::_( 'Author: ' );?>
			<a href="<?php echo $row->blogger->getProfileLink(); ?>" itemprop="author"><?php echo $row->blogger->getName(); ?></a>
		</span>
	</li>
	<?php } ?>
<?php } ?>