<?php
/**
* @Copyright Copyright (C) 2010 VTEM . All rights reserved.
* @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
* @link     	http://www.vtem.net
**/

// no direct access
defined( '_JEXEC' ) or die('Restricted access');

class modVtembookletHelper{
    public static function getLists($params){
        global $mainframe;

        $db         =& JFactory::getDBO();
        $user       =& JFactory::getUser();
        $userId     =  (int) $user->get('id');
        $aid        =  $user->get('aid', 0);
        $nullDate   =  $db->getNullDate();
        $date       =& JFactory::getDate();
        $now        =  $date->toMySQL();
        $contentConfig = &JComponentHelper::getParams( 'com_content' );
		$access		= !$contentConfig->get('shownoauth');
        
        $count		    = $params->get('booklet_count', 3);
        $content_source = $params->get('content_source','mods');
		$section = $params->get('section', ''); // ID of section from list
		$category = $params->get('category', ''); // ID of category from list	
		$sections = $params->get('sections', ''); // String contained IDs of sections separated by comma
		$categoriess = $params->get('categories', ''); // String contained IDs of scategories separated by comma
		$IDs = $params->get('ids',''); 
        $show_front	    = $params->get('show_front', 1);
        $jordering      = $params->get('item_ordering');
        $k2cat_id       = $params->get('k2_cat_id');
        $k2ordering     = $params->get('k2_item_ordering');
        //joomla specific
        if($content_source == 'joomla')
        {
            require_once (JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php');
			$source = false;
			$where1 = '';
		    $where2 = '';
		    if($section != 0 && $category == 0 && $sections == '' && $categoriess == '' && $IDs == ''){
			    $source = $section;
			    $where1 = ' cc.section = ';
			    $where2 = ' OR cc.section = ';
		    }elseif($category != 0 && $sections == '' && $categoriess == '' && $IDs == ''){
				$source = $category;
				$where1 = ' cc.id = ';
				$where2 = ' OR cc.id = ';
		    }elseif($sections != '' && $categoriess == '' && $IDs == ''){
				$source = $sections;
				$where1 = ' cc.section = ';
				$where2 = ' OR cc.section = ';
		    }elseif($categoriess != '' && $IDs == ''){
				$source = $categoriess;
				$where1 = ' cc.id = ';
				$where2 = ' OR cc.id = ';		
		    }else{
				$source = $IDs;
				$where1 = ' a.id = ';
				$where2 = ' OR a.id = ';	
		    }
			$content_tab = explode(',', $source);
			$where = ''; 
			// generating WHERE condition
			for($i = 0;$i < count($content_tab);$i++){
				if($i == 0){
					$where .= $where1.$content_tab[$i];
				}else{
					$where .= $where2.$content_tab[$i];
				}			
			}
            // ordering
            switch ($jordering) {
                case 'date' :
                    $orderby = 'a.created ASC';
                    break;
                case 'rdate' :
                    $orderby = 'a.created DESC';
                    break;
                case 'alpha' :
                    $orderby = 'a.title';
                    break;
                case 'ralpha' :
                    $orderby = 'a.title DESC';
                    break;
                case 'order' :
                    $orderby = 'a.ordering';
                    break;
                default :
                    $orderby = 'a.id DESC';
                    break;
            }

            // Content Items only
    		$query = 'SELECT a.*, ' .
    			' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,'.
    			' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug,'.
                ' CHAR_LENGTH( a.fulltext ) AS readmore ' .
    			' FROM #__content AS a' .
    			($show_front == '0' ? ' LEFT JOIN #__content_frontpage AS f ON f.content_id = a.id' : '') .
    			($show_front == '2' ? ' INNER JOIN #__content_frontpage AS f ON f.content_id = a.id' : '') .
    			' INNER JOIN #__categories AS cc ON cc.id = a.catid' .
    			' INNER JOIN #__sections AS s ON s.id = a.sectionid' .
    			' WHERE '.($source ? '( '.$where.' ) AND ' : '').' a.state = 1' .
    			($access ? ' AND a.access <= ' .(int) $aid. ' AND cc.access <= ' .(int) $aid. ' AND s.access <= ' .(int) $aid : '').
				' AND (a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).' ) ' .
			    ' AND (a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).' )' .
    			($show_front == '2' ? ' AND f.content_id = a.id ' : '').
    			($show_front == '0' ? ' AND f.content_id IS NULL ' : '').
    			' AND s.published = 1' .
    			' AND cc.published = 1' .
    			' ORDER BY '. $orderby;
    		// end Joomla specific

        }else if($content_source == 'k2'){
            // start K2 specific
		    require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php');
			require_once(JPATH_SITE . DS . 'components' . DS . 'com_k2' . DS . 'helpers' . DS . 'utilities.php');
            $query = "SELECT i.*, c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams";
            if ($k2ordering == 'best') $query .= ", (r.rating_sum/r.rating_count) AS rating";
            if ($k2ordering == 'comments') $query .= ", COUNT(comments.id) AS numOfComments";
            $query .= " FROM #__k2_items as i LEFT JOIN #__k2_categories c ON c.id = i.catid";
            if ($k2ordering == 'best') $query .= " LEFT JOIN #__k2_rating r ON r.itemID = i.id";
            if ($k2ordering == 'comments') $query .= " LEFT JOIN #__k2_comments comments ON comments.itemID = i.id";
            $query .= " WHERE i.published = 1 AND i.access <= {$aid} AND i.trash = 0 AND c.published = 1 AND c.access <= {$aid} AND c.trash = 0";
            $query .= " AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." )";
            $query .= " AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." )";

            if ($params->get('catfilter')) {
				if (!is_null($k2cat_id)) {
					if (is_array($k2cat_id)) {
						if ($params->get('get_children')) {
							require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'models'.DS.'itemlist.php');
							$allChildren = array();
							foreach ($k2cat_id as $id) {
								$categories = K2ModelItemlist::getCategoryChilds($id, true);
								$categories[] = $id;
								$categories = @array_unique($categories);
								$allChildren = @array_merge($allChildren, $categories);
							}

							$allChildren = @array_unique($allChildren);
							JArrayHelper::toInteger($allChildren);
							$sql = @implode(',', $allChildren);
							$query .= " AND i.catid IN ({$sql})";

						} else {
							JArrayHelper::toInteger($k2cat_id);
							$query .= " AND i.catid IN(".implode(',', $k2cat_id).")";
						}

					} else {
						if ($params->get('get_children')) {
							require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'models'.DS.'itemlist.php');
							$categories = K2ModelItemlist::getCategoryChilds($k2cat_id, true);
							$categories[] = $k2cat_id;
							$categories = @array_unique($categories);
							JArrayHelper::toInteger($categories);
							$sql = @implode(',', $categories);
							$query .= " AND i.catid IN ({$sql})";
						} else {
							$query .= " AND i.catid=".(int)$k2cat_id;
						}

					}
				}
			}

            if ($params->get('k2_featured_items') == '0') $query .= " AND i.featured != 1";
            if ($params->get('k2_featured_items') == '2') $query .= " AND i.featured = 1";
            if ($k2ordering == 'comments')
            $query .= " AND comments.published = 1";
            switch ($k2ordering) {
                case 'date':
                    $orderby = 'i.created ASC';
                    break;
                case 'rdate':
                    $orderby = 'i.created DESC';
                    break;
                case 'alpha':
                    $orderby = 'i.title';
                    break;
                case 'ralpha':
                    $orderby = 'i.title DESC';
                    break;
                case 'order':
                    if ($params->get('k2_featured_items') == '2')
                    $orderby = 'i.featured_ordering';
                    else
                    $orderby = 'i.ordering';
                    break;
                case 'rorder':
                    if ($params->get('k2_featured_items') == '2')
                    $orderby = 'i.featured_ordering DESC';
                    else
                    $orderby = 'i.ordering DESC';
                    break;
                case 'rand':
                    $orderby = 'RAND()';
                    break;
                case 'best':
                    $orderby = 'rating DESC';
                    break;
                case 'comments':
                    $query.=" GROUP BY i.id ";
                    $orderby = 'numOfComments DESC';
                    break;
                default:
                    $orderby = 'i.id DESC';
                    break;
            }
            $query .= " ORDER BY ".$orderby;
            
        }
		$db->setQuery($query, 0, $count);
		$items = $db->loadObjectList();
		$lists = array();
		$lists = modVtembookletHelper::buildLists($params, $items);
		return $lists;
    }
	
    function imageList ($directory, $sortcriteria, $sortorder) {
	    $results = array();
	    $handler = opendir($directory);
			$i = 0;
	    while ($file = readdir($handler)) {
	        if ($file != '.' && $file != '..' && modVtembookletHelper::isImage($file)) {
						$results[$i][0] = $file;
						$results[$i][1] = filemtime($directory . "/" .$file);
						$i++;
					}
	    }
	    closedir($handler);

			//these lines sort the contents of the directory by the date
			// Obtain a list of columns

			foreach($results as $res) {
				if ($sortcriteria == 0 ) $sortAux[] = $res[0];
				else $sortAux[] = $res[1];
			}

			if ($sortorder == 0) {
				array_multisort($sortAux, SORT_ASC, $results);
			} elseif ($sortorder == 2) {
				srand((float)microtime() * 1000000);
				shuffle($results);
			} else {
				array_multisort($sortAux, SORT_DESC, $results);
			}

			foreach($results as $res) {
				$sorted_results[] = $res[0];
			}

	    return $sorted_results;
	}

	function isImage($file) {
		$imagetypes = array(".jpg", ".jpeg", ".gif", ".png");
		$extension = substr($file,strrpos($file,"."));
		if (in_array($extension, $imagetypes)) return true;
		else return false;
	}

	function cleanDir($dir) {
		if (substr($dir, -1, 1) == '/')
			return $dir;
		else
			return $dir . "/";
	}
	
    //function specific for Joomla and k2 content
    private static function buildLists($params, $items){
        $show_introtext = $params->get('show_introtext', 1);
		$link_titles = $params->get('link_titles', 0);
		$showtitles = $params->get('showtitles', 0);
		$style = $params->get('style', 'captionfull');
		$class1 = $class2 = $class3 = '';
		if($style=="captionfull" or $style=="caption"){$class1="vtemshow";$class2="showcaption";}
		if($style=="slideright" or $style=="thecombo" or $style=="slidedown" or $style=="peek"){$class3="class='vtemshow'";}
		
		$itemIntroText = $params->get('itemIntroText', 1);
        $i = 0;
        $lists = array();
        $contentConfig = &JComponentHelper::getParams( 'com_content' );
        $content_source = $params->get('content_source','joomla');       
        foreach($items as $row){
            $user		=& JFactory::getUser();
            $dispatcher   =& JDispatcher::getInstance();
            $results = @$dispatcher->trigger('onPrepareContent', array (& $row, & $params, 0));
            $text = JHTML::_('content.prepare',$row->introtext,$contentConfig);
            $lists[$i]->id = $row->id;
			$lists[$i]->created = $row->created;
			$lists[$i]->modified = $row->modified;
            $lists[$i]->title = htmlspecialchars( $row->title );         
            if ($row->access >  $user->get('aid', 0)){
                $lists[$i]->link = JRoute::_("index.php?option=com_user&view=login");
                $lists[$i]->readmore_register = true;
            }
			else if ($content_source=='joomla') {
			    $lists[$i]->link = JRoute::_(ContentHelperRoute::getArticleRoute($row->slug, $row->catslug, $row->sectionid));
                $lists[$i]->readmore_register = false;
				$introtext_limit=$params->get('introtext_limit', 100);
				  if($introtext_limit != 0){	  
						  $str = $text;
							if(JString::strlen($str) > $introtext_limit){
								if(JString::strlen($str) >= $introtext_limit){	
								    $text = strip_tags($str);
									$text = JString::substr($text, 0, $introtext_limit);
									$text .= "...";
								}
							}
				    }
				    $lists[$i]->introtext ='';
					if($showtitles){
						if($link_titles){
						  $lists[$i]->introtext .= '<h4 class="vtem_booklet_title"><a href="'.$lists[$i]->link.'">'. $lists[$i]->title .'</a></h4>';
						}else{
						  $lists[$i]->introtext .= '<h4 class="vtem_booklet_title">'.$lists[$i]->title.'</h4>';
						}
					}
				    if($show_introtext){
					  $lists[$i]->introtext .= $text;
				    }
					if ($params->get('show_readmore')){
						ob_start();
						?>
						 <div class="vt_readmore"><a class="vtem-booklet-readon" href="<?php echo $lists[$i]->link; ?>" ><span>
							<?php if ($lists[$i]->readmore_register) :
							  echo JText::_('Register to read more...');
							elseif ($readmore = $params->get('readmore_text')) :
							  echo $readmore;
							else :
							  echo JText::sprintf('Read more...');
							endif; ?></span></a></div>
						<?php  	 	
						$readmore_html = ob_get_clean();
						$lists[$i]->introtext .= $readmore_html;
                     }
			} else {
			    $lists[$i]->link = JRoute::_(K2HelperRoute::getItemRoute($row->id.':'.$row->alias, $row->catid.':'.$row->categoryalias));
                $lists[$i]->image = modVtembookletHelper::getK2Images($lists[$i]->id, $lists[$i]->title, $params->get('k2_img_size','M'));
                $lists[$i]->readmore_register = false;
				$lists[$i]->introtext = '';
				if($params->get('itemTitle')){
				  $lists[$i]->introtext .= '<h4 class="vtem_booklet_title"><a href="'.$lists[$i]->link.'">'.$lists[$i]->title.'</a></h4>';
				}
				if ($params->get('itemIntroText')) {
						  if($lists[$i]->image){
							 $lists[$i]->introtext .='<a href="'.$lists[$i]->link.'"><img src="'.$lists[$i]->image.'" alt="'.$lists[$i]->title.'" class="vtem_drawer_image"/></a>';
						  }else{
							 $lists[$i]->introtext .='<img src="'.JURI::root().'modules/mod_vtem_booklet/styles/images/noimage.jpg" alt="" class="vtem_drawer_image" />';
						  }
						if ($params->get('itemIntroTextWordLimit')) {
						    $lists[$i]->introtext .= K2HelperUtilities::wordLimit($text, $params->get('itemIntroTextWordLimit'));
						} else {
							$lists[$i]->introtext .= $text;
						}
				 }
				  ob_start();
                  ?>
				  <?php if ($params->get('show_k2readmore')) :?>
                  <div class="vt_readmore"><a href="<?php echo $lists[$i]->link; ?>" class="vtem-booklet-readon"><span>
                    <?php if ($lists[$i]->readmore_register) :
                      echo JText::_('Register to read more...');
                      elseif ($readmore = $params->get('k2readmore')) :
                      echo $readmore;
                      else :
                      echo JText::sprintf('Read more...');
                 endif; ?></span></a></div>
				 <?php endif; ?>
                  <?php    
                  $readmore_html = ob_get_clean();
                  $lists[$i]->introtext .= $readmore_html;
			  }
            $i++;
        }
        return $lists;
    }
	
    public static function getK2Images($id, $title, $image_size){
        if (file_exists(JPATH_SITE.DS.'media'.DS.'k2'.DS.'items'.DS.'cache'.DS.md5("Image".$id).'_'.$image_size.'.jpg')) {
            $image_path = 'media/k2/items/cache/'.md5("Image".$id).'_'.$image_size.'.jpg';
            $image_path = JURI::Root(true).'/'.$image_path;
            return $image_path;
        }
        else{
          echo "Image not found for article $title \n";
        }
    }
}